/*
 * Copyright (c) 2003 Benedikt Meurer (benedikt.meurer@unix-ag.uni-siegen.de)
 *               2004 Jean-François Wauthy (pollux@xfce.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __XFPRINT_FILTER_H__
#define __XFPRINT_FILTER_H__

#include <glib.h>

typedef struct _XfprintFilter	XfprintFilter;
typedef struct _XfprintFilterList	XfprintFilterList;

struct _XfprintFilter
{
	guint	argc;
	gchar	**argv;
	gchar	*command;
	guint	size;
};

struct _XfprintFilterList
{
	GList	*cursor;
	GList	*filters;
};

/* filter function prototypes */
extern XfprintFilter	*xfprint_filter_new(const gchar *);
extern void		xfprint_filter_free(XfprintFilter *);
extern void		xfprint_filter_add(XfprintFilter *, const gchar *, ...);

/* filterlist function prototypes */
extern XfprintFilterList	*xfprint_filterlist_new(void);
extern void		xfprint_filterlist_free(XfprintFilterList *);
extern void		xfprint_filterlist_append(XfprintFilterList *, XfprintFilter *);
extern void		xfprint_filterlist_prepend(XfprintFilterList *, XfprintFilter *);
extern int		xfprint_filterlist_execute(XfprintFilterList *, int,int,int);

#endif	/* !__XFPRINT_FILTER_H__ */
