/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/***************************************************************
* DNDUtils -------------------------------------------------
*  Utility functions for common drag and drop tasks.
* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
* REQUIRED IMPORTS:
****************************************************************/

//////////// global variables /////////////////////

var app;

//////////// global constants ////////////////////

////////////////////////////////////////////////////////////////////////////
//// class DNDUtils

var DNDUtils =
{
  invokeSession: function(aTarget, aTypes, aValues)
  {
    var transData, trans, supports;
    let transArray = XPCU.createInstance("@mozilla.org/array;1", "nsIMutableArray");
    for (var i = 0; i < aTypes.length; ++i) {
      transData = this.createTransferableData(aValues[i]);
      trans = XPCU.createInstance("@mozilla.org/widget/transferable;1", "nsITransferable");
      trans.addDataFlavor(aTypes[i]);
      trans.setTransferData (aTypes[i], transData.data, transData.size);
      supports = trans.QueryInterface(Components.interfaces.nsISupports);
      transArray.appendElement(supports, /* weak */ false);
    }

    var nsIDragService = Components.interfaces.nsIDragService;
    var dragService = XPCU.getService("@mozilla.org/widget/dragservice;1", "nsIDragService");
    dragService.invokeDragSession(aTarget, transArray, null, nsIDragService.DRAGDROP_ACTION_MOVE);
  },
  
  createTransferableData: function(aValue)
  {
    var obj = {};
    if (typeof(aValue) == "string") {
      obj.data = XPCU.createInstance("@mozilla.org/supports-string;1", "nsISupportsString");
      obj.data.data = aValue;
      obj.size = aValue.length*2;
    } else if (false) {
      // TODO: create data for other primitive types
    }
    
    return obj;
  },
  
  checkCanDrop: function(aType)
  {
    var dragService = XPCU.getService("@mozilla.org/widget/dragservice;1", "nsIDragService");
    var dragSession = dragService.getCurrentSession();
    
    var gotFlavor = false;
    for (var i = 0; i < arguments.length; ++i)
      gotFlavor |= dragSession.isDataFlavorSupported(arguments[i]); 

    dragSession.canDrop = gotFlavor;
    return gotFlavor;
  },
  
  getData: function(aType, aIndex)
  {
    var dragService = XPCU.getService("@mozilla.org/widget/dragservice;1", "nsIDragService");
    var dragSession = dragService.getCurrentSession();
    
    var trans = XPCU.createInstance("@mozilla.org/widget/transferable;1", "nsITransferable");
    trans.addDataFlavor(aType);
  
    dragSession.getData(trans, aIndex);
    var data = new Object();
    trans.getAnyTransferData ({}, data, {});
    return data.value;
  }  
  
};

