/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef hmac_sha384_vectors_h__
#define hmac_sha384_vectors_h__

#include "testvectors_base/test-structs.h"

const HmacTestVector kHmacSha384WycheproofVectors[] = {
    {1, "empty message",
     "ee8df067857df2300fa71a10c30997178bb3796127b5ece5f2ccc170932be0e78ea9b0a59"
     "36c09157e671ce7ec9fc510",
     "",
     "a655184daf3346ffc6629d493c8442644e4996a2799e42e3306fa6f5b0967b6cf3a6f819b"
     "ab89bce297d1d1a5907b2d0",
     false},

    {2, "short message",
     "976696c0dc97182ca771975c3928ff9168ef89cd740cd2292858fd916068a702bc1df7c6c"
     "d8ee1f0d25e61d4c514cc5d",
     "2b",
     "363e8973fedcf7892013dfae0b7065d61d80b98c635bc09ed860a01473b9bcd0dc550dbf6"
     "6cf0d601fe9cbf3ae59620d",
     false},

    {3, "short message",
     "c55ea4c64a0a63e2d14ad42559ba7c816b8824d263c2cc6a015761b53f681e514369f0dfb"
     "a5cde165320ee10a96eb1fc",
     "5abd",
     "ccc2925f164a7d9662f1e76bcaf6345492bb091d4d2d775af2178a4bcc1ca21dcf8b3bf8f"
     "056823770782f25a419bb3e",
     false},

    {4, "short message",
     "2928d465d92fa40072ca9d67761be66e491755e43499003c1057d3bec870f255126c3658d"
     "0d8a0c7d207df8710037ca7",
     "c405ae",
     "d9e19c672a466e4c83a849905728c4be1db99bdd260946d9ff52939779002dcc460c576f0"
     "2b40dda0717182be96b5411",
     false},

    {5, "short message",
     "686a3730085cc944fceb141628419818e662fe21e52bea2748f3b704f80ce801086db1e30"
     "68917b242e62b4d6e6ed685",
     "6601c683",
     "10dc39103983b3a6be376a8eda7b6f363cb91efe11b027a62440ae136bd66f98b0a1d8b8f"
     "2399099492021076afa14a0",
     false},

    {6, "short message",
     "f22d867b972b232e3f444a488dd794d170807c70eb650f952b6177596f76c558a5d860d6f"
     "7be0be9e666f9bd53732f8d",
     "15b29377e0",
     "e02e4e20b5f1e5f06913bc9745c9069c09ec1369f1a296ad1d07c04cc4f9cb4741248d7ba"
     "097cd3ba0e75d2409d6a01b",
     false},

    {7, "short message",
     "3ac9abd53dbd0fbb891f9b5e16dd45df994e5283527832707138fc2712bad9e34761e7d9c"
     "6d05d46f2c8323ddb0efe99",
     "5a34155b1115",
     "78c53dd1a2431174628f5f4867fa777afa6df1b36269bba114d016d1065fcb021170baad0"
     "9b4a528f40573903a65f540",
     false},

    {8, "short message",
     "ae3aa94fdd35e2bef40472d29bdad3a409840ea441c3d7025cd72f3e81ff56da602161d84"
     "b23d1634061385be30c5bbd",
     "8a140d781e7191",
     "fd22ba896cb1147bb86f8ad51c253b792657c0becc913e90104da0f139f9b08c9169706f1"
     "531a2c6c03d6bd72a77eff2",
     false},

    {9, "short message",
     "44b79852cabcf3fe93d2fff55d2afe6a46c35b7ad1954ce0888de7b459b982722faf8b490"
     "e6b00e7bcabbd36f18443f5",
     "9398cd251deafe8b",
     "56128fb438a93f6f48f47c0f4c7549f8008a8e69bbdbf0886ec40f86e7870034ef9090d2b"
     "04057391f1def5b25e8f0ad",
     false},

    {10, "short message",
     "03fed2f579a3ebdececfb184ebe2984876113399c4a593d98b5f5e606dd330fb394c285d9"
     "ead601748259b493335f8e5",
     "18d879b1f63df3ac7a",
     "a0e3b5660eeb5fc4a5dd48e725b09a0e282b22bbe2693d8b893ddf0f2116450e087592540"
     "7e909fde0f1f728f608fba9",
     false},

    {11, "short message",
     "f4ef48bf4056d39dbba4154018c63bdf29420b9991ea594ff05e3cc1cb02e176d54ba038a"
     "6b78692519d6788e495bbab",
     "0a5de13cd9ba31c94486",
     "e9a1219e86983d69e336068b280309f974ab61f25968fc6352324ba49c36ce42c578676a3"
     "a31ef11e960d6771386650e",
     false},

    {12, "short message",
     "fc771f7ccd499a1ed633d86876d707b5f1d53c6bcdf21aa2907766ab3ca7fa6cdd6a9b981"
     "b1a84a528e81444303f1057",
     "03ba11f3f3173b85226b25",
     "cfb4971d5449db364e2c8d0d429a0767050d480a5397f0dcc74294f52ea96260a57fe6cad"
     "14409ad67da6fbebf2da0d8",
     false},

    {13, "short message",
     "b3999de680b11550e18631c8199f7eb8a74e21bdc9d97f781245c2af19f85497d9f38b250"
     "a564e48650fd00be365f155",
     "9c658cb5e601d85dc3857863",
     "d547e4cbd56e82b47d2ec93eeb6b34924ebda461fb60e475bf328d2368618f55fbf7b0e2e"
     "b1ff542c4eb7eefbfc8bd2b",
     false},

    {14, "short message",
     "88005a62864ea699e1509616ec48033e84d2e2a13b8bc2e8a76f2eccbdb207a95ac8e2f5b"
     "5a703b22a0b571e8acc599a",
     "5a94f84541a794bf23d72db16d",
     "d6b73ee67e88a20fceb5520be92594daf1b3786c7187535ccb1f0b926dae11adde6e8697b"
     "a803b159019849df3c9d2c7",
     false},

    {15, "short message",
     "b1cbda2c9a12f92315a5101aef311e99d6db002b0e04fb53c50106aa4d28e9a346697ba97"
     "084572eea56ccfc4ad7e572",
     "ce12c0c78e3f6b276ac56ed7435e",
     "5c0802cd0ed82380e4c2a61d146ed72762613de89eb4ab9fe71da9ad3d79e1d2321cae186"
     "292f7c52ab639d3ba6aa85a",
     false},

    {16, "short message",
     "08517e8014e00db5c37f2a20f987ea2ec52e7938de018ad6be256ba2236804144ad2a1bcc"
     "242738862b40647007e0a2c",
     "21e2a0a167789a6b722d1737d92f8b",
     "2264d3c9b835aedf699d5fbfc05d46f085591441df75aa2b2873f6c8a11a0856a2b79ae11"
     "ea0a91609dbd564a0bed456",
     false},

    {17, "",
     "503d7478a773b694d6e552c9703cc8bc56fd49fafc9a17cab8b0332dca8d49336fa7e9ec2"
     "bcb56253fe5bb504e3e7f7f",
     "d96e6fed893addfd9237c81c4f4e341b",
     "19389766789912260f3f9757df3651663829c358bb48b22c1c63132070df318905beffd45"
     "f51e4dfcb3e785f44cf9106",
     false},

    {18, "",
     "41341bab902e767d4d1964c0acfecf46eff1b02b6455bcb2097de9c154be1f667f21be076"
     "de18cd2c15c005896fca87f",
     "4c43ac7de3631cc86f4da72fe6b6a552f1",
     "3c3104f24b7070cc3277d9ae640d416298fc917a0c1cdc3c2e7b6da75706fd2ae234efd55"
     "1af12ae29144704793e2f6a",
     false},

    {19, "",
     "c2f83be1acce7b89a5f9e9ea7e4c4f8b0f4319986fbe479fa3b4a3c298168362393b56ea0"
     "3b5cef77f48e5a72abe6d08",
     "8dd0cd786cd800ffebec098728923d69249d3223c4c595cb",
     "751c6c7d00fef5e4edc993915fba694943a7ee3a2c8e5b700d0ee536bf85fb117a9cd6c45"
     "6485cd670f7a0b490c83e61",
     false},

    {20, "",
     "6bd2aee9dd98d6b6609fce82181b10c20bba861da68a1590586fab08c5e9e90ff584047db"
     "4760828643fea38087160e4",
     "33236a9de603c1e4f5e11164224740627d10f6008eb73ec2642321bf0b82d579",
     "e4cd8b8868bb078ed5d6938e40d9ff4bf61a4994be40a5f2b5446463e5db90516bccdd19f"
     "16c92e3f839b9d6de68b2a9",
     false},

    {21, "long message",
     "2f98ba2ceaadc5ba08880a35cb0080dc870a5734a782ebe31c4bab100ff8786dcc3be6de1"
     "8482ea5d1b3bf14aeabb470",
     "2d74a66dacf12edb85ef3073feafd122889cb634add00ff0395d224b4ff8b5d5d67ca6419"
     "b6826abffdb41bab427d5",
     "a8ea72100859f4b7b6f2fe596248f1729bcdf0606c900ab52e51eab548d26e1eb634a42e5"
     "fc7ccc18356c0d283597ee2",
     false},

    {22, "long message",
     "5e5f60e40d84c7ca2608af3bcc6e04abc5f8b7ca730a78af7f6f032e5a1501695bd91f3be"
     "bb28590af1db90d8390ca58",
     "2efe6a14ea8d679e62dbcedf35e61852278c83c54adbe1f1c72cb1a746b11cff8cb4fc3a2"
     "c3acd44255d51c020ca6d47",
     "6e8c95a4097ea13d064ed10809a33b569a6a84205158bd692ff82bc4b70b47a60ed332f2f"
     "5bca5211a1cc89c06f9c595",
     false},

    {23, "long message",
     "bc310bc3913d9fe59e2012a058c9e150534d25611e36206cf07ccaefe153f38eb0eaad994"
     "1b6883dfbce01bcb5196041",
     "9f0747d7396bfbe01cf3e85361e50085e0a91a7490b994031d81851b725065993f45dad0d"
     "60d794aedec7ba5d9d6dbbee4",
     "3a86498f78c3fb7eb3b7b3d82f677d2dfe01166fe76e232083334d74f11588fd089637c94"
     "761e9cfe836436005deaef7",
     false},

    {24, "long message",
     "dc770c64d00d156e43cb74970e3a1a2ad28b6d9ec6b2b6e5ac3e356a99f879cb620f00340"
     "c044cc1f31bdccfa0dbd177",
     "403fd8e3ef51b6539db658a894be85b58fbc84881e61c5e0cb13ae421a09d31d780603256"
     "d390edd056d190856be00ad20a7048f0c67416fe8e02884086155f4263262e8c1275504d4"
     "f91f2751d3c3dccd4409ff2b45e41de93f7b104d58f6e15bacb62ace9700615ecc1b30a0c"
     "c1b35",
     "1c4f6474f39e6eabbe7a99faa234f49833444130acf01dae68d68251a930419960b0fb5f4"
     "8360149e05d1209941cc9ec",
     false},

    {25, "long message",
     "cca9299c7bdc26a4b595055c99ca23bec8ed11b5deeda91f83e2365e7340395ceef4e86e5"
     "cd91f2593bcfec498a67fc9",
     "a05b40b8d3a7bc7b75b0e97309c9bd1c9d8755c1ff5245ef6308a6a5cad3ecfbcb6364b41"
     "ca6f3d24bbee844d6204d1026abe345af7bdec114a373b109aa5724b738d50ab7a826c268"
     "e873709f8b35135a870045d5fb9daa82d3c245b5338917354e72b3058c9a4b80711746521"
     "7d7d14f36f8a8d4e97bc3b93587c92641e7",
     "1b6b5ba848bc13dd46c35177ae9ff9bd2d6ca5f4c9373964d3182483d980b4654527f36d7"
     "cc51b9e2efe7ed97a82e3be",
     false},

    {26, "long message",
     "c728e65e08d9296fe3cdf2dedb49c81a30b603a62569eece4ee5d01e9a32ae3bcb4ec163e"
     "455e452582454ceefefc046",
     "e6c6bac87c17e269a471434ca9568401451d78c2444a9d6edcda3cdab51c5bed1c19eaf34"
     "326580fd85ae5236ad51bc5dae386b36101f54695c595eeedcdd0182a4a117f8093f4f481"
     "2e03db396ede9849d193e7722081aeec4be6c4caf6c979d36ead56634a21be21162ea232d"
     "ec9cffdbd2474245878dca369e814fd028303",
     "533920a013cf006aa29b26f74b6dd293634293089986aa249271c426b942dc6bae32b2641"
     "616672f3d75968866e182e5",
     false},

    {27, "long message",
     "90c4215dc3f237435047fefdd8638d339a3fc66fca06c5063eacbda002ab335e621605f67"
     "2f3da9f641fae110afc3e7b",
     "1ebc22c3031b64615eb6f1a0696e33b7df139a4b891d3e6721cc26c05d55de790dca62366"
     "8c10308485d38e95ec4769fa4430ca3ebc25da9f5d31c972674517d9a2222e6b97d8def65"
     "12af096c6d1480d83a229c84b7f28c80184b6bebf3f4eff5fc4e5c6cfea4f8eba9a957f79"
     "13b20a88ad1734f7c38547e934d1dbf2d73dbd61e31fb1583c7b6577a171e7d02f1904512"
     "6ac2973d855bc18d34d32326d1e216da58366a60033450091128ae26a479069bba7b91b2a"
     "b7f3c5fbcde391de3ca114b951d6852f92795f8023d7a29a7f4ce61e9241b4f235d21e899"
     "087167ab3f3a0e9321c7942b165178788df48d3b106b203ec1e01d29bda41a99ac0d2c00",
     "c52b91daed6ee46416f2db78978251cb334e5d8e00b32ae06e365f455d28de406a9cce2f9"
     "f29378f229822dbf26bfdad",
     false},

    {28, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "45be81c415d283ab7a62a45188e5dafbcb97da606bd5b16c92c1fc36f198c0b3a71492184"
     "8d5e03df1c4849bb8310c66",
     true},

    {29, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a84d07ff90b338e064b03603d76bcf0214b1fb88c66b9415dde76674896400f97b8408bfe"
     "fa6ee86c716bfa4a460d216",
     true},

    {30, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "46be81c415d283ab7a62a45188e5dafbcb97da606bd5b16c92c1fc36f198c0b3a71492184"
     "8d5e03df1c4849bb8310c66",
     true},

    {31, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "ab4d07ff90b338e064b03603d76bcf0214b1fb88c66b9415dde76674896400f97b8408bfe"
     "fa6ee86c716bfa4a460d216",
     true},

    {32, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "c4be81c415d283ab7a62a45188e5dafbcb97da606bd5b16c92c1fc36f198c0b3a71492184"
     "8d5e03df1c4849bb8310c66",
     true},

    {33, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "294d07ff90b338e064b03603d76bcf0214b1fb88c66b9415dde76674896400f97b8408bfe"
     "fa6ee86c716bfa4a460d216",
     true},

    {34, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "44bf81c415d283ab7a62a45188e5dafbcb97da606bd5b16c92c1fc36f198c0b3a71492184"
     "8d5e03df1c4849bb8310c66",
     true},

    {35, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94c07ff90b338e064b03603d76bcf0214b1fb88c66b9415dde76674896400f97b8408bfe"
     "fa6ee86c716bfa4a460d216",
     true},

    {36, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "44be814415d283ab7a62a45188e5dafbcb97da606bd5b16c92c1fc36f198c0b3a71492184"
     "8d5e03df1c4849bb8310c66",
     true},

    {37, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d077f90b338e064b03603d76bcf0214b1fb88c66b9415dde76674896400f97b8408bfe"
     "fa6ee86c716bfa4a460d216",
     true},

    {38, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "44be81c414d283ab7a62a45188e5dafbcb97da606bd5b16c92c1fc36f198c0b3a71492184"
     "8d5e03df1c4849bb8310c66",
     true},

    {39, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff91b338e064b03603d76bcf0214b1fb88c66b9415dde76674896400f97b8408bfe"
     "fa6ee86c716bfa4a460d216",
     true},

    {40, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "44be81c417d283ab7a62a45188e5dafbcb97da606bd5b16c92c1fc36f198c0b3a71492184"
     "8d5e03df1c4849bb8310c66",
     true},

    {41, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff92b338e064b03603d76bcf0214b1fb88c66b9415dde76674896400f97b8408bfe"
     "fa6ee86c716bfa4a460d216",
     true},

    {42, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "44be81c415d2832b7a62a45188e5dafbcb97da606bd5b16c92c1fc36f198c0b3a71492184"
     "8d5e03df1c4849bb8310c66",
     true},

    {43, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b3386064b03603d76bcf0214b1fb88c66b9415dde76674896400f97b8408bfe"
     "fa6ee86c716bfa4a460d216",
     true},

    {44, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "44be81c415d283ab7b62a45188e5dafbcb97da606bd5b16c92c1fc36f198c0b3a71492184"
     "8d5e03df1c4849bb8310c66",
     true},

    {45, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b338e065b03603d76bcf0214b1fb88c66b9415dde76674896400f97b8408bfe"
     "fa6ee86c716bfa4a460d216",
     true},

    {46, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "44be81c415d283abfa62a45188e5dafbcb97da606bd5b16c92c1fc36f198c0b3a71492184"
     "8d5e03df1c4849bb8310c66",
     true},

    {47, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b338e0e4b03603d76bcf0214b1fb88c66b9415dde76674896400f97b8408bfe"
     "fa6ee86c716bfa4a460d216",
     true},

    {48, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "44be81c415d283ab7a42a45188e5dafbcb97da606bd5b16c92c1fc36f198c0b3a71492184"
     "8d5e03df1c4849bb8310c66",
     true},

    {49, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b338e064903603d76bcf0214b1fb88c66b9415dde76674896400f97b8408bfe"
     "fa6ee86c716bfa4a460d216",
     true},

    {50, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "44be81c415d283ab7a62a55188e5dafbcb97da606bd5b16c92c1fc36f198c0b3a71492184"
     "8d5e03df1c4849bb8310c66",
     true},

    {51, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b338e064b03703d76bcf0214b1fb88c66b9415dde76674896400f97b8408bfe"
     "fa6ee86c716bfa4a460d216",
     true},

    {52, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "44be81c415d283ab7a62a45189e5dafbcb97da606bd5b16c92c1fc36f198c0b3a71492184"
     "8d5e03df1c4849bb8310c66",
     true},

    {53, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b338e064b03603d66bcf0214b1fb88c66b9415dde76674896400f97b8408bfe"
     "fa6ee86c716bfa4a460d216",
     true},

    {54, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "44be81c415d283ab7a62a4518ae5dafbcb97da606bd5b16c92c1fc36f198c0b3a71492184"
     "8d5e03df1c4849bb8310c66",
     true},

    {55, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b338e064b03603d56bcf0214b1fb88c66b9415dde76674896400f97b8408bfe"
     "fa6ee86c716bfa4a460d216",
     true},

    {56, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "44be81c415d283ab7a62a45108e5dafbcb97da606bd5b16c92c1fc36f198c0b3a71492184"
     "8d5e03df1c4849bb8310c66",
     true},

    {57, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b338e064b03603576bcf0214b1fb88c66b9415dde76674896400f97b8408bfe"
     "fa6ee86c716bfa4a460d216",
     true},

    {58, "Flipped bit 376 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "44be81c415d283ab7a62a45188e5dafbcb97da606bd5b16c92c1fc36f198c0b3a71492184"
     "8d5e03df1c4849bb8310c67",
     true},

    {59, "Flipped bit 376 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b338e064b03603d76bcf0214b1fb88c66b9415dde76674896400f97b8408bfe"
     "fa6ee86c716bfa4a460d217",
     true},

    {60, "Flipped bit 377 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "44be81c415d283ab7a62a45188e5dafbcb97da606bd5b16c92c1fc36f198c0b3a71492184"
     "8d5e03df1c4849bb8310c64",
     true},

    {61, "Flipped bit 377 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b338e064b03603d76bcf0214b1fb88c66b9415dde76674896400f97b8408bfe"
     "fa6ee86c716bfa4a460d214",
     true},

    {62, "Flipped bit 382 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "44be81c415d283ab7a62a45188e5dafbcb97da606bd5b16c92c1fc36f198c0b3a71492184"
     "8d5e03df1c4849bb8310c26",
     true},

    {63, "Flipped bit 382 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b338e064b03603d76bcf0214b1fb88c66b9415dde76674896400f97b8408bfe"
     "fa6ee86c716bfa4a460d256",
     true},

    {64, "Flipped bit 383 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "44be81c415d283ab7a62a45188e5dafbcb97da606bd5b16c92c1fc36f198c0b3a71492184"
     "8d5e03df1c4849bb8310ce6",
     true},

    {65, "Flipped bit 383 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b338e064b03603d76bcf0214b1fb88c66b9415dde76674896400f97b8408bfe"
     "fa6ee86c716bfa4a460d296",
     true},

    {66, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "45be81c415d283ab7b62a45188e5dafbcb97da606bd5b16c92c1fc36f198c0b3a71492184"
     "8d5e03df1c4849bb8310c66",
     true},

    {67, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a84d07ff90b338e065b03603d76bcf0214b1fb88c66b9415dde76674896400f97b8408bfe"
     "fa6ee86c716bfa4a460d216",
     true},

    {68, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "44be814415d2832b7a62a45188e5dafbcb97da606bd5b16c92c1fc36f198c0b3a71492184"
     "8d5e03df1c4849bb8310c66",
     true},

    {69, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d077f90b3386064b03603d76bcf0214b1fb88c66b9415dde76674896400f97b8408bfe"
     "fa6ee86c716bfa4a460d216",
     true},

    {70, "Flipped bits 63 and 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "44be81c415d2832b7a62a45188e5da7bcb97da606bd5b16c92c1fc36f198c0b3a71492184"
     "8d5e03df1c4849bb8310c66",
     true},

    {71, "Flipped bits 63 and 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b3386064b03603d76bcf8214b1fb88c66b9415dde76674896400f97b8408bfe"
     "fa6ee86c716bfa4a460d216",
     true},

    {72, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "bb417e3bea2d7c54859d5bae771a25043468259f942a4e936d3e03c90e673f4c58eb6de7b"
     "72a1fc20e3b7b6447cef399",
     true},

    {73, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "56b2f8006f4cc71f9b4fc9fc289430fdeb4e047739946bea2218998b769bff06847bf7401"
     "059117938e9405b5b9f2de9",
     true},

    {74, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "0000000000000000000000000000000000000000000000000000000000000000000000000"
     "00000000000000000000000",
     true},

    {75, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "0000000000000000000000000000000000000000000000000000000000000000000000000"
     "00000000000000000000000",
     true},

    {76, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
     "fffffffffffffffffffffff",
     true},

    {77, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
     "fffffffffffffffffffffff",
     true},

    {78, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "c43e01449552032bfae224d108655a7b4b175ae0eb5531ec12417cb67118403327941298c"
     "85560bd7144041b38b18ce6",
     true},

    {79, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "29cd877f1033b860e430b68357eb4f8294317b0846eb14955d67e6f409e48079fb04883f6"
     "f266e0647963f2424e05296",
     true},

    {80, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "45bf80c514d382aa7b63a55089e4dbfaca96db616ad4b06d93c0fd37f099c1b2a61593194"
     "9d4e13cf0c5859ab9300d67",
     true},

    {81, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a84c06fe91b239e165b13702d66ace0315b0fa89c76a9514dce66775886501f87a8509bee"
     "ea7ef87c617bea5a561d317",
     true},

    {82, "empty message",
     "1c678267be13acb464939c2896c9e9ce1deb5b30833bdd9ca00370889b84410782ad52afe"
     "25dc10ab7ec5cf5f34793b7",
     "", "6dd566be678c1e6359ab31b635cc160160a0c5a9c49a0ac5", false},

    {83, "short message",
     "00b184c2c0a491d764a26f8b2e56a965222b36213bdd106ae782305c50f89269902476e5d"
     "f3fa58e0ecfae82a9607c8e",
     "9f", "5afff4b009ca9c9e5dcd84f05607e7a7d43ee43b42498989", false},

    {84, "short message",
     "055b67edb659e29c10e3e9cd25aa1cd5abf0880e2026ed8436e39b064b7315760cd7a9294"
     "ee23d4750969cc8b5dbaed7",
     "4047", "4d08baef969eed23b814472acff08d08fd3491a728778a1c", false},

    {85, "short message",
     "9e3c198e93930f076b035c5fa8f10d9a65e98c66cfb36633e3cb33279cdf57688f10b7472"
     "d1fc9d962ce6954519bfbf6",
     "88cfab", "1cde3765ba5a15b1d0182136a72c603acd3b904ceac8f7ad", false},

    {86, "short message",
     "f5f5962bda257b38b2a2318929121b2eaef792d5c6a9585e48b80cf5357b29c3951b787ed"
     "3e03e385b05b8ffe6861dc3",
     "d9397753", "4638e4427e6084b76c53ed9d6e916162fcb8b962c3d616f1", false},

    {87, "short message",
     "f62820ed5f9833fd22dee7bd49e2c9b19fc9668897c2c33e6c7c1fa5c277c3b9f581faef3"
     "ddc664ba537975d8afaa707",
     "9b6cc7caa4", "f6e272a7a6235f60b72b4c7424cf32a07f98ea592665bad8", false},

    {88, "short message",
     "f222a1dabf322aff8463acee6444939331212be3e19d31f4b73fdcc97e2925365ea33c985"
     "282805c83dcd8fb42a0e214",
     "c85ad7872b76", "933f0fa61d4466b5baf5a601f6b96d81a97e81c512d822e6", false},

    {89, "short message",
     "56e80f3899e945310a9d9bef3d32091f29c157dd46b2d439ad89d63e14b2c24390f74db4d"
     "905f6bd03f75c32e91225fe",
     "80ba25f1c27650", "a1a6e248b40864ddf83b00c52ae2c303b7e76fba0548d4d4",
     false},

    {90, "short message",
     "6cb6261a56a21b2c3c13453c158364aafa78f58172a9ae3eeb328ac38808b5c68c111197a"
     "303ec36847c9a315ac5eb5b",
     "79430de51d68cf34", "33593a80da455e580ccc5ee9b60edcd1468460539788fc41",
     false},

    {91, "short message",
     "44ca1ecb490470a84c7e13e1f1c69da21f48c33b6f050f48f7f244f0fda8b3c855904ed06"
     "12e2dafa5105cbd7f6449eb",
     "870b981c8afd9fae1b", "930f2e401e3aafb46a0c4029002f4ef1ab9fe838bc00c79e",
     false},

    {92, "short message",
     "aaca68882cfa7250988a247b96cfb3232d6567378f8fa7e7aaaca1c386e1ae15e54957d22"
     "bfff1e50ae7f21beea197a5",
     "a6f31b822ec24da1b1e9", "a9c2d68f0ad1ba50089b169c86d965f97f52388a48ace744",
     false},

    {93, "short message",
     "1b32f9b6378934a502dd74d8b74a4606d5b2c9a8587fab1cfa90d75007734d2b8bdfe6348"
     "15243526ebc0f33c04d0d05",
     "55367c657c792610efdcc0",
     "934083c8594591da783f0da28f4b58adb604e9cc76b99efe", false},

    {94, "short message",
     "09d91b2fa22e68b5335d478235aa4e157435c9acfed772219adfa1e9dd72f33e1a2183a02"
     "03a104f80e643cdf29e5aff",
     "b31e254957db6b1b70a06ce2",
     "7d45f3899455787e7116b570df8f7787f672d5821d6f75fe", false},

    {95, "short message",
     "d311a80ac801e3639b9185608af4a85e4122e29b5c23f05234c30d92d59ad13cb80390e5f"
     "a0ea4a54853228b356689f5",
     "e6b443dba0dab35d43ca5d6ce6",
     "27297096f58f598391c57778129949b94628bf17bb2422d1", false},

    {96, "short message",
     "06297e6c46558b9b0fc36c272b4ae7e65dd536cc1d13acbfa831fa5574b34f99e09adfb7f"
     "20321f203075fd26ed2e29d",
     "309b95e5f1ec26f70786e74d806d",
     "aabff26fc44a40f0b87a40c175c17ea7140f8467dcdb95cd", false},

    {97, "short message",
     "e8b63a25cd85ad4f39e3c0e9584eacb94d6ae33f984da259aa533d4d28aeb341cf3ffe49c"
     "029e4af6a4805f760f35f2c",
     "d225c27795f809454bb2c51d21f3ac",
     "0e12b758015ac89797d55470f3982c13a5ff1483276083d2", false},

    {98, "",
     "d83a685ace9fa0c0aa47f0c7b4f0f00717619a82e2eeff87f51f67d814d51dd9e4cad7578"
     "a4e49b672b5af83943c2583",
     "abfa7f5978f751e87e8b5a15a6e89f4f",
     "e4e6ba041bbb7a47ec8482b2043455c119fbdb389a3945a0", false},

    {99, "",
     "5beaf406a6627eaafcadb6dea4e27ba4fd879fd3e5bfd87ea3c8d5e0acfbbda2c6bf006be"
     "af5a30312e690724c4744a3",
     "bc57d467a9a2af64ad5e14b7bc0898dc63",
     "3fab1a7a192359b6333a9699b75612211a38b6dccab4572d", false},

    {100, "",
     "76b36cc3b8ca975708ee4b32bdbe40ca13f9ce384c52c4b6602b7fd92164f1fd8432706c1"
     "966f648bf4830f4deb34795",
     "b1d022c6536f401d147dfc0d7d4e600bb753ef0e9f243bc3",
     "c91eb3f362049c5336c5074cb887edcb27aac1ef6575a92d", false},

    {101, "",
     "20569a16f453dd3c34df98155286b1ca8a392ea164c919311f0df9d39d976062f4f992b96"
     "def3851886e6295f2615064",
     "5402c4e683d1a431868ad528afbf4128b0b10cef947d063b34d376d344b793b2",
     "27728059696aed5bb00a13c1db100691d4a21ebea0a8e4c3", false},

    {102, "long message",
     "9ef6a55f8a9b6b9ef1f8296167319078163706ae5b60897c2dd6e340b67ed5d577fb54c55"
     "47cd5f248f06e7082ffb826",
     "6a0d16276941d8f04eac2ec723fa53b9d6b16da7e30e7f2d9ad898e7cbb71bd3dd234ee22"
     "836ff4ac6011b6f12bd3a",
     "cef5d900eef0abefc625c1d2862a3f42998ce8b1e007d2b8", false},

    {103, "long message",
     "fb56bbbc6d751b744d8c1b57cc27a1d2c2f4e38e3491f54448cfcfb9389b7f63fd0d41920"
     "968ef612510625f2637d28d",
     "cf1791517ef5a61c0db65a668bee26fdbc975d799b2623cc0f3e4560e80c7014fa9c02d56"
     "8c98c86385e000fe6776bb7",
     "88e99accc9c23c9c8c1110e7470cade0317817916d8505f5", false},

    {104, "long message",
     "d041e24e59b34d7a18128a42d8a7a52dcba5d79e5ed585b55c7c9e4946e5ccaf7e59df0f3"
     "da98c7d0523e4cc8f9d7da4",
     "5279618f1b41534910395a78ded968aee3431085b599c4f55eb5ff8a2e879bc44291d923d"
     "e31009db1b9f7f81095afb3ea",
     "8500f603ce85c030cfa05731758b6be3317b6fe8e99b7d48", false},

    {105, "long message",
     "e1ce4884fd74a0e197c68ace3b29b552313af8e451e98d9ab8d0e8f8ee74143e8fcb64462"
     "17c0f3123a426b8ab6f62cb",
     "71154b9a657b905f884ba5140d5e7b9243fec3e03fbbdbb360c8194963ae43177b5502cd2"
     "0f559eeeff8638d028c501926ebc7eddd132ccea29ead7ad0c95a30b9d325952cafb0ea5e"
     "c9d9d6fdeb63950d5d69c8bbbea702aed1d444da286807ffd6b36cb49902cba7abf9bda1b"
     "577c6",
     "c7e9ae2a81de32280b518d055c2c9d7f0f5db6d06ad0e4ae", false},

    {106, "long message",
     "8a242c22d1b54ce216ca03c88455beb128211a9f35af2343709af7c5f43a681451ea53a36"
     "de2e5048eb44a51681c6120",
     "ab5eee6b83869119f00dd3cc66dde75cb5700535a90e9b3e32b31434c297ef53f94659d7d"
     "9b11323161b2e66c6b9c9ad20e313303f81e88e471786c8e936011f78121e39630b2e0804"
     "fc97ce5cb3a34f26949439fe530adcea6e97c78b042e0817253bf75dd54335584122f5edd"
     "210341b6d93f58aa1b4de2aad76fecec44f",
     "77392b18577ba8819fbd76fc73d45029e55e7ebecd58a320", false},

    {107, "long message",
     "311c4bee7cf257b780135a2e4a6413e68a816f5d8462515dcb1c72494b6335581a9b60a21"
     "7b9ff1c75e7768148f8df46",
     "63ccc3849c4c323cb6ce926877969048b849ee4af18e71eef52fe9f274a8678560f9a5d47"
     "510c3c98c8a08ed4c01a01e0a3663ef0cc6c3cdca6276d91e99b0d414263498fb64ad74b8"
     "20ab52b37adeaf27cb44545edb8f09094992837b8d3a0baa2a101a49592eb889dc8bace4c"
     "71e3efcb9d4149bd670ce2f774d73c12f2a45",
     "94674aaefc06eead22d15317900fa26c8df8cdfb252bcaae", false},

    {108, "long message",
     "fb792867c8928f0503aa24477cebf42e0b018346e3619770b9e8f5097945e2e275ad06f0c"
     "12152366ac06e278c94090a",
     "0a63e6d91d7a6a18dbad879fb8e23ae351920391eb40fead6cba846768a2c6797ff347b43"
     "01327b09afc41f7b803af6b61f6d9b818e0ddcc02536d0543dbf1a87f2c5e020f64590943"
     "44b72596d548435c313544e92c254d54a70a1d6f6edd2f82540a1ea2e82125b0715fa0f89"
     "0bb2be4ba0065d2ba0144854682aed041c1035996648e2ed671b7253ba567ffb999d91fd8"
     "e7ffce5c6dc4790732adae443435a454fe6c2a7c6708d9d5b2eb9292d6fbe5e026d65332b"
     "38c7925eff9beb89063cab63fbecb2ac0e1bb61a5b1e511f949c43a34ee26f1156e97793d"
     "a97bcf5b5c67641384f268131b297857d719eeb6cafa3dbe9b8d0da55c98656f20e5b39b",
     "1aaaff966c0a84bac791ab9e0b9b505d393073665732a74a", false},

    {109, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "45be81c415d283ab7a62a45188e5dafbcb97da606bd5b16c", true},

    {110, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a84d07ff90b338e064b03603d76bcf0214b1fb88c66b9415", true},

    {111, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "46be81c415d283ab7a62a45188e5dafbcb97da606bd5b16c", true},

    {112, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "ab4d07ff90b338e064b03603d76bcf0214b1fb88c66b9415", true},

    {113, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "c4be81c415d283ab7a62a45188e5dafbcb97da606bd5b16c", true},

    {114, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "294d07ff90b338e064b03603d76bcf0214b1fb88c66b9415", true},

    {115, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "44bf81c415d283ab7a62a45188e5dafbcb97da606bd5b16c", true},

    {116, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94c07ff90b338e064b03603d76bcf0214b1fb88c66b9415", true},

    {117, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "44be814415d283ab7a62a45188e5dafbcb97da606bd5b16c", true},

    {118, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d077f90b338e064b03603d76bcf0214b1fb88c66b9415", true},

    {119, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "44be81c414d283ab7a62a45188e5dafbcb97da606bd5b16c", true},

    {120, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff91b338e064b03603d76bcf0214b1fb88c66b9415", true},

    {121, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "44be81c417d283ab7a62a45188e5dafbcb97da606bd5b16c", true},

    {122, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff92b338e064b03603d76bcf0214b1fb88c66b9415", true},

    {123, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "44be81c415d2832b7a62a45188e5dafbcb97da606bd5b16c", true},

    {124, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b3386064b03603d76bcf0214b1fb88c66b9415", true},

    {125, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "44be81c415d283ab7b62a45188e5dafbcb97da606bd5b16c", true},

    {126, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b338e065b03603d76bcf0214b1fb88c66b9415", true},

    {127, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "44be81c415d283abfa62a45188e5dafbcb97da606bd5b16c", true},

    {128, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b338e0e4b03603d76bcf0214b1fb88c66b9415", true},

    {129, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "44be81c415d283ab7a42a45188e5dafbcb97da606bd5b16c", true},

    {130, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b338e064903603d76bcf0214b1fb88c66b9415", true},

    {131, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "44be81c415d283ab7a62a55188e5dafbcb97da606bd5b16c", true},

    {132, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b338e064b03703d76bcf0214b1fb88c66b9415", true},

    {133, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "44be81c415d283ab7a62a45189e5dafbcb97da606bd5b16c", true},

    {134, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b338e064b03603d66bcf0214b1fb88c66b9415", true},

    {135, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "44be81c415d283ab7a62a4518ae5dafbcb97da606bd5b16c", true},

    {136, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b338e064b03603d56bcf0214b1fb88c66b9415", true},

    {137, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "44be81c415d283ab7a62a45108e5dafbcb97da606bd5b16c", true},

    {138, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b338e064b03603576bcf0214b1fb88c66b9415", true},

    {139, "Flipped bit 184 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "44be81c415d283ab7a62a45188e5dafbcb97da606bd5b16d", true},

    {140, "Flipped bit 184 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b338e064b03603d76bcf0214b1fb88c66b9414", true},

    {141, "Flipped bit 185 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "44be81c415d283ab7a62a45188e5dafbcb97da606bd5b16e", true},

    {142, "Flipped bit 185 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b338e064b03603d76bcf0214b1fb88c66b9417", true},

    {143, "Flipped bit 190 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "44be81c415d283ab7a62a45188e5dafbcb97da606bd5b12c", true},

    {144, "Flipped bit 190 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b338e064b03603d76bcf0214b1fb88c66b9455", true},

    {145, "Flipped bit 191 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "44be81c415d283ab7a62a45188e5dafbcb97da606bd5b1ec", true},

    {146, "Flipped bit 191 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b338e064b03603d76bcf0214b1fb88c66b9495", true},

    {147, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "45be81c415d283ab7b62a45188e5dafbcb97da606bd5b16c", true},

    {148, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a84d07ff90b338e065b03603d76bcf0214b1fb88c66b9415", true},

    {149, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "44be814415d2832b7a62a45188e5dafbcb97da606bd5b16c", true},

    {150, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d077f90b3386064b03603d76bcf0214b1fb88c66b9415", true},

    {151, "Flipped bits 63 and 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "44be81c415d2832b7a62a45188e5da7bcb97da606bd5b16c", true},

    {152, "Flipped bits 63 and 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a94d07ff90b3386064b03603d76bcf8214b1fb88c66b9415", true},

    {153, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "bb417e3bea2d7c54859d5bae771a25043468259f942a4e93", true},

    {154, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "56b2f8006f4cc71f9b4fc9fc289430fdeb4e047739946bea", true},

    {155, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "000000000000000000000000000000000000000000000000", true},

    {156, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "000000000000000000000000000000000000000000000000", true},

    {157, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "ffffffffffffffffffffffffffffffffffffffffffffffff", true},

    {158, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "ffffffffffffffffffffffffffffffffffffffffffffffff", true},

    {159, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "c43e01449552032bfae224d108655a7b4b175ae0eb5531ec", true},

    {160, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "29cd877f1033b860e430b68357eb4f8294317b0846eb1495", true},

    {161, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "45bf80c514d382aa7b63a55089e4dbfaca96db616ad4b06d", true},

    {162, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "a84c06fe91b239e165b13702d66ace0315b0fa89c76a9514", true},

    {163, "short key", "08476e9d49499c5f52e37f80ece6f5a45459948806b48241", "",
     "1b6cfc8709aab8075465f32e13b0b0f796cc34d93d7bed090f297dcf9fb75e0d8e285b150"
     "0b732d554ac97ba45f33e47",
     false},

    {164, "short key", "213b44d8e1fabaff837ef30ee2542f9ab82ed70411dae78f",
     "ee0bf48585c186ff991b4d8607817c9c",
     "54f4010d50f80bcdb4b84d56bc4ef30e4c68f75128214cf446b5145f6fff1326a209945fc"
     "21ab5e1f5d917559ea9b800",
     false},

    {165, "short key", "b4afa9daaa8c944d73a3881f3221e42b34ef4e35f184e878",
     "cf607f6a0eb44ecbca81b6d1fdb595cee35f2353da02e82e28e133b9decd8fbb",
     "d064a51fb109c3b1d443f13f41e90e14198f846080464547806d46a8151c4e3855a81f4af"
     "40915609095dd72f869aa1b",
     false},

    {166, "short key", "89e46b66209548c80b0c830662223b49b0e3b895eb30e2fc", "",
     "4b012c0c0da44ede2a427e85ace8ecc54b379e9e24f08d41", false},

    {167, "short key", "f2c10ce8cb1cf3b363354473b027c1e53deccef03233be0c",
     "e1fa10b8e301e0348405770bc3fafcb1",
     "2d088af29cc744e347124fbe4100cbcdebbae037ed9bf69d", false},

    {168, "short key", "92e074442cc4c59e72260808d80d8e7b85c6335068917b83",
     "34eae27425ace17771e164cbb634306f352edc9c37bf608be8a755fb94148183",
     "b7e6b7bb29c02e4635dbdc50d8be71e2ddf0a544471de285", false},

    {169, "long key",
     "db6f9956c3f4ca6e41f1f7f14629d44c79e0353edbf3e310e6858bbc45a7cd57778a9053b"
     "a22a141bf58bfd434ad08648c7041a224b97a0d17e0edf94fd40b410a",
     "",
     "0cb1b296255bb259f3b601b49b35524a5eca6c52360754d3d96dd521c905b1c1821d74965"
     "967d8e86d50de950fe4d635",
     false},

    {170, "long key",
     "f03404bdb3e08f530d4c3a5f165d236012a4c45cd063e3e4483da088ec0afdb24e9639fcc"
     "abb91f98a49dc2972e2981426573ecfe69c00c43a2d99a3107cef3a70",
     "73ed9fa2acf49d6c98bfc7d6c5ad9c56",
     "b6132e5216f711eeeb44da3d92983fe5b6de5cd9410be71db8d3b07228341686aa60e7081"
     "e95f2e4b69bb7cd9648bc0b",
     false},

    {171, "long key",
     "ee799e25edb1b18452e5ed174bc6b2185a6754417d6cc05d736d2ba9efc8367e4b05ba0a2"
     "ee525ceeab74f9804a8479130c328d671e34070cf174a003a1dfb5994",
     "ac3e7da7e578b9b4dc2424030446c7f6aebcc471445a9e0e6e65099caeec5b2f",
     "c8607fca1888418166c550dd58d7a3976a6ecd0e4ca99b02fb187800a9c9ef909a6c1497c"
     "0652d4dca82405ab07f5eed",
     false},

    {172, "long key",
     "063d6e12e670098adabe68192023b637bb6d8d713fc8436188c4ec06fdd084ce6d193f26c"
     "86a9560e1abc27d813fce2b3eac0170fd1cb72e1930a2776bc84d6c11",
     "", "9dc2acbfa28a7ac5f2a5bdd4b1b2dbc806c48f96ce950eb5", false},

    {173, "long key",
     "359318e6c6279ba9ebcb1675f5a98195bbf5d895da9c17b8329038be857dc395b12ae91a5"
     "5598876593c1c20bc0172cf15126b7a6bf0a238eda3325d6dd60600ef",
     "7ad0c9098ea10e615bb672b52c96542d",
     "4163737c219f7c5e743843dc3d36019c6585ea5d4e7cf24f", false},

    {174, "long key",
     "d01cd898089d8a1eeb0035b0d332da80fbd3571b9192db10fa6f55f665ab192d7050cab64"
     "3996e99254d9573e0cf4eeaa63afccdefd81614fe7b83dfe30e3ba19f",
     "d67c77cdd0af5d10e8cae887e5a609bb76a9e5597653773c303b82b918fdc59f",
     "e7df527a988080749ee215ba0f8207838df38a37707a6330", false}};

#endif  // hmac_sha384_vectors_h__
