require_relative '../../spec_helper'
require_relative 'fixtures/classes'

describe "Method#owner" do
  it "returns the owner of the method" do
    "abc".method(:upcase).owner.should == String
  end

  it "returns the same owner when aliased in the same classes" do
    obj = MethodSpecs::Methods.new
    obj.method(:foo).owner.should == MethodSpecs::Methods
    obj.method(:bar).owner.should == MethodSpecs::Methods
  end

  it "returns the class/module it was defined in" do
    MethodSpecs::C.new.method(:baz).owner.should == MethodSpecs::A
    MethodSpecs::MySuper.new.method(:bar).owner.should == MethodSpecs::MyMod
  end

  describe "for a Method generated by respond_to_missing?" do
    it "returns the owner of the method" do
      @m = MethodSpecs::Methods.new
      @m.method(:handled_via_method_missing).owner.should == MethodSpecs::Methods
    end
  end

  it "returns the class on which public was called for a private method in ancestor" do
    MethodSpecs::InheritedMethods::C.new.method(:derp).owner.should == MethodSpecs::InheritedMethods::C
  end
end
