//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2002 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMOBJECTACTION_H
#define PMOBJECTACTION_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmvector.h"
#include "pmcontrolpoint.h"
#include "pmobjecttype.h"
#include <qptrlist.h>
#include <qstring.h>

class KAction;

/**
 * Helper class for object action functions.
 *
 * Each object can define actions that are inserted into the context
 * menu. This class stores informations of one action.
 *
 * The actionID has to be unique for each class.
 *
 * The member m_action is set later by the framework.
 */
class PMObjectAction
{
public:
   /** Constructor */
   PMObjectAction( PMObjectType ot, int actionID,
                   const QString& description, bool enabled = true )
   {
      m_class = ot;
      m_actionID = actionID;
      m_description = description;
      m_enabled = enabled;
      m_action = 0;
   }

   /** Returns the class type for the action */
   PMObjectType objectType( ) const { return m_class; }
   /** Returns the action ID */
   int actionID( ) const { return m_actionID; }
   /** Returns the description */
   QString description( ) const { return m_description; }

   /** Returns the enabled flag */
   bool isEnabled( ) const { return m_enabled; }
   /** Sets the enabled flag */
   void setEnabled( bool enable ) { m_enabled = enable; }

   /** Returns the action */
   KAction* action( ) const { return m_action; }
   /** Sets the action */
   void setAction( KAction* action ) { m_action = action; }
   
private:
   PMObjectType m_class;
   int m_actionID;
   QString m_description;
   bool m_enabled;
   KAction* m_action;
};

#endif
