/***************************************************************************
                          glowconfigdialog.cpp  -  description
                             -------------------
    begin                : Thu Sep 12 2001
    copyright            : (C) 2001 by Henning Burchardt
    email                : h_burchardt@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qbitmap.h>
#include <qsignalmapper.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <kglobal.h>
#include <kglobalsettings.h>
#include <kconfig.h>
#include <klocale.h>
#include <kcolorbutton.h>
#include <kpixmapeffect.h>
#include <kpixmap.h>
#include <kdebug.h>

#include "glowconfigdialog.h"
#include "../bitmaps.h"

#define NUMBER_OF_BUTTONS 5

extern "C"
{
	QObject* allocate_config( KConfig* conf, QWidget* parent )
	{
		return(new GlowConfigDialog(conf, parent));
	}
}

GlowConfigDialog::GlowConfigDialog( KConfig * conf, QWidget * parent )
	: QObject(parent)
{
	m_glowConfig = new KConfig("kwinglowrc");
	KGlobal::locale()->insertCatalogue("kwin_glow_config");

	m_mainGroupBox = new QGroupBox(0, Qt::Vertical, i18n("Decoration Settings"), parent);
	QVBoxLayout *mainGroupBoxLayout = new QVBoxLayout(m_mainGroupBox->layout());
	mainGroupBoxLayout->setAlignment(Qt::AlignTop | Qt::AlignLeft);
	mainGroupBoxLayout->setSpacing(6);

	m_showResizeHandleCheckBox = new QCheckBox(i18n("Show resize handle"), m_mainGroupBox);
	connect(m_showResizeHandleCheckBox, SIGNAL(clicked()),
		this, SLOT(slotResizeHandleCheckBoxChanged()));
	mainGroupBoxLayout->addWidget(m_showResizeHandleCheckBox);

	QHBoxLayout *titlebarGradientTypeLayout = new QHBoxLayout();
	m_titlebarGradientTypeComboBox = new QComboBox(m_mainGroupBox);

    KConfig *c = KGlobal::config();
    KConfigGroupSaver cgs( c, QString::fromLatin1("WM") );
    QColor activeBackground = c->readColorEntry("activeBackground");
    QColor activeBlend = c->readColorEntry("activeBlend");

	// If the colors are equal, change one to get a gradient effect
	if (activeBackground==activeBlend) {
		activeBackground = activeBackground.dark();
	}
	for (int i=0; i< KPixmapEffect::EllipticGradient; i++ ) {
		KPixmap gradPixmap(QSize(196,20));
		KPixmapEffect::gradient(gradPixmap, activeBackground,
								activeBlend, (KPixmapEffect::GradientType) i);

		m_titlebarGradientTypeComboBox->insertItem(gradPixmap, i);
	}

	connect(m_titlebarGradientTypeComboBox, SIGNAL(activated(int)),
		this, SLOT(slotTitlebarGradientTypeChanged(int)));
	titlebarGradientTypeLayout->addWidget(
		new QLabel(i18n("Titlebar gradient type:"), m_mainGroupBox));
	titlebarGradientTypeLayout->addWidget(m_titlebarGradientTypeComboBox);
	mainGroupBoxLayout->addLayout(titlebarGradientTypeLayout);

	m_buttonGlowColorGroupBox = new QGroupBox(
		0, Qt::Horizontal, i18n("Button Glow Colors"), m_mainGroupBox);
	QHBoxLayout *colorHBoxLayout =
		new QHBoxLayout(m_buttonGlowColorGroupBox->layout());

	// create buttons
	QSize buttonSize(DEFAULT_BITMAP_SIZE, DEFAULT_BITMAP_SIZE);
	QPixmap pm(buttonSize);
	pm.fill(Qt::black);
	
	m_stickyButton = new QPushButton(m_buttonGlowColorGroupBox);
	pm.setMask(QBitmap(buttonSize, stickyoff_bits, true));
	m_stickyButton->setPixmap(pm);
	colorHBoxLayout->addWidget(m_stickyButton);
	m_titleButtonList.push_back(m_stickyButton);

	m_helpButton = new QPushButton(m_buttonGlowColorGroupBox);
	pm.setMask(QBitmap(buttonSize, help_bits, true));
	m_helpButton->setPixmap(pm);
	colorHBoxLayout->addWidget(m_helpButton);
	m_titleButtonList.push_back(m_helpButton);

	m_iconifyButton = new QPushButton(m_buttonGlowColorGroupBox);
	pm.setMask(QBitmap(buttonSize, minimize_bits, true));
	m_iconifyButton->setPixmap(pm);
	colorHBoxLayout->addWidget(m_iconifyButton);
	m_titleButtonList.push_back(m_iconifyButton);

	m_maximizeButton = new QPushButton(m_buttonGlowColorGroupBox);
	pm.setMask(QBitmap(buttonSize, maximizeoff_bits, true));
	m_maximizeButton->setPixmap(pm);
	colorHBoxLayout->addWidget(m_maximizeButton);
	m_titleButtonList.push_back(m_maximizeButton);

	m_closeButton = new QPushButton(m_buttonGlowColorGroupBox);
	pm.setMask(QBitmap(buttonSize, close_bits, true));
	m_closeButton->setPixmap(pm);
	colorHBoxLayout->addWidget(m_closeButton);
	m_titleButtonList.push_back(m_closeButton);
	

	// create signal mapper
	m_titleButtonMapper = new QSignalMapper(this);
	for( uint i=0; i<m_titleButtonList.size(); i++ ) {
		m_titleButtonMapper->setMapping(m_titleButtonList[i], i);
		connect(m_titleButtonList[i], SIGNAL(clicked()),m_titleButtonMapper, SLOT(map()));
	}
	connect(m_titleButtonMapper, SIGNAL(mapped(int)),this, SLOT(slotTitleButtonClicked(int)));

	m_colorButton = new KColorButton(m_buttonGlowColorGroupBox);
	m_colorButton->setEnabled(false);
	connect(m_colorButton, SIGNAL(changed(const QColor&)),
		this, SLOT(slotColorButtonChanged(const QColor&)));

	colorHBoxLayout->addItem(new QSpacerItem(
		200, 20, QSizePolicy::Expanding, QSizePolicy::Minimum));
	colorHBoxLayout->addWidget(m_colorButton);

	mainGroupBoxLayout->addWidget(m_buttonGlowColorGroupBox);

	// load config and update user interface
	load(conf);

	m_mainGroupBox->show();
}

GlowConfigDialog::~GlowConfigDialog()
{
	delete m_mainGroupBox;
	delete m_glowConfig;
	delete[] m_buttonConfigMap;
}

void GlowConfigDialog::load( KConfig* /* conf */ )
{
	QColor color;
	const QColor defaultButtonColor(DEFAULT_BUTTON_COLOR);
	const QColor defaultCloseButtonColor(DEFAULT_CLOSE_BUTTON_COLOR);
	
	m_glowConfig->setGroup("General");

	m_buttonConfigMap = new QColor[NUMBER_OF_BUTTONS];
	color = m_glowConfig->readColorEntry("stickyButtonGlowColor", &defaultButtonColor);
	m_buttonConfigMap[stickyButton] = color;

	color = m_glowConfig->readColorEntry("helpButtonGlowColor", &defaultButtonColor);
	m_buttonConfigMap[helpButton] = color;

	color = m_glowConfig->readColorEntry("iconifyButtonGlowColor", &defaultButtonColor);
	m_buttonConfigMap[iconifyButton] = color;

	color = m_glowConfig->readColorEntry("maximizeButtonGlowColor", &defaultButtonColor);
	m_buttonConfigMap[maximizeButton] = color;

	color = m_glowConfig->readColorEntry("closeButtonGlowColor", &defaultCloseButtonColor);
	m_buttonConfigMap[closeButton] = color;

	m_showResizeHandle = m_glowConfig->readBoolEntry("showResizeHandle", true);
	m_titlebarGradientType = static_cast<KPixmapEffect::GradientType>
							(m_glowConfig->readNumEntry("titlebarGradientType", 
							KPixmapEffect::DiagonalGradient));

	m_showResizeHandleCheckBox->setChecked(m_showResizeHandle);
	m_titlebarGradientTypeComboBox->setCurrentItem(m_titlebarGradientType);
}

void GlowConfigDialog::save( KConfig* /* conf */ )
{
	m_glowConfig->setGroup("General");

	m_glowConfig->writeEntry("stickyButtonGlowColor", m_buttonConfigMap[stickyButton]);
	m_glowConfig->writeEntry("helpButtonGlowColor", m_buttonConfigMap[helpButton]);
	m_glowConfig->writeEntry("iconifyButtonGlowColor", m_buttonConfigMap[iconifyButton]);
	m_glowConfig->writeEntry("maximizeButtonGlowColor", m_buttonConfigMap[maximizeButton]);
	m_glowConfig->writeEntry("closeButtonGlowColor", m_buttonConfigMap[closeButton]);

	m_glowConfig->writeEntry("showResizeHandle", m_showResizeHandle);
	m_glowConfig->writeEntry("titlebarGradientType", m_titlebarGradientType);

	m_glowConfig->sync();
}

void GlowConfigDialog::defaults()
{
	const QColor defaultButtonColor = DEFAULT_BUTTON_COLOR;
	const QColor defaultCloseButtonColor = DEFAULT_CLOSE_BUTTON_COLOR;

	m_buttonConfigMap[stickyButton] = defaultButtonColor;
	m_buttonConfigMap[helpButton] = defaultButtonColor;
	m_buttonConfigMap[iconifyButton] = defaultButtonColor;
	m_buttonConfigMap[maximizeButton] = defaultButtonColor;
	m_buttonConfigMap[closeButton] = defaultCloseButtonColor;

	m_showResizeHandle = true;
	m_titlebarGradientType = KPixmapEffect::DiagonalGradient;

	m_showResizeHandleCheckBox->setChecked(m_showResizeHandle);
	m_titlebarGradientTypeComboBox->setCurrentItem(m_titlebarGradientType);
}

void GlowConfigDialog::slotTitlebarGradientTypeChanged(int index)
{
	m_titlebarGradientType = static_cast<KPixmapEffect::GradientType>(index);
	emit changed();
}

void GlowConfigDialog::slotResizeHandleCheckBoxChanged()
{
	m_showResizeHandle = m_showResizeHandleCheckBox->isChecked();
	emit changed();
}

void GlowConfigDialog::slotTitleButtonClicked(int index)
{
	for( int i=0; i< ((int) m_titleButtonList.size()); i++ ) {
		m_titleButtonList[i]->setDown(i==index);
	}
	m_colorButton->setEnabled(true);
	m_colorButton->setColor(m_buttonConfigMap[index]);
}

void GlowConfigDialog::slotColorButtonChanged(const QColor& glowColor)
{
	if( m_stickyButton->isDown() ) {
		m_buttonConfigMap[stickyButton] = glowColor;
	} else if( m_helpButton->isDown() ) {
		m_buttonConfigMap[helpButton] = glowColor;
	} else if( m_iconifyButton->isDown() ) {
		m_buttonConfigMap[iconifyButton] = glowColor;
	} else if( m_maximizeButton->isDown() ) {
		m_buttonConfigMap[maximizeButton] = glowColor;
	} else {
		m_buttonConfigMap[closeButton] = glowColor;
	}
	emit changed();
}

#include "glowconfigdialog.moc"
