#ifndef XFDATA_H
#define XFDATA_H

#include <qstring.h>

struct GraphicsCard {
    GraphicsCard() : maxClock( 0 ), fixedClock( false ), ram( -1 ) {}

    QString deviceSection;
    QString moduleSection;
    QString driverName;
    
    float maxClock;
    bool fixedClock;
    QString fixedClocks;

    int ram;
    
    void dump() const;
};

struct LCDMonitor {
    QString model;
    QString horizSync;

    void dump() const;
};

struct Monitor {
    Monitor() : hMin( 0 ), hMax( 0 ), vMin( 0 ), vMax( 0 ) {}

    QString vendor;
    QString model;
    int hMin;
    int hMax;
    int vMin;
    int vMax;
    QString modeLines;

    QString hSyncToken;
    QString vSyncToken;

    void dump() const;
};

#endif
