/*-
 * config.h --
 *	PMake configuration for LSF remote execution.
 *
 * Copyright (c) 1988 by the Regents of the University of California
 * Copyright (c) 1988 by Adam de Boor
 * Copyright (c) 1995 by Andreas Stolcke
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  Neither the University of California nor
 * Adam de Boor nor Andreas Stolcke makes any representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 *	"$Id: config.h,v 1.2 1995/08/19 17:58:30 stolcke Exp $ ICSI (Berkeley)"
 */

/*
 * For LSF, everything's the same except we tell the job module to use
 * the Rmt interfaces.
 */
#include "../unix/config.h"

#if defined(sun) && defined(SVR4)
# define SOLARIS			/* needed by lsf.h */
#endif

#include <lsf/lsf.h>

/*
 * CAN_EXPORT
 *	If defined, indicates that an export system is installed. This
 *	activates the -X and -x flags.
 * EXPORTDOC
 *	A name to identify the exportation facility used in this version
 *	of PMake.
 */
#define CAN_EXPORT
#define EXPORTDOC	_LS_VERSION_

/*
 * If you're using something more reliable than NFS for your filesystem,
 * nuke this #undef line. Look at the note in ../unix/config.h for its
 * meaning.
 */
#undef RECHECK

/*
 * LSF uses reserved ports for authentication
 */
#define USE_RESERVED_PORTS

