/*
	setup.c
	28.3.99 tn@xcdroast.org
*/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "largefile.h"
#include "gettext.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifdef HAVE_LOCALE_H
#include <locale.h>
#endif

#if ENABLE_NLS
# define _(String) gettext (String)
# define N_(String) gettext_noop (String)
#else
# define _(String) (String)
# define N_(String) (String)
#endif

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "xcdrdata.h"
#include "xcdroast.h"
#include "main.h"
#include "language.h"
#include "../xpms/ico_cdrom.xpm"
#include "../xpms/ico_cdwriter.xpm"
#include "../xpms/ico_dvdrom.xpm"
#include "../xpms/ico_dvdwriter.xpm"

extern GtkWidget *toplevel;
extern GtkWidget *sidespace;
extern GtkWidget *workspace;
extern writerreader_devices_t **writerreaderdevs;
extern writer_driver_t **drivers;
extern gchar *language;
extern setup_data_t setupdata;
extern current_set_t curset;
extern gchar configdir[MAXLINE];
extern gchar rootconfig[MAXLINE];
extern gchar xcdroast_version_loaded[MAXLINE];
extern gchar sharedir[MAXLINE];
extern gint altdevscan;

static setup_data_t bak_setupdata;
static writerreader_bak_t **bak_writerreader;
static GtkCList *clist_list, *dev_scan_clist;
static GtkCList  *users_clist, *hosts_clist;
static GtkWidget *clist_entry, *rootusers_entry, *roothosts_entry;
static GtkWidget *updatesum_label, *updatebutton;
static GtkWidget *cddb_entry1, *cddb_entry2, *log_entry;
static GtkWidget *cddb_entry3, *cddb_entry4, *cddb_opt1, *cddb_opt2;
static GtkWidget *btn_testdsp, *readslider1, *readslider2, *readspd1, *readspd2;
static GtkWidget *prodvdkey_txt;
static GtkWidget *cdr_drv_omenu, *cdr_mode_omenu, *rdr_para_check;
static GtkObject *cdr_spd_adj, *cdr_fifo_adj;
static GtkWidget *writer_frame, *reader_frame;
static GtkObject *rdr_spd_adj, *rdr_sec_adj, *rdr_ovrl_adj, *rdr_para_adj;
static GtkWidget *writer_omenu, *reader_omenu;
static GtkWidget *nrs_frame, *nrs_page, *nrs_dialog;
static gint nrs_mode, nrs_fromsetup;
static gint nrs_dialog_done;
static GtkWidget *gen_nonroot_page1(gint act, gint fromsetup);
static GtkWidget *gen_nonroot_page2(gint act);
static GtkWidget *gen_nonroot_page3(gint act, gint status, gint fromsetup);

static void draw_scsi_scan_devs(GtkCList *clist);
static gint draw_cd_setup_writers(GtkWidget *menu, gint *firstdevnr); 
static gint draw_cd_setup_readers(GtkWidget *menu, gint *firstdevnr); 
static void writer_selected(GtkWidget *item, gpointer devnr);
static void reader_selected(GtkWidget *item, gpointer devnr); 

 
/* main functions of the setup-menu */
/* called by cancel-button */

static void menu_setup_cancel(GtkWidget *widget, gpointer data) {
gint i,j;

	dodebug(8, "canceling setup\n");
	dolog(2, "Cancel setup\n");
 
	/* restore the saved data - therefore deletes all changes */
	free_glist(&setupdata.image_dirs);
	memcpy(&setupdata,&bak_setupdata,sizeof(setup_data_t));
	setupdata.image_dirs = NULL;
	copy_glist(&setupdata.image_dirs, bak_setupdata.image_dirs);
	free_glist(&bak_setupdata.image_dirs);

#if !(defined(__MACH__) && defined(__APPLE__)) && (USE_NONROOTMODE == 1)
	if (isroot()) {
		setupdata.root_users_lists = NULL;
		setupdata.root_hosts_lists = NULL;
		free_glist(&setupdata.root_users_lists);
		free_glist(&setupdata.root_hosts_lists);
		copy_glist(&setupdata.root_users_lists, bak_setupdata.root_users_lists);
		free_glist(&bak_setupdata.root_users_lists);
		copy_glist(&setupdata.root_hosts_lists, bak_setupdata.root_hosts_lists);
		free_glist(&bak_setupdata.root_hosts_lists);
	}
#endif

	setupdata.dsp_device = g_strdup(bak_setupdata.dsp_device);
	g_free(bak_setupdata.dsp_device);
	setupdata.mix_device = g_strdup(bak_setupdata.mix_device);
	g_free(bak_setupdata.mix_device);
	setupdata.cddb_host = g_strdup(bak_setupdata.cddb_host);
	g_free(bak_setupdata.cddb_host);
	setupdata.cddb_proxy_host = g_strdup(bak_setupdata.cddb_proxy_host);
	g_free(bak_setupdata.cddb_proxy_host);
	setupdata.logfile = g_strdup(bak_setupdata.logfile);
	g_free(bak_setupdata.logfile);
	setupdata.ProDVDkey = g_strdup(bak_setupdata.ProDVDkey);
	g_free(bak_setupdata.ProDVDkey);

	/* restore and free also writerreader structure copy */
	if (bak_writerreader) {
		i = 0;
		while(bak_writerreader[i] != NULL) {
			/* get matching device for our saved data */
			j = get_writerreaderdevs_index(bak_writerreader[i]->devnr);
			/* device still valid? */
			if (j >= 0) {
				/* revert any possible changed values */
				writerreaderdevs[j]->writer_drvmode = bak_writerreader[i]->values[0];
				writerreaderdevs[j]->writer_mode = bak_writerreader[i]->values[1];
				writerreaderdevs[j]->writer_speed = bak_writerreader[i]->values[2];
				writerreaderdevs[j]->writer_fifo = bak_writerreader[i]->values[3];
				writerreaderdevs[j]->audioread_interface = bak_writerreader[i]->values[4];
				writerreaderdevs[j]->audioread_speed = bak_writerreader[i]->values[5];
				writerreaderdevs[j]->audioread_overlap = bak_writerreader[i]->values[6];
				writerreaderdevs[j]->audioread_sectorburst = bak_writerreader[i]->values[7];
				writerreaderdevs[j]->audioread_useparanoia = bak_writerreader[i]->values[8];
				writerreaderdevs[j]->audioread_paranoiaretries = bak_writerreader[i]->values[9];
			}
			g_free(bak_writerreader[i]);
			i++;
		}
		g_free(bak_writerreader);
		bak_writerreader = NULL;
	} 

 
	/* check if cancel and no config-file loaded */
	if (strcmp(xcdroast_version_loaded, "") == 0) {
		/* no config file - continue to lock duplicate and create
		   buttons */
        	create_main(1);
	} else {
		create_main(0);
	}
}


/* calculate all setup-data before leaving setup-menu */

static gint menu_setup_ok_work(GtkWidget *widget, gpointer data) {
gint i, n;
gchar *rowdata[2];
gchar tmp[MAXLINE], tmp2[MAXLINE];
gchar *buf, *locreturn, *p;

	dodebug(8, "confirming setup\n");

	/* create glist of image-dirs */
	free_glist(&setupdata.image_dirs);
	for (i = 0; i < clist_list->rows; i++) {
		gtk_clist_get_text(clist_list,i,0,rowdata);	
		setupdata.image_dirs = g_list_append(setupdata.image_dirs,
			g_strdup(rowdata[0]));
	}

	/* no image-dirs? */
	if (i == 0) {
		show_dialog(ICO_ERROR, _("No image-directories defined. You have to define at\nleast one directory for saving image data in order to continue."), T_CANCEL, NULL, NULL, 0);
		return 1;
	}

#if !(defined(__MACH__) && defined(__APPLE__)) && (USE_NONROOTMODE == 1)
	if (isroot()) {
		/* create glist of nonroot stuff */
		free_glist(&setupdata.root_users_lists);
		for (i = 0; i < users_clist->rows; i++) {
			gtk_clist_get_text(users_clist,i,0,rowdata);	
			setupdata.root_users_lists = g_list_append(setupdata.root_users_lists, g_strdup(rowdata[0]));
		}
		free_glist(&setupdata.root_hosts_lists);
		for (i = 0; i < hosts_clist->rows; i++) {
			gtk_clist_get_text(hosts_clist,i,0,rowdata);	
			setupdata.root_hosts_lists = g_list_append(setupdata.root_hosts_lists, g_strdup(rowdata[0]));
		}
	}
#endif


	if (strcmp(setupdata.language, "") != 0) {
		g_free(language);
		language = g_strdup(setupdata.language);
#ifdef HAVE_SETLOCALE
		locreturn = setlocale(LC_ALL, language);
		if (locreturn == NULL) {
			/* locate not supported? */
			g_snprintf(tmp,MAXLINE,_("The requested language with the locale\n\"%s\" is not available on this system.\nYour language setting will be ignored."), language);
			show_dialog(ICO_WARN, tmp, T_OK, NULL, NULL, 0);
		}
		setlocale (LC_NUMERIC, "C");
#endif 
	} else {
		/* get language from locale */
#ifdef HAVE_SETLOCALE
		setlocale (LC_ALL, "");
		setlocale (LC_NUMERIC, "C");
#endif
	}

	/* now generate mixer-device from dsp-device */
	g_free(setupdata.mix_device);
	if (setupdata.dsp_device != NULL) {
		setupdata.mix_device = g_strdup(
			gen_mix_from_dspdev(setupdata.dsp_device,tmp));
	}

	/* now get cddb/log-entries */
	g_free(setupdata.cddb_host);
	strcpy(tmp, gtk_entry_get_text(GTK_ENTRY(cddb_entry1)));
	strip_string(tmp);
	setupdata.cddb_host = g_strdup(tmp);
	if (setupdata.cddb_use_http == 0) {
		setupdata.cddb_port = atoi(
			gtk_entry_get_text(GTK_ENTRY(cddb_entry2)));
	}
	g_free(setupdata.cddb_proxy_host);
	strcpy(tmp, gtk_entry_get_text(GTK_ENTRY(cddb_entry3)));
	strip_string(tmp);
	setupdata.cddb_proxy_host = g_strdup(tmp);
	setupdata.cddb_proxy_port = atoi(
		gtk_entry_get_text(GTK_ENTRY(cddb_entry4)));

	g_free(setupdata.logfile);
	strcpy(tmp, gtk_entry_get_text(GTK_ENTRY(log_entry)));
	/* check_tilde(tmp); */
	setupdata.logfile = g_strdup(tmp);

	g_free(setupdata.ProDVDkey);
	n = gtk_text_get_length(GTK_TEXT(prodvdkey_txt));
	buf = gtk_editable_get_chars(GTK_EDITABLE(prodvdkey_txt),0,n);
	strncpy(tmp, buf, MAXLINE);
	strip_string(tmp); 
	if ((p = strstr(tmp,"CDR_SECURITY=")) != NULL) {
		/* user pasted to much of the key - strip */
		setupdata.ProDVDkey = g_strdup(p+13);
	} else {
		setupdata.ProDVDkey = g_strdup(tmp);
	}
        g_snprintf(tmp2,MAXLINE,"CDR_SECURITY=%s", setupdata.ProDVDkey);

#if defined(HAVE_SETENV) && HAVE_SETENV == 1
        setenv("CDR_SECURITY", setupdata.ProDVDkey, 1);
#else  
        putenv(tmp2);
#endif

	/* save the current window size if we are asked to */
	if (setupdata.option_savepos) {
		gdk_window_get_root_origin(GTK_WIDGET(toplevel)->window,
			&setupdata.mainwindow.x, 
			&setupdata.mainwindow.y);
		gdk_window_get_size(GTK_WIDGET(toplevel)->window,
			&setupdata.mainwindow.width,
			&setupdata.mainwindow.height);
	}

	return 0;
}


/* called by ok-button */

static void menu_setup_ok(GtkWidget *widget, gpointer data) {
gint i, ret;
gchar tmp[MAXLINE];

	dolog(2, "Confirm setup\n");

	/* some lasts checks and warnings */
	if (is_dvdwriter(setupdata.writer_devnr) && !curset.isProDVD) {
		ret = show_dialog(ICO_WARN, _("Please note that you have to install ProDVD support before\nyou can write DVDs. Currently you will only be able to\nwrite regular CDs with your DVD-Writer."), T_OK,T_CANCEL, NULL, 0);
		if (ret == 1) {
			/* abort */
			return;
		}
	}

	/* get the writer device string */
	if (convert_devnr2busid(setupdata.writer_devnr, tmp) == 0) {

		/* ATAPI device? (only on linux) */
		if (strstr(tmp, "ATAPI")) {
			ret = show_dialog(ICO_WARN, _("You have selected an ATAPI device as your CD-Writer.\nThis is not a recommended setup - you will experience\nlong delays within X-CD-Roast and bad writing performance.\nSee the FAQ how to properly install scsi-emulation for best results."), T_OK,T_CANCEL, NULL, 0);
			if (ret == 1) {
				/* abort */
				return;
			}
		}
	}		

	if (menu_setup_ok_work(widget,data)) 
		return;

	/* free memory of backup-config */
	g_free(bak_setupdata.ProDVDkey);
	g_free(bak_setupdata.logfile);
	g_free(bak_setupdata.cddb_host);
	g_free(bak_setupdata.cddb_proxy_host);
	g_free(bak_setupdata.dsp_device);
	g_free(bak_setupdata.mix_device);
	free_glist(&bak_setupdata.image_dirs);
#if !(defined(__MACH__) && defined(__APPLE__)) && (USE_NONROOTMODE == 1)
	if (isroot()) {
		free_glist(&bak_setupdata.root_users_lists);
		free_glist(&bak_setupdata.root_hosts_lists);
	}
#endif

	/* free also writerreader structure copy */
	if (bak_writerreader) {
		i = 0;
		while(bak_writerreader[i] != NULL) {
			g_free(bak_writerreader[i]);
			i++;
		}
		g_free(bak_writerreader);
		bak_writerreader = NULL;
	} 
	
	strcpy(xcdroast_version_loaded, XCDROAST_VERSION);

        create_main(0);
}


/* called by save button */

static void menu_setup_save(GtkWidget *widget, gpointer data) {
gchar tmp2[MAXLINE];
gint stat;

	if (menu_setup_ok_work(widget,data))
		return;

	dolog(2, "Save setup configuration\n");

#if !(defined(__MACH__) && defined(__APPLE__)) && (USE_NONROOTMODE == 1)

	if (isroot()) {
		/* save special root config */
		stat = save_setup_config("", rootconfig);	

		/* make sure this config got the right permissions */
		/* fix_guid(); */
		/* chown(rootconfig, 0, getegid()); */
		chmod(rootconfig, 0644);
		/* fix_guid(); */
	} else {
#endif
		stat = save_setup_config(configdir, CONFFILE);

#if !(defined(__MACH__) && defined(__APPLE__)) && (USE_NONROOTMODE == 1)
	}
#endif

	/* write config file */
	if (stat == 1) {
		/* save failed */
		g_snprintf(tmp2,MAXLINE,_("Failed to save configuration file: %s"), CONFFILE);
		show_dialog(ICO_WARN, tmp2, T_OK, NULL, NULL, 0);
	} else {
		/* save ok */
		show_dialog(ICO_INFO,_("Configuration saved"), T_OK, NULL, NULL, 0);
	}
}


/* click on device-list */

static void device_select_row(GtkWidget *clist, gint row, gint col,
                     GdkEventButton *event, gpointer data) {

	/* double click? */
	if (event && event->type == GDK_2BUTTON_PRESS) {
		show_device_detail(writerreaderdevs[row]->devnr);
	}	
}


/* redraw the device scan glist and the writer/reader lists in setup
   after new devices are scanned
*/ 
 
static void redraw_writerreader_menus() {
gint firstdevnr;
GtkWidget *menu;

	/* redraw menus */
	if (dev_scan_clist) {
		gtk_clist_clear(dev_scan_clist);
		draw_scsi_scan_devs(dev_scan_clist);
	}
	if (writer_omenu) {
		/* replace current writer list by updated one */
		gtk_option_menu_remove_menu(GTK_OPTION_MENU(writer_omenu));
		menu = gtk_menu_new();
		draw_cd_setup_writers(menu, &firstdevnr);
		gtk_option_menu_set_menu(GTK_OPTION_MENU(writer_omenu), menu);

		setupdata.writer_devnr = firstdevnr;

		/* and update corresponding displayed writer data */
		writer_selected(NULL, GINT_TO_POINTER(setupdata.writer_devnr));
	}
	if (reader_omenu) {
		/* replace current reader list by updated one */
		gtk_option_menu_remove_menu(GTK_OPTION_MENU(reader_omenu));
		menu = gtk_menu_new();
		draw_cd_setup_readers(menu, &firstdevnr);
		gtk_option_menu_set_menu(GTK_OPTION_MENU(reader_omenu), menu);

		setupdata.reader_devnr = firstdevnr;

		/* and update corresponding displayed reader data */
		reader_selected(NULL, GINT_TO_POINTER(setupdata.reader_devnr));
	}
}


static void rescan_clicked(GtkWidget *widget, gpointer altdevscan) {
gint ret;

	ret = show_dialog(ICO_WARN,_("Are you sure you want to rescan for devices?\nThis will remove all manually configured devices and all\nsaved configuration data for the other devices."), 
		T_OK,T_CANCEL,NULL,1);

	if (ret == 1) {
		/* abort */
		return;
	}

	/* remove all device information */
	free_writerreader_data();

	/* scan */
	create_device_scanning(GPOINTER_TO_INT(altdevscan), 0, 0,  NULL); 

	redraw_writerreader_menus();
}


static void manual_add_clicked(GtkWidget *widget, gpointer data) {
gint ret, i, found;
gchar tmp[MAXLINE];

	ret = show_add_manual_device(tmp);
	if (ret != 0) {
		/* cancel */
		return;
	}

	strip_string(tmp);

	if (strlen(tmp) == 0) {
		show_dialog(ICO_ERROR,_("Invalid device specification."), T_OK, NULL, NULL, 0);
                return;
	}

	/* special case REMOTE and trailing colon */
	if (strstr(tmp,"REMOTE")) {
		if (tmp[strlen(tmp)-1] == ':') {
			/* strip last colon */
			tmp[strlen(tmp)-1] = '\0';
		}
	}

	/* check if such a device is already added */
	i = 0; found = 0;
	while(writerreaderdevs[i] != NULL) {
		if (strcmp(writerreaderdevs[i]->devicestr,tmp) == 0) {
			found = 1;
			break;
		}
		i++;
	}
	if (found) {
		show_dialog(ICO_ERROR,_("Device already existing."), T_OK, NULL, NULL, 0);
		return;
	}

	/* scan that single device and add to writerreader list */
	create_device_scanning(0, 1, 0, tmp);
	
	/* redraw menus if new device was found */	
	redraw_writerreader_menus();
}


/* remove a single device from the device list */

static void remove_single_device(gint devnr) {
gint ret;
gchar tmp[MAXLINE], tmp2[MAXLINE];

	convert_devnr2devstring(devnr, tmp);
	g_snprintf(tmp2, MAXLINE, _("Are you sure you want to remove the device\n%s\nfrom this configuration?"), tmp);

	ret = show_dialog(ICO_WARN, tmp2, T_YES,T_NO, NULL, 0);
	if (ret == 1) {
		/* abort */
		return;
	}

	/* remove device */
	remove_from_writerreader_data(devnr);

	/* redraw menus if new device was found */	
	redraw_writerreader_menus();
}


/* an item was selected on the popup menu */

static void scan_context_response(gint selected) {
GList *sel;
gint row;

	sel = dev_scan_clist->selection;
	if (sel) {
		row = GPOINTER_TO_INT(sel->data);
		switch (selected) {

		case 0:
			show_device_detail(writerreaderdevs[row]->devnr);
			break;
		
		case 1:
			remove_single_device(writerreaderdevs[row]->devnr);
			break;
		default:
			break;
		}
	}
}


static gint scan_activate_context(GtkWidget *widget, GdkEvent *event) {
gint click_x, click_y, row, col;
GtkCList *clist;

	/* find out which row was clicked */
	clist = dev_scan_clist; 
	click_x = (gint)event->button.x;
	click_y = (gint)event->button.y;

        if (!gtk_clist_get_selection_info(
                clist, click_x, click_y, &row, &col)) {
                row = -1;
                col = 0;
        }

        if (event->button.button == 3) {
		/* right button press? select row now */
		if (row >= 0) 
			gtk_clist_select_row(clist, row, 0);

                /* show context menu */
                gtk_menu_popup(GTK_MENU(widget), NULL, NULL, 
                        NULL, NULL, event->button.button, event->button.time);
                return TRUE;
        }
        return FALSE;
}


static void draw_scsi_scan_devs(GtkCList *clist) {
gint count;
GdkPixmap *pixmap;
GdkBitmap *mask;
gchar **xpm;
gchar *data[5];
gchar tmp[MAXLINE];
GtkStyle *style;

	style = gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(clist)));
	count = 0;
	while(writerreaderdevs[count] != NULL) {

		g_snprintf(tmp,MAXLINE,"[%s]",
			writerreaderdevs[count]->devicestr);

		data[0] = NULL;
		data[1] = tmp;
		data[2] = writerreaderdevs[count]->vendor;
		data[3] = writerreaderdevs[count]->model;
		data[4] = writerreaderdevs[count]->rev;
		gtk_clist_append(clist,data);

		xpm = ico_cdrom_xpm;
		if (writerreaderdevs[count]->is_dvdreader) {
			xpm = ico_dvdrom_xpm;
		}
		if (writerreaderdevs[count]->is_cdrwriter) {
			xpm = ico_cdwriter_xpm;
		}
		if (writerreaderdevs[count]->is_dvdwriter) {
			xpm = ico_dvdwriter_xpm;
		}

		pixmap = gdk_pixmap_create_from_xpm_d(clist->clist_window, 
			&mask, &style->bg[GTK_STATE_NORMAL],(gchar **)xpm);
		gtk_clist_set_pixmap(clist,count,0,pixmap,mask);
		
		count++;
	}
}


/* draw scsi-scan screen */

static void draw_scsi_scan(GtkWidget *win) {
gchar *titles[5];
GtkWidget *list, *vbox, *l1, *box2, *b1, *b2;
GtkCList *clist;
GtkWidget *scrolled_win;
GtkStyle *style;
GtkWidget *context_menu, *context_items;
#ifdef PRIV_COLS 
GdkColor c;
#endif

	dev_scan_clist = NULL;	

        vbox = gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(win),vbox);
        gtk_widget_show(vbox);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 5);
	gtk_box_pack_start(GTK_BOX(vbox),scrolled_win, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
		GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);

	titles[0] = _("Type");
	titles[1] = _("Device-Id");
	titles[2] = _("Vendor");
	titles[3] = _("Model");
	titles[4] = _("Rev.");

	list = gtk_clist_new_with_titles(5,titles);
	gtk_container_add (GTK_CONTAINER (scrolled_win), list);
	gtk_widget_realize(list);

	context_menu = gtk_menu_new();
	context_items = gtk_menu_item_new_with_label(_("Show details..."));
	gtk_menu_append(GTK_MENU(context_menu), context_items);
	gtk_signal_connect_object (GTK_OBJECT (context_items), 
                        "activate", GTK_SIGNAL_FUNC(scan_context_response),
			GINT_TO_POINTER(0));
	gtk_widget_show(context_items);
	context_items = gtk_menu_item_new_with_label(_("Remove device"));
	gtk_menu_append(GTK_MENU(context_menu), context_items);
	gtk_signal_connect_object (GTK_OBJECT (context_items), 
                        "activate", GTK_SIGNAL_FUNC(scan_context_response),
			GINT_TO_POINTER(1));
	gtk_widget_show(context_items);

	if (!isroot() && !(setupdata.root_option_change_writer &&
		setupdata.root_option_change_reader)) {
		gtk_widget_set_sensitive(context_items, FALSE);
	}


	clist = GTK_CLIST(list);
	dev_scan_clist = clist;
	gtk_clist_set_column_auto_resize(clist, 5, TRUE);

        gtk_signal_connect_object(GTK_OBJECT(clist), "button_press_event",
        	GTK_SIGNAL_FUNC(scan_activate_context), GTK_OBJECT(context_menu));

	style = gtk_style_copy(gtk_widget_get_style(list));
#ifdef PRIV_COLS 
	gdk_color_parse(GTKLISTCOL,&c);
	gdk_color_alloc(gtk_widget_get_colormap(list),&c);

	style->base[GTK_STATE_NORMAL] = c;
	gtk_widget_set_style(GTK_WIDGET(list),style);
#endif

	gtk_clist_set_row_height(clist, 48);
	gtk_clist_set_column_width(clist, 0, 48);
	gtk_clist_set_column_justification(clist, 0, GTK_JUSTIFY_CENTER);
	gtk_clist_set_column_width(clist, 1, tbf(220));
	gtk_clist_set_column_justification(clist, 1, GTK_JUSTIFY_CENTER);
	gtk_clist_set_column_width(clist, 2, tbf(70));
	gtk_clist_set_column_width(clist, 3, tbf(140));
	gtk_clist_set_column_width(clist, 4, tbf(35));
	gtk_signal_connect(GTK_OBJECT(clist), "select_row",
		GTK_SIGNAL_FUNC(device_select_row), NULL);
	
	draw_scsi_scan_devs(clist);

	gtk_widget_show(list);
	gtk_widget_show(scrolled_win);

	box2 = gtk_hbox_new(FALSE,0);
        gtk_box_pack_start(GTK_BOX(vbox),box2,FALSE,TRUE,5);
	b1 = gtk_button_new_with_label(_("Rescan devices"));
        gtk_signal_connect(GTK_OBJECT(b1),"clicked",
                GTK_SIGNAL_FUNC(rescan_clicked), GINT_TO_POINTER(altdevscan));
	gtk_box_pack_start(GTK_BOX(box2),b1,TRUE,TRUE,10);
	gtk_widget_show(b1);
	define_tooltip(b1,_("Removes the currently configured devices and scans for them again. Useful when you changed something in your hardware configuration."));

	if (!isroot() && !(setupdata.root_option_change_writer &&
		setupdata.root_option_change_reader)) {
		gtk_widget_set_sensitive(b1, FALSE);
	}

	b2 = gtk_button_new_with_label(_("Manually add device"));
        gtk_signal_connect(GTK_OBJECT(b2),"clicked",
                GTK_SIGNAL_FUNC(manual_add_clicked),NULL);
	gtk_box_pack_start(GTK_BOX(box2),b2,TRUE,TRUE,10);
	gtk_widget_show(b2);
	define_tooltip(b2,_("Add a device that wasn't recognized by the automatic scanning."));

	gtk_widget_show(box2);

	if (!isroot() && !(setupdata.root_option_change_writer &&
		setupdata.root_option_change_reader)) {
		gtk_widget_set_sensitive(b2, FALSE);
	}

	l1 = gtk_label_new(_("Please see http://www.xcdroast.org/faq when you miss a drive this list."));
	gtk_box_pack_start(GTK_BOX(vbox),l1, FALSE, TRUE, 0);
	gtk_widget_show(l1);
}


/* following functions are the callbacks for the cd-setup-menu */

static void speed_changed(GtkAdjustment *adj, GtkWidget *label) {
gchar tmp[MAXLINE];
gint i;

	i = get_writerreaderdevs_index(setupdata.writer_devnr);

	g_snprintf(tmp, MAXLINE,"%dx",(gint)adj->value);
	gtk_label_set_text(GTK_LABEL(label),tmp);
	if (!isroot() && !setupdata.root_option_change_writeparam) {
		set_labelcolor(label,DISABLEDCOLOR);
	}
	writerreaderdevs[i]->writer_speed = (gint)adj->value;
}


static void fifo_changed(GtkAdjustment *adj, GtkWidget *label) {
gchar tmp[MAXLINE];
gint i;

	i = get_writerreaderdevs_index(setupdata.writer_devnr);

	g_snprintf(tmp, MAXLINE,"%.1fMB",(gfloat)adj->value);
	gtk_label_set_text(GTK_LABEL(label),tmp);
	if (!isroot() && !setupdata.root_option_change_writeparam) {
		set_labelcolor(label,DISABLEDCOLOR);
	}
	writerreaderdevs[i]->writer_fifo = (gint)(adj->value * 1024);
}

static void audio_speed_changed(GtkAdjustment *adj, GtkWidget *label) {
gchar tmp[MAXLINE];
gint i;

	i = get_writerreaderdevs_index(setupdata.reader_devnr);

	g_snprintf(tmp, MAXLINE,"%dx",(gint)adj->value);
	gtk_label_set_text(GTK_LABEL(label),tmp);
	if (!isroot() && !setupdata.root_option_change_readparam) {
		set_labelcolor(label,DISABLEDCOLOR);
	}	
	writerreaderdevs[i]->audioread_speed = (gint)adj->value;
}

static void sectors_changed(GtkAdjustment *adj, GtkWidget *label) {
gchar tmp[MAXLINE];
gint i;

	i = get_writerreaderdevs_index(setupdata.reader_devnr);

	g_snprintf(tmp, MAXLINE,"%d",(gint)adj->value);
	gtk_label_set_text(GTK_LABEL(label),tmp);
	if (!isroot() && !setupdata.root_option_change_readparam) {
		set_labelcolor(label,DISABLEDCOLOR);
	}	
	writerreaderdevs[i]->audioread_overlap = (gint)adj->value;
}

static void sectors2_changed(GtkAdjustment *adj, GtkWidget *label) {
gchar tmp[MAXLINE];
gint i;

	i = get_writerreaderdevs_index(setupdata.reader_devnr);

	g_snprintf(tmp, MAXLINE,"%d",(gint)adj->value);
	gtk_label_set_text(GTK_LABEL(label),tmp);
	if (!isroot() && !setupdata.root_option_change_readparam) {
		set_labelcolor(label,DISABLEDCOLOR);
	}	
	writerreaderdevs[i]->audioread_sectorburst = (gint)adj->value;
}

static void sectors3_changed(GtkAdjustment *adj, GtkWidget *label) {
gchar tmp[MAXLINE];
gint i;

	i = get_writerreaderdevs_index(setupdata.reader_devnr);

	g_snprintf(tmp, MAXLINE,"%d",(gint)adj->value);
	gtk_label_set_text(GTK_LABEL(label),tmp);
	if (!isroot() && !setupdata.root_option_change_readparam) {
		set_labelcolor(label,DISABLEDCOLOR);
	}	
	writerreaderdevs[i]->audioread_paranoiaretries = (gint)adj->value;
}


static void writer_selected(GtkWidget *item, gpointer devnr) {
gint i,j;
GtkMenuShell *menu_shell;
GtkWidget *menuitem;
GList *loop;

	setupdata.writer_devnr = GPOINTER_TO_INT(devnr);

	/* i is the index in our writerreaderdevs structure */
	i = get_writerreaderdevs_index(setupdata.writer_devnr);

	/* no device? lock all the dialoge */ 
	if (i == -1) {
		if (writer_frame)
			gtk_widget_set_sensitive(writer_frame, FALSE);
		return;
	} else {
		if (writer_frame)
			gtk_widget_set_sensitive(writer_frame, TRUE);
	}

	/* update data displayed for this writer */
	if (cdr_drv_omenu) {
		gtk_option_menu_set_history(GTK_OPTION_MENU (cdr_drv_omenu),
			writerreaderdevs[i]->writer_drvmode +1);
	}
	if (cdr_mode_omenu) {
		gtk_option_menu_set_history(GTK_OPTION_MENU (cdr_mode_omenu),
			writerreaderdevs[i]->writer_mode);
		menu_shell = GTK_MENU_SHELL(GTK_OPTION_MENU (cdr_mode_omenu)->menu);
		/* loop through all given menu entries */
		j = 0;
		loop = g_list_first(menu_shell->children);
		while(loop) {
			menuitem = loop->data;	
			if (!writemode_supported(j, setupdata.writer_devnr)) {
				gtk_widget_set_sensitive(menuitem, FALSE);
			} else {
				gtk_widget_set_sensitive(menuitem, TRUE);
			}
			j++;
			loop = loop->next;
		}		
	}
	if (cdr_spd_adj) {
		/* We add 0.1 because otherwise the value of
	   	   zero is ignored. Very strange */
		gtk_adjustment_set_value(GTK_ADJUSTMENT (cdr_spd_adj), 
			(gfloat)writerreaderdevs[i]->writer_speed +0.1);
	}
	if (cdr_fifo_adj) {
		gtk_adjustment_set_value(GTK_ADJUSTMENT (cdr_fifo_adj), 
			(gfloat)(writerreaderdevs[i]->writer_fifo/1024));
	}
}

static void writermode_selected(GtkWidget *item, gpointer mode) {
gint i;
static gint showonce = 0;

	i = get_writerreaderdevs_index(setupdata.writer_devnr);

	/* user touched that setting? */
	if (writerreaderdevs[i]->writer_drvmode != GPOINTER_TO_INT(mode)) {
		if (!showonce) {
			showonce = 1;
			show_dialog(ICO_WARN,_("Please note that changing this setting to anything other\nthan \"autodetect\" is almost never required.\nDon't touch unless you are a cdrtools expert."),T_OK,NULL,NULL,0);
		}
	}
	writerreaderdevs[i]->writer_drvmode = GPOINTER_TO_INT(mode);
	
}


static void paranoia_selected(GtkWidget *item, gpointer data) {
gint i;

	i = get_writerreaderdevs_index(setupdata.reader_devnr);

	writerreaderdevs[i]->audioread_useparanoia = 
		gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item));

	if (writerreaderdevs[i]->audioread_useparanoia == 0) {
		gtk_widget_set_sensitive(readslider2,FALSE);
		set_labelcolor(readspd2,DISABLEDCOLOR);
		if (isroot() || setupdata.root_option_change_readparam) {
			gtk_widget_set_sensitive(readslider1,TRUE);
			set_labelcolor(readspd1,ENABLEDCOLOR);
		}
	} else {
		gtk_widget_set_sensitive(readslider1,FALSE);
		set_labelcolor(readspd1,DISABLEDCOLOR);
		if (isroot() || setupdata.root_option_change_readparam) {
			gtk_widget_set_sensitive(readslider2,TRUE);
			set_labelcolor(readspd2,ENABLEDCOLOR);
		}
	}
}


static void reader_selected(GtkWidget *item, gpointer devnr) {
gint i;

	setupdata.reader_devnr = GPOINTER_TO_INT(devnr);

	/* i is the index in our writerreaderdevs structure */
	i = get_writerreaderdevs_index(setupdata.reader_devnr);

	/* no device? lock all the dialoge */ 
	if (i == -1) {
		if (reader_frame)
			gtk_widget_set_sensitive(reader_frame, FALSE);
		return;
	} else {
		if (reader_frame)
			gtk_widget_set_sensitive(reader_frame, TRUE);
	}

	/* update data for this reader */
	if (rdr_spd_adj) {
		gtk_adjustment_set_value(GTK_ADJUSTMENT (rdr_spd_adj), 
			(gfloat)writerreaderdevs[i]->audioread_speed +0.1);
	}
	if (rdr_sec_adj) {
		gtk_adjustment_set_value(GTK_ADJUSTMENT (rdr_sec_adj), 
			(gfloat)writerreaderdevs[i]->audioread_sectorburst +0.1);
	}
	if (rdr_ovrl_adj) {
		gtk_adjustment_set_value(GTK_ADJUSTMENT (rdr_ovrl_adj), 
			(gfloat)writerreaderdevs[i]->audioread_overlap +0.1);
	}
	if (rdr_para_adj) {
		gtk_adjustment_set_value(GTK_ADJUSTMENT (rdr_para_adj), 
			(gfloat)writerreaderdevs[i]->audioread_paranoiaretries +0.1);
	}
	if (rdr_para_check) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rdr_para_check),
			writerreaderdevs[i]->audioread_useparanoia);
		paranoia_selected(rdr_para_check, NULL);
	}
}

#if 0
static void audiointerface_selected(GtkWidget *item, gpointer data) {
gint i;

	i = get_writerreaderdevs_index(setupdata.reader_devnr);
	writerreaderdevs[i]->audioread_interface = 
		gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item));
}
#endif

static void defwritemode_selected(GtkWidget *item, gpointer level) {
gint i;

	i = get_writerreaderdevs_index(setupdata.writer_devnr);
	writerreaderdevs[i]->writer_mode = GPOINTER_TO_INT(level);
}


static gint draw_cd_setup_writers(GtkWidget *menu, gint *firstdevnr) {
GtkWidget *menu_item;
gint i, menuhistory, menuidx;
gchar tmp[MAXLINE];

	menuidx = 0; menuhistory = -1; *firstdevnr = -1;
	i = 0;
	while(writerreaderdevs[i] != NULL) {

		/* only show writers here */
                if (writerreaderdevs[i]->is_cdrwriter ||
                    writerreaderdevs[i]->is_dvdwriter) {

			if (*firstdevnr == -1) {
				*firstdevnr = writerreaderdevs[i]->devnr;
			}
			if (convert_devnr2devstring(writerreaderdevs[i]->devnr,tmp) == 0) {
				menu_item = gtk_menu_item_new_with_label(tmp);
				gtk_signal_connect(GTK_OBJECT(menu_item),
					"activate", GTK_SIGNAL_FUNC(writer_selected),
					GINT_TO_POINTER(writerreaderdevs[i]->devnr));
				gtk_menu_append (GTK_MENU (menu), menu_item);
				/* look if this is the currently selected writer */
				if (setupdata.writer_devnr == writerreaderdevs[i]->devnr) { menuhistory = menuidx; }
				menuidx++;
				gtk_widget_show (menu_item);
			}
		}
		i++;
	}
	
	return menuhistory;
}

static gint draw_cd_setup_readers(GtkWidget *menu, gint *firstdevnr) {
GtkWidget *menu_item;
gint i, menuhistory, menuidx;
gchar tmp[MAXLINE];

	menuidx = 0; menuhistory = -1; *firstdevnr = -1;
	i = 0;
	while(writerreaderdevs[i] != NULL) {

		if (*firstdevnr == -1) {
			*firstdevnr = writerreaderdevs[i]->devnr;
		}
		if (convert_devnr2devstring(writerreaderdevs[i]->devnr,tmp) == 0) {
			menu_item = gtk_menu_item_new_with_label(tmp);
			gtk_signal_connect(GTK_OBJECT(menu_item),
				"activate", GTK_SIGNAL_FUNC(reader_selected),
				GINT_TO_POINTER(writerreaderdevs[i]->devnr));
			gtk_menu_append (GTK_MENU (menu), menu_item);

			if (setupdata.reader_devnr == writerreaderdevs[i]->devnr) { menuhistory = menuidx; }
			menuidx++;
			gtk_widget_show (menu_item);
		}
		i++;
	}

	return menuhistory;
}


/* draw cd-setup screen */

static void draw_cd_setup(GtkWidget *win) {
GtkWidget *omenu;
GtkWidget *menu_item;
GtkWidget *menu;
GtkWidget *l1;
GtkWidget *f1;
GtkWidget *vbox, *vbox2, *sep;
GtkWidget *tbl;
GtkObject *adj1,*adj2,*adj3,*adj4,*adj5,*adj6;
GtkWidget *scale;
GtkWidget *spdlabel, *fifolabel, *check;
gchar tmp[MAXLINE];
#if 0 
GSList *group;
GtkWidget *btn;
#endif
gint i;
gint menuhistory, firstdevnr;
static const gchar *writemodes[] = WRITE_MODES;
static const gchar *helpwritemodes[] = HELP_WRITE_MODES;

	writer_omenu = NULL;
	cdr_drv_omenu = NULL;
	cdr_mode_omenu = NULL;
	cdr_spd_adj = NULL;
	cdr_fifo_adj = NULL;

	reader_omenu = NULL;
	rdr_spd_adj = NULL;
	rdr_sec_adj = NULL;
	rdr_ovrl_adj = NULL;
	rdr_para_adj = NULL;
	rdr_para_check = NULL;

	writer_frame = NULL;
	reader_frame = NULL;

	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(win),vbox);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),10);

	gtk_widget_show(vbox);

	f1 = gtk_frame_new(_("CD/DVD Writer Configuration"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,FALSE,TRUE,0);
	gtk_widget_show(f1);
	writer_frame = f1;

	vbox2 = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(f1),vbox2);
	gtk_widget_show(vbox2);

	tbl = gtk_table_new(1,32,TRUE);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),14,5);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_box_pack_start(GTK_BOX(vbox2),tbl,FALSE,TRUE,0);
	gtk_widget_show(tbl);

	if (!curset.isProDVD) {
		l1 = rightjust_gtk_label_new(_("CD Writer Device:"));
	} else {
		l1 = rightjust_gtk_label_new(_("CD/DVD Writer Device:"));
	}
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,15,0,1);
	gtk_widget_show(l1);
	
	omenu = gtk_option_menu_new ();
	menu = gtk_menu_new();
	writer_omenu = omenu;

	menuhistory = draw_cd_setup_writers(menu, &firstdevnr);

	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	/* set the preselected writer */
	if (menuhistory != -1) {
		gtk_option_menu_set_history(GTK_OPTION_MENU (omenu),menuhistory);
	} else {
		/* nothing valid preselected */
		setupdata.writer_devnr = firstdevnr;
	}
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,15,32,0,1);
	gtk_widget_show(omenu);
	define_tooltip(omenu,_("Select the CD- or DVD-Writer you want to use."));

	if (!isroot() && !setupdata.root_option_change_writer) {
		gtk_widget_set_sensitive(omenu,FALSE);
	}

        sep = gtk_hseparator_new();
        gtk_box_pack_start(GTK_BOX(vbox2),sep,TRUE,TRUE,0);
        gtk_widget_show(sep);

	tbl = gtk_table_new(4,32,TRUE);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),14,5);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_box_pack_start(GTK_BOX(vbox2),tbl,FALSE,TRUE,0);
	gtk_widget_show(tbl);


	l1 = rightjust_gtk_label_new(_("CD Writer Mode:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,15,0,1);
	gtk_widget_show(l1);

	/* list of cdrecord drivers */
	omenu = gtk_option_menu_new();
	menu = gtk_menu_new();
	cdr_drv_omenu = omenu;

	menu_item = gtk_menu_item_new_with_label(_("Autodetect"));
	gtk_signal_connect(GTK_OBJECT(menu_item),
		"activate", GTK_SIGNAL_FUNC(writermode_selected),
		GINT_TO_POINTER(-1));
	gtk_menu_append (GTK_MENU (menu), menu_item);
	gtk_widget_show (menu_item);

	i = 0;
	while(drivers[i] != NULL) {

		menu_item = gtk_menu_item_new_with_label(drivers[i]->desc);
		gtk_signal_connect(GTK_OBJECT(menu_item),
			"activate", GTK_SIGNAL_FUNC(writermode_selected),
			GINT_TO_POINTER(i));
		gtk_menu_append (GTK_MENU (menu), menu_item);
		gtk_widget_show (menu_item);
		i++;
	}
	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,15,32,0,1);
	gtk_widget_show(omenu);
	define_tooltip(omenu,_("The write-mode: Leave that at \"autodetect\" unless you really know what you are doing."));

        if (!isroot() && !(setupdata.root_option_change_writeparam &&
		setupdata.root_option_change_writer)) {
		gtk_widget_set_sensitive(omenu,FALSE);
	}

	l1 = rightjust_gtk_label_new(_("Default Write Mode:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,15,1,2);
	gtk_widget_show(l1);

        omenu = gtk_option_menu_new ();
        menu = gtk_menu_new();
	cdr_mode_omenu = omenu;

        i = 0;
        while (writemodes[i]) {
                menu_item = gtk_menu_item_new_with_label(_(writemodes[i]));
                gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
                        GTK_SIGNAL_FUNC(defwritemode_selected),
                        GINT_TO_POINTER(i));
                gtk_menu_append (GTK_MENU (menu), menu_item);
                gtk_widget_show (menu_item);
                if (helpwritemodes[i])
                        define_tooltip(menu_item,(gchar *)_(helpwritemodes[i]));                i++;
        }
        gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
        gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,15,32,1,2);
        gtk_widget_show(omenu);
        /* concat 2 help strings */
        g_snprintf(tmp,MAXLINE,"%s %s",_("Choose which write mode you want to use with your CD-Writer. Not all modes are supported with all writers. Try \"DAO\" first, because its usually the best option. If the write fails, try one of the \"TAO\" modes."), _("Click an option and hold the button to get additional help for each mode."));
        define_tooltip(omenu, tmp);

	if (!isroot() && !setupdata.root_option_change_writeparam) {
                gtk_widget_set_sensitive(omenu,FALSE);
        }


	l1 = rightjust_gtk_label_new(_("CD Writer Speed:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,15,2,3);
	gtk_widget_show(l1);

	f1 = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_IN);
	gtk_container_border_width(GTK_CONTAINER(f1),3);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,15,19,2,3);
	gtk_widget_show(f1);

	spdlabel = gtk_label_new("");
	gtk_container_add(GTK_CONTAINER(f1),spdlabel);
	gtk_widget_show(spdlabel);

	adj1 = gtk_adjustment_new(0.0,0.0,65.0,1.0,1.0,1.0);
	cdr_spd_adj = adj1;
	gtk_signal_connect(GTK_OBJECT(adj1), "value_changed",
		GTK_SIGNAL_FUNC(speed_changed), spdlabel);
	scale = gtk_hscale_new(GTK_ADJUSTMENT (adj1));
	gtk_scale_set_value_pos (GTK_SCALE(scale), GTK_POS_LEFT);
	gtk_scale_set_digits(GTK_SCALE(scale),0);
	gtk_scale_set_draw_value(GTK_SCALE(scale),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),scale,19,32,2,3);


	gtk_widget_show(scale);
	define_tooltip(scale,_("The default speed to be used for writing."));
	
	if (!isroot() && !setupdata.root_option_change_writeparam) {
		gtk_widget_set_sensitive(scale,FALSE);
	}

	l1 = rightjust_gtk_label_new(_("CD Writer FIFO-Buffer-Size:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,15,3,4);
	gtk_widget_show(l1);

	f1 = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_IN);
	gtk_container_border_width(GTK_CONTAINER(f1),3);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,15,19,3,4);
	gtk_widget_show(f1);

	fifolabel = gtk_label_new("");
	gtk_container_add(GTK_CONTAINER(f1),fifolabel);
	gtk_widget_show(fifolabel);

	adj2 = gtk_adjustment_new(1.0,1.0,16.0,0.5,0.5,0.0);
	cdr_fifo_adj = adj2;
	gtk_signal_connect(GTK_OBJECT(adj2), "value_changed",
		GTK_SIGNAL_FUNC(fifo_changed), fifolabel);
	scale = gtk_hscale_new(GTK_ADJUSTMENT (adj2));
	gtk_scale_set_value_pos (GTK_SCALE(scale), GTK_POS_LEFT);
	gtk_scale_set_digits(GTK_SCALE(scale),0);
	gtk_scale_set_draw_value(GTK_SCALE(scale),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),scale,19,32,3,4);

	/* next line is to fix a bug in adj_set_value */
	gtk_label_set_text(GTK_LABEL(fifolabel),"1.0MB");
		 
	gtk_widget_show(scale);
	define_tooltip(scale,_("This is the internal memory-buffer cdrecord allocates to prevent buffer-underruns while burning. This should be set higher than the writer-internal hardware buffer for more performance."));

	if (!isroot() && !setupdata.root_option_change_writeparam) {
		gtk_widget_set_sensitive(scale,FALSE);
	}

	/* draw current values */
	writer_selected(NULL, GINT_TO_POINTER(setupdata.writer_devnr));
	
	/* ------------------------------ */

	f1 = gtk_frame_new(_("CD/DVD Reader Configuration"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,FALSE,TRUE,5);
	gtk_widget_show(f1);
	reader_frame = f1;

	vbox2 = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(f1),vbox2);
	gtk_widget_show(vbox2);


	tbl = gtk_table_new(1,32,TRUE);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),14,5);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_box_pack_start(GTK_BOX(vbox2),tbl,FALSE,TRUE,0);
	gtk_widget_show(tbl);

	l1 = rightjust_gtk_label_new(_("Read Device:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,15,0,1);
	gtk_widget_show(l1);

	omenu = gtk_option_menu_new ();
	menu = gtk_menu_new();
	reader_omenu = omenu;

	menuhistory = draw_cd_setup_readers(menu, &firstdevnr);

	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	if (menuhistory != -1) {
		gtk_option_menu_set_history(GTK_OPTION_MENU (omenu),menuhistory);
	} else {
		setupdata.reader_devnr = firstdevnr;
	}
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,15,32,0,1);
	gtk_widget_show(omenu);
	define_tooltip(omenu,_("The device you want to use to read data or audio from CDs."));

	if (!isroot() && !setupdata.root_option_change_reader) {
		gtk_widget_set_sensitive(omenu,FALSE);
	}

        sep = gtk_hseparator_new();
        gtk_box_pack_start(GTK_BOX(vbox2),sep,TRUE,TRUE,0);
        gtk_widget_show(sep);

	tbl = gtk_table_new(5,32,TRUE);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),14,5);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_box_pack_start(GTK_BOX(vbox2),tbl,FALSE,TRUE,0);
	gtk_widget_show(tbl);

#if 0
	/* audio-interface selector */
	l1 = rightjust_gtk_label_new(_("Audio Read Interface:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,15,5,6);
	gtk_widget_show(l1);

	btn = gtk_radio_button_new_with_label(NULL,_("generic_scsi"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,15,24,5,6);
	gtk_widget_show(btn);
	if (!isroot() && !setupdata.root_option_change_readparam) {
		gtk_widget_set_sensitive(btn,FALSE);
	}
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));
	btn = gtk_radio_button_new_with_label(group,_("cooked_ioctl"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(audiointerface_selected),NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,24,32,5,6);
	gtk_widget_show(btn);
	/* set current value */
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),setupdata.audioread_interface);

	if (!isroot() && !setupdata.root_option_change_readparam) {
		gtk_widget_set_sensitive(btn,FALSE);
	}

#endif

	l1 = rightjust_gtk_label_new(_("Audio Read Speed:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,15,0,1);
	gtk_widget_show(l1);

	f1 = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_IN);
	gtk_container_border_width(GTK_CONTAINER(f1),3);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,15,19,0,1);
	gtk_widget_show(f1);

	spdlabel = gtk_label_new("");
	gtk_container_add(GTK_CONTAINER(f1),spdlabel);
	gtk_widget_show(spdlabel);

	adj3 = gtk_adjustment_new(0.0,0.0,65.0,1.0,1.0,1.0);
	rdr_spd_adj = adj3;
	gtk_signal_connect(GTK_OBJECT(adj3), "value_changed",
		GTK_SIGNAL_FUNC(audio_speed_changed), spdlabel);
	scale = gtk_hscale_new(GTK_ADJUSTMENT (adj3));
	gtk_scale_set_value_pos (GTK_SCALE(scale), GTK_POS_LEFT);
	gtk_scale_set_digits(GTK_SCALE(scale),0);
	gtk_scale_set_draw_value(GTK_SCALE(scale),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),scale,19,32,0,1);
	gtk_widget_show(scale);
	define_tooltip(scale,_("The speed X-CD-Roast tries to set on reader when reading audio tracks. This setting will be silently ignored by some devices."));

	if (!isroot() && !setupdata.root_option_change_readparam) {
		gtk_widget_set_sensitive(scale,FALSE);
	}
	
	/* -- */

	l1 = rightjust_gtk_label_new(_("Sectors per request:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,15,1,2);
	gtk_widget_show(l1);

	f1 = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_IN);
	gtk_container_border_width(GTK_CONTAINER(f1),3);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,15,19,1,2);
	gtk_widget_show(f1);

	spdlabel = gtk_label_new("");
	gtk_container_add(GTK_CONTAINER(f1),spdlabel);
	gtk_widget_show(spdlabel);

	adj5 = gtk_adjustment_new(1.0,1.0,151.0,1.0,1.0,1.0);
	rdr_sec_adj = adj5;
	gtk_signal_connect(GTK_OBJECT(adj5), "value_changed",
		GTK_SIGNAL_FUNC(sectors2_changed), spdlabel);
	scale = gtk_hscale_new(GTK_ADJUSTMENT (adj5));
	gtk_scale_set_value_pos (GTK_SCALE(scale), GTK_POS_LEFT);
	gtk_scale_set_digits(GTK_SCALE(scale),0);
	gtk_scale_set_draw_value(GTK_SCALE(scale),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),scale,19,32,1,2);
	gtk_widget_show(scale);
	define_tooltip(scale,_("How many audio sectors are read per request. Higher Settings result in better quality but require more scsi-buffer-memory."));

	if (!isroot() && !setupdata.root_option_change_readparam) {
		gtk_widget_set_sensitive(scale,FALSE);
	}

	/* -- */

	l1 = rightjust_gtk_label_new(_("Sectors for overlap sampling:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,15,2,3);
	gtk_widget_show(l1);

	f1 = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_IN);
	gtk_container_border_width(GTK_CONTAINER(f1),3);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,15,19,2,3);
	gtk_widget_show(f1);

	spdlabel = gtk_label_new("");
	readspd1 = spdlabel;
	gtk_container_add(GTK_CONTAINER(f1),spdlabel);
	gtk_widget_show(spdlabel);

	adj4 = gtk_adjustment_new(0.0,0.0,31.0,1.0,1.0,1.0);
	rdr_ovrl_adj = adj4;
	gtk_signal_connect(GTK_OBJECT(adj4), "value_changed",
		GTK_SIGNAL_FUNC(sectors_changed), spdlabel);
	scale = gtk_hscale_new(GTK_ADJUSTMENT (adj4));
	readslider1 = scale;
	gtk_scale_set_value_pos (GTK_SCALE(scale), GTK_POS_LEFT);
	gtk_scale_set_digits(GTK_SCALE(scale),0);
	gtk_scale_set_draw_value(GTK_SCALE(scale),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),scale,19,32,2,3);
	gtk_widget_show(scale);
	define_tooltip(scale,_("Enables jitter-correction for audio tracks. The higher this setting the slower can the read process be. Set this to 0 for full speed."));

	if (!isroot() && !setupdata.root_option_change_readparam) {
		gtk_widget_set_sensitive(scale,FALSE);
	}

	/* -- */

	l1 = rightjust_gtk_label_new(_("Paranoia retries per sector:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,15,3,4);
	gtk_widget_show(l1);

	f1 = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_IN);
	gtk_container_border_width(GTK_CONTAINER(f1),3);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,15,19,3,4);
	gtk_widget_show(f1);

	spdlabel = gtk_label_new("");
	readspd2 = spdlabel;
	gtk_container_add(GTK_CONTAINER(f1),spdlabel);
	gtk_widget_show(spdlabel);

	adj6 = gtk_adjustment_new(0.0,0.0,65.0,1.0,1.0,1.0);
	rdr_para_adj = adj6;
	gtk_signal_connect(GTK_OBJECT(adj6), "value_changed",
		GTK_SIGNAL_FUNC(sectors3_changed), spdlabel);
	scale = gtk_hscale_new(GTK_ADJUSTMENT (adj6));
	readslider2 = scale;
	gtk_scale_set_value_pos (GTK_SCALE(scale), GTK_POS_LEFT);
	gtk_scale_set_digits(GTK_SCALE(scale),0);
	gtk_scale_set_draw_value(GTK_SCALE(scale),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),scale,19,32,3,4);
	gtk_widget_show(scale);
	define_tooltip(scale,_("How often the paranoia code will try to read a fautly sector before giving up."));

	if (!isroot() && !setupdata.root_option_change_readparam) {
		gtk_widget_set_sensitive(scale,FALSE);
	}

	/* paranoia mode? */

	check = gtk_check_button_new_with_label(_("Use paranoia mode for audio"));
	rdr_para_check = check;
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(paranoia_selected), NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,15,32,4,5);
	gtk_widget_show(check);
	define_tooltip(check, _("Read audio CDs with the enhanced error correction paranoia code."));

	if (!isroot() && !setupdata.root_option_change_readparam) {
		gtk_widget_set_sensitive(check,FALSE);
	}

	/* draw current values */
	reader_selected(NULL, GINT_TO_POINTER(setupdata.reader_devnr));
}


/* check if the filesystem-device is already in use of another
   image-path. return 1 if yes, 0 if not. returns also the other
   image-path in busypath. return -1 if not yet any path was updated */

static gint fs_in_use(GtkCList *clist, gchar *fs, gchar *busypath) {
gint i;
gchar tmp[MAXLINE];
gchar *mnt;
gchar *data[3];

	for (i = 0; i < clist->rows; i++) {
		mnt = (gchar *)gtk_clist_get_row_data(clist,i);
		if (mnt == NULL) {
			return -1;
		}
		strcpy(tmp,mnt);
		if (strcmp(tmp,fs) == 0) {
			if (busypath != NULL) {
				gtk_clist_get_text(clist,i,0,data);
				strcpy(busypath,data[0]);
			}
			return 1;
		}
	}
	return 0;
}


/* check if the filesystem-device is already in use of another
   image-path. Skip the row "skiprow". return 1 if hit found */ 

static gint fs_in_use2(GtkCList *clist, gchar *fs, gint skiprow) {
gint i;
gchar *mnt;

	for (i = 0; i < clist->rows; i++) {
		mnt = (gchar *)gtk_clist_get_row_data(clist,i);
		if (mnt == NULL) {
			/* ignore not updated lines */
			continue;
		}
		if (i == skiprow) {
			/* ignore the row marked to skip */
			continue;
		}
		if (strcmp(mnt,fs) == 0) {
			/* we found a match */
			return 1;
		}
	}
	return 0;
}


/* callbacks for hd-setup-menu */

static void entry_imagepath_callback(GtkWidget *widget, GtkCList *clist) {
gchar dir[MAXLINE];
gchar *data[3];
gchar tmp[MAXLINE];
gchar tmp2[MAXLINE];
gchar fs[MAXLINE];
gint free;
gint row;
gint fsuse;

	strcpy(dir,gtk_entry_get_text(GTK_ENTRY(clist_entry)));
	check_tilde(dir);
	gtk_entry_set_text(GTK_ENTRY(clist_entry), dir);

	/* valid directory? */
	if (is_directory(dir) == 0) {
		show_dialog(ICO_INFO,_("No valid path specified"),T_OK,NULL,NULL,0);	
		return;
	}

	/* now run update to get all partitions */
	gtk_button_clicked(GTK_BUTTON(updatebutton));

	/* last character a /? remove */
	if (dir[strlen(dir)-1] == '/') {
		dir[strlen(dir)-1] = '\0';
	}

	free = get_free_space(dir,fs);

	/* now check if this directory is on a filesystem which you 
 	   already added */
	fsuse = fs_in_use(clist,fs,tmp);
	if (fsuse == 1) {
		g_snprintf(tmp2,MAXLINE,_("Invalid path to add because it is on the same\nfilesystem as the already added path:\n%s"),tmp);
		show_dialog(ICO_WARN,tmp2,T_OK,NULL,NULL,0);	
		return;
	} else if (fsuse == -1) {
		/* no updated sizes yet - press update first */
		show_dialog(ICO_INFO,_("Please press \"Update\" once before adding new paths."),T_OK,NULL,NULL,0);
		return;
	}

	data[0] = dir;
	data[1] = "N.A.";

	if (free != -1) {
		convert_kbytes2mbminstring(free,tmp);
		data[1] = tmp;
	}

	if (is_dir_writeable(dir) == 0) {
		data[2] = T_YES;
	} else {
		data[2] = T_NO;
	}
	
	row = gtk_clist_append(clist,data);

	/* save the filesystem-device into row-data */
	gtk_clist_set_row_data(clist,row,g_strdup(fs));

	gtk_entry_set_text(GTK_ENTRY(clist_entry),"");

	/* now update again to have all registered paths updated */
	gtk_button_clicked(GTK_BUTTON(updatebutton));

}


/* called when a drag is received on the entry */

static void entry_imagepath_drag_received(GtkWidget *widget, 
	GdkDragContext *dc, gint x, gint y, GtkSelectionData *selection_data,
	guint info, guint t, gpointer data) {
gchar *text;
gchar newdir[MAXLINE];

	/* nothing received? ignore */
	if(selection_data == NULL)
		return;
        if(selection_data->length < 0)
                return;

	if ((info == DRAG_TAR_INFO_0) ||
           (info == DRAG_TAR_INFO_1) ||
           (info == DRAG_TAR_INFO_2)) {
		text = selection_data->data;
		if (extract_single_drag_filename(text, selection_data->length, newdir)) {
			/* extracted the plain filename from drag */
			if (strcmp(newdir,"") != 0) {
				dodebug(3,"Received from drag: %s\n", newdir);
				gtk_entry_set_text(GTK_ENTRY(clist_entry),newdir);
				if (data) {
					/* now simulate the press to the
					   add button because we dragged
					   directly onto the clist */
					entry_imagepath_callback(NULL, 
						GTK_CLIST(data));
				}
			}
		}
	}
}


static void button_imagepath_callback(GtkWidget *widget, gpointer data) {
gchar tmp[MAXLINE];

	show_dir_tree(tmp);
	if (strcmp(tmp,"") != 0) {
		gtk_entry_set_text(GTK_ENTRY(clist_entry),tmp);
	}
}

static void update_imagepath_callback(GtkWidget *widget, GtkCList *clist) {
gchar *data[3];
gchar tmp[MAXLINE];
gchar fs[MAXLINE];
gint free, sum;
gint i;
GdkCursor *cursor;
gchar *mnt;
gint marktodelete;

	/* set watch-cursor */
	cursor = gdk_cursor_new(GDK_WATCH);
	gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	/* give gtk time to update cursor */
	gtk_main_iteration_do(FALSE);

	marktodelete = -1;
	sum = 0;
	/* loop through all rows */
	for (i = 0; i < clist->rows; i++) {
		gtk_clist_get_text(clist,i,0,data);
		mnt = (gchar *)gtk_clist_get_row_data(clist,i);

		free = get_free_space(data[0],fs);

		convert_kbytes2mbminstring(free,tmp);

		gtk_clist_set_text(clist,i,1,tmp);

		if (is_dir_writeable(data[0]) == 0) {
			gtk_clist_set_text(clist,i,2,T_YES);
		} else {
			gtk_clist_set_text(clist,i,2,T_NO);
		}

		/* not yet a filesystem registred (updated) for this path? */
		if (mnt == NULL) {
			/* do it now */
			gtk_clist_set_row_data(clist,i,g_strdup(fs));
		}
		
		/* now check if the new updated filesystem is already
		   in use (should never happen - but may possible if the
		   user repartitioned its drive without telling xcdroast) */
		if (fs_in_use2(clist,fs,i) == 1) {
			/* mark the conflicting entry */
			marktodelete = i;
			continue;
		}

		/* add sizes up */
		sum+=free;
	}	
	convert_kbytes2mbminstring(sum,tmp);
	gtk_label_set_text(GTK_LABEL(updatesum_label),tmp);

	/* normal cursor */
	gdk_window_set_cursor(GTK_WIDGET(toplevel)->window, NULL);
	gdk_cursor_destroy (cursor);

	/* if we found a conflicting entry - delete it now */
	if (marktodelete != -1) {	
		g_free(gtk_clist_get_row_data(clist,marktodelete));
		gtk_clist_remove(clist,marktodelete);
		show_dialog(ICO_WARN,_("Removed a conflicting path.\nPlease \"Update\" again."),T_OK,NULL,NULL,0);
	}
}

static void remove_imagepath_callback(GtkWidget *widget, GtkCList *clist) {
GList *sel;
gint row;

	sel = clist->selection;

	if (sel != NULL) {
		row = GPOINTER_TO_INT(sel->data);
		g_free(gtk_clist_get_row_data(clist,row));
		gtk_clist_remove(clist,row);
	} else {
		show_dialog(ICO_INFO,_("No path selected to remove"),T_OK,NULL,NULL,0);	
	}
}


/* draw hd-setup screen */

static void draw_hd_setup(GtkWidget *win) {
GtkWidget *vbox;
GtkWidget *scrolled_win;
GtkWidget *f1,*l1;
gchar *titles[3];
gchar *data[3];
GtkWidget *list;
GtkCList  *clist;
GList *loop;
GtkWidget *tbl;
GtkWidget *b1;
GtkWidget *e1;
gint row;
#ifdef PRIV_COLS 
GtkStyle *style;
GdkColor c;
#endif
GtkTargetEntry target_entry[3];

	/* required for drag&drop setup */
	target_entry[0].target = DRAG_TAR_NAME_0;
	target_entry[0].flags = 0;
	target_entry[0].info = DRAG_TAR_INFO_0;
        target_entry[1].target = DRAG_TAR_NAME_1;
        target_entry[1].flags = 0;
        target_entry[1].info = DRAG_TAR_INFO_1;
        target_entry[2].target = DRAG_TAR_NAME_2;
        target_entry[2].flags = 0;
        target_entry[2].info = DRAG_TAR_INFO_2;

	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(win),vbox);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),10);
	gtk_widget_show(vbox);

	f1 = gtk_frame_new(_("Temporary Image Storage Directories"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,TRUE,TRUE,0);
	gtk_widget_show(f1);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 5);
	gtk_container_add(GTK_CONTAINER(f1),scrolled_win);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
		GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	gtk_widget_show(scrolled_win);

	titles[0] = _("Path");
	titles[1] = _("Free space (MB/min.)");
	titles[2] = _("Writeable");

	list = gtk_clist_new_with_titles(3,titles);
	gtk_widget_set_usize(GTK_WIDGET(list),0,tbf(150));
	gtk_container_add (GTK_CONTAINER (scrolled_win), list);
	
	clist = GTK_CLIST(list);
	gtk_clist_set_column_auto_resize(clist, 2, TRUE);
	clist_list = clist;

#ifdef PRIV_COLS 
        gdk_color_parse(GTKLISTCOL,&c);
        gdk_color_alloc(gtk_widget_get_colormap(list),&c);

        style = gtk_style_copy(gtk_widget_get_style(list));
        style->base[GTK_STATE_NORMAL] = c;
        gtk_widget_set_style(GTK_WIDGET(list),style);
#endif
	gtk_clist_set_column_width(clist,0,tbf(270));
	gtk_clist_set_column_width(clist,1,tbf(160));
	gtk_clist_set_column_justification(clist, 1, GTK_JUSTIFY_CENTER);
	gtk_clist_set_column_justification(clist, 2, GTK_JUSTIFY_CENTER);

	/* now fill list with current values */
	loop = g_list_first(setupdata.image_dirs);
	while (loop) {
		data[0] = (gchar *)loop->data;
		data[1] = " -"; 
		if (is_dir_writeable((gchar *)loop->data) == 0) {
			data[2] = T_YES;
		} else {
			data[2] = T_NO;
		}
		row = gtk_clist_append(clist,data);
		gtk_clist_set_row_data(clist,row,NULL);
		loop = loop->next;
	}

        gtk_widget_realize(list);
        if(!GTK_WIDGET_NO_WINDOW(list)) {

		gtk_drag_dest_set(list, GTK_DEST_DEFAULT_MOTION |
	 	  GTK_DEST_DEFAULT_HIGHLIGHT | GTK_DEST_DEFAULT_DROP,
		  target_entry, sizeof(target_entry) / sizeof(GtkTargetEntry),
		  GDK_ACTION_MOVE | GDK_ACTION_COPY);
		gtk_signal_connect(GTK_OBJECT(list), "drag_data_received",
		  GTK_SIGNAL_FUNC(entry_imagepath_drag_received), clist);
	}
	gtk_widget_show(list);

	tbl = gtk_table_new(4,8,TRUE);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),5);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),5);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),1,10);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),2,10);

	gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,TRUE,10);
	gtk_widget_show(tbl);

	l1 = rightjust_gtk_label_new(_("Total space available:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,3,0,1);
	gtk_widget_show(l1);

	f1 = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_IN);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,3,6,0,1);
	gtk_widget_show(f1);

	l1 = gtk_label_new("");
	updatesum_label = l1;
	gtk_container_add(GTK_CONTAINER(f1),l1);
	gtk_widget_show(l1);

	b1 = gtk_button_new_with_label(_("Update"));
	updatebutton = b1;
	gtk_table_attach_defaults(GTK_TABLE(tbl),b1,6,8,0,1);
	gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(update_imagepath_callback),clist);
	gtk_widget_show(b1);
	define_tooltip(b1,_("Calculates all currently free space in the image directories."));

	l1 = rightjust_gtk_label_new(_("Path:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,2,3);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	clist_entry = e1;
 	gtk_signal_connect(GTK_OBJECT(e1), "activate",
		GTK_SIGNAL_FUNC(entry_imagepath_callback),clist);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,6,2,3);
	gtk_widget_show(e1);
	gtk_drag_dest_set(e1, GTK_DEST_DEFAULT_MOTION |
	 	GTK_DEST_DEFAULT_HIGHLIGHT | GTK_DEST_DEFAULT_DROP,
		target_entry, sizeof(target_entry) / sizeof(GtkTargetEntry),
		GDK_ACTION_MOVE | GDK_ACTION_COPY);
	gtk_signal_connect(GTK_OBJECT(e1), "drag_data_received",
		GTK_SIGNAL_FUNC(entry_imagepath_drag_received), NULL);

	b1 = gtk_button_new_with_label(_("Browse"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),b1,6,8,2,3);
	gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(button_imagepath_callback),NULL);
	gtk_widget_show(b1);
	define_tooltip(b1,_("Displays a directory selector to pick a new image directory."));

	if (!isroot() && !setupdata.root_option_change_imagedirs) {
		gtk_widget_set_sensitive(e1,FALSE);
		gtk_widget_set_sensitive(b1,FALSE);
	}

	b1 = gtk_button_new_with_label(_("Add"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),b1,2,4,3,4);
 	gtk_signal_connect(GTK_OBJECT(b1), "clicked",
		GTK_SIGNAL_FUNC(entry_imagepath_callback),clist);
	gtk_widget_show(b1);
	define_tooltip(b1,_("Adds a new image directory."));

	if (!isroot() && !setupdata.root_option_change_imagedirs) {
		gtk_widget_set_sensitive(b1,FALSE);
	}

	b1 = gtk_button_new_with_label(_("Remove"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),b1,4,6,3,4);
 	gtk_signal_connect(GTK_OBJECT(b1), "clicked",
		GTK_SIGNAL_FUNC(remove_imagepath_callback),clist);
	gtk_widget_show(b1);
	define_tooltip(b1,_("Removes the selected image directory from the list."));
	if (!isroot() && !setupdata.root_option_change_imagedirs) {
		gtk_widget_set_sensitive(b1,FALSE);
	}
}


/* callbacks for misc-menu */

static void dspdevice_selected(GtkWidget *item, gchar *device) {

	g_free(setupdata.dsp_device);
	setupdata.dsp_device = g_strdup(device);

	/* set dsp-test-button to active when we set a dsp-device */
	if (strcmp(setupdata.dsp_device,"") != 0) {
		gtk_widget_set_sensitive(btn_testdsp, TRUE);
	} else {
		gtk_widget_set_sensitive(btn_testdsp, FALSE);
	}
}

static void dsptest_callback(GtkWidget *widget, gpointer data) {

	show_setup_dsptest();
}

static void notifyvia_selected(GtkWidget *item, gpointer data) {

	setupdata.notify_via = 
		gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item));
}

static void notifyat_selected(GtkWidget *item, gpointer data) {

	setupdata.notify_at = GPOINTER_TO_INT(data); 
}

static void cddb_entry1_callback(GtkWidget *widget, gpointer data) {
gchar tmp[MAXLINE];
	
	g_free(setupdata.cddb_host);
	strcpy(tmp, gtk_entry_get_text(GTK_ENTRY(widget)));
	strip_string(tmp);

	setupdata.cddb_host = g_strdup(tmp);
	gtk_entry_set_text(GTK_ENTRY(widget), tmp);
	gtk_entry_select_region(GTK_ENTRY(widget), 0, 
			GTK_ENTRY(widget)->text_length);
}

static void cddb_entry2_callback(GtkWidget *widget, gpointer data) {
gchar tmp[MAXLINE];
	
	setupdata.cddb_port = atoi(gtk_entry_get_text(GTK_ENTRY(widget)));
	g_snprintf(tmp, MAXLINE,"%d",setupdata.cddb_port);
	gtk_entry_set_text(GTK_ENTRY(widget),tmp);
	gtk_entry_select_region(GTK_ENTRY(widget), 0, 
			GTK_ENTRY(widget)->text_length);
}

static void cddb_entry3_callback(GtkWidget *widget, gpointer data) {
gchar tmp[MAXLINE];
	
	g_free(setupdata.cddb_proxy_host);
	strcpy(tmp, gtk_entry_get_text(GTK_ENTRY(widget)));
	strip_string(tmp);

	setupdata.cddb_proxy_host = g_strdup(tmp);
	gtk_entry_set_text(GTK_ENTRY(widget), tmp);
	gtk_entry_select_region(GTK_ENTRY(widget), 0, 
			GTK_ENTRY(widget)->text_length);
}

static void cddb_entry4_callback(GtkWidget *widget, gpointer data) {
gchar tmp[MAXLINE];
	
	setupdata.cddb_proxy_port = atoi(gtk_entry_get_text(GTK_ENTRY(widget)));
	g_snprintf(tmp, MAXLINE,"%d",setupdata.cddb_proxy_port);
	gtk_entry_set_text(GTK_ENTRY(widget),tmp);
	gtk_entry_select_region(GTK_ENTRY(widget), 0, 
			GTK_ENTRY(widget)->text_length);
}

static void cddb_use_http_selected(GtkWidget *item, gpointer data) {
gchar tmp[MAXLINE];
	
	setupdata.cddb_use_http = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item));

	if (setupdata.cddb_use_http == 0) {
		gtk_widget_set_sensitive(cddb_entry3, FALSE);
		gtk_widget_set_sensitive(cddb_entry4, FALSE);
		gtk_widget_set_sensitive(cddb_opt2, FALSE);

		/* no long http mode - restore original port */
		gtk_widget_set_sensitive(cddb_entry2, TRUE);
		g_snprintf(tmp, MAXLINE,"%d",setupdata.cddb_port);
		gtk_entry_set_text(GTK_ENTRY(cddb_entry2),tmp);
	} else {
		if (setupdata.cddb_use_proxy == 1) {
			gtk_widget_set_sensitive(cddb_entry3, TRUE);
			gtk_widget_set_sensitive(cddb_entry4, TRUE);
		}
		gtk_widget_set_sensitive(cddb_opt2, TRUE);

		/* http mode uses always port 80 */
		gtk_entry_set_text(GTK_ENTRY(cddb_entry2),"80");
		gtk_widget_set_sensitive(cddb_entry2, FALSE);
	}
}

static void cddb_use_proxy_selected(GtkWidget *item, gpointer data) {
	
	setupdata.cddb_use_proxy = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item));
	if (setupdata.cddb_use_http == 1 && setupdata.cddb_use_proxy == 0) {
		gtk_widget_set_sensitive(cddb_entry3, FALSE);
		gtk_widget_set_sensitive(cddb_entry4, FALSE);
	}
	if (setupdata.cddb_use_http == 1 && setupdata.cddb_use_proxy == 1) {
		gtk_widget_set_sensitive(cddb_entry3, TRUE);
		gtk_widget_set_sensitive(cddb_entry4, TRUE);
	}
}

static void logfile_entry_callback(GtkWidget *widget, gpointer data) {
gchar tmp[MAXLINE];
	
	g_free(setupdata.logfile);
	strcpy(tmp, gtk_entry_get_text(GTK_ENTRY(widget)));
	/* check_tilde(tmp); */

	setupdata.logfile = g_strdup(tmp);
	gtk_entry_set_text(GTK_ENTRY(widget), tmp);
	gtk_entry_select_region(GTK_ENTRY(widget), 0, 
			GTK_ENTRY(widget)->text_length);
}


/* called when a drag is received on the entry */

static void entry_logfile_drag_received(GtkWidget *widget, 
        GdkDragContext *dc, gint x, gint y, GtkSelectionData *selection_data,
        guint info, guint t, gpointer data) {
gchar *text;
gchar newdir[MAXLINE];

        /* nothing received? ignore */
        if(selection_data == NULL)
                return;
        if(selection_data->length < 0)
                return;

        if ((info == DRAG_TAR_INFO_0) ||
           (info == DRAG_TAR_INFO_1) ||
           (info == DRAG_TAR_INFO_2)) {
                text = selection_data->data;
                if (extract_single_drag_filename(text, selection_data->length, newdir)) {
                        /* extracted the plain filename from drag */
                        if (strcmp(newdir,"") != 0) {
				dodebug(3,"Received from drag: %s\n", newdir);
				gtk_entry_set_text(data, newdir);
				g_free(setupdata.logfile);
				setupdata.logfile = g_strdup(gtk_entry_get_text(data));
                        }
                }
        }
}

static void logfile_browse_callback(GtkWidget *widget, GtkEntry *entry) {
char tmp[MAXLINE];

	show_file_selector(_("Select Logfile"),gtk_entry_get_text(entry),tmp);
	if (strcmp(tmp,"") != 0) {
		gtk_entry_set_text(entry,tmp);
		g_free(setupdata.logfile);
		setupdata.logfile = g_strdup(gtk_entry_get_text(entry));
	}
}

static void loglevel_selected(GtkWidget *item, gpointer level) {

	setupdata.loglevel = GPOINTER_TO_INT(level);
}

static void language_selected(GtkWidget *item, gchar *lang) {

	g_free(setupdata.language);
	setupdata.language = g_strdup(lang);
}


/* draw misc-setup screen */

static void draw_misc_setup(GtkWidget *win) {
GtkWidget *vbox;
GtkWidget *f1,*l1,*b1,*e1;
GtkWidget *tbl;
GtkWidget *omenu;
GtkWidget *menu;
GtkWidget *menu_item;
GSList *group;
GtkWidget *btn, *check;
GList *dsp;
gint i;
gint menuhistory, menuidx, menulang;
gchar tmp[MAXLINE];
static const gchar *lang_array[] = AVAIL_LANG;
GtkTargetEntry target_entry[3];

        /* required for drag&drop setup */
        target_entry[0].target = DRAG_TAR_NAME_0;
        target_entry[0].flags = 0;
        target_entry[0].info = DRAG_TAR_INFO_0;
        target_entry[1].target = DRAG_TAR_NAME_1;
        target_entry[1].flags = 0;
        target_entry[1].info = DRAG_TAR_INFO_1;
        target_entry[2].target = DRAG_TAR_NAME_2;
        target_entry[2].flags = 0;
        target_entry[2].info = DRAG_TAR_INFO_2;

	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(win),vbox);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),10);
	gtk_widget_show(vbox);

	f1 = gtk_frame_new(_("Audio"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,FALSE,TRUE,0);
	gtk_widget_show(f1);

	tbl = gtk_table_new(4,8,TRUE);
	gtk_container_add (GTK_CONTAINER (f1), tbl);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),5);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),2,10);
	gtk_widget_show(tbl);

	l1 = rightjust_gtk_label_new(_("DSP-Device:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,1,3,0,1);
	gtk_widget_show(l1);

	/* get a list of all dsp-devices */
	dsp = get_dsp_devices();

	omenu = gtk_option_menu_new ();
	menu = gtk_menu_new();

	menuidx = 0; menuhistory = 0;
	/* "none"-setting */
	menu_item = gtk_menu_item_new_with_label(_("None "));
	gtk_signal_connect(GTK_OBJECT(menu_item),
		"activate", GTK_SIGNAL_FUNC(dspdevice_selected),
		"");
	gtk_menu_append (GTK_MENU (menu), menu_item);
	if (strcmp(setupdata.dsp_device,"") == 0) { menuhistory = menuidx; }
	menuidx++;
	gtk_widget_show (menu_item);

	while (dsp) {
		menu_item = gtk_menu_item_new_with_label((gchar *)dsp->data);
		gtk_signal_connect(GTK_OBJECT(menu_item),
			"activate", GTK_SIGNAL_FUNC(dspdevice_selected),
			(gchar *)dsp->data);
		gtk_menu_append (GTK_MENU (menu), menu_item);

		if (setupdata.dsp_device != NULL) {
			if (strcmp(setupdata.dsp_device,(gchar *)dsp->data) == 0) {
				menuhistory = menuidx;
			}
		}
		menuidx++;
		gtk_widget_show (menu_item);

		dsp = dsp->next;
	}
	
	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	gtk_option_menu_set_history(GTK_OPTION_MENU (omenu),menuhistory);
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,3,6,0,1);
	gtk_widget_show(omenu);
	define_tooltip(omenu,_("The soundcard device. Used to play warning sounds or audio tracks."));

	b1 = gtk_button_new_with_label(_("Test"));
	btn_testdsp = b1;
	gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(dsptest_callback),NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),b1,6,7,0,1);
	gtk_widget_show(b1);
	define_tooltip(b1,_("Plays a demo sample on the soundcard to verify if its working correctly."));

	/* only allow test when device is set */
	if (strcmp(setupdata.dsp_device,"") == 0) {
		gtk_widget_set_sensitive(btn_testdsp, FALSE);
	}

	l1 = rightjust_gtk_label_new(_("Notify-Beeps via:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,3,1,2);
	gtk_widget_show(l1);

	btn = gtk_radio_button_new_with_label(NULL,_("DSP-Device"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,3,5,1,2);
	gtk_widget_show(btn);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));
	btn = gtk_radio_button_new_with_label(group,_("internal speaker"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(notifyvia_selected),NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,5,8,1,2);
	gtk_widget_show(btn);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),
		setupdata.notify_via);
	
	l1 = rightjust_gtk_label_new(_("at events:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,1,3,2,3);
	gtk_widget_show(l1);

	btn = gtk_radio_button_new_with_label(NULL,_("never"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(notifyat_selected),GINT_TO_POINTER(0));
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,3,5,2,3);
	gtk_widget_show(btn);
	if (setupdata.notify_at == 0) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));
	btn = gtk_radio_button_new_with_label(group,_("always"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(notifyat_selected),GINT_TO_POINTER(1));
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,5,8,2,3);
	gtk_widget_show(btn);
	if (setupdata.notify_at == 1) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));
	btn = gtk_radio_button_new_with_label(group,_("on completion"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(notifyat_selected),GINT_TO_POINTER(2));
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,3,5,3,4);
	gtk_widget_show(btn);
	if (setupdata.notify_at == 2) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));
	btn = gtk_radio_button_new_with_label(group,_("on warnings"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,5,8,3,4);
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(notifyat_selected),GINT_TO_POINTER(3));
	gtk_widget_show(btn);
	if (setupdata.notify_at == 3) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);

	/* -- */
	
	f1 = gtk_frame_new(_("Network"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,FALSE,TRUE,10);
	gtk_widget_show(f1);

	tbl = gtk_table_new(2,32,TRUE);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_container_add (GTK_CONTAINER (f1), tbl);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),5);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),5);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),11,10);
	gtk_widget_show(tbl);

	l1 = rightjust_gtk_label_new(_("CDDB-Server:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,1,12,0,1);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cddb_entry1 = e1;
	gtk_signal_connect(GTK_OBJECT(e1), "activate",
		GTK_SIGNAL_FUNC(cddb_entry1_callback),NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,12,19,0,1);
	if (setupdata.cddb_host != NULL) {
		gtk_entry_set_text(GTK_ENTRY(e1),setupdata.cddb_host);
	}
	gtk_widget_show(e1);
	define_tooltip(e1,_("The CDDB-Server to connect to in order to download track-titles from the internet."));

	l1 = rightjust_gtk_label_new(_("Port:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,19,22,0,1);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cddb_entry2 = e1;
	gtk_signal_connect(GTK_OBJECT(e1), "activate",
		GTK_SIGNAL_FUNC(cddb_entry2_callback),NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,22,25,0,1);
	g_snprintf(tmp, MAXLINE,"%d",setupdata.cddb_port);
	gtk_entry_set_text(GTK_ENTRY(e1),tmp);
	gtk_widget_show(e1);

	check = gtk_check_button_new_with_label(_("Use HTTP"));
	cddb_opt1 = check;
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(cddb_use_http_selected), NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,25,32,0,1);
	gtk_widget_show(check);
	define_tooltip(check, _("Use the HTTP protocol rather than the CDDB protocol to access the CDDB-Server."));

	l1 = rightjust_gtk_label_new(_("via HTTP-Proxy:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,1,12,1,2);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cddb_entry3 = e1;
	gtk_signal_connect(GTK_OBJECT(e1), "activate",
		GTK_SIGNAL_FUNC(cddb_entry3_callback),NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,12,19,1,2);
	if (setupdata.cddb_proxy_host != NULL) {
		gtk_entry_set_text(GTK_ENTRY(e1),setupdata.cddb_proxy_host);
	}
	gtk_widget_show(e1);
	define_tooltip(e1,_("If you are behind a firewall you may require to use a HTTP-proxy to reach the CDDB-Server. If your proxy requires authentication you can use the following syntax: \"user:password@proxyhost\""));

	l1 = rightjust_gtk_label_new(_("Port:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,19,22,1,2);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cddb_entry4 = e1;
	gtk_signal_connect(GTK_OBJECT(e1), "activate",
		GTK_SIGNAL_FUNC(cddb_entry4_callback),NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,22,25,1,2);
	g_snprintf(tmp, MAXLINE,"%d",setupdata.cddb_proxy_port);
	gtk_entry_set_text(GTK_ENTRY(e1),tmp);
	gtk_widget_show(e1);

	check = gtk_check_button_new_with_label(_("Use Proxy"));
	cddb_opt2 = check;
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(cddb_use_proxy_selected), NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,25,32,1,2);
	gtk_widget_show(check);
	define_tooltip(check, _("Don't connect directly to the CDDB-Server, but use a HTTP-proxy instead."));

	/* set editable fields according to current settings */
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cddb_opt1),
		setupdata.cddb_use_http);
	cddb_use_http_selected(cddb_opt1, NULL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cddb_opt2),
		setupdata.cddb_use_proxy);
	cddb_use_proxy_selected(cddb_opt2, NULL);

	/* -- */

	f1 = gtk_frame_new(_("Logging"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,FALSE,TRUE,0);
	gtk_widget_show(f1);

	tbl = gtk_table_new(2,8,TRUE);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_container_add (GTK_CONTAINER (f1), tbl);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),5);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),5);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),2,10);
	gtk_widget_show(tbl);

	l1 = rightjust_gtk_label_new(_("Logfile:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,1,3,0,1);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	log_entry = e1;
	gtk_signal_connect(GTK_OBJECT(e1), "activate",
		GTK_SIGNAL_FUNC(logfile_entry_callback),NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,3,6,0,1);
	gtk_widget_show(e1);
        gtk_drag_dest_set(e1, GTK_DEST_DEFAULT_MOTION |
                GTK_DEST_DEFAULT_HIGHLIGHT | GTK_DEST_DEFAULT_DROP,
                target_entry, sizeof(target_entry) / sizeof(GtkTargetEntry),
                GDK_ACTION_MOVE | GDK_ACTION_COPY);
        gtk_signal_connect(GTK_OBJECT(e1), "drag_data_received",
                GTK_SIGNAL_FUNC(entry_logfile_drag_received), GTK_ENTRY(e1));
	if (setupdata.logfile != NULL) {
		gtk_entry_set_text(GTK_ENTRY(e1),setupdata.logfile);
	}
	gtk_widget_show(e1);
	define_tooltip(e1,_("The name of the file that logs all actions of X-CD-Roast."));

	b1 = gtk_button_new_with_label(_("Browse"));
	gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(logfile_browse_callback),GTK_ENTRY(e1));
	gtk_table_attach_defaults(GTK_TABLE(tbl),b1,6,8,0,1);
	gtk_widget_show(b1);

	if (!isroot() && !setupdata.root_option_change_logoptions) {
		gtk_widget_set_sensitive(e1,FALSE);
		gtk_widget_set_sensitive(b1,FALSE);
	}

	l1 = rightjust_gtk_label_new(_("Loglevel:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,1,3,1,2);
	gtk_widget_show(l1);

	omenu = gtk_option_menu_new ();
	menu = gtk_menu_new();

	/* loglevels */
	menu_item = gtk_menu_item_new_with_label(_("Off"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
		GTK_SIGNAL_FUNC(loglevel_selected),GINT_TO_POINTER(0));
	gtk_menu_append (GTK_MENU (menu), menu_item);
	gtk_widget_show (menu_item);
	menu_item = gtk_menu_item_new_with_label(_("Sparse"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
		GTK_SIGNAL_FUNC(loglevel_selected),GINT_TO_POINTER(1));
	gtk_menu_append (GTK_MENU (menu), menu_item);
	gtk_widget_show (menu_item);
	menu_item = gtk_menu_item_new_with_label(_("Medium"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
		GTK_SIGNAL_FUNC(loglevel_selected),GINT_TO_POINTER(2));
	gtk_menu_append (GTK_MENU (menu), menu_item);
	gtk_widget_show (menu_item);
	menu_item = gtk_menu_item_new_with_label(_("Verbose"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
		GTK_SIGNAL_FUNC(loglevel_selected),GINT_TO_POINTER(3));
	gtk_menu_append (GTK_MENU (menu), menu_item);
	gtk_widget_show (menu_item);

	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	gtk_option_menu_set_history(GTK_OPTION_MENU (omenu), 
		setupdata.loglevel);
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,3,6,1,2);
	gtk_widget_show(omenu);
	define_tooltip(omenu,_("How much information is logged into the logfile."));

	if (!isroot() && !setupdata.root_option_change_logoptions) {
		gtk_widget_set_sensitive(omenu,FALSE);
	}

	f1 = gtk_frame_new(_("Internationalization"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,FALSE,TRUE,10);
	gtk_widget_show(f1);

	tbl = gtk_table_new(1,8,TRUE);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),5);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
	gtk_container_add (GTK_CONTAINER (f1), tbl);
	gtk_widget_show(tbl);

	l1 = rightjust_gtk_label_new(_("Language:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,1,3,0,1);
	gtk_widget_show(l1);

	omenu = gtk_option_menu_new ();
	menu = gtk_menu_new();

	i = 0; 
	menulang = 0;

	/* add default setting */

#if ENABLE_NLS

	menu_item = gtk_menu_item_new_with_label(_("System default"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
		GTK_SIGNAL_FUNC(language_selected),"");
	gtk_menu_append (GTK_MENU (menu), menu_item);
	gtk_widget_show (menu_item);

	while(lang_array[i]) {

		/* count valid languages */
		if (strcmp(setupdata.language, lang_array[i+1]) == 0) 
			menulang = i/2+1;

		menu_item = gtk_menu_item_new_with_label(
			lang_array[i]);
		gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(language_selected),(gpointer)lang_array[i+1]);
		gtk_menu_append (GTK_MENU (menu), menu_item);
		gtk_widget_show (menu_item);
		i+=2;
	}
#else
	menu_item = gtk_menu_item_new_with_label(lang_array[0]);
	gtk_menu_append (GTK_MENU (menu), menu_item);
	gtk_widget_show (menu_item);
	gtk_widget_set_sensitive(omenu,FALSE);
#endif

	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	gtk_option_menu_set_history(GTK_OPTION_MENU (omenu), menulang);
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,3,6,0,1);
	gtk_widget_show(omenu);
	define_tooltip(omenu,_("Set the language: You have to leave setup to activate this setting. Please note that switching directly to languages that require a different font will not work correctly."));

}


/* callbacks for misc-setup2 */

static void options_selected(GtkWidget *item, gpointer nr) {
gint sel;

	sel = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item));

	switch (GPOINTER_TO_INT(nr)) {
		case 0:
			setupdata.option_tooltips = sel;
			break;
		case 1:
			setupdata.option_autoraise = sel;
			break;
		case 2:
			setupdata.option_savepos = sel;
			break;
		case 3:
			setupdata.option_personimage = sel;
			break;
		case 4:
			setupdata.option_overwritewarn = sel;
			break;
		case 5:
			setupdata.option_autodelete = sel;
			break;
		case 6:
			setupdata.option_titleprogress = sel;
			break;
		case 7:
			setupdata.option_displaycdtext = sel;
			break;
		case 8:
			setupdata.option_selectionmode = sel;
			break;
	}
}


/* draw misc-setup screen part 2 */

static void draw_misc2_setup(GtkWidget *win) {
GtkWidget *vbox, *txt, *scrolled_win;
GtkWidget *f1, *l1;
GtkWidget *tbl;
GtkWidget *check;

	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(win),vbox);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),10);
	gtk_widget_show(vbox);

	f1 = gtk_frame_new(_("Options"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,FALSE,TRUE,0);
	gtk_widget_show(f1);

	tbl = gtk_table_new(9,8,TRUE);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_container_add (GTK_CONTAINER (f1), tbl);
	gtk_widget_show(tbl);

	check = gtk_check_button_new_with_label(_("Tooltips help"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(options_selected),GINT_TO_POINTER(0));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,7,0,1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.option_tooltips);
	gtk_widget_show(check);
	define_tooltip(check, _("Display help when pausing the mouse pointer over a button."));

	check = gtk_check_button_new_with_label(_("Auto-raise/lower windows"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(options_selected),GINT_TO_POINTER(1));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,7,1,2);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.option_autoraise);
	gtk_widget_show(check);
	gtk_widget_set_sensitive(check, FALSE);
	define_tooltip(check, _("Not implemented yet"));

	check = gtk_check_button_new_with_label(_("Save window positions"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(options_selected),GINT_TO_POINTER(2));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,7,2,3);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.option_savepos);
	gtk_widget_show(check);
	define_tooltip(check, _("When you save your configuration also save the last used window position and size."));

	check = gtk_check_button_new_with_label(_("Personalize image filenames"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(options_selected),GINT_TO_POINTER(3));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,7,3,4);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.option_personimage);
	gtk_widget_show(check);
	gtk_widget_set_sensitive(check, FALSE);
	define_tooltip(check, _("Not implemented yet"));

	check = gtk_check_button_new_with_label(_("Warn before overwriting images"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(options_selected),GINT_TO_POINTER(4));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,7,4,5);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.option_overwritewarn);
	gtk_widget_show(check);
	define_tooltip(check, _("When reading or creating new tracks do warn before overwriting existing tracks on the hard drive."));

	check = gtk_check_button_new_with_label(_("Automatically delete images after burn"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(options_selected),GINT_TO_POINTER(5));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,7,5,6);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.option_autodelete);
	gtk_widget_show(check);
	gtk_widget_set_sensitive(check, FALSE);
	define_tooltip(check, _("Not implemented yet"));

	check = gtk_check_button_new_with_label(_("Progress-indicator in window-title"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(options_selected),GINT_TO_POINTER(6));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,7,6,7);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.option_titleprogress);
	gtk_widget_show(check);
	define_tooltip(check, _("Shows the percentage of the current write/read process in the titlebar. Allows to minimize X-CD-Roast and still see the progress in some window-managers."));

	check = gtk_check_button_new_with_label(_("Display CD-Text if available"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(options_selected),GINT_TO_POINTER(7));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,7,7,8);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.option_displaycdtext);
	gtk_widget_show(check);
	define_tooltip(check, _("Display CD-Text in Info-Screen when available by CD-ROM and CD."));

	check = gtk_check_button_new_with_label(_("Windows style list selections"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(options_selected),GINT_TO_POINTER(8));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,7,8,9);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.option_selectionmode);
	gtk_widget_show(check);
	define_tooltip(check, _("When enabled, then multiple selections in lists are handled like the lists in Windows (hold CTRL-Key to select more than one entry and use SHIFT to select a whole range of entries)."));


	f1 = gtk_frame_new(_("cdrecord-ProDVD key"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,TRUE,TRUE,10);
	gtk_widget_show(f1);

	tbl = gtk_table_new(1,8,TRUE);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),2,10);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_container_add(GTK_CONTAINER(f1),tbl);
	gtk_widget_show(tbl);

	l1 = rightjust_gtk_label_new(_("CDR_SECURITY key: "));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,3,0,1);
	gtk_widget_show(l1);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_table_attach_defaults(GTK_TABLE(tbl),scrolled_win,3,8,0,1);
	gtk_widget_show(scrolled_win);

	txt = gtk_text_new(NULL,NULL);
	prodvdkey_txt = txt;
	gtk_text_set_editable(GTK_TEXT(txt),TRUE);
	gtk_text_set_word_wrap(GTK_TEXT(txt),FALSE);
	gtk_widget_set_usize(txt,0,tbf(32));
	gtk_container_add(GTK_CONTAINER(scrolled_win), txt);
	gtk_widget_show(txt);
	define_tooltip(txt, _("Cut & Paste your CDR_SECURITY key from cdrecord-ProDVD into this area. Please refer to the FAQ on how to obtain such a key."));

	gtk_text_freeze(GTK_TEXT(txt));
	gtk_text_insert(GTK_TEXT(txt), NULL, NULL, NULL, setupdata.ProDVDkey,
		strlen(setupdata.ProDVDkey));
	gtk_text_set_point(GTK_TEXT(txt),0);
	gtk_text_thaw(GTK_TEXT(txt));
	
	if (curset.isProDVD == 0) {
		gtk_widget_set_sensitive(f1, FALSE);
		gtk_widget_set_sensitive(l1, FALSE);
		gtk_widget_set_sensitive(txt, FALSE);
	}
}


/* callbacks for nonroot */

static void root_options_selected(GtkWidget *item, gpointer nr) {
gint sel;

	sel = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item));

	switch (GPOINTER_TO_INT(nr)) {
		case 0:
			setupdata.root_option_change_writer = sel;
			break;
		case 1:
			setupdata.root_option_change_writeparam = sel;
			break;
		case 2:
			setupdata.root_option_change_reader = sel;
			break;
		case 3:
			setupdata.root_option_change_readparam = sel;
			break;
		case 4:
			setupdata.root_option_change_imagedirs = sel;
			break;
		case 5:
			setupdata.root_option_change_logoptions = sel;
			break;
	}
}


static void entry_rootusers_callback(GtkWidget *widget, GtkCList *clist) {
gchar user[MAXLINE], tmp2[MAXLINE];
gchar *data[1];
gint row,i,stat;

	strcpy(user,gtk_entry_get_text(GTK_ENTRY(rootusers_entry)));
	strip_string(user);

	/* ignore empty entry */
	if (strcmp(user,"") == 0) {
		return;
	}

	/* and now if user is already added */
	for (i = 0; i < clist->rows; i++) {
		gtk_clist_get_text(clist,i,0,data);	
		if (strcmp(data[0],user) == 0) {
			g_snprintf(tmp2,MAXLINE,_("User \"%s\" already added"),user);
			show_dialog(ICO_WARN,tmp2,T_OK,NULL,NULL,0);	
			return;
		}
	}

	/* now check if user does exist */
	if (!check_pw_user(user)) {
		g_snprintf(tmp2,MAXLINE,_("User \"%s\" does not exist.\nAdd anyway?"),user);
		stat = show_dialog(ICO_WARN,tmp2,T_NO,T_YES,NULL,0);	
		if (stat == 0) return;
	}

	data[0] = user;
	row = gtk_clist_append(clist,data);
	
	/* scroll to newly added entry */
	gtk_clist_moveto(clist,row,0,0.0,1.0);

	gtk_entry_set_text(GTK_ENTRY(rootusers_entry),"");

}

static void remove_rootusers_callback(GtkWidget *widget, GtkCList *clist) {
GList *sel;
gint row;

	sel = clist->selection;

	if (sel == NULL) {
		/* nothing selected to remove */
		show_dialog(ICO_WARN,_("No user selected to remove"),T_OK,NULL,NULL,0);	
	}

	while (sel) {
		row = GPOINTER_TO_INT(sel->data);
		gtk_clist_remove(clist,row);
		sel = clist->selection;
	}
}

static void entry_roothosts_callback(GtkWidget *widget, GtkCList *clist) {
gchar host[MAXLINE],tmp2[MAXLINE];
gchar *data[1];
gint row,i;

	strcpy(host,gtk_entry_get_text(GTK_ENTRY(roothosts_entry)));
	strip_string(host);

	/* ignore empty entry */
	if (strcmp(host,"") == 0) {
		return;
	}

	/* and now if user is already added */
	for (i = 0; i < clist->rows; i++) {
		gtk_clist_get_text(clist,i,0,data);	
		if (strcmp(data[0],host) == 0) {
			g_snprintf(tmp2,MAXLINE,_("Host \"%s\" already added"),host);
			show_dialog(ICO_WARN,tmp2,T_OK,NULL,NULL,0);	
			return;
		}
	}

	data[0] = host;
	row = gtk_clist_append(clist,data);
	
	/* scroll to newly added entry */
	gtk_clist_moveto(clist,row,0,0.0,1.0);

	gtk_entry_set_text(GTK_ENTRY(roothosts_entry),"");

}

static void remove_roothosts_callback(GtkWidget *widget, GtkCList *clist) {
GList *sel;
gint row;

	sel = clist->selection;

	if (sel == NULL) {
		/* nothing selected to remove */
		show_dialog(ICO_WARN,_("No host selected to remove"),T_OK,NULL,NULL,0);	
	}

	while (sel) {
		row = GPOINTER_TO_INT(sel->data);
		gtk_clist_remove(clist,row);
		sel = clist->selection;
	}
}


static void root_users_selected(GtkWidget *item, gpointer data) {

        setupdata.root_users_access = GPOINTER_TO_INT(data); 
}

static void root_hosts_selected(GtkWidget *item, gpointer data) {

        setupdata.root_hosts_access = GPOINTER_TO_INT(data); 
}


/* display non-root-mode configurator */

static void clicked_nrm_selector(GtkWidget *widget, gpointer data) {
gint nrm;

	nrm = query_nonrootmode();
	create_nonroot_configurator(nrm, 1);
}


/* draw non-root menu */

static void draw_nonroot_setup(GtkWidget *win) {
GtkWidget *vbox, *hbox;
GtkWidget *tbl, *tbl2;
GtkWidget *f1, *b1, *e1;
GtkWidget *scrolled_win;
GtkWidget *list;
GtkWidget *btn, *check;
GSList *group;
GList *loop;
gchar *data[1];

	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(win),vbox);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),10);
	gtk_widget_show(vbox);

	/* left and right frame */
	tbl = gtk_table_new(1,2,TRUE);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),0,5);
	gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,TRUE,0);
	gtk_widget_show(tbl);

	f1 = gtk_frame_new(_("Access by users:"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,0,1,0,1);
	gtk_widget_show(f1);

	tbl2 = gtk_table_new(5,14,TRUE);
	gtk_table_set_col_spacing(GTK_TABLE(tbl2),9,5);
	gtk_container_set_border_width(GTK_CONTAINER (tbl2),5);
	gtk_container_add(GTK_CONTAINER(f1),tbl2);
	gtk_widget_show(tbl2);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl2),scrolled_win,6,14,0,3);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
		GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	gtk_widget_show(scrolled_win);

	list = gtk_clist_new(1);
	users_clist = GTK_CLIST(list);
	gtk_container_add (GTK_CONTAINER (scrolled_win), list);
	gtk_clist_set_column_auto_resize(users_clist, 0, TRUE);
	if (setupdata.option_selectionmode == 0) {
		gtk_clist_set_selection_mode (users_clist, GTK_SELECTION_MULTIPLE);
	} else {
		gtk_clist_set_selection_mode (users_clist, GTK_SELECTION_EXTENDED);
	}

	gtk_widget_show(list);

	/* now add current values */
        loop = g_list_first(setupdata.root_users_lists);
	while (loop) {
                data[0] = (gchar *)loop->data;
                gtk_clist_append(users_clist,data);
                loop = loop->next;
        }


	e1 = gtk_entry_new();
	rootusers_entry = e1;
        gtk_signal_connect(GTK_OBJECT(e1), "activate",
                GTK_SIGNAL_FUNC(entry_rootusers_callback),users_clist);
	gtk_table_attach_defaults(GTK_TABLE(tbl2),e1,6,14,3,4);
	gtk_widget_show(e1);
	define_tooltip(e1, _("Enter here an username which should be allowed or denied access for X-CD-Roast. Press Return or click on the \"Add\"-button to put it on the list."));

	/* add button */
	b1 = gtk_button_new_with_label(_("Add"));
        gtk_signal_connect(GTK_OBJECT(b1), "clicked",
                GTK_SIGNAL_FUNC(entry_rootusers_callback),users_clist);
	gtk_table_attach_defaults(GTK_TABLE(tbl2),b1,6,10,4,5);
	gtk_widget_show(b1);
	define_tooltip(b1, _("Add the username given in the entry-field to the list."));

	/* remove button */
	b1 = gtk_button_new_with_label(_("Remove"));
        gtk_signal_connect(GTK_OBJECT(b1), "clicked",
                GTK_SIGNAL_FUNC(remove_rootusers_callback),users_clist);
	gtk_table_attach_defaults(GTK_TABLE(tbl2),b1,10,14,4,5);
	gtk_widget_show(b1);
	define_tooltip(b1, _("Remove all selected users from the list."));

	btn = gtk_radio_button_new_with_label(NULL,_("Allow all"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(root_users_selected),GINT_TO_POINTER(0));
	gtk_table_attach_defaults(GTK_TABLE(tbl2),btn,0,6,0,1);
	gtk_widget_show(btn);
	define_tooltip(btn, _("All users are allowed to start X-CD-Roast."));
        if (setupdata.root_users_access == 0) 
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));

	btn = gtk_radio_button_new_with_label(group,_("None allowed"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(root_users_selected),GINT_TO_POINTER(1));
	gtk_table_attach_defaults(GTK_TABLE(tbl2),btn,0,6,1,2);
	gtk_widget_show(btn);
	define_tooltip(btn, _("No users are allowed to start X-CD-Roast (except root)."));
        if (setupdata.root_users_access == 1) 
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));

	btn = gtk_radio_button_new_with_label(group,_("All in list"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(root_users_selected),GINT_TO_POINTER(2));
	gtk_table_attach_defaults(GTK_TABLE(tbl2),btn,0,6,2,3);
	gtk_widget_show(btn);
	define_tooltip(btn, _("Only the users which were added to the list are allowed to start X-CD-Roast."));
        if (setupdata.root_users_access == 2) 
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));

	btn = gtk_radio_button_new_with_label(group,_("All, but listed"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(root_users_selected),GINT_TO_POINTER(3));
	gtk_table_attach_defaults(GTK_TABLE(tbl2),btn,0,6,3,4);
	gtk_widget_show(btn);
	define_tooltip(btn, _("All users on the list are not allowed to start X-CD-Roast. All others may use it."));
        if (setupdata.root_users_access == 3) 
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);

	/* right frame */
	f1 = gtk_frame_new(_("Access by hosts:"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,1,2,0,1);
	gtk_widget_show(f1);

	tbl2 = gtk_table_new(5,14,TRUE);
	gtk_table_set_col_spacing(GTK_TABLE(tbl2),9,5);
	gtk_container_set_border_width(GTK_CONTAINER (tbl2),5);
	gtk_container_add(GTK_CONTAINER(f1),tbl2);
	gtk_widget_show(tbl2);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl2),scrolled_win,6,14,0,3);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
		GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	gtk_widget_show(scrolled_win);

	list = gtk_clist_new(1);
	hosts_clist = GTK_CLIST(list);
	gtk_container_add (GTK_CONTAINER (scrolled_win), list);
	gtk_clist_set_column_auto_resize(hosts_clist, 0, TRUE);
	if (setupdata.option_selectionmode == 0) {
		gtk_clist_set_selection_mode (hosts_clist, GTK_SELECTION_MULTIPLE);
	} else {
		gtk_clist_set_selection_mode (hosts_clist, GTK_SELECTION_EXTENDED);
	}
	gtk_widget_show(list);

	/* now add current values */
        loop = g_list_first(setupdata.root_hosts_lists);
	while (loop) {
                data[0] = (gchar *)loop->data;
                gtk_clist_append(hosts_clist,data);
                loop = loop->next;
        }

	e1 = gtk_entry_new();
	roothosts_entry = e1;
        gtk_signal_connect(GTK_OBJECT(e1), "activate",
                GTK_SIGNAL_FUNC(entry_roothosts_callback),hosts_clist);
	gtk_table_attach_defaults(GTK_TABLE(tbl2),e1,6,14,3,4);
	gtk_widget_show(e1);
	define_tooltip(e1, _("Enter here a hostname of a computer which may run X-CD-Roast. This makes sense, when using the same config-file on more than one host (e.g. pool-installations)."));

	/* add button */
	b1 = gtk_button_new_with_label(_("Add"));
        gtk_signal_connect(GTK_OBJECT(b1), "clicked",
                GTK_SIGNAL_FUNC(entry_roothosts_callback),hosts_clist);
	gtk_table_attach_defaults(GTK_TABLE(tbl2),b1,6,10,4,5);
	gtk_widget_show(b1);
	define_tooltip(b1, _("Add the hostname given in the entry-field to the list."));

	/* remove button */
	b1 = gtk_button_new_with_label(_("Remove"));
        gtk_signal_connect(GTK_OBJECT(b1), "clicked",
                GTK_SIGNAL_FUNC(remove_roothosts_callback),hosts_clist);
	gtk_table_attach_defaults(GTK_TABLE(tbl2),b1,10,14,4,5);
	gtk_widget_show(b1);
	define_tooltip(b1, _("Remove all selected hosts from the list."));

	btn = gtk_radio_button_new_with_label(NULL,_("Allow all"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(root_hosts_selected),GINT_TO_POINTER(0));
	gtk_table_attach_defaults(GTK_TABLE(tbl2),btn,0,6,0,1);
	gtk_widget_show(btn);
	define_tooltip(btn, _("X-CD-Roast may be started on all hosts."));
        if (setupdata.root_hosts_access == 0) 
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));

	btn = gtk_radio_button_new_with_label(group,_("None allowed"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(root_hosts_selected),GINT_TO_POINTER(1));
	gtk_table_attach_defaults(GTK_TABLE(tbl2),btn,0,6,1,2);
	gtk_widget_show(btn);
	define_tooltip(btn, _("X-CD-Roast won't start on any host (except when run by root)."));
        if (setupdata.root_hosts_access == 1) 
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));

	btn = gtk_radio_button_new_with_label(group,_("All in list"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(root_hosts_selected),GINT_TO_POINTER(2));
	gtk_table_attach_defaults(GTK_TABLE(tbl2),btn,0,6,2,3);
	gtk_widget_show(btn);
	define_tooltip(btn, _("Only the hosts in the list may start X-CD-Roast."));
        if (setupdata.root_hosts_access == 2) 
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));

	btn = gtk_radio_button_new_with_label(group,_("All, but listed"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(root_hosts_selected),GINT_TO_POINTER(3));
	gtk_table_attach_defaults(GTK_TABLE(tbl2),btn,0,6,3,4);
	gtk_widget_show(btn);
	define_tooltip(btn, _("Only hosts which are not listed can start X-CD-Roast."));
        if (setupdata.root_hosts_access == 3) 
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);

	/* options */

	f1 = gtk_frame_new(_("Users are allowed to:"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,FALSE,TRUE,10);
	gtk_widget_show(f1);

	tbl = gtk_table_new(4,16,TRUE);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_container_add (GTK_CONTAINER (f1), tbl);
	gtk_widget_show(tbl);

	if (!curset.isProDVD) {
		check = gtk_check_button_new_with_label(_("change CD Writer Device"));
	} else {
		check = gtk_check_button_new_with_label(_("change CD/DVD Writer Device"));
	}
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(root_options_selected),GINT_TO_POINTER(0));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,9,0,1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.root_option_change_writer);
	gtk_widget_show(check);
	define_tooltip(check, _("If enabled, then the user is allowed to change the settings for the CD Writer. Else the setting given by root must be used."));

	check = gtk_check_button_new_with_label(_("change write parameters"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(root_options_selected),GINT_TO_POINTER(1));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,9,16,0,1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.root_option_change_writeparam);
	gtk_widget_show(check);
	define_tooltip(check, _("If enabled, then the user is allowed the change the write parameters for the CD Writer (e.g. Speed and FIFO-Buffer-Size)."));

	if (!curset.isProDVD) {
		check = gtk_check_button_new_with_label(_("change CD Reader Device"));
	} else {
		check = gtk_check_button_new_with_label(_("change CD/DVD Reader Device"));
	}
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(root_options_selected),GINT_TO_POINTER(2));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,9,1,2);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.root_option_change_reader);
	gtk_widget_show(check);
	define_tooltip(check, _("If enabled, then the user is allowed to change the settings for the CD Readers. Else the settings given by root must be used."));

	check = gtk_check_button_new_with_label(_("change read parameters"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(root_options_selected),GINT_TO_POINTER(3));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,9,16,1,2);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.root_option_change_readparam);
	gtk_widget_show(check);
	define_tooltip(check, _("If enabled, then the user is allowed the change the read parameters for the CD Readers (e.g. Speed and overlap sectors)."));

	check = gtk_check_button_new_with_label(_("change Image Storage Directories"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(root_options_selected),GINT_TO_POINTER(4));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,9,2,3);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.root_option_change_imagedirs);
	gtk_widget_show(check);
	define_tooltip(check, _("If enabled, then the user may give his own image-directories (best where he got write permissions). Else the directories specified by root must be used (should be also a directory where any user can write into)."));

	check = gtk_check_button_new_with_label(_("change Logging-Options"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(root_options_selected),GINT_TO_POINTER(5));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,9,3,4);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.root_option_change_logoptions);
	gtk_widget_show(check);
	define_tooltip(check, _("If enabled, then the user may change the logging parameters (the path of the logfile and the loglevel)."));

	hbox = gtk_alignment_new(0.5, 0.5, 0.5, 0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,TRUE,TRUE,10);
	gtk_widget_show(hbox);

	/* non root config mode selector */
	b1 = gtk_button_new_with_label(_("Change Non-Root configuration"));
        gtk_signal_connect(GTK_OBJECT(b1), "clicked",
                GTK_SIGNAL_FUNC(clicked_nrm_selector),NULL);
	gtk_container_add(GTK_CONTAINER(hbox),b1);
	gtk_widget_show(b1);
	define_tooltip(b1, _("Choose if you want to enable or disable the Non-Root-Mode of X-CD-Roast. If you enable the Non-Root-Mode then you do not need to become root first in order to use X-CD-Roast."));
}


/* called by the setup-button */

void create_setup() {
GtkWidget *side_t;
GtkWidget *side_t_btn2;
GtkWidget *side_t_btn3;
GtkWidget *side_t_btn4;
GtkWidget *notebook,*f1,*l1;
GtkWidget *head,*head_l;
gint i;

	/* backup the current setup-data */
	memcpy(&bak_setupdata,&setupdata,sizeof(setup_data_t)); 
	bak_setupdata.image_dirs = NULL;
	copy_glist(&bak_setupdata.image_dirs, setupdata.image_dirs); 
#if !(defined(__MACH__) && defined(__APPLE__)) && (USE_NONROOTMODE == 1)
	if (isroot()) {
		bak_setupdata.root_users_lists = NULL;
		copy_glist(&bak_setupdata.root_users_lists, setupdata.root_users_lists); 
		bak_setupdata.root_hosts_lists = NULL;
		copy_glist(&bak_setupdata.root_hosts_lists, setupdata.root_hosts_lists); 
	}
#endif
	bak_setupdata.dsp_device = g_strdup(setupdata.dsp_device);
	bak_setupdata.mix_device = g_strdup(setupdata.mix_device);
	bak_setupdata.cddb_host = g_strdup(setupdata.cddb_host);
	bak_setupdata.cddb_proxy_host = g_strdup(setupdata.cddb_proxy_host);
	bak_setupdata.logfile = g_strdup(setupdata.logfile);
	bak_setupdata.ProDVDkey = g_strdup(setupdata.ProDVDkey);

	/* backup the dynamic part of the readerwriter structure too */
	bak_writerreader = g_new0(writerreader_bak_t *, MAXDEVICES);
	i = 0;
	while(writerreaderdevs[i] != NULL) {
		bak_writerreader[i] = g_new0(writerreader_bak_t, 1);
		bak_writerreader[i]->devnr = writerreaderdevs[i]->devnr;
		bak_writerreader[i]->values[0] = writerreaderdevs[i]->writer_drvmode;
		bak_writerreader[i]->values[1] = writerreaderdevs[i]->writer_mode;
		bak_writerreader[i]->values[2] = writerreaderdevs[i]->writer_speed;
		bak_writerreader[i]->values[3] = writerreaderdevs[i]->writer_fifo;
		bak_writerreader[i]->values[4] = writerreaderdevs[i]->audioread_interface;
		bak_writerreader[i]->values[5] = writerreaderdevs[i]->audioread_speed;
		bak_writerreader[i]->values[6] = writerreaderdevs[i]->audioread_overlap;
		bak_writerreader[i]->values[7] = writerreaderdevs[i]->audioread_sectorburst;
		bak_writerreader[i]->values[8] = writerreaderdevs[i]->audioread_useparanoia;
		bak_writerreader[i]->values[9] = writerreaderdevs[i]->audioread_paranoiaretries;

		i++;
	}

	clear_sidespace();
	clear_workspace();

        side_t = gtk_table_new(10,10, TRUE);
        gtk_table_set_row_spacings(GTK_TABLE(side_t),10);

        gtk_box_pack_start(GTK_BOX(sidespace), side_t,TRUE,TRUE,0);

        side_t_btn2 = gtk_button_new_with_label (_("Save configuration"));
        side_t_btn3 = gtk_button_new_with_label (T_OK);
        side_t_btn4 = gtk_button_new_with_label (T_CANCEL);

	gtk_signal_connect (GTK_OBJECT (side_t_btn2), "clicked",
                GTK_SIGNAL_FUNC(menu_setup_save),NULL);

	gtk_signal_connect (GTK_OBJECT (side_t_btn3), "clicked",
                GTK_SIGNAL_FUNC(menu_setup_ok),NULL);

	gtk_signal_connect (GTK_OBJECT (side_t_btn4), "clicked",
                GTK_SIGNAL_FUNC(menu_setup_cancel),NULL);


        gtk_table_attach_defaults(GTK_TABLE(side_t), side_t_btn2, 0,10,5,6);
        gtk_widget_show(side_t_btn2);
        define_tooltip(side_t_btn2,_("Saves your current configuration."));

        gtk_table_attach_defaults(GTK_TABLE(side_t), side_t_btn3, 0,10,7,8);
        gtk_widget_show(side_t_btn3);
        define_tooltip(side_t_btn3,_("Accept the current configuration and return to main menu."));

        gtk_table_attach_defaults(GTK_TABLE(side_t), side_t_btn4, 0,10,8,9);
        gtk_widget_show(side_t_btn4);
        define_tooltip(side_t_btn4,_("Cancel all changes and return to main menu."));

        gtk_widget_show(side_t);
	gtk_widget_show(sidespace);

	/* draw workspace */

	head = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(head),GTK_SHADOW_IN);
	gtk_widget_set_usize(head,0,45);
	gtk_box_pack_start(GTK_BOX(workspace), head,FALSE,TRUE,0);
	gtk_widget_show(head);
	head_l = gtk_label_new(_("Setup"));
	set_font_and_color(head_l,BIGFONT,NULL);
	gtk_container_add(GTK_CONTAINER(head),head_l);
	gtk_widget_show(head_l);
	gtk_widget_show(workspace);

	notebook = gtk_notebook_new();
	gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
	gtk_box_pack_start(GTK_BOX(workspace), notebook,TRUE,TRUE,10);
	gtk_widget_show(notebook);

	l1 = gtk_label_new(_("Device-Scan"));
	f1 = gtk_frame_new(NULL);
	gtk_container_set_border_width (GTK_CONTAINER (f1), 10);
	gtk_notebook_append_page(GTK_NOTEBOOK (notebook),f1,l1);
	gtk_widget_show(f1);
	draw_scsi_scan(f1);

	if (!curset.isProDVD) {
		l1 = gtk_label_new(_("CD Settings"));
	} else {
		l1 = gtk_label_new(_("CD/DVD Settings"));
	}
	f1 = gtk_frame_new(NULL);
	gtk_container_set_border_width (GTK_CONTAINER (f1), 10);
	gtk_notebook_append_page(GTK_NOTEBOOK (notebook),f1,l1);
	gtk_widget_show(f1);
	draw_cd_setup(f1);

	l1 = gtk_label_new(_("HD Settings"));
	f1 = gtk_frame_new(NULL);
	gtk_container_set_border_width (GTK_CONTAINER (f1), 10);
	gtk_notebook_append_page(GTK_NOTEBOOK (notebook),f1,l1);
	gtk_widget_show(f1);
	draw_hd_setup(f1);

	l1 = gtk_label_new(_("Miscellaneous"));
	f1 = gtk_frame_new(NULL);
	gtk_container_set_border_width (GTK_CONTAINER (f1), 10);
	gtk_notebook_append_page(GTK_NOTEBOOK (notebook),f1,l1);
	gtk_widget_show(f1);
	draw_misc_setup(f1);

	l1 = gtk_label_new(_("Options"));
	f1 = gtk_frame_new(NULL);
	gtk_container_set_border_width (GTK_CONTAINER (f1), 10);
	gtk_notebook_append_page(GTK_NOTEBOOK (notebook),f1,l1);
	gtk_widget_show(f1);
	draw_misc2_setup(f1);

#if !(defined(__MACH__) && defined(__APPLE__)) && (USE_NONROOTMODE == 1)
	if (isroot()) {
		/* non root mode? */
		l1 = gtk_label_new(_("Users"));
		f1 = gtk_frame_new(NULL);
		gtk_container_set_border_width (GTK_CONTAINER (f1), 10);
		gtk_notebook_append_page(GTK_NOTEBOOK (notebook),f1,l1);
		gtk_widget_show(f1);
		draw_nonroot_setup(f1);
	}
#endif

	/* check if found any cdrom/writer at all */
	if (writerreaderdevs[0] == NULL) {
		/* no devices found */
		show_dialog(ICO_WARN, _("No CD-Writer or CD-ROM device detected.\nFor ATAPI/IDE devices under Linux you have to enable\nSCSI-Emulation in the kernel in order to activate them.\nPlease see the X-CD-Roast manual how to do that."), T_OK, NULL, NULL, 0);
	}	
}


/* called on delete event of nrm-configurator */
static gint nrs_dialog_delete_event(GtkWidget *widget, GdkEvent *event, gpointer data) {

	nrs_dialog_done = -1;
	return (TRUE);
}


/* show dialog for non-root configurator */

void create_nonroot_configurator(gint nonrootmode, gint fromsetup) {
GtkWidget *dialog, *page, *l1, *f1, *vbox, *xcdroast_logo;
GdkPixbuf *im, *im2;
GdkPixmap *p;
GdkBitmap *m;
gchar tmp[MAXLINE];
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor;
GtkRequisition rq;

	/* if another dialog is running, ignore */
	if (nrs_dialog_done == 999) {
		return;
	}

	dodebug(8, "displaying create_nonroot_configurator\n");

	/* mark our dialog as running */
	nrs_dialog_done = 999;

	dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	nrs_dialog = dialog;
	set_xcdr_title(dialog, NULL, -1);
	gtk_window_set_policy(GTK_WINDOW(dialog), FALSE, TRUE, FALSE);
	gtk_widget_set_usize(dialog,tbf(365),0);

	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (nrs_dialog_delete_event), (gpointer) dialog);

	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(dialog),vbox);
	gtk_widget_show(vbox);

	/* load the half scaled logo */
	g_snprintf(tmp,MAXLINE,"%s/%s", sharedir, XCDRLOGO);
	im=gdk_pixbuf_new_from_file(tmp);
	if (im) {
		im2 = gdk_pixbuf_scale_simple(im, 
			gdk_pixbuf_get_width(im)/2, 
			gdk_pixbuf_get_height(im)/2, 
			GDK_INTERP_TILES);
		gdk_pixbuf_render_pixmap_and_mask(im2, &p, &m, 128);
        	xcdroast_logo = gtk_pixmap_new(p,m);
		gdk_pixbuf_unref(im);
		gdk_pixbuf_unref(im2);
	} else {
		xcdroast_logo = gtk_label_new("[LOGO]");
	}
	gtk_box_pack_start(GTK_BOX(vbox),xcdroast_logo,FALSE,FALSE,0);
	gtk_widget_show(xcdroast_logo);	

	g_snprintf(tmp,MAXLINE,_("Version %s"),XCDROAST_VERSION);
	l1 = gtk_label_new(tmp);	
	gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_CENTER);
	set_font_and_color(l1,NULL,"red");
	gtk_box_pack_start(GTK_BOX(vbox),l1,FALSE,FALSE,0);
	gtk_widget_show(l1);

	f1 = gtk_frame_new(NULL);
	nrs_frame = f1;
	gtk_box_pack_start(GTK_BOX(vbox),f1,TRUE,TRUE,0);
	gtk_container_set_border_width(GTK_CONTAINER (f1),5);
	gtk_widget_show(f1);

	/* show first page of configurator */
	page = gen_nonroot_page1(nonrootmode, fromsetup);
	nrs_page = page;
	nrs_mode = nonrootmode;
	nrs_fromsetup = fromsetup;
	gtk_container_add(GTK_CONTAINER(f1),page);
	gtk_widget_show(page);

        /* grab cursor and change to watch */
	cursor = NULL;
        if (GTK_WIDGET_MAPPED(toplevel)) {
                gtk_grab_add(dialog);
                cursor = gdk_cursor_new(GDK_WATCH);
                gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
        }

        /* only center window when toplevel visible */
        if ( GTK_WIDGET_VISIBLE(toplevel)) {
                gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
                gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);                gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);                gtk_widget_size_request(dialog,&rq);
                gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
        } else {
                /* otherwise center in screen */
                gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
                xsize = gdk_screen_width();
                ysize = gdk_screen_height();
                gtk_widget_size_request(dialog,&rq);
                gtk_widget_set_uposition(GTK_WIDGET(dialog),xsize/2-rq.width/2,ysize/2-rq.height/2);

        }

	gtk_widget_show(dialog);

        /* now wait until button is pressed */
        while (nrs_dialog_done == 999) {
                wait_and_process_events();
        }

        if (GTK_WIDGET_MAPPED(toplevel)) {
                gtk_grab_remove(GTK_WIDGET(dialog));
                gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,NULL);
                if (cursor) gdk_cursor_destroy (cursor);
        }

        /* remove dialog window */
        gtk_widget_destroy(dialog);
}


/* called by activate/deactivate button */

static void change_nonroot_mode(GtkWidget *widget, gpointer data) {
gint act;

	act = GPOINTER_TO_INT(data);

	/* destroy old content of window */
	gtk_widget_destroy(nrs_page);

	/* create new one */
	nrs_page = gen_nonroot_page2(act);
	gtk_container_add(GTK_CONTAINER(nrs_frame),nrs_page);
	gtk_widget_show(nrs_page);

}


/* called by launch button of non-root-configuration */

static void launch_nonroot_mode(GtkWidget *widget, gpointer data) {

	/* remove dialog */
	nrs_dialog_done = 0;
}


/* render widget with the first page of non-root-configurator */

static GtkWidget *gen_nonroot_page1(gint act, gint fromsetup) {
GtkWidget *align, *b1, *b2, *sep;
GtkWidget *l1, *vbox2, *hbox;

	vbox2 = gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width(GTK_CONTAINER (vbox2),5);

	l1 = gtk_label_new(_("Non-Root-Mode configuration:"));
	set_font_and_color(l1,BOLDFONT,NULL);
	gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_CENTER);
	gtk_box_pack_start(GTK_BOX(vbox2),l1,TRUE,TRUE,0);
	gtk_widget_show(l1);

	l1 = gtk_label_new(_("Welcome to X-CD-Roast!\n\nYou have now the opportunity to configure X-CD-Roast\nso, that not only the root user can start it, but any user\nyou choose. Using the Non-Root-Mode is recommended\nand secure. You can change the mode anytime in the\nUsers-Pane of the Setup-Menu."));
	gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_CENTER);
	gtk_box_pack_start(GTK_BOX(vbox2),l1,TRUE,TRUE,10);
	gtk_widget_show(l1);

	align = gtk_alignment_new(0.5, 0.5, 0, 0);
	gtk_box_pack_start(GTK_BOX(vbox2),align,TRUE,TRUE,0);
	gtk_widget_show(align);

	hbox = gtk_hbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(align),hbox);
	gtk_widget_show(hbox);

	l1 = gtk_label_new(_("Current status:"));
	gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_RIGHT);
	gtk_box_pack_start(GTK_BOX(hbox),l1,FALSE,FALSE,0);
	gtk_widget_show(l1);

	/* non-root status */
	if (act == 0) {
		l1 = gtk_label_new(_("Non-Root-Mode deactivated"));
	} else {
		l1 = gtk_label_new(_("Non-Root-Mode activated"));
	}
	set_font_and_color(l1,BOLDFONT,"red");
	gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(hbox),l1,FALSE,FALSE,10);
	gtk_widget_show(l1);

	sep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox2),sep,TRUE,TRUE,15);
	gtk_widget_show(sep);

	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox2),hbox,FALSE,TRUE,5);
	gtk_widget_show(hbox);

	if (act == 0) {
		b1 = gtk_button_new_with_label(_("Activate Non-Root-Mode"));
	} else {
		b1 = gtk_button_new_with_label(_("Deactivate Non-Root-Mode"));
	}
	gtk_signal_connect (GTK_OBJECT (b1), "clicked",
                GTK_SIGNAL_FUNC(change_nonroot_mode),GINT_TO_POINTER(act));
	gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,5);
	gtk_widget_show(b1);

	if (fromsetup) {
		b2 = gtk_button_new_with_label(T_CLOSE);
	} else {
		b2 = gtk_button_new_with_label(_("Launch X-CD-Roast"));
	}
	gtk_signal_connect (GTK_OBJECT (b2), "clicked",
                GTK_SIGNAL_FUNC(launch_nonroot_mode),NULL);
	gtk_box_pack_start(GTK_BOX(hbox),b2,TRUE,TRUE,5);
	gtk_widget_show(b2);

	return vbox2;	
}


/* called by OK button of de/activate-non-root-menu */

static void ok_change_nonroot_mode(GtkWidget *widget, GtkWidget *txt) {
gchar cmds[MAXLINE*10];
gchar *p;
gchar cmd[MAXLINE];
gint stat, allok;
gint n;

	allok = 1;
	n = gtk_text_get_length(GTK_TEXT(txt));
	strncpy(cmds, gtk_editable_get_chars(GTK_EDITABLE(txt),0,n), 
			MAXLINE*10);

#if 0
	/* save now the old flags and owners if we are activating */
	if (nrs_mode == 0) {
		save_current_nonrootvalues(configdir, NONROOTBAK);
	}
#endif
	
	/* now extract all the commands one by one */
	p = strtok(cmds, "\n");
	while (p) {
		strncpy(cmd, p, MAXLINE);
		stat = simple_exec(cmd);
		if (stat != 0) {
			g_print("Warning: Command %s failed!\n", cmd);
			allok = 0;
		}
		/* special case..if we just created a group, wait one
		   second before using it */
#if 0
		if (strncmp(cmd, GROUPADD, strlen(GROUPADD)) == 0) {
			usleep(1000000);
		}
#endif
		p = strtok(NULL, "\n");
	}

	
	/* destroy old content of window */
	gtk_widget_destroy(nrs_page);

	/* create new one */
	nrs_page = gen_nonroot_page3(nrs_mode, allok, nrs_fromsetup);
	gtk_container_add(GTK_CONTAINER(nrs_frame),nrs_page);
	gtk_widget_show(nrs_page);

}


/* called by cancel button of activate-non-root-menu */

static void cancel_change_nonroot_mode(GtkWidget *widget, gpointer data) {

	/* destroy old content of window */
	gtk_widget_destroy(nrs_page);

	/* create new one */
	nrs_page = gen_nonroot_page1(nrs_mode, nrs_fromsetup);
	gtk_container_add(GTK_CONTAINER(nrs_frame),nrs_page);
	gtk_widget_show(nrs_page);
}


/* render widget with the second page of non-root-configurator */

static GtkWidget *gen_nonroot_page2(gint act) {
GtkWidget *b1, *b2, *sep, *scrolled_win;
GtkWidget *l1, *vbox2, *hbox, *txt;
gchar tmp[MAXLINE*10];
gint stat;

	vbox2 = gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width(GTK_CONTAINER (vbox2),5);

	if (act == 0) {
		l1 = gtk_label_new(_("Activate Non-Root-Mode"));
	} else {
		l1 = gtk_label_new(_("Deactivate Non-Root-Mode"));
	}
	set_font_and_color(l1,BOLDFONT,NULL);
	gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_CENTER);
	gtk_box_pack_start(GTK_BOX(vbox2),l1,FALSE,FALSE,0);
	gtk_widget_show(l1);

	if (act == 0) {
		l1 = gtk_label_new(_("The following commands will be executed in order\nto activate the Non-Root-Mode.\nPress OK when you are sure you want that."));
	} else {
		l1 = gtk_label_new(_("The following commands will be executed in order\nto deactivate the Non-Root-Mode.\nPress OK when you are sure you want that."));
	}
	gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_CENTER);
	gtk_box_pack_start(GTK_BOX(vbox2),l1,FALSE,FALSE,10);
	gtk_widget_show(l1);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(vbox2),scrolled_win,TRUE,TRUE,5);
	gtk_widget_show(scrolled_win);

	txt = gtk_text_new(NULL,NULL);
	gtk_text_set_editable(GTK_TEXT(txt),FALSE);
	gtk_text_set_word_wrap(GTK_TEXT(txt),FALSE);
	gtk_container_add(GTK_CONTAINER(scrolled_win), txt);
	gtk_widget_show(txt);

	sep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox2),sep,FALSE,FALSE,5);
	gtk_widget_show(sep);

	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox2),hbox,FALSE,TRUE,5);
	gtk_widget_show(hbox);

	b1 = gtk_button_new_with_label(T_OK);
	gtk_signal_connect (GTK_OBJECT (b1), "clicked",
                GTK_SIGNAL_FUNC(ok_change_nonroot_mode), txt);
	gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,5);
	gtk_widget_show(b1);

	b2 = gtk_button_new_with_label(T_CANCEL);
	gtk_box_pack_start(GTK_BOX(hbox),b2,TRUE,TRUE,5);
	gtk_signal_connect (GTK_OBJECT (b2), "clicked",
                GTK_SIGNAL_FUNC(cancel_change_nonroot_mode),NULL);
	gtk_widget_show(b2);

	/* fill textbox */
	stat = get_commands_to_change_nrm(tmp, act);
	gtk_text_insert(GTK_TEXT(txt), NULL, NULL, NULL, tmp, strlen(tmp));
	gtk_text_set_point(GTK_TEXT(txt),0);

	/* error reported? */
	if (stat != 0) {
		/* disable OK button */
		gtk_widget_set_sensitive(b1, FALSE);
	}

	return vbox2;	
}


/* render widget with the third page of non-root-configurator */

static GtkWidget *gen_nonroot_page3(gint act, gint status, gint fromsetup) {
GtkWidget *b1, *sep;
GtkWidget *l1, *vbox2, *hbox;

	vbox2 = gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width(GTK_CONTAINER (vbox2),5);

	if (act == 0) {
		l1 = gtk_label_new(_("Activate Non-Root-Mode"));
	} else {
		l1 = gtk_label_new(_("Deactivate Non-Root-Mode"));
	}
	set_font_and_color(l1,BOLDFONT,NULL);
	gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_CENTER);
	gtk_box_pack_start(GTK_BOX(vbox2),l1,FALSE,FALSE,0);
	gtk_widget_show(l1);

	/* show message according to success */
	if (act == 0) {
		if (status == 1) {
			/* activation ok */
			l1 = gtk_label_new(_("Activation of the Non-Root-Mode was successful!\n\nEnter now the Setup-Menu to configure\nwhich users may work with X-CD-Roast."));
		} else {
			/* activation failed */
			l1 = gtk_label_new(_("Activation of the Non-Root-Mode failed!\n\nPlease try again with enabled Debug-Mode and report.\n(See the FAQ on http://www.xcdroast.org)"));
		}
	} else {
		if (status == 1) {
			/* deactivation ok */
			l1 = gtk_label_new(_("Deactivation of the Non-Root-Mode was successful!\n\nThe original file permissons have been restored.\nOnly the root user can now use X-CD-Roast."));
		} else {
			/* deactivation failed */
			l1 = gtk_label_new(_("Deactivation of the Non-Root-Mode failed!\n\nPlease try again with enabled Debug-Mode and report.\n(See the FAQ on http://www.xcdroast.org)"));
		}
	}
	gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_CENTER);
	gtk_box_pack_start(GTK_BOX(vbox2),l1,TRUE,TRUE,10);
	gtk_widget_show(l1);

	sep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox2),sep,FALSE,FALSE,5);
	gtk_widget_show(sep);

	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox2),hbox,FALSE,TRUE,5);
	gtk_widget_show(hbox);

	if (fromsetup) {
		b1 = gtk_button_new_with_label(T_CLOSE);
	} else {
		b1 = gtk_button_new_with_label(_("Launch X-CD-Roast"));
	}
	gtk_signal_connect (GTK_OBJECT (b1), "clicked",
                GTK_SIGNAL_FUNC(launch_nonroot_mode),NULL);
	gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,5);
	gtk_widget_show(b1);

	return vbox2;	
}


static void nrs_dialog_btn_press(GtkWidget *widget, gpointer data) {

        nrs_dialog_done = GPOINTER_TO_INT(data);
}


/* show dialog for device scanning */
/* a big and a small version for manual scanning only */

gint create_device_scanning(gint scanparam, gint manual, gint withlogo, gchar *devicestr) {
GtkWidget *dialog, *l1, *f1, *vbox, *xcdroast_logo;
GtkWidget *vbox2, *scrolled_win, *txt, *sep, *hbox, *b1;
GdkPixbuf *im, *im2;
GdkPixmap *p;
GdkBitmap *m;
gchar tmp[MAXLINE];
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor, *cursor2;
GtkRequisition rq;

	/* if another dialog is running, ignore */
	if (nrs_dialog_done == 999) {
		return -1;
	}

	dodebug(8, "displaying create_device_scanning\n");

	/* mark our dialog as running */
	nrs_dialog_done = 999;

	dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	nrs_dialog = dialog;
	set_xcdr_title(dialog, NULL, -1);
	gtk_window_set_policy(GTK_WINDOW(dialog), FALSE, TRUE, FALSE);
	gtk_widget_set_usize(dialog,tbf(400),0);
	gtk_widget_realize(dialog);

	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (nrs_dialog_delete_event), (gpointer) dialog);

	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(dialog),vbox);
	gtk_widget_show(vbox);

	/* load the half scaled logo */
	if (withlogo) {
		g_snprintf(tmp,MAXLINE,"%s/%s", sharedir, XCDRLOGO);
		im=gdk_pixbuf_new_from_file(tmp);
		if (im) {
			im2 = gdk_pixbuf_scale_simple(im, 
				gdk_pixbuf_get_width(im)/2, 
				gdk_pixbuf_get_height(im)/2, 
				GDK_INTERP_TILES);
			gdk_pixbuf_render_pixmap_and_mask(im2, &p, &m, 128);
       	 		xcdroast_logo = gtk_pixmap_new(p,m);
			gdk_pixbuf_unref(im);
			gdk_pixbuf_unref(im2);
		} else {
			xcdroast_logo = gtk_label_new("[LOGO]");
		}
		gtk_box_pack_start(GTK_BOX(vbox),xcdroast_logo,FALSE,FALSE,0);
		gtk_widget_show(xcdroast_logo);	

		g_snprintf(tmp,MAXLINE,_("Version %s"),XCDROAST_VERSION);
		l1 = gtk_label_new(tmp);	
		gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_CENTER);
		set_font_and_color(l1,NULL,"red");
		gtk_box_pack_start(GTK_BOX(vbox),l1,FALSE,FALSE,0);
		gtk_widget_show(l1);
	}

	if (!manual) { 
		f1 = gtk_frame_new(NULL);
	} else {
		f1 = gtk_frame_new(_("Scanning for new devices"));
		set_font_and_color(f1,BOLDFONT,NULL);
	}
	gtk_box_pack_start(GTK_BOX(vbox),f1,TRUE,TRUE,0);
	gtk_container_set_border_width(GTK_CONTAINER (f1),5);
	gtk_widget_show(f1);


	vbox2 = gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width(GTK_CONTAINER (vbox2),5);

	if (!manual) {
		l1 = gtk_label_new(_("Scanning for devices"));
		set_font_and_color(l1,BOLDFONT,NULL);
		gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_CENTER);
		gtk_box_pack_start(GTK_BOX(vbox2),l1,FALSE,FALSE,0);
		gtk_widget_show(l1);
	}

	l1 = gtk_label_new(_("Scanning for CD/DVD-Writers and CD/DVD-Reading devices.\nOn some configurations this can take a while."));
	gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_CENTER);
	gtk_box_pack_start(GTK_BOX(vbox2),l1,FALSE,FALSE,10);
	gtk_widget_show(l1);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(vbox2),scrolled_win,TRUE,TRUE,5);
	gtk_widget_show(scrolled_win);

	txt = gtk_text_new(NULL,NULL);
	gtk_text_set_editable(GTK_TEXT(txt),FALSE);
	gtk_text_set_word_wrap(GTK_TEXT(txt),FALSE);
	gtk_container_add(GTK_CONTAINER(scrolled_win), txt);
	gtk_widget_show(txt);

	sep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox2),sep,FALSE,FALSE,5);
	gtk_widget_show(sep);

	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox2),hbox,FALSE,TRUE,5);
	gtk_widget_show(hbox);

	b1 = gtk_button_new_with_label(T_OK);
	gtk_signal_connect (GTK_OBJECT (b1), "clicked",
                GTK_SIGNAL_FUNC(nrs_dialog_btn_press), GINT_TO_POINTER(0));
	gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,5);
	gtk_widget_set_sensitive(b1, FALSE);
	gtk_widget_show(b1);


	gtk_container_add(GTK_CONTAINER(f1),vbox2);
	gtk_widget_show(vbox2);

	cursor = NULL;
	cursor2 = NULL;
        /* grab cursor and change to watch */
        if (GTK_WIDGET_MAPPED(toplevel)) {
                gtk_grab_add(dialog);

                cursor = gdk_cursor_new(GDK_WATCH);
                gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
        }

	/* also set watch cursor on scan window itself */
        if (1) {
                cursor2 = gdk_cursor_new(GDK_WATCH);
                gdk_window_set_cursor(GTK_WIDGET(dialog)->window,cursor2);
        }

        /* only center window when toplevel visible */
        if ( GTK_WIDGET_VISIBLE(toplevel)) {
                gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
                gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);                gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);                gtk_widget_size_request(dialog,&rq);
                gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
        } else {
                /* otherwise center in screen */
                gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
                xsize = gdk_screen_width();
                ysize = gdk_screen_height();
                gtk_widget_size_request(dialog,&rq);
                gtk_widget_set_uposition(GTK_WIDGET(dialog),xsize/2-rq.width/2,ysize/2-rq.height/2);

        }
	gtk_widget_show(dialog);

	/* fill textbox  and do the actual scanning */
	if (!manual) {
		scanbus_new(txt, scanparam);
	} else {
		/* the syntax used to scan for REMOTE scsi devices */
		if (strncmp(devicestr,"REMOTE:", 7) == 0 && 
			strstr(devicestr+7, ":") == 0) {
			scanbus_rscsi(devicestr, txt);	
		} else {
			scanbus_new_single(devicestr, txt);
		}
	}

	/* unlock ok button */
	gtk_widget_set_sensitive(b1, TRUE);

        if (1) {
                gdk_window_set_cursor(GTK_WIDGET(dialog)->window,NULL);
                if (cursor2) gdk_cursor_destroy (cursor2);
        }

        /* now wait until button is pressed */
        while (nrs_dialog_done == 999) {
                wait_and_process_events();
        }

        if (GTK_WIDGET_MAPPED(toplevel)) {
                gtk_grab_remove(GTK_WIDGET(dialog));
                gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,NULL);
                if (cursor) gdk_cursor_destroy (cursor);
        }

        /* remove dialog window */
        gtk_widget_destroy(dialog);
        wait_and_process_events();


	return (nrs_dialog_done);
}


/* small dialog to ask whether to disable the diskautomount daemon */
/* osX only */

static gint show_autodiskmount_handler() {
GtkWidget *dialog, *l1, *f1, *vbox, *xcdroast_logo;
GtkWidget *vbox2, *b1;
GdkPixbuf *im, *im2;
GdkPixmap *p;
GdkBitmap *m;
gchar tmp[MAXLINE];
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor;
GtkRequisition rq;

	/* if another dialog is running, ignore */
	if (nrs_dialog_done == 999) {
		return -1;
	}

	dodebug(8, "displaying create_autodiskmount_handler\n");

	/* mark our dialog as running */
	nrs_dialog_done = 999;

	dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	nrs_dialog = dialog;
	set_xcdr_title(dialog, NULL, -1);
	gtk_window_set_policy(GTK_WINDOW(dialog), FALSE, TRUE, FALSE);
	/* gtk_widget_set_usize(dialog,tbf(400),0); */
	gtk_widget_realize(dialog);

	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (nrs_dialog_delete_event), (gpointer) dialog);

	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(dialog),vbox);
	gtk_widget_show(vbox);

	/* load the half scaled logo */
	g_snprintf(tmp,MAXLINE,"%s/%s", sharedir, XCDRLOGO);
	im=gdk_pixbuf_new_from_file(tmp);
	if (im) {
		im2 = gdk_pixbuf_scale_simple(im, 
			gdk_pixbuf_get_width(im)/2, 
			gdk_pixbuf_get_height(im)/2, 
			GDK_INTERP_TILES);
		gdk_pixbuf_render_pixmap_and_mask(im2, &p, &m, 128);
       	 	xcdroast_logo = gtk_pixmap_new(p,m);
		gdk_pixbuf_unref(im);
		gdk_pixbuf_unref(im2);
	} else {
		xcdroast_logo = gtk_label_new("[LOGO]");
	}
	gtk_box_pack_start(GTK_BOX(vbox),xcdroast_logo,FALSE,FALSE,0);
	gtk_widget_show(xcdroast_logo);	

	g_snprintf(tmp,MAXLINE,_("Version %s"),XCDROAST_VERSION);
	l1 = gtk_label_new(tmp);	
	gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_CENTER);
	set_font_and_color(l1,NULL,"red");
	gtk_box_pack_start(GTK_BOX(vbox),l1,FALSE,FALSE,0);
	gtk_widget_show(l1);

	f1 = gtk_frame_new(NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,TRUE,TRUE,0);
	gtk_container_set_border_width(GTK_CONTAINER (f1),5);
	gtk_widget_show(f1);


	vbox2 = gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width(GTK_CONTAINER (vbox2),5);
	gtk_container_add(GTK_CONTAINER(f1),vbox2);
	gtk_widget_show(vbox2);

	l1 = gtk_label_new(_("Mac OS X preparations"));
	set_font_and_color(l1,BOLDFONT,NULL);
	gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_CENTER);
	gtk_box_pack_start(GTK_BOX(vbox2),l1,FALSE,FALSE,0);
	gtk_widget_show(l1);

	l1 = gtk_label_new(_("In order to allow X-CD-Roast access to your CD-Writing-Devices\nyou have to stop the finder from automatically mounting CDs to\nyour desktop by disabling the autodiskmount-daemon. If you\ndon't do that you will not be able to use your writer."));
	gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_CENTER);
	gtk_box_pack_start(GTK_BOX(vbox2),l1,FALSE,FALSE,10);
	gtk_widget_show(l1);


	b1 = gtk_button_new_with_label(_("Stop the autodiskmount-daemon now and continue"));
	gtk_signal_connect (GTK_OBJECT (b1), "clicked",
                GTK_SIGNAL_FUNC(nrs_dialog_btn_press), GINT_TO_POINTER(0));
	gtk_box_pack_start(GTK_BOX(vbox2),b1,TRUE,TRUE,15);
	GTK_WIDGET_SET_FLAGS (b1, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (b1);
	gtk_widget_show(b1);

	b1 = gtk_button_new_with_label(_("Ignore the daemon and start X-CD-Roast anyway"));
	gtk_signal_connect (GTK_OBJECT (b1), "clicked",
                GTK_SIGNAL_FUNC(nrs_dialog_btn_press), GINT_TO_POINTER(1));
	gtk_box_pack_start(GTK_BOX(vbox2),b1,TRUE,TRUE,5);
	gtk_widget_show(b1);

	b1 = gtk_button_new_with_label(_("Restart the autodiskmount-daemon and quit X-CD-Roast"));
	gtk_signal_connect (GTK_OBJECT (b1), "clicked",
                GTK_SIGNAL_FUNC(nrs_dialog_btn_press), GINT_TO_POINTER(2));
	gtk_box_pack_start(GTK_BOX(vbox2),b1,TRUE,TRUE,5);
	gtk_widget_show(b1);

	b1 = gtk_button_new_with_label(_("Exit X-CD-Roast"));
	gtk_signal_connect (GTK_OBJECT (b1), "clicked",
                GTK_SIGNAL_FUNC(nrs_dialog_btn_press), GINT_TO_POINTER(-1));
	gtk_box_pack_start(GTK_BOX(vbox2),b1,TRUE,TRUE,5);
	gtk_widget_show(b1);


	cursor = NULL;
        /* grab cursor and change to watch */
        if (GTK_WIDGET_MAPPED(toplevel)) {
                gtk_grab_add(dialog);
                cursor = gdk_cursor_new(GDK_WATCH);
                gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
        }


        /* only center window when toplevel visible */
        if ( GTK_WIDGET_VISIBLE(toplevel)) {
                gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
                gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);                gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);                gtk_widget_size_request(dialog,&rq);
                gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
        } else {
                /* otherwise center in screen */
                gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
                xsize = gdk_screen_width();
                ysize = gdk_screen_height();
                gtk_widget_size_request(dialog,&rq);
                gtk_widget_set_uposition(GTK_WIDGET(dialog),xsize/2-rq.width/2,ysize/2-rq.height/2);

        }
	gtk_widget_show(dialog);

        /* now wait until button is pressed */
        while (nrs_dialog_done == 999) {
                wait_and_process_events();
        }

        if (GTK_WIDGET_MAPPED(toplevel)) {
                gtk_grab_remove(GTK_WIDGET(dialog));
                gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,NULL);
                if (cursor) gdk_cursor_destroy (cursor);
        }

        /* remove dialog window */
        gtk_widget_destroy(dialog);

	return (nrs_dialog_done);
}


/* prompt for sudo password */
/* mode = 0, for stopping daemon, mode = 1 for restarting */

static gint prompt_autodiskmount_sudo_password(gint mode, gchar *str) {
GtkWidget *dialog, *l1, *f1, *vbox;
GtkWidget *vbox2, *e1, *box2, *hbox2, *b1;
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor;
GtkRequisition rq;

	/* if another dialog is running, ignore */
	if (nrs_dialog_done == 999) {
		return -1;
	}

	dodebug(8, "displaying prompt_autodiskmount_sudo_password\n");

	/* mark our dialog as running */
	nrs_dialog_done = 999;

	dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	nrs_dialog = dialog;
	set_xcdr_title(dialog, NULL, -1);
	gtk_window_set_policy(GTK_WINDOW(dialog), FALSE, TRUE, FALSE);
	/* gtk_widget_set_usize(dialog,tbf(400),0); */
	gtk_widget_realize(dialog);

	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (nrs_dialog_delete_event), (gpointer) dialog);

	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(dialog),vbox);
	gtk_widget_show(vbox);

	if (mode == 0) {
		f1 = gtk_frame_new(_("Stop the autodiskmount-daemon"));
	} else {
		f1 = gtk_frame_new(_("Restart the autodiskmount-daemon"));
	}
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,TRUE,TRUE,0);
	gtk_container_set_border_width(GTK_CONTAINER (f1),5);
	gtk_widget_show(f1);


	vbox2 = gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width(GTK_CONTAINER (vbox2),5);
	gtk_container_add(GTK_CONTAINER(f1),vbox2);
	gtk_widget_show(vbox2);



	if (mode == 0) {
		l1 = gtk_label_new(_("If you are a Mac OS X admin user please enter your password.\n It will be used with \"sudo\" to stop the autodiskmount-daemon."));
	} else {
		l1 = gtk_label_new(_("If you are a Mac OS X admin user please enter your password.\n It will be used with \"sudo\" to restart the autodiskmount-daemon\nand X-CD-Roast will exit."));
	}
	gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_CENTER);
	gtk_box_pack_start(GTK_BOX(vbox2),l1,FALSE,FALSE,10);
	gtk_widget_show(l1);

	if (mode == 0) {
		l1 = gtk_label_new(_("Be sure to have all media removed from your drives\nbefore continuing!"));
		set_font_and_color(l1,BOLDFONT,NULL);
		gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_CENTER);
		gtk_box_pack_start(GTK_BOX(vbox2),l1,FALSE,FALSE,5);
		gtk_widget_show(l1);
	}

        hbox2 = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox2),hbox2,FALSE,FALSE,10);
	gtk_widget_show(hbox2);

	l1 = gtk_label_new(_("Your login password:"));
	gtk_box_pack_start(GTK_BOX(hbox2),l1,FALSE,FALSE,10);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
        gtk_signal_connect(GTK_OBJECT(e1), "activate",
                GTK_SIGNAL_FUNC(nrs_dialog_btn_press), GINT_TO_POINTER(0));
	gtk_box_pack_start(GTK_BOX(hbox2),e1,TRUE,TRUE,10);
	gtk_entry_set_visibility(GTK_ENTRY(e1), FALSE);
	gtk_widget_show(e1);

	/* preselect the entry widget to save us a click */
	gtk_widget_grab_focus(e1);

        box2 = gtk_hbox_new(FALSE,0);
        gtk_box_pack_start(GTK_BOX(vbox),box2,FALSE,TRUE,10);
        gtk_widget_show(box2);

	b1 = gtk_button_new_with_label(T_OK);
	gtk_signal_connect (GTK_OBJECT (b1), "clicked",
                GTK_SIGNAL_FUNC(nrs_dialog_btn_press), GINT_TO_POINTER(0));
	gtk_box_pack_start(GTK_BOX(box2),b1,TRUE,TRUE,10);
	GTK_WIDGET_SET_FLAGS (b1, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (b1);
	gtk_widget_show(b1);

	b1 = gtk_button_new_with_label(T_CANCEL);
	gtk_signal_connect (GTK_OBJECT (b1), "clicked",
                GTK_SIGNAL_FUNC(nrs_dialog_btn_press), GINT_TO_POINTER(-1));
	gtk_box_pack_start(GTK_BOX(box2),b1,TRUE,TRUE,10);
	GTK_WIDGET_SET_FLAGS (b1, GTK_CAN_DEFAULT);
	gtk_widget_show(b1);

	cursor = NULL;
        /* grab cursor and change to watch */
        if (GTK_WIDGET_MAPPED(toplevel)) {
                gtk_grab_add(dialog);
                cursor = gdk_cursor_new(GDK_WATCH);
                gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
        }


        /* only center window when toplevel visible */
        if ( GTK_WIDGET_VISIBLE(toplevel)) {
                gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
                gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);                gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);                gtk_widget_size_request(dialog,&rq);
                gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
        } else {
                /* otherwise center in screen */
                gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
                xsize = gdk_screen_width();
                ysize = gdk_screen_height();
                gtk_widget_size_request(dialog,&rq);
                gtk_widget_set_uposition(GTK_WIDGET(dialog),xsize/2-rq.width/2,ysize/2-rq.height/2);

        }
	gtk_widget_show(dialog);

        /* now wait until button is pressed */
        while (nrs_dialog_done == 999) {
                wait_and_process_events();
        }

        if (GTK_WIDGET_MAPPED(toplevel)) {
                gtk_grab_remove(GTK_WIDGET(dialog));
                gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,NULL);
                if (cursor) gdk_cursor_destroy (cursor);
        }

	/* get entry contents */
	if (nrs_dialog_done == 0) {
		strncpy(str,gtk_entry_get_text(GTK_ENTRY(e1)),MAXLINE);
	} else {
		strcpy(str,"");
	}	

        /* remove dialog window */
        gtk_widget_destroy(dialog);

	return (nrs_dialog_done);
}


/* send stop or cont signal to autodiskmount daemon */
/* mode = 0: stop, mode = 1: cont */

static gint stop_cont_autodiskmount(gint mode) {
gint pid, stat;
gchar tmp[MAXLINE];

	pid = get_autodiskmount_pid();
	stat = 1;

	if (pid > 0) {
		if (mode == 0) {
			g_snprintf(tmp,MAXLINE,"/bin/kill -STOP %d 2>/dev/null", pid);
		} else {
			g_snprintf(tmp,MAXLINE,"/bin/kill -CONT %d 2>/dev/null", pid);
		}
		stat = run_sudo_command(tmp);	
	}

	return stat;
}	

static void show_stop_autodiskmount() {
gint stat;

	/* never a passwort set? dont even try then */
	if (!curset.sudo_passwd) 
		return;

	stat = stop_cont_autodiskmount(0);	
	if (stat != 0) {

		show_dialog(ICO_ERROR,_("Failed to stop the autodiskmount-daemon.\nX-CD-Roast might not perform correctly."), T_OK, NULL, NULL, 0);

		/* ok, our password did not work anyway? */
		/* forget the given password */
		g_free(curset.sudo_passwd);
		curset.sudo_passwd = NULL;
	}	
}

void show_restart_autodiskmount(gint textonly) {
gint stat;
gchar tmp[MAXLINE];

	/* never a passwort set? dont even try then */
	if (!curset.sudo_passwd) 
		return;

	stat = stop_cont_autodiskmount(1);	
	if (stat != 0) {

		strncpy(tmp, _("Failed to restart the autodiskmount-daemon.\nYou might run into trouble with the finder now."), MAXLINE);
		if (!textonly) {
			show_dialog(ICO_ERROR,tmp, T_OK, NULL, NULL, 0);
		} else {
			g_warning(tmp);
		}
	}	
}


/* show user through the osX startup stuff */

gint create_autodiskmount_handler() {
gint stat;
gchar tmp[MAXLINE];

	/* what to do at first? */
	stat = show_autodiskmount_handler();

	switch(stat) {
		case 0: 
			/* stop daemon */
			if (prompt_autodiskmount_sudo_password(0, tmp) == 0) {
				curset.sudo_passwd = g_strdup(tmp);
				show_stop_autodiskmount();
			} else {
				/* cancel pressed */
				return -1;
			}
			break;

		case 1:
			/* ignore and startup */
			break;
	
		case 2:
			/* restart damon and exit */
			if (prompt_autodiskmount_sudo_password(1, tmp) == 0) {
				curset.sudo_passwd = g_strdup(tmp);
				show_restart_autodiskmount(0);

				/* exit xcdroast */
				return 0;
			} else {
				/* cancel pressed */
				return -1;
			}
			break;

		default:
			/* exit xcdroast */
			return 0;
	}

	return 1;
}

