/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Pan - A Newsreader for Gtk+
 * Copyright (C) 2002  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __UTIL_WRAP__H__
#define __UTIL_WRAP__H__

/**
 * Run the specified text through a rot13 filter.
 * @param text
 */
char * pan_text_rot13_inplace     (char         * text);

/**
 * Strip out quoted text, replacing it with "> [Quoted text muted]".
 * @param text
 */
char * pan_text_mute_quoted       (const char   * text);

/**
 * Wraps/fills the specified text to the specified column number.
 * @param text
 * @param wrap_column
 */
char * pan_text_fill              (const char   * text,
                                   int            wrap_column);

#endif /* __UTIL_WRAP__H__ */
