/*
 * battery.cpp
 *
 * Copyright (c) 1999 Paul Campbell <paul@taniwha.com>
 * Copyright (c) 2002 Marc Mutz <mutz@kde.org>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// my headers:
#include "battery.h"
#include "version.h"
#include "portable.h"

// other KDE headers:
#include <klocale.h>
#include <kconfig.h>
#include <knuminput.h>
#include <kiconloader.h>
#include <kicondialog.h>
#include <kapplication.h>

// other Qt headers:
#include <qlayout.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qhbox.h>
#include <qvgroupbox.h>
#include <qgrid.h>


BatteryConfig::BatteryConfig (QWidget * parent, const char *name)
  : KCModule(parent, name),
    editPoll(0),
    iconloader(0),
    buttonNoBattery(0),
    buttonNoCharge(0),
    buttonCharge(0)
{
    apm = laptop_portable::has_power_management();
    config =  new KConfig("kcmlaptoprc");

    QVBoxLayout *top_layout = new QVBoxLayout( this, KDialog::marginHint(),
					       KDialog::spacingHint() );

    // do we show the monitor
    runMonitor = new QCheckBox( i18n("&Show battery monitor"), this );
    top_layout->addWidget( runMonitor );
    connect( runMonitor, SIGNAL(clicked()), this, SLOT(configChanged()) );

    if (!apm) {
      top_layout->addWidget( laptop_portable::no_power_management_explanation(this) );
    } else {
      iconloader = new KIconLoader("klaptopdaemon");

      // the poll time (in seconds)
      QHBox *hb = new QHBox( this );
      hb->setSpacing( KDialog::spacingHint() );
      top_layout->addWidget( hb );

      QLabel* poll_label = new QLabel( i18n("&Check status every:"), hb );
      editPoll = new QSpinBox( 1, 3600, 1, hb ); // min,max,step
      editPoll->setSuffix( i18n("keep short, unit in spinbox", "sec") );
      poll_label->setBuddy( editPoll );
      connect( editPoll, SIGNAL(valueChanged(int)),
	       this, SLOT(configChanged()) );
      QWidget* spacer = new QWidget( hb );
      hb->setStretchFactor( spacer, 1 );

      // group box to hold the icons together
      QVGroupBox* icons_groupbox = new QVGroupBox( i18n("Icons"), this );
      icons_groupbox->layout()->setSpacing( KDialog::spacingHint() );
      top_layout->addWidget( icons_groupbox, 0, Qt::AlignLeft );

      // layout to hold the icons inside the groupbox
      QGrid *icon_grid = new QGrid( 3 /*cols*/, icons_groupbox );
      icon_grid->setSpacing( KDialog::spacingHint() );

      buttonNoBattery = new KIconButton( iconloader, icon_grid );
      buttonNoCharge  = new KIconButton( iconloader, icon_grid );
      buttonCharge    = new KIconButton( iconloader, icon_grid );
      (void)new QLabel( buttonNoBattery, i18n("No &battery"), icon_grid);
      (void)new QLabel( buttonNoCharge, i18n("&Not charging"), icon_grid);
      (void)new QLabel( buttonCharge, i18n("Char&ging"), icon_grid);
      buttonNoBattery->setIconType( KIcon::NoGroup, KIcon::Any );
      buttonNoCharge->setIconType( KIcon::NoGroup, KIcon::Any );
      buttonCharge->setIconType( KIcon::NoGroup, KIcon::Any );

      QLabel* explain = new QLabel( i18n("This panel controls whether the battery status\nmonitor appears in the dock and what it looks like."), this);
      top_layout->addWidget(explain, 0);
      laptop_portable::extra_config(this, config, top_layout);
    }

    top_layout->addStretch(1);
    top_layout->addWidget( new QLabel( i18n("Version: %1").arg(LAPTOP_VERSION), this), 0, Qt::AlignRight );


    load();
}

BatteryConfig::~BatteryConfig()
{
  delete config;
}


void BatteryConfig::save()
{
        enablemonitor = runMonitor->isChecked();

        if (apm) {
                poll_time = editPoll->value();
                nobattery =  buttonNoBattery->icon();
                chargebattery =  buttonCharge->icon();
                nochargebattery =  buttonNoCharge->icon();
        }
        config->setGroup("BatteryDefault");

        config->writeEntry("Enable", enablemonitor);
        config->writeEntry("Poll", poll_time);
        config->writeEntry("NoBatteryPixmap", nobattery);
        config->writeEntry("ChargePixmap", chargebattery);
        config->writeEntry("NoChargePixmap", nochargebattery);
	config->sync();
        changed(false);
        kapp->startServiceByDesktopName("klaptopdaemon");
}

void BatteryConfig::load()
{
       	config->setGroup("BatteryDefault");

        poll_time = config->readNumEntry("Poll", 20);
        enablemonitor = config->readBoolEntry("Enable", true);

        nobattery = config->readEntry("NoBatteryPixmap", "laptop_nobattery");
        nochargebattery = config->readEntry("NoChargePixmap", "laptop_nocharge");
        chargebattery = config->readEntry("ChargePixmap", "laptop_charge");

        runMonitor->setChecked(enablemonitor);
        if (apm) {
                editPoll->setValue(poll_time);
                buttonNoCharge->setIcon(nochargebattery);
                //buttonNoCharge->setPixmap(kapp->iconLoader()->loadIcon(nochargebattery));
                buttonCharge->setIcon(chargebattery);
		//buttonCharge->setPixmap(kapp->iconLoader()->loadIcon(chargebattery));
	        buttonNoBattery->setIcon(nobattery);
                //buttonNoBattery->setPixmap(kapp->iconLoader()->loadIcon(nobattery));
        }
        changed(false);
}

void BatteryConfig::defaults()
{
        poll_time = 20;
        enablemonitor = true;

        nobattery = "laptop_nobattery";
        nochargebattery = "laptop_nocharge";
        chargebattery = "laptop_charge";

        runMonitor->setChecked(enablemonitor);
        if (apm) {
                editPoll->setValue(poll_time);
                buttonNoCharge->setIcon(nochargebattery);
                //buttonNoCharge->setPixmap(kapp->iconLoader()->loadIcon(nochargebattery));
                buttonCharge->setIcon(chargebattery);
                //buttonCharge->setPixmap(kapp->iconLoader()->loadIcon(chargebattery));
                buttonNoBattery->setIcon(nobattery);
                //buttonNoBattery->setPixmap(kapp->iconLoader()->loadIcon(nobattery));
        }
        changed(false);
}


void BatteryConfig::configChanged()
{
  emit changed(true);
}


QString BatteryConfig::quickHelp() const
{
  return i18n("<h1>Battery Monitor</h1>This module allows you to monitor "
	"your batteries. To make use of this module, you must have APM "
	"installed. (And, of course, you should have batteries in your "
	"machine.)");
}


#include "battery.moc"


