/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */


#include <klocale.h>
#include <kinstance.h>
#include <kaboutdata.h>
#include <kdebug.h>

#include "pc_factory.h"
#include "pocompendium.h"


extern "C"
{
	void *init_libpocompendium()
	{
		return new PcFactory;
	}
};


KInstance *PcFactory::s_instance = 0;
KAboutData *PcFactory::s_about = 0;


PcFactory::PcFactory( QObject *parent, const char *name)
		: KLibFactory(parent,name)
{
}

PcFactory::~PcFactory()
{
	if(s_instance)
	{
		delete s_instance;
		s_instance=0;
	}

	if(s_about)
	{
		delete s_about;
		s_about=0;
	}
}


QObject *PcFactory::createObject( QObject *parent, const char *name
				, const char *classname, const QStringList &)
{
	if(QCString(classname) != "SearchEngine")
	{
		kdError() << "not a SearchEngine requested" << endl;
		return 0;
	}
	
	return new PoCompendium(parent,name);
}


KInstance *PcFactory::instance()
{
	if(!s_instance)
	{
		s_about = new KAboutData( "pocompendium", I18N_NOOP("PO Compendium")
						, "1.0"
						, I18N_NOOP("A module for searching in a PO file")
						, KAboutData::License_GPL
						, "Copyright 2000-2001, Matthias Kiefer"
						,0,0, "kiefer@kde.org");

		s_about->addAuthor("Matthias Kiefer",0,"kiefer@kde.org");
		
		s_instance = new KInstance(s_about);
	}

	return s_instance;
}

#include "pc_factory.moc"
