// tsfbuffer.h
//
// Kit AIM client
//
// For copyright and license, see accompanying documentation

#ifndef TSFBUFFER_H
#define TSFBUFFER_H

#if !defined(__osf__)
extern "C"
{
#include <inttypes.h>
}
#else
typedef unsigned short uint16_t;
typedef unsigned int uint32_t;
#endif

// framing for SFLAP connections

#define SFLAP_DATA_SIZE 8192

typedef struct sflap_frame
{
	unsigned char asterisk;
	unsigned char type;
	uint16_t sequence;
	uint16_t data_length;
	char data[SFLAP_DATA_SIZE];
};

#define SFLAP_SIGNON 1
#define SFLAP_DATA 2
#define SFLAP_KEEP_ALIVE 5

#define SFLAP_HEADERSIZE 6

// *******************
// * class TSFBuffer *
// *******************

// sflap_frame buffer entry
typedef struct sfb_entry
{
	sfb_entry *prev;
	sfb_entry *next;
	sflap_frame frame;
};

class TSFBuffer
{
	public:
		TSFBuffer();
		~TSFBuffer();
		
		void writeFrame(sflap_frame &);
		int readFrame(sflap_frame &);

		void clear(void);
	private:
		sfb_entry *head;
		sfb_entry *tail;

		unsigned short firstInSequence;
		int receivedFrame;
};

#endif
