/*
 * Decompiled with CFR 0.152.
 */
package org.kde.kjas.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.kde.kjas.server.KJASBrokenClassFixer;
import org.kde.kjas.server.Main;
import org.kde.kjas.server.StatusListener;

public final class KJASAppletClassLoader
extends URLClassLoader {
    private static Hashtable loaders = new Hashtable();
    private URL docBaseURL;
    private URL codeBaseURL;
    private Vector archives;
    private String dbgID;
    private static int globalId = 0;
    private int myId = 0;
    private Vector statusListeners = new Vector();
    private AccessControlContext acc;
    private Hashtable loadedClasses = new Hashtable();
    static /* synthetic */ Class class$org$kde$kjas$server$KJASAppletClassLoader;

    public static synchronized KJASAppletClassLoader getLoader(String string, String string2) {
        KJASAppletClassLoader kJASAppletClassLoader;
        block4: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkCreateClassLoader();
            }
            kJASAppletClassLoader = null;
            try {
                URL uRL = new URL(string);
                URL uRL2 = KJASAppletClassLoader.getCodeBaseURL(uRL, string2);
                Main.debug("CL: getLoader: key = " + uRL2);
                kJASAppletClassLoader = (KJASAppletClassLoader)loaders.get(uRL2.toString());
                if (kJASAppletClassLoader == null) {
                    URL[] uRLArray = new URL[]{};
                    kJASAppletClassLoader = new KJASAppletClassLoader(uRLArray, uRL, uRL2);
                    loaders.put(uRL2.toString(), kJASAppletClassLoader);
                    break block4;
                }
                Main.debug("CL: reusing classloader");
            }
            catch (MalformedURLException malformedURLException) {
                Main.kjas_err("bad DocBase URL", malformedURLException);
            }
        }
        return kJASAppletClassLoader;
    }

    public static URL getCodeBaseURL(URL uRL, String string) {
        URL uRL2;
        block10: {
            uRL2 = null;
            try {
                if (string != null) {
                    if (!string.endsWith("/")) {
                        string = string + "/";
                    }
                    try {
                        uRL2 = new URL(string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        try {
                            uRL2 = new URL(uRL, string);
                        }
                        catch (MalformedURLException malformedURLException2) {
                            // empty catch block
                        }
                    }
                }
                if (uRL2 != null) break block10;
                String string2 = uRL.getFile();
                if (string2 == null || string2.length() == 0) {
                    uRL2 = uRL;
                    break block10;
                }
                if (string2.endsWith("/")) {
                    uRL2 = uRL;
                    break block10;
                }
                String string3 = uRL.toString();
                int n = string3.lastIndexOf(47);
                String string4 = string3.substring(0, n + 1);
                uRL2 = new URL(string4);
            }
            catch (Exception exception) {
                Main.kjas_err("CL: exception ", exception);
            }
        }
        return uRL2;
    }

    public static KJASAppletClassLoader getLoader(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        if (loaders.containsKey(string)) {
            return (KJASAppletClassLoader)loaders.get(string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KJASAppletClassLoader(URL[] uRLArray, URL uRL, URL uRL2) {
        super(uRLArray);
        this.acc = AccessController.getContext();
        Class clazz = class$org$kde$kjas$server$KJASAppletClassLoader == null ? (class$org$kde$kjas$server$KJASAppletClassLoader = KJASAppletClassLoader.class$("org.kde.kjas.server.KJASAppletClassLoader")) : class$org$kde$kjas$server$KJASAppletClassLoader;
        synchronized (clazz) {
            this.myId = ++globalId;
        }
        this.docBaseURL = uRL;
        this.codeBaseURL = uRL2;
        this.archives = new Vector();
        this.dbgID = "CL-" + this.myId + "(" + this.codeBaseURL.toString() + "): ";
    }

    protected void addURL(URL uRL) {
        Main.debug(this + " add URL: " + uRL);
        super.addURL(uRL);
    }

    public void addStatusListener(StatusListener statusListener) {
        this.statusListeners.add(statusListener);
    }

    public void removeStatusListener(StatusListener statusListener) {
        this.statusListeners.remove(statusListener);
    }

    public void showStatus(String string) {
        Enumeration enumeration = this.statusListeners.elements();
        while (enumeration.hasMoreElements()) {
            StatusListener statusListener = (StatusListener)enumeration.nextElement();
            statusListener.showStatus(string);
        }
    }

    public void paramsDone() {
        String string;
        int n = 0;
        while (n < this.archives.size()) {
            string = (String)this.archives.elementAt(n);
            try {
                URL uRL = new URL(this.codeBaseURL, string);
                this.addURL(uRL);
                Main.debug("added archive URL \"" + uRL + "\" to KJASAppletClassLoader");
            }
            catch (MalformedURLException malformedURLException) {
                Main.kjas_err("Could not construct URL for jar file: " + this.codeBaseURL + " + " + string, malformedURLException);
            }
            ++n;
        }
        this.addURL(this.codeBaseURL);
        string = this.docBaseURL.toString();
        int n2 = string.lastIndexOf("/");
        if (n2 > 0) {
            string = string.substring(0, n2 + 1);
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            Main.debug("Could not make a new URL from docBaseURL=" + this.docBaseURL);
        }
        if (uRL != null && !this.codeBaseURL.equals(uRL)) {
            this.addURL(uRL);
        }
    }

    void addArchiveName(String string) {
        if (!this.archives.contains(string)) {
            this.archives.add(string);
        }
    }

    public URL getDocBase() {
        return this.docBaseURL;
    }

    public URL getCodeBase() {
        return this.codeBaseURL;
    }

    public synchronized Class findClass(String string) throws ClassNotFoundException {
        Class clazz;
        block6: {
            clazz = null;
            try {
                clazz = this.findSystemClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string2 = string;
                int n = string.indexOf(36);
                if (n > 0) {
                    string2 = string.substring(0, n);
                }
                this.showStatus("Loading Class: " + string2 + "...");
                clazz = this.findLoadedClass(string);
                if (clazz != null) break block6;
                try {
                    clazz = super.findClass(string);
                }
                catch (ClassFormatError classFormatError) {
                    Main.debug(string + ": Catched " + classFormatError + ". Trying to repair...");
                    clazz = this.loadFixedClass(string);
                }
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Class:" + string);
        }
        return clazz;
    }

    public synchronized Class loadClass(String string) throws ClassNotFoundException {
        Main.debug(this.dbgID + "loadClass, class name = " + string);
        String string2 = string;
        Object v = this.loadedClasses.get(string2);
        if (v != null) {
            Main.debug("already loaded: " + v);
            return (Class)v;
        }
        Class clazz = this.findClass(string2);
        Main.debug(this.dbgID + " returns class " + clazz.getName() + " Classloader=" + clazz.getClassLoader());
        return clazz;
    }

    private final synchronized Class loadFixedClass(String string) throws ClassNotFoundException {
        String string2 = string.replace('.', '/') + ".class";
        try {
            int n;
            final URL uRL = this.getResource(string2);
            Main.debug(this.dbgID + string + ": got URL: " + uRL);
            if (uRL == null) {
                throw new ClassNotFoundException(string2 + ": invalid resource URL.");
            }
            Certificate[] certificateArray = new Certificate[]{};
            CodeSource codeSource = new CodeSource(uRL, certificateArray);
            InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return uRL.openStream();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        return null;
                    }
                }
            }, this.acc);
            if (inputStream == null) {
                throw new ClassNotFoundException(string + ": could not be loaded.");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = 0;
            int n3 = 1024;
            byte[] byArray = new byte[n3];
            while ((n = inputStream.read(byArray, 0, n3)) > 0) {
                n2 += n;
                byteArrayOutputStream.write(byArray, 0, n);
            }
            Main.debug(this.dbgID + string + ": " + n2 + " bytes");
            Class clazz = this.fixAndDefineClass(string, byteArrayOutputStream.toByteArray(), 0, n2, codeSource);
            if (clazz != null) {
                this.loadedClasses.put(string, clazz);
            }
            return clazz;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new ClassNotFoundException("triggered by " + throwable);
        }
    }

    public URL findResource(String string) {
        URL uRL;
        Main.debug(this.dbgID + "findResource, name = " + string);
        String string2 = string;
        try {
            uRL = new URL(string);
            String string3 = uRL.getFile();
            if (string3 != null && string3.length() > 0) {
                string2 = string3;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.showStatus("Loading: " + string2);
        uRL = super.findResource(string);
        Main.debug("findResource for " + string + " returns " + uRL);
        return uRL;
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Main.debug(this.dbgID + " getPermissions(" + codeSource + ")");
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        Enumeration<Permission> enumeration = permissionCollection.elements();
        while (enumeration.hasMoreElements()) {
            Main.debug(this + " Permission: " + enumeration.nextElement());
        }
        return permissionCollection;
    }

    private final Class fixAndDefineClass(String string, byte[] byArray, int n, int n2, CodeSource codeSource) throws ClassFormatError {
        KJASBrokenClassFixer kJASBrokenClassFixer = new KJASBrokenClassFixer();
        if (kJASBrokenClassFixer.process(byArray, n, n2)) {
            Main.debug(string + " fixed");
        } else {
            Main.info(string + " could not be fixed");
        }
        return this.defineClass(string, kJASBrokenClassFixer.getProcessedData(), kJASBrokenClassFixer.getProcessedDataOffset(), kJASBrokenClassFixer.getProcessedDataLength(), codeSource);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

