/***************************************************************************
                           card.cpp  -  description
                             -------------------
    begin                : Fri Feb 22 2002
    copyright            : (C) 2002 by Scott Wheeler
    email                : wheeler@kde.org
***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
***************************************************************************/

#include "card.h"

////////////////////////////////////////////////////////////////////////////////
// public members
////////////////////////////////////////////////////////////////////////////////

Card::Card()
{
  cardFront = QString::null;
  cardBack = QString::null;
  reversed = false;
}

Card::Card(const QString &front, const QString &back)
{
  cardFront = front;
  cardBack = back;
  reversed = false;
}

Card::~Card()
{

}

QString Card::front() const
{
  if(!reversed)
    return(cardFront);
  else
    return(cardBack);
}

QString Card::back() const
{
  if(!reversed)
    return(cardBack);
  else
    return(cardFront);
}

void Card::setFront(const QString &front)
{
  cardFront = front;
}

void Card::setBack(const QString &back)
{
  cardBack = back;
}

bool Card::frontBackReversed() const
{
  return(reversed);
}

void Card::setFrontBackReversed(bool reverse)
{
  reversed = reverse;
}
