 /***************************************************************************
                          kgeoModeHandling.cpp  -  description
                             -------------------
    begin                : Sun Oct 8 2000
    copyright            : (C) 2000 by Marc Bartsch
    email                : marc.bartsch@topmail.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kgeo.h"

void KGeoApp::disconnectAll()
{
	// Disconnect from all important slots.
	canvas->disconnect();
	bg->disconnect();
}

void KGeoApp::startKioskMode()
{
	startMoveMode();
	connect( canvas, SIGNAL( mouseRightPressEvent( Coordinates ) ), this, SLOT( slotMouseRightPressEvent( Coordinates ) ) );

	canvas->setIsKiosk( true );
	canvas->reparent( kiosk, 0, QPoint( 0, 0 ), true );
	canvas->setGeometry( 0, 0, kapp->desktop()->width(), kapp->desktop()->height() );

	MetricsCenter::intCanvasLeftTopX = 0;
	MetricsCenter::intCanvasLeftTopY = 0;

	canvas->paintWholeWidget();
  canvas->setMouseTracking( true );

	kiosk->raise();
	kiosk->show();
}

void KGeoApp::endKioskMode()
{
	disconnectAll();

	canvas->setIsKiosk( false );
	canvas->reparent( mainWidget->GeoContainer, 0,QPoint( 2, 2 ),true );
  GeoWidgetLayout->addWidget( canvas );

	setCentralWidget( mainWidget );
  canvas->setMouseTracking( true );
	kiosk->hide();
	canvas->setCentered( true );
	canvas->paintWholeWidget();

	startMoveMode();
}

void KGeoApp::startMoveMode ()
{
	disconnectAll();
	connect( canvas, SIGNAL( mouseMove( Coordinates ) ), this, SLOT( printCoordsInStatusline( Coordinates ) ) );
	connect( canvas, SIGNAL( mouseMove( Coordinates ) ), this, SLOT( changeMousePointer( Coordinates ) ) );
	connect( canvas, SIGNAL( mouseLeftPressEvent( Coordinates ) ), this, SLOT( selectPoint( Coordinates ) ) );
	connect( canvas, SIGNAL( loadDropFile( QString ) ), this, SLOT( loadDrawing( QString ) ) );
	connect( bg, 		 SIGNAL( clicked( int ) ), this, SLOT ( toolBar2Clicked( int ) ) );

	if ( canvas->getIsKiosk() == true )
	{
		connect( canvas, SIGNAL( mouseRightPressEvent( Coordinates ) ), this, SLOT( slotMouseRightPressEvent( Coordinates ) ) );
	}

	//	Set standard cursor for move mode
	standardCursor = arrowCursor;
	canvas->setCursor( standardCursor );

	//	Set drawing mode to move
	canvas->startMoveMode( false );
  drawingMode =  ID_drawingModeMovingObjects;

  bg->setButton( ID_buttonPointer );
	currentButtonID = ID_buttonPointer;

  statusBar()->changeItem( " " + i18n( "Move objects mode" ), 1 );

	if ( newObject != 0 )
	{
		delete newObject;
	}

	newObject = 0;
	currentObject = 0;
	moveList.clear();

}

void KGeoApp::startDragMode()
{
	disconnectAll();
	connect( canvas, SIGNAL( mouseMove( Coordinates ) ), this, SLOT( printCoordsInStatusline( Coordinates ) ) );
	connect( canvas, SIGNAL( mouseMoveLeftButton( Coordinates ) ), this, SLOT( movePoint( Coordinates ) ) );
	connect( canvas, SIGNAL( mouseLeftClickEvent( Coordinates ) ), this, SLOT( releaseMouse( Coordinates ) ) );
}

void KGeoApp::startConstructionMode( QString statusLine )
{
	disconnectAll();
	connect( canvas, SIGNAL( mouseMove( Coordinates ) ), this, SLOT( printCoordsInStatusline( Coordinates ) ) );
	connect( canvas, SIGNAL( mouseLeftClickEvent( Coordinates ) ), this, SLOT( insertObject( Coordinates ) ) );
	connect( canvas, SIGNAL( mouseMove( Coordinates ) ), this, SLOT( changeMousePointer( Coordinates ) ) );
	connect( bg, 		 SIGNAL( clicked( int ) ), this, SLOT ( toolBar2Clicked( int ) ) );

	canvas->setCursor( arrowCursor );
	canvas->startMoveMode( false );
  standardCursor = crossCursor;
  drawingMode = ID_drawingModeConstructing;

	statusBar()->changeItem( " " + statusLine, 1 );
}

void KGeoApp::startMoveGridMode()
{
	disconnectAll();
	canvas->startMoveMode( true );
	if ( kapp->config()->readBoolEntry( "DragMode", true ) )
	{
		connect( canvas, SIGNAL( mouseLeftClickEvent( Coordinates ) ), this, SLOT( startMoveMode() ) );
	}
	connect( bg, 		 SIGNAL( clicked( int ) ), this, SLOT ( toolBar2Clicked( int ) ) );
}
