/***************************************************************************
                          geomeasure.cpp  -  description
                             -------------------
    begin                : Thu Jul 26 2001
    copyright            : (C) 2001 by Marc Bartsch
    email                : marc.bartsch@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "geomeasure.h"

GeoMeasure::GeoMeasure() : GeoObjects()
{
  kapp->config()->setGroup( "Sizes" );
	width = kapp->config()->readNumEntry( "LineWidth", 1 );

  zOrder = 2;
	ID = ID_geoMeasure;
  identificator = "GeoMeasure";

	acceptsQPoint = true;
	acceptsQPointOnly = false;
	acceptsGeoPoint = false;
	canBeDestroyed = false;
	isMovable = true;

	surroundingRect = QRect( 0, 0, 50, 50 );
	textRect = QRect( 0, 0, 0, 0 );
	picRect  = QRect( 5, 5, 10, 10 );
	value = "";
}

GeoMeasure::~GeoMeasure()
{
}

void GeoMeasure::paint( QPainter *p )
{
	if ( initComplete )
	{
		value = value.stripWhiteSpace();
		value.append( " " );
		QRect tempTextRect = p->boundingRect ( textRect, Qt::AlignVCenter | Qt::AlignRight, value );
		if ( tempTextRect.width() + 30 > textRect.width() )
		{	
			QPoint center = textRect.center();
			textRect = tempTextRect;
			textRect.setWidth( tempTextRect.width() + 30 );
			textRect.setHeight( 22 );
			textRect.moveCenter( center );
		}

		p->setPen( QPen( Qt::black, 1, Qt::DotLine ) );
		p->drawLine( textRect.center(), anchorPoint );
		p->setPen( QPen( Qt::black, 1, Qt::SolidLine ) );
//		p->setBrush( QColor( 255, 255, 222 ) );
		p->setBrush( Qt::white );
		p->drawRect( textRect );
		p->drawText( textRect, Qt::AlignRight | Qt::AlignVCenter , value );
		QPoint pt = textRect.topLeft();
		pt.setX( textRect.left() + 2 );
		pt.setY( textRect.top() + 2 );
		p->drawPixmap( pt , pic, picRect );
		p->setPen( QPen( QColor( 197, 194, 197 ), 1, Qt::SolidLine ) );
		p->drawLine( textRect.topLeft(), textRect.topRight() );
		p->drawLine( textRect.topLeft(), textRect.bottomLeft() );
	}
}

bool GeoMeasure::contains( QPoint *pt )
{
	return textRect.contains( *pt );
}

void GeoMeasure::move()
{
}

void GeoMeasure::move( QPoint *pt )
{
	coords.set( *pt );
	coords += moveOffset;

	textRect.moveCenter( coords.getQPoint() );
	move();
}

void GeoMeasure::getObjectOverlay( QList <QRect> & list )
{
	//	Append textRect
	list.append( new QRect( textRect ) );

	//	Append line from textRect to measured object
	Coordinates coord1( textRect.center() );
	Coordinates coord2( anchorPoint );
	getLineOverlay( list, ID_overlayRectSize, coord1, coord2 );
}

void GeoMeasure::writeToFile( KSimpleConfig *config )
{
	config->writeEntry( "Geo", ID );
	config->writeEntry( "Color", getColor() );
	config->writeEntry( "Size", width );

	Coordinates coord1( textRect.center() );
	MetricsCenter::mapCanvasToGrid( coord1 );
	config->writeEntry( "TextRectCenterX",  coord1.getD_X() );
	config->writeEntry( "TextRectCenterY",  coord1.getD_Y() );
	config->writeEntry( "TextRectWidth", textRect.width() );
	config->writeEntry( "TextRectHeight", textRect.height() );
}

void GeoMeasure::readFromFile( KSimpleConfig *config )
{
	textRect = QRect( 0, 0, 0, 0 );
	color = config->readColorEntry( "Color" );

	int textX = config->readNumEntry( "TextRectWidth" );
	int textY = config->readNumEntry( "TextRectHeight" );
  textRect.setWidth( textX );
  textRect.setHeight( textY );

	QString strX, strY;
	strX = config->readEntry( "TextRectCenterX" );
	strY = config->readEntry( "TextRectCenterY" );
	double x = strX.toDouble();
	double y = strY.toDouble();
	Coordinates coord1( x, y );
  MetricsCenter::mapGridToCanvas( coord1 );
	textRect.moveCenter( coord1.getQPoint() );

	setSize( config->readNumEntry( "Size" ) );
	initComplete = true;
}
