// A Qt to C# binding generator.
//
// Copyright (C) 2002  Adam Treat (manyoso@yahoo.com)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

using System;
using System.Collections;

namespace QtCSharp {

	public class QTypeMap {

		Hashtable arraymap, mastermap, pinvoketypes, pinvokecalltypes, csharptypes, overloadtypes, reserved, interfaces;

		public QTypeMap ()
		{
			arraymap = new Hashtable ();
			arraymap.Add ("void*", "int[]");
			arraymap.Add ("void *", "int[]");
			arraymap.Add ("int*", "int[]");
			arraymap.Add ("int *", "int[]");
			arraymap.Add ("double*", "double[]");
			arraymap.Add ("double *", "double[]");
			arraymap.Add ("short*", "short[]");
			arraymap.Add ("short *", "short[]");
			arraymap.Add ("char**", "string[]");
			arraymap.Add ("char **", "string[]");
			arraymap.Add ("char*", "string");
			arraymap.Add ("uchar**", "string[]");
			arraymap.Add ("uchar **", "string[]");

			mastermap = new Hashtable ();
		//	mastermap.Add ("void", "int");
			mastermap.Add ("void", "void");
			mastermap.Add ("QByteArray", "byte[]");
			mastermap.Add ("QBitArray", "byte[]");
			mastermap.Add ("uchar", "string");
			mastermap.Add ("unsigned int", "uint");
			mastermap.Add ("unsigned short", "ushort");
			mastermap.Add ("unsigned long", "ulong");
			mastermap.Add ("unsigned char", "string");
			mastermap.Add ("HANDLE", "uint");
			mastermap.Add ("HBITMAP", "uint");
			mastermap.Add ("HCURSOR", "uint");
			mastermap.Add ("HDC", "uint");
			mastermap.Add ("HFONT", "uint");
			mastermap.Add ("HPALETTE", "uint");
			mastermap.Add ("HRGN", "uint");
			mastermap.Add ("Display", "IntPtr");
			mastermap.Add ("Q_REFCOUNT bool", "bool");
			mastermap.Add ("EventRef", "IntPtr");
			mastermap.Add ("MSG", "IntPtr");
			mastermap.Add ("XEvent", "IntPtr");
			mastermap.Add ("QWSEvent", "IntPtr");
			mastermap.Add ("GDHandle", "IntPtr");
			mastermap.Add ("QRgb", "int");
			mastermap.Add ("QWSDecoration", "IntPtr");
			mastermap.Add ("QTextParag", "IntPtr");
			mastermap.Add ("Qt.HANDLE", "IntPtr");
			mastermap.Add ("QUObject", "IntPtr");
			mastermap.Add ("QGfx", "IntPtr");
			mastermap.Add ("QRESULT", "long");
			mastermap.Add ("QUnknownInterface", "IntPtr");
			mastermap.Add ("QPtrCollection.Item", "int");
			mastermap.Add ("type", "IntPtr");
			mastermap.Add ("array_data", "IntPtr");
			mastermap.Add ("bitarr_data", "IntPtr");
			mastermap.Add ("Offset", "int");
			mastermap.Add ("Q_INT16", "short");
			mastermap.Add ("Q_INT32", "int");
			mastermap.Add ("Q_INT8", "char");
			mastermap.Add ("Q_LONG", "long");
			mastermap.Add ("Q_PACKED", "uint");
			mastermap.Add ("Q_UINT16", "ushort");
			mastermap.Add ("Q_UINT32", "uint");
			mastermap.Add ("Q_UINT8", "char");
			mastermap.Add ("Q_ULONG", "long");
			mastermap.Add ("QStyleHintReturn", "IntPtr");
			mastermap.Add ("QFileInfoList", "IntPtr");
			mastermap.Add ("QDomNodePrivate", "IntPtr");
			mastermap.Add ("GUID", "System.Guid");
			mastermap.Add ("FILE", "string");
			mastermap.Add ("EncoderFn", "int");
			mastermap.Add ("DecoderFn", "int");
			mastermap.Add ("QDiskFont", "IntPtr");
			mastermap.Add ("pointer", "IntPtr");
			mastermap.Add ("T", "IntPtr");
			mastermap.Add ("T1", "IntPtr");
			mastermap.Add ("T2", "IntPtr");
			mastermap.Add ("Iterator", "IntPtr");
			mastermap.Add ("iterator", "IntPtr");
			mastermap.Add ("_iterator", "IntPtr");
			mastermap.Add ("reference", "IntPtr");
			mastermap.Add ("_reference", "IntPtr");
			mastermap.Add ("ConstIterator", "int");
			mastermap.Add ("QWSDisplay", "IntPtr");
			mastermap.Add ("CGContextRef", "IntPtr");
			mastermap.Add ("WId", "uint");
			mastermap.Add ("QWidgetMapper", "IntPtr");
			mastermap.Add ("size_type", "int");
			mastermap.Add ("Item", "IntPtr");
			mastermap.Add ("image_io_handler", "int");
			mastermap.Add ("QCOORD", "short");
			mastermap.Add ("key_type", "IntPtr");
			mastermap.Add ("K", "IntPtr");
			mastermap.Add ("NodePtr", "int");
			mastermap.Add ("QTextFormat", "IntPtr");
			mastermap.Add ("QTextDocument", "IntPtr");
			mastermap.Add ("QTextCursor", "IntPtr");
			mastermap.Add ("_NPStream", "IntPtr");
			mastermap.Add ("PID", "long");
			mastermap.Add ("Region", "int");
			mastermap.Add ("RgnHandle", "IntPtr");
			mastermap.Add ("QRemoteInterface", "IntPtr");
			mastermap.Add ("mode_t", "int");
			mastermap.Add ("QSqlFieldInfo", "IntPtr");
			mastermap.Add ("QSqlRecordInfo", "IntPtr");
			mastermap.Add ("QSqlRecordPrivate", "IntPtr");
			mastermap.Add ("QTSMFI", "int");
			mastermap.Add ("Widget", "QWidget");
			mastermap.Add ("WidgetClass", "int");
			mastermap.Add ("ArgList", "int");
			mastermap.Add ("Cardinal", "int");
			mastermap.Add ("XrmOptionDescRec", "IntPtr");
			mastermap.Add ("size_t", "int");
			mastermap.Add ("ULONG_MAX", "UInt64.MaxValue");

			// Enums
			mastermap.Add ("Event", "QAccessible.Event");
			mastermap.Add ("Role", "QAccessible.Role");
			mastermap.Add ("NavDirection", "QAccessible.NavDirection");
			mastermap.Add ("Text", "QAccessible.Text");
			mastermap.Add ("ColorSpec", "QApplication.ColorSpec");
			mastermap.Add ("ToggleState", "QButton.ToggleState");
			mastermap.Add ("RttiValues", "QCanvasItem.RttiValues");
			mastermap.Add ("FrameAnimationType", "QCanvasSprite.FrameAnimationType");
			mastermap.Add ("Category", "QChar.Category");
			mastermap.Add ("Decomposition", "QChar.Decomposition");
			mastermap.Add ("Joining", "QChar.Joining");
			mastermap.Add ("CombiningClass", "QChar.CombiningClass");
			mastermap.Add ("Spec", "QColor.Spec");
			mastermap.Add ("ColorRole", "QColorGroup.ColorRole");
			mastermap.Add ("Boundary", "QDataBrowser.Boundary");
			mastermap.Add ("ByteOrder", "QDataStream.ByteOrder");
			mastermap.Add ("Refresh", "QDataTable.Refresh");
			mastermap.Add ("Order", "QDateEdit.Order");
			mastermap.Add ("DialogCode", "QDialog.DialogCode");
			mastermap.Add ("FilterSpec", "QDir.FilterSpec");
			mastermap.Add ("SortSpec", "QDir.SortSpec");
			mastermap.Add ("RecordType", "QDns.RecordType");
			mastermap.Add ("HandlePosition", "QDockArea.HandlePosition");
			mastermap.Add ("Place", "QDockWindow.Place");
			mastermap.Add ("CloseMode", "QDockWindow.CloseMode");
			mastermap.Add ("NodeType", "QDomNode.NodeType");
			mastermap.Add ("DragMode", "QDragObject.DragMode");
			mastermap.Add ("Action", "QDropEvent.Action");
			mastermap.Add ("ViewMode", "QFileDialog.ViewMode");
			mastermap.Add ("PreviewMode", "QFileDialog.PreviewMode");
			mastermap.Add ("PermissionSpec", "QFileInfo.PermissionSpec");
			mastermap.Add ("StyleStrategy", "QFont.StyleStrategy");
			mastermap.Add ("Weight", "QFont.Weight");
			mastermap.Add ("Script", "QFont.Script");
			mastermap.Add ("Shadow", "QFrame.Shadow");
			mastermap.Add ("FormatOption", "QGL.FormatOption");
			mastermap.Add ("Corner", "QGridLayout.Corner");
			mastermap.Add ("Size", "QIconSet.Size");
			mastermap.Add ("Arrangement", "QIconView.Arrangement");
			mastermap.Add ("ItemTextPos", "QIconView.ItemTextPos");
			mastermap.Add ("Endian", "QImage.Endian");
			mastermap.Add ("ScaleMode", "QImage.ScaleMode");
			mastermap.Add ("PaintDeviceFlags", "QInternal.PaintDeviceFlags");
			mastermap.Add ("Rules", "QJpUnicodeConv.Rules");
			mastermap.Add ("SegmentStyle", "QLCDNumber.SegmentStyle");
			mastermap.Add ("LayoutMode", "QListBox.LayoutMode");
			mastermap.Add ("WidthMode", "QListView.WidthMode");
			mastermap.Add ("RenameAction", "QListView.RenameAction");
			mastermap.Add ("DockWindows", "QMainWindow.DockWindows");
			mastermap.Add ("Color", "QMapNodeBase.Color");
			mastermap.Add ("Separator", "QMenuBar.Separator");
			mastermap.Add ("Icon", "QMessageBox.Icon");
			mastermap.Add ("Access", "QMetaData.Access");
			mastermap.Add ("Flags", "QMetaProperty.Flags");
			mastermap.Add ("Status", "QMovie.Status");
			mastermap.Add ("InstanceMode", "QNPInstance.InstanceMode");
			mastermap.Add ("StreamMode", "QNPInstance.StreamMode");
			mastermap.Add ("Operation", "QNetworkProtocol.Operation");
			mastermap.Add ("ConnectionState", "QNetworkProtocol.ConnectionState");
			mastermap.Add ("DisposalMethod", "QPNGImageWriter.DisposalMethod");
			mastermap.Add ("PDevCmd", "QPaintDevice.PDevCmd");
			mastermap.Add ("CoordinateMode", "QPainter.CoordinateMode");
			mastermap.Add ("TextDirection", "QPainter.TextDirection");
			mastermap.Add ("ColorGroup", "QPalette.ColorGroup");
			mastermap.Add ("Optimization", "QPixmap.Optimization");
			mastermap.Add ("Edge", "QPolygonScanner.Edge");
			mastermap.Add ("PrinterMode", "QPrinter.PrinterMode");
			mastermap.Add ("PageSize", "QPrinter.PageSize");
			mastermap.Add ("PageOrder", "QPrinter.PageOrder");
			mastermap.Add ("PaperSource", "QPrinter.PaperSource");
			mastermap.Add ("Communication", "QProcess.Communication");
			mastermap.Add ("RegionType", "QRegion.RegionType");
			mastermap.Add ("ResizePolicy", "QScrollView.ResizePolicy");
			mastermap.Add ("ScrollBarMode", "QScrollView.ScrollBarMode");
			mastermap.Add ("RestartHint", "QSessionManager.RestartHint");
			mastermap.Add ("System", "QSettings.System");
			mastermap.Add ("SizeType", "QSizePolicy.SizeType");
			mastermap.Add ("ExpandData", "QSizePolicy.ExpandData");
			mastermap.Add ("TickSetting", "QSlider.TickSetting");
			mastermap.Add ("Op", "QSql.Op");
			mastermap.Add ("Location", "QSql.Location");
			mastermap.Add ("Confirm", "QSql.Confirm");
			mastermap.Add ("DriverFeature", "QSqlDriver.DriverFeature");
			mastermap.Add ("SectionFlags", "QString.SectionFlags");
			mastermap.Add ("PrimitiveElement", "QStyle.PrimitiveElement");
			mastermap.Add ("StyleFlags", "QStyle.StyleFlags");
			mastermap.Add ("SFlags", "QStyle.StyleFlags");
			mastermap.Add ("ControlElement", "QStyle.ControlElement");
			mastermap.Add ("SubRect", "QStyle.SubRect");
			mastermap.Add ("ComplexControl", "QStyle.ComplexControl");
			mastermap.Add ("SubControl", "QStyle.SubControl");
			mastermap.Add ("SCFlags", "QStyle.SubControl");
			mastermap.Add ("PixelMetric", "QStyle.PixelMetric");
			mastermap.Add ("ContentsType", "QStyle.ContentsType");
			mastermap.Add ("StylePixmap", "QStyle.StylePixmap");
			mastermap.Add ("StyleOptionDefault", "QStyleOption.StyleOptionDefault");
			mastermap.Add ("AdditionalStyleValues", "QStyleSheetItem.AdditionalStyleValues");
			mastermap.Add ("DisplayMode", "QStyleSheetItem.DisplayMode");
			mastermap.Add ("WhiteSpaceMode", "QStyleSheetItem.WhiteSpaceMode");
			mastermap.Add ("Margin", "QStyleSheetItem.Margin");
			mastermap.Add ("ListStyle", "QStyleSheetItem.ListStyle");
			mastermap.Add ("FocusStyle", "QTable.FocusStyle");
			mastermap.Add ("EditMode", "QTable.EditMode");
			mastermap.Add ("EditType", "QTableItem.EditType");
			mastermap.Add ("TabletDevice", "QTabletEvent.TabletDevice");
			mastermap.Add ("KeyboardAction", "QTextEdit.KeyboardAction");
			mastermap.Add ("CursorAction", "QTextEdit.CursorAction");
			mastermap.Add ("SaveMode", "QTranslator.SaveMode");
			mastermap.Add ("Prefix", "QTranslatorMessage.Prefix");
			mastermap.Add ("FocusPolicy", "QWidget.FocusPolicy");
			mastermap.Add ("BackgroundOrigin", "QWidget.BackgroundOrigin");
			mastermap.Add ("ButtonState", "Qt.ButtonState");
			mastermap.Add ("AlignmentFlags", "Qt.AlignmentFlags");
			mastermap.Add ("TextFlags", "Qt.TextFlags");
			mastermap.Add ("WidgetState", "Qt.WidgetState");
			mastermap.Add ("WState", "Qt.WidgetState");
			mastermap.Add ("WidgetFlags", "Qt.WidgetFlags");
			mastermap.Add ("WFlags", "Qt.WidgetFlags");
			mastermap.Add ("ImageConversionFlags", "Qt.ImageConversionFlags");
			mastermap.Add ("BGMode", "Qt.BGMode");
			mastermap.Add ("PaintUnit", "Qt.PaintUnit");
			mastermap.Add ("GUIStyle", "Qt.GUIStyle");
			mastermap.Add ("Modifier", "Qt.Modifier");
			mastermap.Add ("Key", "Qt.Key");
			mastermap.Add ("ArrowType", "Qt.ArrowType");
			mastermap.Add ("RasterOp", "Qt.RasterOp");
			mastermap.Add ("PenStyle", "Qt.PenStyle");
			mastermap.Add ("PenCapStyle", "Qt.PenCapStyle");
			mastermap.Add ("PenJoinStyle", "Qt.PenJoinStyle");
			mastermap.Add ("BrushStyle", "Qt.BrushStyle");
			mastermap.Add ("WindowsVersion", "Qt.WindowsVersion");
			mastermap.Add ("UIEffect", "Qt.UIEffect");
			mastermap.Add ("CursorShape", "Qt.CursorShape");
			mastermap.Add ("TextFormat", "Qt.TextFormat");
			mastermap.Add ("Dock", "Qt.Dock");
			mastermap.Add ("DateFormat", "Qt.DateFormat");
			mastermap.Add ("BackgroundMode", "Qt.BackgroundMode");
			mastermap.Add ("StringComparisonMode", "Qt.StringComparisonMode");
			mastermap.Add ("ComparisonFlags", "Qt.StringComparisonMode");
			// We need to make sure all params use the interfaces, ie IQPaintDevice
			/*mastermap.Add ("QAccessibleFactoryInterface", "IQAccessibleFactory");
			mastermap.Add ("QAccessibleInterface", "IQAccessible");*/
			mastermap.Add ("QPaintDevice", "IQPaintDevice");
			/*mastermap.Add ("QMenuData", "IQMenuData");
			mastermap.Add ("QRangeControl", "IQRangeControl");
			mastermap.Add ("QMimeSource", "IQMimeSource");
			mastermap.Add ("QLayoutItem", "IQLayoutItem");
			mastermap.Add ("QUrl", "IQUrl");
			mastermap.Add ("QIODevice", "IQIODevice");
			mastermap.Add ("QXmlContentHandler", "IQXmlContentHandler");
			mastermap.Add ("QXmlErrorHandler", "IQXmlErrorHandler");
			mastermap.Add ("QXmlDTDHandler", "IQXmlDTDHandler");
			mastermap.Add ("QXmlEntityResolver", "IQXmlEntityResolver");
			//mastermap.Add ("QXmlLexicalHandler", "IQXmlLexicalHandler");
			mastermap.Add ("QXmlDeclHandler", "IQXmlDeclHandler");
			mastermap.Add ("QwAbsSpriteFieldView", "IQwAbsSpriteFieldView");
			mastermap.Add ("QSqlQuery", "IQSqlQuery");
			mastermap.Add ("QFeatureListInterface", "IQFeatureList");
			mastermap.Add ("QUnknownInterface", "IQUnknown");
			mastermap.Add ("QShared", "IQShared");*/

			// Key Duplication
			//mastermap.Add ("Direction", "QBoxLayout.Direction");
			//mastermap.Add ("Direction", "QChar.Direction");
			//mastermap.Add ("Reason", "QContextMenuEvent.Reason");
			//mastermap.Add ("Reason", "QFocusEvent.Reason");
			//mastermap.Add ("Reason", "QNPInstance.Reason");
			//mastermap.Add ("Mode", "QFileDialog.Mode");
			//mastermap.Add ("Mode", "QIconSet.Mode");
			//mastermap.Add ("Mode", "QLCDNumber.Mode");
			//mastermap.Add ("Mode", "QSqlCursor.Mode");
			//mastermap.Add ("Shape", "QFrame.Shape");
			//mastermap.Add ("Shape", "QTabBar.Shape");
			//mastermap.Add ("KeyType", "QGCache.KeyType");
			//mastermap.Add ("KeyType", "QGDict.KeyType");
			//mastermap.Add ("State", "QAccessible.State");
			//mastermap.Add ("State", "QNetworkProtocol.State");
			//mastermap.Add ("State", "QSocket.State");
			//mastermap.Add ("State", "QValidator.State");
			//mastermap.Add ("ResizeMode", "QIconView.ResizeMode");
			//mastermap.Add ("ResizeMode", "QLayout.ResizeMode");
			//mastermap.Add ("ResizeMode", "QListView.ResizeMode");
			//mastermap.Add ("ResizeMode", "QListView.ResizeMode");
			//mastermap.Add ("EchoMode", "QLineEdit.EchoMode");
			//mastermap.Add ("EchoMode", "QtMultiLineEdit.EchoMode");
			//mastermap.Add ("ColorMode", "QApplication.ColorMode");
			//mastermap.Add ("ColorMode", "QPrinter.ColorMode");
			//mastermap.Add ("ColorMode", "QPixmap.ColorMode");
			//mastermap.Add ("SelectionMode", "QIconView.SelectionMode");
			//mastermap.Add ("SelectionMode", "QListBox.SelectionMode");
			//mastermap.Add ("SelectionMode", "QListView.SelectionMode");
			//mastermap.Add ("SelectionMode", "QTable.SelectionMode");
			//mastermap.Add ("Error", "QSocket.Error");
			//mastermap.Add ("Error", "QSocketDevice.Error");
			//mastermap.Add ("Error", "QNetworkProtocol.Error");
			//mastermap.Add ("ButtonSymbols", "QSpinBox.ButtonSymbols");
			//mastermap.Add ("ButtonSymbols", "QSpinWidget.ButtonSymbols");
			//mastermap.Add ("StyleHint", "QStyle.StyleHint");
			//mastermap.Add ("StyleHint", "QFont.StyleHint");
			//mastermap.Add ("Encoding", "QApplication.Encoding");
			//mastermap.Add ("Encoding", "QTextStream.Encoding");
			//mastermap.Add ("VerticalAlignment", "QTextEdit.VerticalAlignment");
			//mastermap.Add ("VerticalAlignment", "QStyleSheetItem.VerticalAlignment");
			//mastermap.Add ("Orientation", "QPrinter.Orientation");
			//mastermap.Add ("Orientation", "Qt.Orientation");
			//mastermap.Add ("WrapPolicy", "QTextEdit.WrapPolicy");
			//mastermap.Add ("WrapPolicy", "QtMultiLineEdit.WrapPolicy");
			//mastermap.Add ("WordWrap", "QTextEdit.WordWrap");
			//mastermap.Add ("WordWrap", "QtMultiLineEdit.WordWrap");

			// These are here in case we need to override the mastermap
			pinvoketypes = new Hashtable ();
			pinvokecalltypes = new Hashtable ();
			csharptypes = new Hashtable ();
			overloadtypes = new Hashtable ();

			// These are reserved keywords.
			reserved = new Hashtable ();
			reserved.Add ("lock", "Q_lock");
			reserved.Add ("object", "Q_object");
			reserved.Add ("ref", "Q_ref");
			reserved.Add ("base", "Q_base");
			reserved.Add ("string", "Q_string");
			reserved.Add ("const", "Q_const");
			reserved.Add ("event", "Q_event");

			// The allowed interfaces
			interfaces = new Hashtable ();
			interfaces.Add ("QAccessibleFactoryInterface", "IQAccessibleFactory");
			interfaces.Add ("QAccessibleInterface", "IQAccessible");
			interfaces.Add ("QPaintDevice", "IQPaintDevice");
			interfaces.Add ("QMenuData", "IQMenuData");
			interfaces.Add ("QRangeControl", "IQRangeControl");
			interfaces.Add ("QMimeSource", "IQMimeSource");
			interfaces.Add ("QLayoutItem", "IQLayoutItem");
			interfaces.Add ("QUrl", "IQUrl");
			interfaces.Add ("QIODevice", "IQIODevice");
			interfaces.Add ("QXmlContentHandler", "IQXmlContentHandler");
			interfaces.Add ("QXmlErrorHandler", "IQXmlErrorHandler");
			interfaces.Add ("QXmlDTDHandler", "IQXmlDTDHandler");
			interfaces.Add ("QXmlEntityResolver", "IQXmlEntityResolver");
			//interfaces.Add ("QXmlLexicalHandler", "IQXmlLexicalHandler");
			interfaces.Add ("QXmlDeclHandler", "IQXmlDeclHandler");
			interfaces.Add ("QwAbsSpriteFieldView", "IQwAbsSpriteFieldView");
			interfaces.Add ("QSqlQuery", "IQSqlQuery");
			interfaces.Add ("QFeatureListInterface", "IQFeatureList");
			interfaces.Add ("QUnknownInterface", "IQUnknown");
			interfaces.Add ("QShared", "IQShared");

		}

		public string PinvokeType (string str)
		{
			if ((string)mastermap[str] != null)
				if((string)pinvoketypes[(string)mastermap[str]] != null)
					return (string)pinvoketypes[(string)mastermap[str]];
				else
					return (string)mastermap[str];
			else if ((string)pinvoketypes[str] != null)
				return (string)pinvoketypes[str];
			else
				return str;
		}

		public string PinvokeCallType (string str)
		{

			if ((string)mastermap[str] != null)
				if((string)pinvokecalltypes[(string)mastermap[str]] != null)
					return (string)pinvokecalltypes[(string)mastermap[str]];
				else
					return (string)mastermap[str];
			else if ((string)pinvokecalltypes[str] != null)
				return (string)pinvokecalltypes[str];
			else
				return str;
		}

		public string CSharpType (string str)
		{
			if ((string)mastermap[str] != null)
				if((string)csharptypes[(string)mastermap[str]] != null)
					return (string)csharptypes[(string)mastermap[str]];
				else
					return (string)mastermap[str];
			else if ((string)csharptypes[str] != null)
				return (string)csharptypes[str];
			else
				return str;
		}

		public string OverloadType (string str)
		{
			if ((string)mastermap[str] != null)
				if((string)overloadtypes[(string)mastermap[str]] != null)
					return (string)overloadtypes[(string)mastermap[str]];
				else
					return (string)mastermap[str];
			else if ((string)overloadtypes[str] != null)
				return (string)overloadtypes[str];
			else
				return str;
		}

		public string ArrayType (string str)
		{
			if ((string)arraymap[str] != null)
				return (string)arraymap[str];
			else
				return str;
		}

		public string ReservedType (string str)
		{
			if ((string)reserved[str] != null)
				return (string)reserved[str];
			else
				return str;
		}

		public string ReturnType (string str)
		{
			if ((string)reserved[str] != null)
				return (string)reserved[str];
			else
				return str;
		}

		public string InterfaceType (string str)
		{
			if ((string)interfaces[str] != null)
				return (string)interfaces[str];
			else
				return str;
		}
	}
}
