/****************************************************************************
** Form implementation generated from reading ui file 'book.ui'
**
** Created: Wed Aug 8 03:34:02 2001
**      by:  The User Interface Compiler (uic)
**
** WARNING! All changes made in this file will be lost!
****************************************************************************/
import org.kde.qt.*;

public class BookForm extends QWidget { 
    QDataTable AuthorDataTable;
    QDataTable BookDataTable;
    QPushButton connectButton;
    QPushButton editButton;

    QGridLayout BookFormLayout;
	QSizePolicy policy_1;
	QSizePolicy policy_2;
	QSpacerItem spacer;
	QSpacerItem spacer_2;

	QSqlCursor authorCursor;
	QSqlCursor bookCursor;

/* 
 *  Constructs a BookForm which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
BookForm( QWidget parent, String name, int fl )
{
    super( parent, name, fl );
    if ( name == null )
	setName( "BookForm" );
    resize( 478, 498 ); 
    setCaption( trUtf8( "Book" ) );
    BookFormLayout = new QGridLayout( this ); 
    BookFormLayout.setSpacing( 6 );
    BookFormLayout.setMargin( 11 );

    AuthorDataTable = new QDataTable( this, "AuthorDataTable" );
    AuthorDataTable.addColumn( "surname", trUtf8( "Surname", "" ) );
    AuthorDataTable.addColumn( "forename", trUtf8( "Forename", "" ) );
    AuthorDataTable.setSorting( true );
    AuthorDataTable.setConfirmDelete( true );
    AuthorDataTable.setSort( new String[] { "surname ASC", "forename ASC" } );

    BookFormLayout.addMultiCellWidget( AuthorDataTable, 1, 1, 0, 2 );
    spacer = new QSpacerItem( 20, 20, QSizePolicy.Expanding, QSizePolicy.Minimum );
    BookFormLayout.addMultiCell( spacer, 0, 0, 1, 2 );

    BookDataTable = new QDataTable( this, "BookDataTable" );
    BookDataTable.addColumn( "title", trUtf8( "Title", "" ) );
    BookDataTable.addColumn( "price", trUtf8( "Price", "" ) );
    BookDataTable.addColumn( "notes", trUtf8( "Notes", "" ) );
    BookDataTable.setReadOnly( true );
    BookDataTable.setSorting( true );
    BookDataTable.setSort( new String[] { "title ASC" } );

    BookFormLayout.addMultiCellWidget( BookDataTable, 2, 2, 0, 2 );
    spacer_2 = new QSpacerItem( 20, 20, QSizePolicy.Expanding, QSizePolicy.Minimum );
    BookFormLayout.addMultiCell( spacer_2, 3, 3, 0, 1 );

    connectButton = new QPushButton( this, "connectButton" );
	policy_1 = new QSizePolicy( (int)0, (int)0, connectButton.sizePolicy().hasHeightForWidth() );
    connectButton.setSizePolicy( policy_1 );
    connectButton.setText( trUtf8( "&Connect..." ) );

    BookFormLayout.addWidget( connectButton, 0, 0 );

    editButton = new QPushButton( this, "editButton" );
    editButton.setEnabled( false );
	policy_2 = new QSizePolicy( (int)0, (int)0, editButton.sizePolicy().hasHeightForWidth() );
    editButton.setSizePolicy( policy_2 );
    editButton.setText( trUtf8( "&Edit Books" ) );

    BookFormLayout.addWidget( editButton, 3, 2 );

    // database support





    // signals and slots connections
    connect( editButton, SIGNAL( "clicked()" ), this, SLOT( "editClicked()" ) );
    connect( AuthorDataTable, SIGNAL( "primeInsert(QSqlRecord)" ), this, SLOT( "primeInsertAuthor(QSqlRecord)" ) );
    connect( AuthorDataTable, SIGNAL( "currentChanged(QSqlRecord)" ), this, SLOT( "newCurrentAuthor(QSqlRecord)" ) );
    connect( connectButton, SIGNAL( "clicked()" ), this, SLOT( "connectClicked()" ) );

    // tab order
    setTabOrder( connectButton, editButton );
    init();
}

BookForm( QWidget parent, String name )
{
	this(parent, name, 0);
}

BookForm( QWidget parent )
{
	this(parent, null, 0);
}

BookForm( )
{
	this(null, null, 0);
}

void init()
{
}

public void destroy()
{
}

void editClicked()
{
    EditBookForm dialog = new EditBookForm( this, "Edit Book Form", true, 0 );
    QSqlCursor cur = new QSqlCursor( "book" );
    dialog.BookDataBrowser.setSqlCursor( cur );
    dialog.BookDataBrowser.setFilter( BookDataTable.filter() );
	String[] sort = new String[BookDataTable.sort().size()];
	sort = (String[]) BookDataTable.sort().toArray(sort);
    dialog.BookDataBrowser.setSort(QSqlIndex.fromStringList(
	sort, cur ) );
    dialog.BookDataBrowser.refresh();
    int i = BookDataTable.currentRow();
    if ( i == -1 ) i = 0; // Always use the first row
    dialog.BookDataBrowser.seek( i );
    dialog.exec();
    dialog = null;
    BookDataTable.refresh();
}

void connectClicked()
{
    boolean ok = false;
    ConnectDialog dialog = new ConnectDialog( this, "Connect", true, 0 );
	String[] drivers = new String[QSqlDatabase.drivers().size()];;
	drivers = (String[]) QSqlDatabase.drivers().toArray(drivers);
    dialog.comboDriver.insertStringList( drivers  );
    dialog.editDatabase.setText( "book" );
    if ( dialog.exec() == QDialog.Accepted ) {
	QSqlDatabase.removeDatabase( QSqlDatabase.defaultConnection() );
	QSqlDatabase db = QSqlDatabase.addDatabase( dialog.comboDriver.currentText() );
	db.setDatabaseName( dialog.editDatabase.text() );
	db.setUserName( dialog.editUsername.text() );
	db.setPassword( dialog.editPassword.text() );
	db.setHostName( dialog.editHostname.text() );
	if ( !db.open() ) {
	    //## warning?
	    ok= false;
	} else
	    ok = true;
    } 
    if ( !ok ) {
	editButton.setEnabled( false );
	BookDataTable.setSqlCursor( (QSqlCursor) null );
	AuthorDataTable.setSqlCursor( (QSqlCursor) null );
    }  else {
	editButton.setEnabled( true );
	authorCursor = new QSqlCursor( "author" );
	AuthorDataTable.setSqlCursor( authorCursor, false, true );
	bookCursor = new QSqlCursor( "book" );
	BookDataTable.setSqlCursor( bookCursor, false, true );
	AuthorDataTable.refresh( QDataTable.RefreshAll );
	BookDataTable.refresh( QDataTable.RefreshAll );
    }
    dialog = null;
}

void newCurrentAuthor(QSqlRecord author)
{
    BookDataTable.setFilter( "authorid=" + author.value( "id" ).toString() );
    BookDataTable.refresh();
}

void primeInsertAuthor(QSqlRecord buffer)
{
    QSqlQuery q = new QSqlQuery();
    q.exec( "UPDATE sequence SET sequence = sequence + 1 WHERE tablename='author';" );
    q.exec( "SELECT sequence FROM sequence WHERE tablename='author';" );
    if ( q.next() ) {
	buffer.setValue( "id", q.value( 0 ) );
    }
}

}
