/***************************************************************************
                            KPixmapIO.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPIXMAPIO_H
#define KPIXMAPIO_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**


 KPixmapIO implements a fast path for QPixmap to/from QImage conversions.
 It uses the MIT-SHM shared memory extension for this. If this extension is 
 not available, it will fall back to standard Qt methods. 

 You can use KPixmapIO for load/saving pixmaps.

 <pre>
 KPixmapIO io;
 pixmap = io.convertToPixmap(image);
 image = io.convertToImage(pixmap);
 </pre>

 It also has functionality for partially updating/saving pixmaps, see 
 @ref  #-putImage and @ref  #-getImage.

 Speed measurements were taken. These show that usage of KPixmapIO for 
 images up to a certain threshold size, offers no speed advantage over 
 the Qt routines. Below you can see a plot of these measurements.

 The threshold size, amongst other causes, is determined by the shared 
 memory allocation policy. If the policy is @p ShmDontKeep, the 
 shared memory segment is discarded right after usage, and thus needs to 
 be allocated before each transfer. This introduces a a setup penalty not 
 present when the policy is @p ShmKeepAndGrow. In this case the 
 shared memory segment is kept and resized when necessary, until the 
 KPixmapIO object is destroyed.

 The default policy is @p ShmDontKeep. This policy makes sense when
 loading pixmaps once. The corresponding threshold is taken at 5.000 
 pixels as suggested by experiments. Below this threshold, KPixmapIO 
 will not use shared memory and fall back on the Qt routines.

 When the policy is @p ShmKeepAndGrow, the threshold is taken at
 2.000 pixels. Using this policy, you might want to use @ref  #-preAllocShm
 to pre-allocate a certain amount of shared memory, in order to avoid
 resizes. This allocation policy makes sense in a multimedia type
 application where you are constantly updating the screen.

 Above a couple times the threshold size, KPixmapIO's and Qt's speed become 
 linear in the number of pixels, KPixmapIO being at least 2, and mostly around 
 4 times faster than Qt, depending on the screen and image depth.

 Speed difference seems to be the most at 16 bpp, followed by 32 and 24
 bpp respectively. This can be explained by the relatively poor
 implementation of 16 bit RGB packing in Qt, while at 32 bpp we need to
 transfer more data, and thus gain more, than at 24 bpp.

 For large pixmaps, there's a definite speed improvement when using 
 KPixmapIO. On the other hand, there's no speed improvement for small 
 pixmaps. When you know you're only transferring small pixmaps, there's no
 point in using it.
 
 @author Geert Jansen <jansen@kde.org>

 @version $Id: KPixmapIO.h,v 1.3 2002/03/15 02:12:21 rdale Exp $

 @short Fast QImage to/from QPixmap conversion.

*/
@class QImage; 
@class QPixmap;
@class QPoint;
@class QRect;

@interface  KPixmapIO : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- init;
- (void) dealloc;

/** 
 Convert an image to a pixmap.

*/
- (QPixmap*) convertToPixmap: (QImage *)image;

/** 
 Convert a pixmap to an image.

*/
- (QImage*) convertToImage: (QPixmap *)pixmap;

/** 
 Bitblt an image onto a pixmap.

*/
- putImage: (QPixmap *)dst dx: (int)dx dy: (int)dy src: (QImage*)src;

/** 
 This function is identical to the one above. It only differs in the
 arguments it accepts.
     
*/
- putImage: (QPixmap *)dst offset: (QPoint*)offset src: (QImage*)src;

/** 
 Transfer (a part of) a pixmap to an image.

*/
- (QImage*) getImage: (QPixmap *)src sx: (int)sx sy: (int)sy sw: (int)sw sh: (int)sh;

/** 
 This function is identical to the one above. It only differs in the
 arguments it accepts.
     
*/
- (QImage*) getImage: (QPixmap *)src rect: (QRect*)rect;

/** 
 Set the shared memory allocation policy. See the introduction for
 KPixmapIO for a discussion.

*/
- setShmPolicy: (int)policy;

/** 
 Pre-allocate shared memory. KPixmapIO will be able to transfer images
 up to this size without resizing.

*/
- preAllocShm: (int)size;
+ (int) ShmDontKeep;
+ (int) ShmKeepAndGrow;
@end

#endif
