/***************************************************************************
                            KFileTreeView.h -  description
                             -------------------
    begin                : Thu Mar 21 01:01:29 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Thu Mar 21 01:01:29 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KFILETREEVIEW_H
#define KFILETREEVIEW_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KListView.h>

/**

 The filetreeview offers a treeview on the file system which behaves like  
 a QTreeView showing files and/or directories in the file system.

 KFileTreeView is able to handle more than one URL, represented by
 @ref KFileTreeBranch.

 Typicall usage:
 1. create a KFileTreeView fitting in your layout and add columns to it
 2. call addBranch to create one or more branches
 3. retrieve the root item with @ref -[KFileTreeBranch root] and set it open
    if desired. That starts the listing.
 
 @short 
 The filetreeview offers a treeview on the file system which behaves like  
 a QTreeView showing files and/or directories in the file system.
*/

@class KFileTreeViewItem;
@class KURL;
@class KFileTreeBranch;

@interface KFileTreeView : KListView 
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- initWithWidget: (QWidget *)parent ;
- (void) dealloc;

/** 

*/
- (KFileTreeViewItem*) currentKFileTreeViewItem;

/** 

*/
- (KURL*) currentURL;

/** 
  adds a branch to the treeview item. This highlevel function creates the branch, adds
  it to the treeview and connects some signals. Note that directory listing does not
  yet start. It is started by expanding the branches root either by opening the root
  item by user or by setOpen on the root item.

*/
- (KFileTreeBranch*) addBranch: (KURL*)path name: (NSString *)name showHidden: (BOOL)showHidden;
- (KFileTreeBranch*) addBranch: (KURL*)path name: (NSString *)name ;

/** 
  same as the function above but with a pixmap to set for the branch.
    
*/
- (KFileTreeBranch*) addBranch: (KURL*)path name: (NSString *)name pix: (QPixmap *)pix showHidden: (BOOL)showHidden;
- (KFileTreeBranch*) addBranch: (KURL*)path name: (NSString *)name pix: (QPixmap *)pix ;

/** 
  same as the function above but letting the user create the branch.
    
*/
- (KFileTreeBranch*) addBranch: (KFileTreeBranch*)arg1;

/** 
  removes the branch from the treeview.

*/
- (BOOL) removeBranch: (KFileTreeBranch*)branch;

/** 

*/
- (KFileTreeBranch*) branch: (NSString *)searchName;

/** 

*/
//- (KFileTreeBranchList&) branches;

/** 
  set the directory mode for branches. If true is passed, only directories will be loaded.

*/
- setDirOnlyMode: (KFileTreeBranch*)brnch bool: (BOOL)arg1;

/** 
 searches a branch for a @ref KFileTreeViewItem identified by the relative url given as
 second parameter. The method adds the branches base url to the relative path and finds
 the item.

*/
- (KFileTreeViewItem*) findItem: (KFileTreeBranch*)brnch relUrl: (NSString *)relUrl;

/** 
 see method above, differs only in the first parameter. Finds the branch by its name.
    
*/
- (KFileTreeViewItem*) findItemWithName: (NSString *)branchName relUrl: (NSString *)relUrl;

/** 

*/
- (BOOL) showFolderOpenPixmap;

/** 
 set the flag to show 'extended' folder icons on or off. If switched on, folders will
 have an open folder pixmap displayed if their children are visible, and the standard
 closed folder pixmap (from mimetype folder) if they are closed.
 If switched off, the plain mime pixmap is displayed.

*/
- setShowFolderOpenPixmap: (BOOL)showIt;
- setShowFolderOpenPixmap;

/** 

*/
- (BOOL) acceptDrag: (QDropEvent*)event;
- (QDragObject*) dragObject;
- startAnimation: (KFileTreeViewItem*)item iconBaseName: (NSString *)iconBaseName iconCount: (unsigned int)iconCount;
- startAnimation: (KFileTreeViewItem*)item ;
- stopAnimation: (KFileTreeViewItem*)item;
- virtual_hook: (int)identifier data: (void*)data;
//- slotNewTreeViewItems: (KFileTreeBranch*)arg1 filetreeviewitemlist: (KFileTreeViewItemList*)arg2;
- slotSetNextUrlToSelect: (KURL*)url;
- (QPixmap*) itemIcon: (KFileTreeViewItem*)arg1 gap: (int)gap;
- (QPixmap*) itemIcon: (KFileTreeViewItem*)arg1 ;
@end

/** Override these methods in subclasses of KFileTreeView to customise event handling behaviour */
@protocol KFileTreeViewEventHandling

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- focusOutEvent:(QFocusEvent*) fe;
- childEvent:(QChildEvent*) arg1;
- viewportDragMoveEvent:(QDragMoveEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- contentsWheelEvent:(QWheelEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- leaveEvent:(QEvent*) e;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contentsContextMenuEvent:(QContextMenuEvent*) e;
- viewportContextMenuEvent:(QContextMenuEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- viewportMousePressEvent:(QMouseEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- viewportMouseReleaseEvent:(QMouseEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- viewportMouseDoubleClickEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- viewportDragLeaveEvent:(QDragLeaveEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- contentsDropEvent:(QDropEvent*) ev;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- focusInEvent:(QFocusEvent*) fe;
- imEndEvent:(QIMEvent*) arg1;
- contentsDragLeaveEvent:(QDragLeaveEvent*) e;

/** 
 A special keyPressEvent (for FileManager selection mode).
   
*/
- fileManagerKeyPressEvent:(QKeyEvent*) arg1;
- viewportDropEvent:(QDropEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- contentsMouseDoubleClickEvent:(QMouseEvent*) e;
- viewportDragEnterEvent:(QDragEnterEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- viewportMouseMoveEvent:(QMouseEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- contentsDragMoveEvent:(QDragMoveEvent*) e;
- moveEvent:(QMoveEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- contentsMouseReleaseEvent:(QMouseEvent*) arg1;
- viewportWheelEvent:(QWheelEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- contentsDragEnterEvent:(QDragEnterEvent*) e;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- contentsMouseMoveEvent:(QMouseEvent*) e;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- contentsMousePressEvent:(QMouseEvent*) e;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- viewportPaintEvent:(QPaintEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;

/** 
 Reimplemented for -setFullWidth
   
*/
- viewportResizeEvent:(QResizeEvent*) e;
- resizeEvent:(QResizeEvent*) e;
@end


#endif
