/***************************************************************************
                            KDirNotify.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 An abstract class that receives notifications of added and removed files
 in any directory, local or remote.
 The information comes from the konqueror/kdesktop instance where the
 operation was done, and can interest KDirListers, bookmark handlers, etc.
 
 @short *
 An abstract class that receives notifications of added and removed files
 in any directory, local or remote.
*/
public class KDirNotify extends DCOPObject implements KDirNotifyInterface {
	protected KDirNotify(Class dummy){super((Class) null);}

//	public native k_dcop: /** * Notify that files have been added in @p directory * Note: this is ASYNC so that it can be used with a broadcast */  ASYNC FilesAdded( KURL directory);

/** 
 Notify that files have been deleted.
 Note: this is ASYNC so that it can be used with a broadcast
   
*/
	public native void FilesRemoved( ArrayList fileList);

/** 
 Notify that files have been changed.
 At the moment, this is only used for new icon, but it could be
 used for size etc. as well.
 Note: this is ASYNC so that it can be used with a broadcast
   
*/
	public native void FilesChanged( ArrayList fileList);

/** 
 Notify that a file has been renamed.
 Note: this is ASYNC so that it can be used with a broadcast
   
*/
	public native void FileRenamed( KURL src, KURL dst);
}
