/***************************************************************************
                            KAboutDialog.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A {@link KDialogBase} with predefined main widget.

 As a {@link KDialogBase} it uses your application wide settings
 for {@link KDialogBase}
 objects (base frame tiles, main frame tiles etc).
 To use it, simply create a KAboutDialog object, set all (or some) of its
 properties and show it. Do not derive it to create your own about dialog
 until you need some cool features that are unsupported and you have
 contacted me to add them.

 The dialog can be created using two different constructors. The
 difference between these constructors is the available components that
 can be used to build the contents of the dialog. The first (Constructor I)
 provides a number of easy to use methods. Basically it allows you
 to add the components of choice, and the components are placed in a
 predefined layout. You do not have to plan the layout. Everything is
 taken care of.

 The second constructor (Constructor II) works in quite the same manner
 as the first, but you have better control on where the components
 are postioned in the layout and you have access to an extended number
 of components you can install such as titles, product information,
 a tabbed pages (where you can display rich text with url links) and
 a person (developer) information field. The "About KDE" dialog box is
 created with Constructor II.

 For the derived features, see the basic class {@link KDialogBase}.

 See {@link KAboutDialogSignals} for signals emitted by KAboutDialog.

 

 @author Mirko Boehm (mirko@kde.org) and Espen Sand (espensa@online.no)

 @short *
 A @ref KDialogBase with predefined main widget.
*/
public class KAboutDialog extends KDialogBase  {
	protected KAboutDialog(Class dummy){super((Class) null);}

	private native void newKAboutDialog( QWidget parent, String name, boolean modal);

/** 
 The standard Qt constructor (Constructor I).

 Add components with the following methods:
  {@link #setLogo}, {@link #setAuthor}, {@link #setMaintainer},
   {@link #addContributor}, or {@link #setVersion}.
 The dialog will be laid out automatically.
     
*/
	public KAboutDialog( QWidget parent, String name, boolean modal) {
		super((Class) null);
		newKAboutDialog( parent, name, modal);
	}
	public KAboutDialog( QWidget parent, String name) {
		this( parent, name, true);
	}
	private native void newKAboutDialog();
	public KAboutDialog() {
		super((Class) null);
		newKAboutDialog();
	}
	private native void newKAboutDialog( int dialogLayout, String caption, int buttonMask, int defaultButton, QWidget parent, String name, boolean modal, boolean separator, String user1, String user2, String user3);

/** 
 The extended constructor. (Constructor II).

 Add components with the methods:
  {@link #setTitle}, {@link #setImage}, {@link #setImageBackgroundColor},
  {@link #setImageFrame}, {@link #setProduct}, {@link #addTextPage},
  {@link #addContainerPage}, {@link #addContainer}, or {@link #addPage}.

    
*/
	public KAboutDialog( int dialogLayout, String caption, int buttonMask, int defaultButton, QWidget parent, String name, boolean modal, boolean separator, String user1, String user2, String user3) {
		super((Class) null);
		newKAboutDialog( dialogLayout, caption, buttonMask, defaultButton, parent, name, modal, separator, user1, user2, user3);
	}
	public KAboutDialog( int dialogLayout, String caption, int buttonMask, int defaultButton, QWidget parent, String name, boolean modal, boolean separator, String user1, String user2) {
		this( dialogLayout, caption, buttonMask, defaultButton, parent, name, modal, separator, user1, user2, null);
	}
	public KAboutDialog( int dialogLayout, String caption, int buttonMask, int defaultButton, QWidget parent, String name, boolean modal, boolean separator, String user1) {
		this( dialogLayout, caption, buttonMask, defaultButton, parent, name, modal, separator, user1, null, null);
	}
	public KAboutDialog( int dialogLayout, String caption, int buttonMask, int defaultButton, QWidget parent, String name, boolean modal, boolean separator) {
		this( dialogLayout, caption, buttonMask, defaultButton, parent, name, modal, separator, null, null, null);
	}
	public KAboutDialog( int dialogLayout, String caption, int buttonMask, int defaultButton, QWidget parent, String name, boolean modal) {
		this( dialogLayout, caption, buttonMask, defaultButton, parent, name, modal, false, null, null, null);
	}
	private native void newKAboutDialog( int dialogLayout, String caption, int buttonMask, int defaultButton);
	public KAboutDialog( int dialogLayout, String caption, int buttonMask, int defaultButton) {
		super((Class) null);
		newKAboutDialog( dialogLayout, caption, buttonMask, defaultButton);
	}

/** 
 Adjusts the dialog.

 You can call this method after you have set up all
 the contents but it is not required. It is done automatically when
 {@link #show} is executed.
   
*/
	public native void adjust();

/** 
 Makes a modeless (modal = false in constructor) dialog visible.

 If you reimplement this method make sure you run it
 in the new method (e.g., {@link #show}). Reimplemented
 from {@link KDialogBase}.
   
*/
	public native void show();

/** 
 Makes a modeless (modal = false in constructor) dialog visible.

 If you reimplmement this method make sure you run it
 in the new method (i.e., {@link #show}).

*/
	public native void show( QWidget centerParent);

/** 
 (Constructor II only)
 Sets a title (not caption) in the uppermost area of the dialog.

*/
	public native void setTitle( String title);

/** 
 (Constructor II only)
 Define an image to be shown in the dialog. The position is dependent
 on the <code>dialogLayout</code> in the constructor

*/
	public native void setImage( String fileName);

/** 
 (Constructor II only)
 The image has a minimum size, but is centered within an area if the
 dialog box is enlarged by the user. You set the background color
 of the area with this method.

*/
	public native void setImageBackgroundColor( QColor color);

/** 
 (Constructor II only)
 Enables or disables a frame around the image. The frame is, by default,
 enabled in the constructor

*/
	public native void setImageFrame( boolean state);

/** 
 (Constructor II only)
 Prints the application name, KDE version, author, a copyright sign
 and a year string. To the left of the text the standard application
 icon is displayed.

*/
	public native void setProduct( String appName, String version, String author, String year);

/** 
 (Constructor II only)
 Adds a text page to a tab box. The text can be regular text or
 rich text. The rich text can contain URLs and mail links.

*/
	public native QFrame addTextPage( String title, String text, boolean richText, int numLines);
	public native QFrame addTextPage( String title, String text);

/** 
 (Constructor II only)
 Adds a license page to a tab box.

*/
	public native QFrame addLicensePage( String title, String text, int numLines);
	public native QFrame addLicensePage( String title, String text);

/** 
 (Constructor II only)
 Adds a container to a tab box. You can add text and images to a
 container.

*/
	public native KAboutContainer addContainerPage( String title, int childAlignment, int innerAlignment);
	public native KAboutContainer addContainerPage( String title);

/** 
 (Constructor II only)
 Adds a container inside a QScrollView to a tab box. You can add text
 and images to a container.

*/
	public native KAboutContainer addScrolledContainerPage( String title, int childAlignment, int innerAlignment);
	public native KAboutContainer addScrolledContainerPage( String title);

/** 
 (Constructor II only)
 Adds a container. You can add text and images to a container.

*/
	public native KAboutContainer addContainer( int childAlignment, int innerAlignment);

/** 
 (Constructor II only)
 Adds an empty page to a tab box.

*/
	public native QFrame addPage( String title);

/** 
 (Constructor I only)
 Sets the image as the application logo.
   
*/
	public native void setLogo( QPixmap arg1);

/** 
 (Constructor I only)
 Sets the author's name and email address.
   
*/
	public native void setAuthor( String name, String email, String url, String work);

/** 
 (Constructor I only)
 Sets the maintainer's name and email address.
   
*/
	public native void setMaintainer( String name, String email, String url, String work);

/** 
 (Constructor I only)
 Show this person as one of the major contributors.
   
*/
	public native void addContributor( String name, String email, String url, String work);

/** 
 (Constructor I only)
 Sets the text describing the version.
   
*/
	public native void setVersion( String name);

/** 
 Create a modal dialog with an image in the upper area with a
 URL link below.
   
*/
	public static native void imageURL( QWidget parent, String caption, String path, QColor imageColor, String url);
	protected native void virtual_hook( int identifier, int data);

/** 
 Connected to widget.sendEmail.
   
*/
	protected native void sendEmailSlot( String name, String email);

/** 
 Open this URL.
   
*/
	protected native void openURLSlot( String url);

/** 
 (Constructor II only)
 Tells the position of the mouse cursor when the left mouse button
 is pressed above an image
   
*/
	protected native void mouseTrackSlot( int mode, QMouseEvent e);
	public static final int AbtPlain = 0x0001;
	public static final int AbtTabbed = 0x0002;
	public static final int AbtTitle = 0x0004;
	public static final int AbtImageLeft = 0x0008;
	public static final int AbtImageRight = 0x0010;
	public static final int AbtImageOnly = 0x0020;
	public static final int AbtProduct = 0x0040;
	public static final int AbtKDEStandard = AbtTabbed|AbtTitle|AbtImageLeft;
	public static final int AbtAppStandard = AbtTabbed|AbtTitle|AbtProduct;
	public static final int AbtImageAndTitle = AbtPlain|AbtTitle|AbtImageOnly;
}
