/***************************************************************************
                            QDataBrowser.h -  description
                             -------------------
    begin                : Wed Nov 21 12:08:37 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Nov 21 12:08:37 2001, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef QDATABROWSER_H
#define QDATABROWSER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QWidget.h>

@class QSqlCursor; 
@class QSqlError; 
@class QSqlForm; 
@class QSqlIndex; 

@interface QDataBrowser : QWidget 
- initWithWidget: (QWidget *)parent name: (NSString *)name fl: (int)fl;
- init;
- (void) dealloc;
- (int) boundary;
- setBoundaryChecking: (BOOL)active;
- (BOOL) boundaryChecking;
- setSort: (QSqlIndex*)sort;
- setSortWithStringList: (NSArray *)sort;
- (NSArray *) sort;
- setFilter: (NSString *)filter;
- (NSString *) filter;
- setSqlCursor: (QSqlCursor*)cursor autoDelete: (BOOL)autoDelete;
- setSqlCursor: (QSqlCursor*)cursor ;
- (QSqlCursor*) sqlCursor;
- setForm: (QSqlForm*)form;
- (QSqlForm*) form;
- setConfirmEdits: (BOOL)confirm;
- setConfirmInsert: (BOOL)confirm;
- setConfirmUpdate: (BOOL)confirm;
- setConfirmDelete: (BOOL)confirm;
- setConfirmCancels: (BOOL)confirm;
- (BOOL) confirmEdits;
- (BOOL) confirmInsert;
- (BOOL) confirmUpdate;
- (BOOL) confirmDelete;
- (BOOL) confirmCancels;
- setReadOnly: (BOOL)active;
- (BOOL) isReadOnly;
- setAutoEdit: (BOOL)autoEdit;
- (BOOL) autoEdit;
- (BOOL) seek: (int)i relative: (BOOL)relative;
- (BOOL) seek: (int)i ;
- refresh;
- insert;
- update;
- del;
- first;
- last;
- next;
- prev;
- readFields;
- writeFields;
- clearValues;
- updateBoundary;
- (BOOL) insertCurrent;
- (BOOL) updateCurrent;
- (BOOL) deleteCurrent;
- (BOOL) currentEdited;
- (int) confirmEdit: (int)m;
- (int) confirmCancel: (int)m;
- handleError: (QSqlError*)error;
+ (int) Unknown;
+ (int) None;
+ (int) BeforeBeginning;
+ (int) Beginning;
+ (int) End;
+ (int) AfterEnd;
@end

/** Override these methods in subclasses of QDataBrowser to customise event handling behaviour */
@protocol QDataBrowserEventHandling
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
