/*
 *  Copyright (C) 2001-2002, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <kconfig.h>
#include <kdebug.h>
#include <kglobal.h>

#include <kjs/interpreter.h>
#include <kjs/ustring.h>

#include "jshookloader.h"

namespace KJSEmbed {

static const char *JSCRIPT_HOOKS_GROUP = "JScript Hooks";

JSHookLoader::JSHookLoader( KJS::Interpreter *j )
    : js( j ), cfg( KGlobal::config() ), grp( JSCRIPT_HOOKS_GROUP )
{
}

JSHookLoader::JSHookLoader( KJS::Interpreter *j, KConfig *conf )
    : js( j ), cfg( conf ), grp( JSCRIPT_HOOKS_GROUP )
{
}

JSHookLoader::JSHookLoader( KJS::Interpreter *j, KConfig *conf, const QString &group )
    : js( j ), cfg( conf ), grp( group )
{
}

JSHookLoader::~JSHookLoader()
{
}

void JSHookLoader::setConfig( KConfig *conf )
{
    cfg = conf;
}

void JSHookLoader::setGroup( const QString &group )
{
    grp = group;
}

bool JSHookLoader::hasHooks() const
{
    if (!cfg)
	return false;
    if ( !cfg->hasGroup( grp ) )
	return false;

    kdDebug() << "JSHookLoader: hooks config group is present" <<  endl;
    return true;
}

QString JSHookLoader::hook( const QString &name ) const
{
    if ( !hasHooks() )
	return QString::null;

    KConfigGroupSaver cgs( cfg, grp );
    QString cmd = cfg->readEntry( name );
    kdDebug() << "JSHookLoader: hook '" << name << "' loaded" <<  endl;
    return cmd;
}

void JSHookLoader::runHook( const QString &name )
{
    QString cmd = hook( name );
    if ( cmd.isEmpty() ) {
	kdDebug() << "JSHookLoader: hook '" << name << "' not defined" <<  endl;
	return;
    }

    kdDebug() << "JSHookLoader: jscript code is '" << cmd << "', executing" << endl;
    /*bool ok =*/ js->evaluate( cmd.ascii() );
    //    kdDebug() << "JSHookLoader: result is " << ok << endl;
}

}; // namespace KJSEmbed

// Local Variables:
// c-basic-offset: 4
// End:

