/***************************************************************************
                            KEMailSettings.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KEMAILSETTINGS_H
#define KEMAILSETTINGS_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 This is just a small class to facilitate accessing e-mail settings in 
 a sane way, and allowing any program to manage multiple e-mail 
 profiles effortlessly

 @author Alex Zepeda jazepeda@pacbell.net

 @short 
 This is just a small class to facilitate accessing e-mail settings in 
 a sane way, and allowing any program to manage multiple e-mail 
 profiles effortlessly

*/
@interface  KEMailSettings : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Default constructor, just sets things up.

*/
- init;

/** 
 Default destructor, nothing to see here.

*/
- (void) dealloc;

/** 
 List of profiles available.

*/
- (NSArray *) profiles;

/** 

*/
- (NSString *) currentProfileName;

/** 
 Change the current profile.

*/
- setProfile: (NSString *)arg1;

/** 

*/
- (NSString *) defaultProfileName;

/** 
 New default..

*/
- setDefault: (NSString *)arg1;

/** 
 Get a "basic" setting, one that I've already thought of..

*/
- (NSString *) getSetting: (int)s;
- setSetting: (int)s v: (NSString *)v;

/** 
 Use this when trying to get at currently unimplemented settings
 such as POP3 authentication methods, or mail specific TLS settings
 or something I haven't already thought of.

*/
- (NSString *) getExtendedSetting: (int)e s: (NSString *)s;

/** 
 Use this when trying to get at currently unimplemented settings
 such as POP3 authentication methods, or mail specific TLS settings
 or something I haven't already thought of.

*/
- setExtendedSetting: (int)e s: (NSString *)s v: (NSString *)v;
+ (int) ClientProgram;
+ (int) ClientTerminal;
+ (int) RealName;
+ (int) EmailAddress;
+ (int) ReplyToAddress;
+ (int) Organization;
+ (int) OutServer;
+ (int) OutServerLogin;
+ (int) OutServerPass;
+ (int) OutServerType;
+ (int) OutServerCommand;
+ (int) OutServerTLS;
+ (int) InServer;
+ (int) InServerLogin;
+ (int) InServerPass;
+ (int) InServerType;
+ (int) InServerMBXType;
+ (int) InServerTLS;
+ (int) POP3;
+ (int) SMTP;
+ (int) OTHER;
@end

#endif
