/***************************************************************************
                            KIPC.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class implements a very simple IPC mechanism for KDE. You can send
 a message of a predefined type to either a specific application, or to all
 KDE application on the current display. The message can carry one integer of
 data.

 KIPC is mainly used in KDE for sending "Change Messages", i.e. a message to
 all KDE apps that a certain setting (the font, for example) has changed.
 For anything more complex it is recommended to use DCOP -- the Desktop
 Communications Protocol.

 Messages with id code < 32 are called "System Messages". These are
 directly handled by KApplication. Examples are: PaletteChanged and
 StyleChanged. Messages with id code >= 32 are user messages. KApplication
 emits the signal kipcMessage(id,arg) for each user message it receives.

 KIPC is implemented using X11 ClientMessage events.

 @author Geert Jansen <jansen@kde.org>

 @version $Id: KIPC.java,v 1.7 2002/11/26 04:17:33 rdale Exp $
 
 @short *
 This class implements a very simple IPC mechanism for KDE.
*/
public class  KIPC implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KIPC(Class dummy){}


/** 
 Send a message to a specific application.

*/
	public static native void sendMessage( int msg, int w, int data);
	public static native void sendMessage( int msg, int w);

/** 
 Send a message to all KDE application on the current display.

*/
	public static native void sendMessageAll( int msg, int data);
	public static native void sendMessageAll( int msg);
	public static final int PaletteChanged = 0;
	public static final int FontChanged = 0;
	public static final int StyleChanged = 1;
	public static final int BackgroundChanged = 2;
	public static final int SettingsChanged = 3;
	public static final int IconChanged = 4;
	public static final int ToolbarStyleChanged = 5;
	public static final int ClipboardConfigChanged = 6;
	public static final int UserMessage = 32;
}
