/***************************************************************************
                            KFilterDev.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A class for reading and writing compressed data onto a device
 (e.g. file, but other usages are possible, like a buffer or a socket)

 To simply read/write compressed files, see {@link deviceForFile}.

 @author David Faure <faure@kde.org>
 
 @short *
 A class for reading and writing compressed data onto a device
 (e.
*/
public class KFilterDev extends QIODevice  {
	protected KFilterDev(Class dummy){super((Class) null);}

	private native void newKFilterDev( KFilterBase filter, boolean autodeleteFilterBase);

/** 
 Constructs a KFilterDev for a given filter (e.g. gzip, bzip2 etc.)

*/
	public KFilterDev( KFilterBase filter, boolean autodeleteFilterBase) {
		super((Class) null);
		newKFilterDev( filter, autodeleteFilterBase);
	}
	private native void newKFilterDev( KFilterBase filter);
	public KFilterDev( KFilterBase filter) {
		super((Class) null);
		newKFilterDev( filter);
	}

/** 
 Destructs the KFilterDev.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();
	public native boolean open( int mode);
	public native void close();
	public native void flush();

/** 
 For writing gzip compressed files only:
 set the name of the original file, to be used in the gzip header.
     
*/
	public native void setOrigFileName( String fileName);

/** 
 Call this let this device skip the gzip headers when reading/writing.
 This way KFilterDev (with gzip filter) can be used as a direct wrapper
 around zlib - this is used by KZip.

*/
	public native void setSkipHeaders();
	public native int size();
	public native int at();

/** 
 That one can be quite slow, when going back. Use with care.
     
*/
	public native boolean at( int arg1);
	public native boolean atEnd();
	public native long readBlock( String data, long maxlen);
	public native long writeBlock( String data, long len);
	public native int getch();
	public native int putch( int arg1);
	public native int ungetch( int arg1);

/** 
 Call this to create the appropriate filter device for <code>base</code>
 working on <code>file</code> . The returned QIODevice has to be deleted
 after using.

 To be removed in KDE 3.0
     
*/
	public static native QIODeviceInterface createFilterDevice( KFilterBase base, QFile file);

/** 
 Creates an i/o device that is able to read from <code>fileName</code>,
 whether it's compressed or not. Available compression filters
 (gzip/bzip2 etc.) will automatically be used.

 The compression filter to be used is determined from the <code>fileName</code>
 if <code>mimetype</code> is empty. Pass "application/x-gzip" or "application/x-bzip2"
 to force the corresponding decompression filter, if available.

 Warning: application/x-bzip2 may not be available.
 In that case a QFile opened on the compressed data will be returned !
 Use KFilterBase.findFilterByMimeType and code similar to what
 deviceForFile is doing, to better control what's happening.

 The returned QIODevice has to be deleted after using.
     
*/
	public static native QIODeviceInterface deviceForFile( String fileName, String mimetype, boolean forceFilter);
	public static native QIODeviceInterface deviceForFile( String fileName);

/** 
 Creates an i/o device that is able to read from the QIODevice <code>inDevice</code>,
 whether the data is compressed or not. Available compression filters
 (gzip/bzip2 etc.) will automatically be used.

 The compression filter to be used is determined <code>mimetype</code> .
 Pass "application/x-gzip" or "application/x-bzip2"
 to use the corresponding decompression filter.

 Warning: application/x-bzip2 may not be available.
 In that case 0 will be returned !

 The returned QIODevice has to be deleted after using.

*/
	public static native QIODeviceInterface device( QIODeviceInterface inDevice, String mimetype);

/** 
 Creates an i/o device that is able to read from the QIODevice <code>inDevice</code>,
 whether the data is compressed or not. Available compression filters
 (gzip/bzip2 etc.) will automatically be used.

 The compression filter to be used is determined <code>mimetype</code> .
 Pass "application/x-gzip" or "application/x-bzip2"
 to use the corresponding decompression filter.

 Warning: application/x-bzip2 may not be available.
 In that case 0 will be returned !

 The returned QIODevice has to be deleted after using.

*/
	public static native QIODeviceInterface device( QIODeviceInterface inDevice, String mimetype, boolean autoDeleteInDevice);
}
