/***************************************************************************
                            kde_KFilterBase.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KFILTERBASE
#define KDE_KFILTERBASE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 This is the base class for compression filters
 such as gzip and bzip2. It's pretty much internal.
 Don't use directly, use KFilterDev instead.
 
 @short *
 This is the base class for compression filters
 such as gzip and bzip2.
*/
#define KFILTERBASE_OK	0
#define KFILTERBASE_END	1
#define KFILTERBASE_ERROR	2
void kde_del_KFilterBase( kde_KFilterBase* p );

/** *
 Sets the device on which the filter will work
 If @p autodelete is set to true, @p dev is deleted when the filter is deleted
     
*/
void kde_KFilterBase_setDevice(kde_KFilterBase* instPointer,qt_QIODevice * dev, int autodelete);
qt_QIODevice * kde_KFilterBase_device(kde_KFilterBase* instPointer);
void kde_KFilterBase_init(kde_KFilterBase* instPointer,int mode);
int kde_KFilterBase_mode(kde_KFilterBase* instPointer);
void kde_KFilterBase_terminate(kde_KFilterBase* instPointer);
void kde_KFilterBase_reset(kde_KFilterBase* instPointer);
int kde_KFilterBase_readHeader(kde_KFilterBase* instPointer);
int kde_KFilterBase_writeHeader(kde_KFilterBase* instPointer,qt_QCString* filename);
void kde_KFilterBase_setOutBuffer(kde_KFilterBase* instPointer,char* data, unsigned int maxlen);
void kde_KFilterBase_setInBuffer(kde_KFilterBase* instPointer,char* data, unsigned int size);
int kde_KFilterBase_inBufferEmpty(kde_KFilterBase* instPointer);
int kde_KFilterBase_inBufferAvailable(kde_KFilterBase* instPointer);
int kde_KFilterBase_outBufferFull(kde_KFilterBase* instPointer);
int kde_KFilterBase_outBufferAvailable(kde_KFilterBase* instPointer);
int kde_KFilterBase_uncompress(kde_KFilterBase* instPointer);
int kde_KFilterBase_compress(kde_KFilterBase* instPointer,int finish);

/** *
 Call this to create the appropriate filter for the file
 named @p fileName.
     
*/
kde_KFilterBase* kde_KFilterBase_findFilterByFileName( qt_QString * fileName);

/** *
 Call this to create the appropriate filter for the mimetype
 @p mimeType. For instance application/x-gzip.
     
*/
kde_KFilterBase* kde_KFilterBase_findFilterByMimeType( qt_QString * mimeType);

#endif
