/***************************************************************************
                            kde_KEditToolbar.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KEDITTOOLBAR
#define KDE_KEDITTOOLBAR

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 This is a dialog used to customize or configure toolbars.

 This dialog only works if your application uses the XML UI
 framework for creating menus and toolbars.  It depends on the XML
 files to describe the toolbar layouts and it requires the actions
 to determine which buttons are active.

 Typically, you would include the @ref KStdAction::configureToolbars()
 standard action in your application.  In your slot to this action,
 you would have something like so:

 <pre>
 KEditToolbar dlg(actionCollection());
 if (dlg.exec())
 {
   createGUI();
 }
 </pre>

 That code snippet also takes care of redrawing the menu and
 toolbars if you have made any changes.

 If you are using KMainWindow's settings methods (either save/apply manually
 or autoSaveSettings), you should write something like:
 <pre>
 void MyClass::slotConfigureToolbars()
 {
   saveMainWindowSettings( KGlobal::config(), "MainWindow" );
   KEditToolbar dlg(actionCollection());
   connect(&dlg,SIGNAL(newToolbarConfig()),this,SLOT(slotNewToolbarConfig()));
   if (dlg.exec())
   {
      createGUI();
   }
 }

 void MyClass::slotNewToolbarConfig() // This is called when OK or Apply is clicked
 {
    ...if you use any action list, use plugActionList on each here...
    applyMainWindowSettings( KGlobal::config(), "MainWindow" );
 }
 </pre>

 Note that the procedure is a bit different for KParts applications.
 In this case, you need only pass along a pointer to your
 application's @ref KXMLGUIFactory object.  The editor will take care of
 finding all of the action collections and xml files.  The editor
 aims to be semi-intelligent about where it assigns any
 modifications.  In other words, it will not write out part specific
 changes to your shell's xml file.

 An example would be:

 <pre>
 saveMainWindowSettings( KGlobal::config(), "MainWindow" );
 KEditToolbar dlg(factory());
 connect(&dlg,SIGNAL(newToolbarConfig()),this,SLOT(slotNewToolbarConfig()));
 dlg.exec(); // Note that you shouldn't call createGUI(), so if() might not be even needed anymore

 ... // See above for slotNewToolbarConfig
 </pre>

 @author Kurt Granroth <granroth@kde.org>

 @short A dialog used to customize or configure toolbars.

*/

/** *
 Constructor for apps that do not use components.

 This is the
 only entry point to this class.  You @em must pass along your
 collection of actions (some of which appear in your toolbars).
 The other two parameters are optional.

 The second parameter, @ref xmlfile(), is the name (absolute or
 relative) of your application's UI resource file.  If it is
 left blank, then the resource file: share/apps/appname/appnameui.rc
 is used.  This is the same resource file that is used by the
 default @ref createGUI() function in @ref KMainWindow so you're usually
 pretty safe in leaving it blank.

 The third parameter, @ref global(), controls whether or not the
 global resource file is used.  If this is @p true, then you may
 edit all of the actions in your toolbars -- global ones and
 local one.  If it is @p false, then you may edit only your
 application's entries.  The only time you should set this to
 false is if your application does not use the global resource
 file at all (very rare).

*/
kde_KEditToolbar * kde_new_KEditToolbar(kde_KActionCollection* collection, qt_QString * xmlfile, int global, qt_QWidget * parent, char* name);

/** *
 Constructor for KParts based apps.

 The main parameter, @ref factory(), is a pointer to the
 XML GUI factory object for your application.  It contains a list
 of all of the GUI clients (along with the action collections and
 xml files) and the toolbar editor uses that.

 Use this like so:
 <pre>
 KEditToolbar edit(factory());
 if ( edit.exec() )
 ...
 </pre>

*/
kde_KEditToolbar * kde_new_KEditToolbar1(kde_KXMLGUIFactory* factory, qt_QWidget * parent, char* name);
void kde_del_KEditToolbar( kde_KEditToolbar* p );
void kde_KEditToolbar_virtual_hook(kde_KEditToolbar* instPointer,int identifier, void* data);

/** *
 Overridden in order to save any changes made to the toolbars
   
*/
void kde_KEditToolbar_slotOk(kde_KEditToolbar* instPointer);

/** *
 idem
   
*/
void kde_KEditToolbar_slotApply(kde_KEditToolbar* instPointer);

/** * should OK really save?

*/
void kde_KEditToolbar_acceptOK(kde_KEditToolbar* instPointer,int b);

#endif
