/*
    KSysGuard, the KDE System Guard
   
	Copyright (c) 1999-2001 Chris Schlaeger <cs@kde.org>
    
    This program is free software; you can redistribute it and/or
    modify it under the terms of version 2 of the GNU General Public
    License as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

	$Id: ksysguardd.h,v 1.3 2002/05/29 13:38:26 tokoe Exp $
*/

#ifndef _ksysguardd_h_
#define _ksysguardd_h_

#include <stdio.h>
#include <time.h>

/* This is the official ksysguardd port assigned by IANA. */
#define PORT_NUMBER	3112

/* Timer interval for checking modules */
#define TIMERINTERVAL	2

/* Timer interval for update modules */
#define UPDATEINTERVAL	2

extern int QuitApp;
extern int RunAsDaemon;

/* This pointer give you access to the client which made the request */
extern FILE* CurrentClient;

struct SensorModul {
	const char *configName;
	void (*initCommand)(struct SensorModul*);
	void (*exitCommand)(void);
	int (*updateCommand)(void);
	void (*checkCommand)(void);
	int available;
	time_t time;
};

#endif
