/*
  Copyright (c) 2000 Caldera Systems

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __pciinfo_h__
#define __pciinfo_h__

#include <qstring.h>
#include <qmap.h>

class PCIInfo
{
public:

    static bool lookupVendorAndDeviceID( const QString &busIDString, uint &vendorID, uint &deviceID );

    struct DeviceInfo
    {
        DeviceInfo() {}

        DeviceInfo( uint _vendorID, uint _deviceID )
            { vendorID = _vendorID; deviceID = _deviceID; }

        uint vendorID;
        uint deviceID;
    };

    typedef  QMap<QString, DeviceInfo> DeviceInfoMap;

private:
    static bool initStatic();

    static DeviceInfoMap *s_procBusPCIDevicesList; // parsed content of /proc/bus/pci/devices
    static bool s_initialized;
};

#endif
