/////////////////////////////////////////////////////////////////////////////
//      $Id: packageProperties.h,v 1.14.2.2 2002/12/19 09:10:59 mlaurent Exp $
// File  : packageProperties.h
// Author: Damyan Pepper
// Author: Toivo Pedaste
//
// This widget is used to provide a list of all the properties that are
// found in the package's property dictionary
//
/////////////////////////////////////////////////////////////////////////////

#ifndef PACKAGEPROPERTIES_H
#define PACKAGEPROPERTIES_H
#include "../config.h"

// Standard Headers

// Qt Headers
#include <qpainter.h>
#include <qstringlist.h>
#include <qregexp.h>

// KDE Headers
#include <klocale.h>
#include <ktextbrowser.h>

// kpackage Headers
#include "packageInfo.h"

class packageInfo;

class packagePropertiesWidget : public KTextBrowser
{
  Q_OBJECT
  ///////////// METHODS ------------------------------------------------------
public:

  packagePropertiesWidget(QWidget *parent=0);
  // constructor

  ~packagePropertiesWidget();
  // destructor

  void changePackage(packageInfo *p);

  void setSource( const QString & name );
  // url selected

protected:



  ///////////// DATA ---------------------------------------------------------
private:
  packageInfo *package;

  void initTranslate();
  void iList(QString txt, QString itxt);

  QDict<QString> trl ;
  // allow for translation of labels

  QStringList pList;
  // list specifying order of property distplay

  QStringList cList;
  // list giving order of currently displayed properties

  QString stmp;
  // text accumulation buffer

  void depends(QString f);
  // translate depends string

  void dor(QString f);
  // translate depends string

  void delement(QString f);
  // translate depends element
};


#endif
