#include "EditUpload.moc"
#include "EditUploadBase.h"
#include "ftpaccess.h"
#include "Permissions.h"

#include <qlabel.h>
#include <qtooltip.h>
#include <qcheckbox.h>
#include <qlistbox.h>

#include <klocale.h>
#include <kapplication.h>
#include <kurlrequester.h>

#include <pwd.h>
#include <grp.h>

EditUpload::EditUpload(ftpupload *u, QWidget * parent, char * wname)
 : KDialogBase(parent, wname, true, i18n("Edit Upload"),
               KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true)
{
	mWidget = new EditUploadBase(this);
	setMainWidget(mWidget); 
	if(u==0)
		upl=new ftpupload;
	else
		upl=u;

	mWidget->mayUpload->setChecked(upl->getAllow());
	mWidget->permissions->setValue(upl->getMode());
	mWidget->rootDir->setURL(upl->getRootDir());
	mWidget->dir->setURL(upl->getDirGlob());

	mWidget->rootDir->setMode(KFile::ExistingOnly | KFile::LocalOnly | KFile::Directory);
	mWidget->dir->setMode(KFile::ExistingOnly | KFile::LocalOnly | KFile::Directory);

	mWidget->chownTo->setEnabled(false);
	mWidget->chgrpTo->setEnabled(false);

        connect(mWidget->chown,SIGNAL(toggled(bool)),SLOT(chownPressed()));
        connect(mWidget->chownTo,SIGNAL(highlighted(const QString&)),SLOT(chownToPressed(const QString &)));
        {
            passwd *p;
            while((p=getpwent())!=0)
                  mWidget->chownTo->insertItem(p->pw_name);
            endpwent();
        }

	if(!upl->getOwner().isEmpty()) {
		QString o=upl->getOwner();
		for(unsigned int i=0;i<mWidget->chownTo->count();i++)
			if(o.lower() == mWidget->chownTo->text(i).lower())
				mWidget->chownTo->setSelected(i,true);
	}

        connect(mWidget->chgrp,SIGNAL(toggled(bool)),SLOT(chgrpPressed()));
        connect(mWidget->chgrpTo,SIGNAL(highlighted(const QString&)),SLOT(chgrpToPressed(const QString &)));
        {
            group *g;
            while((g=getgrent())!=0)
                mWidget->chgrpTo->insertItem(g->gr_name);
            endgrent();
        }
	if(!upl->getGroup().isEmpty()) {
		QString g=upl->getGroup();
		for(unsigned int i=0;i<mWidget->chgrpTo->count();i++)
			if (g.lower() == mWidget->chgrpTo->text(i).lower())
				mWidget->chownTo->setSelected(i,true);
	}

	if(!upl->getOwner().isEmpty())
		mWidget->chown->setChecked(true);
	if(!upl->getGroup().isEmpty())
		mWidget->chgrp->setChecked(true);

	mWidget->permitDirs->setChecked(upl->getPermitDirs());
}

EditUpload::~EditUpload()
{
}

QString getqlbtxt(QListBox const * const l)
{
	for(unsigned int i=0; i<l->count(); i++)
		if(l->isSelected(i))
			return l->text(i);
	return 0;
}
void EditUpload::slotOk()
{
    upl->setRootDir(mWidget->rootDir->url());
    upl->setDirGlob(mWidget->dir->url());
    upl->setAllow(mWidget->mayUpload->isChecked());
    if(!getqlbtxt(mWidget->chownTo).isEmpty())
        upl->setOwner(getqlbtxt(mWidget->chownTo));
    else
        upl->setOwner(0);
    if(!getqlbtxt(mWidget->chgrpTo).isEmpty())
        upl->setGroup(getqlbtxt(mWidget->chgrpTo));
    else
        upl->setGroup(0);
    upl->setMode(mWidget->permissions->value());
    upl->setPermitDirs(mWidget->permitDirs->isChecked());
//    upl->setDMode(permissionsDir->value());
    emit EditUploadDone(upl);
    accept();
}

void EditUpload::chownPressed()
{
    mWidget->chownTo->setEnabled(mWidget->chown->isChecked());
    if(!mWidget->chown->isChecked())
        for(unsigned int i=0;i<mWidget->chownTo->count();i++)
            mWidget->chownTo->setSelected(i,false);
}
void EditUpload::chownToPressed(const QString &)
{
    mWidget->chown->setChecked(true);
}

void EditUpload::chgrpPressed()
{
    mWidget->chgrpTo->setEnabled(mWidget->chgrp->isChecked());
    if(!mWidget->chgrp->isChecked())
        for(unsigned int i=0;i<mWidget->chgrpTo->count();i++)
            mWidget->chgrpTo->setSelected(i,false);
}
void EditUpload::chgrpToPressed(const QString &)
{
    mWidget->chgrp->setChecked(true);
}
