\variable{BACKUP_BY_COPYING}
\synopsis{Set the backup mode}
\usage{Int_Type BACKUP_BY_COPYING}
\description
 If non-zero, backup files will be made by copying the original file
 to the backup file.  If zero, the backup file will be created by
 renaming the original file to the backup file.  The default for
 \var{BACKUP_BY_COPYING} is zero because it is fastest.
\seealso{rename_file, copy_file}
\done

\function{IsHPFSFileSystem}
\synopsis{IsHPFSFileSystem}
\usage{Integer IsHPFSFileSystem(String path);}
\description
  Returns non-zero if drive of \var{path} (possibly the default drive) is
  HPFS.
\done

\function{change_default_dir}
\synopsis{change_default_dir}
\usage{Integer change_default_dir (String new_dir);}
\description
  This function may be used to change the current working directory
  of the editor to \var{new_dir}.  It returns zero upon success or \exmp{-1} upon
  failure.
  Note: Each buffer has its own working directory.  This function does not
  change the working directory of the buffer.  Rather, it changes the
  working directory of the whole editor.  This has an effect on functions
  such as \var{rename_file} when such functions are passed relative filenames.
\seealso{setbuf_info, getbuf_info, rename_file}
\done

\function{copy_file}
\synopsis{copy_file}
\usage{Integer copy_file (String src, String dest);}
\description
  This function may be used to copy a file named \var{src} to a new file
  named \var{dest}.  It attempts to preserve the file access and modification
  times as well as the ownership and protection.

  It returns \exmp{0} upon success and \exmp{-1} upon failure.
\seealso{rename_file, file_status}
\done

\function{delete_file}
\synopsis{delete_file}
\usage{Integer delete_file (String file);}
\description
  This function may be used to delete a file specified by the \var{file}
  parameter.  It returns non-zero if the file was sucessfully deleted
  or zero otherwise.
\seealso{rmdir}
\done

\function{directory}
\synopsis{directory}
\description
   returns number of files and list of files which match filename.
      On unix, this defaults to filename*.  It is primarily useful for
      DOS and VMS to expand wildcard filenames
\done

\function{expand_filename}
\synopsis{expand_filename}
\usage{String expand_filename (String file);}
\description
  The \var{expand_filename} function expands a file to a canonical form.
  For example, under Unix, if \var{file} has the value \exmp{"/a/b/../c/d"}, it
  returns \exmp{"/a/c/d"}.  Similarly, if \var{file} has the value
  \exmp{"/a/b/c//d/e"}, \exmp{"/d/e"} is returned.
\done

\function{extract_filename}
\synopsis{extract_filename}
\usage{String extract_filename (String filespec);}
\description
  This function may be used to separate the file name from the path of
  of a file specified by \var{filespec}.  For example, under Unix, the
  expression
#v+
        extract_filename ("/tmp/name");
#v-
  returns the string \exmp{"name"}.
\seealso{expand_filename}
\done

\function{file_changed_on_disk}
\synopsis{file_changed_on_disk}
\usage{Integer file_changed_on_disk (String fn);}
\description
  This function may be used to determine if the disk file specified by the
  parameter \var{fn} is more recent than the current buffer.
\seealso{file_time_compare, check_buffers}
\done

\function{file_status}
\synopsis{file_status}
\usage{Integer file_status (String filename);}
\description
  The \var{file_status} function returns information about a file specified
  by the name \var{filename}.  It returns an integer describing the file
  type:
   2     file is a directory
   1     file exists and is not a directory
   0     file does not exist.
  -1     no access.
  -2     path invalid
  -3     unknown error
\done

\function{file_time_compare}
\synopsis{file_time_compare}
\usage{Integer file_time_cmp (String file1, String file2);}
\description
  This function compares the modification times of two files,
  \var{file1} and \var{file2}. It returns an integer that is either
  positive, negative, or zero integer for \exmp{file1 > file2},
  \exmp{file1 < file2}, or \exmp{file1 == file2}, respectively.  In
  this context, the comparison operators are comparing file
  modification times.  That is, the operator \exmp{>} should be read
  ``is more recent than''.  The convention adopted by this routine is
  that if a file does not exist, its modification time is taken to be
  at the beginning of time.  Thus, if \var{f} exists, but \var{g} does
  not, the \exmp{file_time_compare (f, g)} will return a positive
  number. 
\seealso{file_status, time}
\done

\function{find_file}
\synopsis{find_file}
\usage{Integer find_file (String name);}
\description
  The \var{find_file} function switches to the buffer associated with the
  file specified by \var{name}.  If no such buffer exists, one is created
  and the file specified by \var{name} is read from the disk and associated
  with the new buffer.  The buffer will also become attached to the
  current window.  Use the \var{read_file} function to find a file but not
  associate it with the current window.
\seealso{read_file}
\done

\function{insert_file}
\synopsis{insert_file}
\usage{Integer insert_file (String f);}
\description
  This function may be used to insert the contents of a file named \var{f}
  into the buffer at the current position.  The current editing point
  will be placed at the end of the inserted text.  The function returns
  \exmp{-1} if the file was unable to be opened; otherwise it returns the
  number of lines inserted.  This number can be zero if the file is empty.
\seealso{read_file, find_file, insert}
\done

\function{msdos_fixup_dirspec}
\synopsis{msdos_fixup_dirspec}
\usage{String msdos_fixup_dirspec (String dir);}
\description
  The motivation behind this is that DOS does not like a trailing
  backslash except if it is for the root dir.  This function makes
  \var{dir} conform to that.
\done

\function{read_file}
\synopsis{read_file}
\usage{Integer read_file (string fn);}
\description
  The \var{read_file} function may be used to read a file specified by \var{fn}
  into its own buffer.  It returns a non-zero value upon success and
  signals an error upon failure.  The hook \var{find_file_hook} is called
  after the file is read in.  Unlike the related function, \var{find_file},
  this function does not create a window for the newly created buffer.
\seealso{find_file, file_status, write_buffer}
\done

\function{rename_file}
\synopsis{rename_file}
\usage{Integer rename_file (String old_name, String new_name);}
\description
  This function may be used to change the name of a disk file from
  \var{old_name} to \var{new_name}.  Upon success, zero is returned.  Any other
  value indicates failure.
  Note: Both filenames must refer to the same file system.
\seealso{file_status, stat_file}
\done

\function{set_file_translation}
\synopsis{set_file_translation}
\usage{set_file_translation (Integer n);}
\description
  This function affects only the way the next file is opened.  Its
  affect does not last beyond that.  If it the value of the parameter
  is 1, the next file will be opened in binary mode.  If the parameter is
  zero, the file will be opened in text mode.
\done

