/* this file was generated by the MCOP idl compiler - DO NOT EDIT */

#ifndef ARTSBUILDER_H
#define ARTSBUILDER_H

#include "common.h"

// includes of other idl definitions
#include "core.h"
#include "artsflow.h"

namespace Arts {
enum PortDirection {input = 0, output = 1};
enum PortConnType {conn_stream = 0, conn_event = 1, conn_property = 2};
}
namespace Arts {
class PortType : public Arts::Type {
public:
	PortType();
	PortType(Arts::PortDirection _a_direction, const std::string& _a_dataType, Arts::PortConnType _a_connType, bool _a_isMultiPort);
	PortType(Arts::Buffer& stream);
	PortType(const PortType& copyType);
	PortType& operator=(const PortType& assignType);
	Arts::PortDirection direction;
	std::string dataType;
	Arts::PortConnType connType;
	bool isMultiPort;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
	std::string _typeName() const;
};

class ModuleInfo : public Arts::Type {
public:
	ModuleInfo();
	ModuleInfo(const std::string& _a_name, const std::vector<Arts::PortType>& _a_ports, const std::vector<std::string>& _a_portnames, bool _a_isInterface, bool _a_isStructure);
	ModuleInfo(Arts::Buffer& stream);
	ModuleInfo(const ModuleInfo& copyType);
	ModuleInfo& operator=(const ModuleInfo& assignType);
	std::string name;
	std::vector<Arts::PortType> ports;
	std::vector<std::string> portnames;
	bool isInterface;
	bool isStructure;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
	std::string _typeName() const;
};

}
namespace Arts {
class PortDesc;
class ModuleDesc;
class StructureDesc;
class StructurePortDesc;
class ObjectFactory;
class LocalFactory;
class StructureBuilder;
class ArtsBuilderLoader;
class Structure;

class PortDesc_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static PortDesc_base *_create(const std::string& subClass = "Arts::PortDesc");
	static PortDesc_base *_fromString(const std::string& objectref);
	static PortDesc_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static PortDesc_base *_fromDynamicCast(const Arts::Object& object);
	inline PortDesc_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long ID() = 0;
	virtual Arts::ModuleDesc parent() = 0;
	virtual std::string name() = 0;
	virtual Arts::PortType type() = 0;
	virtual bool isConnected() = 0;
	virtual bool hasValue() = 0;
	virtual void hasValue(bool newValue) = 0;
	virtual std::vector<Arts::PortDesc> * connections() = 0;
	virtual float floatValue() = 0;
	virtual void floatValue(float newValue) = 0;
	virtual std::string stringValue() = 0;
	virtual void stringValue(const std::string& newValue) = 0;
	virtual Arts::Any value() = 0;
	virtual void value(const Arts::Any& newValue) = 0;
	virtual long internalOldID() = 0;
	virtual void constructor(Arts::ModuleDesc parent, const std::string& name, const Arts::PortType& type) = 0;
	virtual bool connectTo(Arts::PortDesc port) = 0;
	virtual void disconnectFrom(Arts::PortDesc port) = 0;
	virtual void disconnectAll() = 0;
	virtual std::vector<std::string> * saveToList() = 0;
	virtual void loadFromList(const std::vector<std::string>& list) = 0;
	virtual void internalConnectInput(Arts::PortDesc port) = 0;
	virtual void internalReConnect(const std::vector<Arts::PortDesc>& allports) = 0;
};

class PortDesc_stub : virtual public PortDesc_base, virtual public Arts::Object_stub {
protected:
	PortDesc_stub();

public:
	PortDesc_stub(Arts::Connection *connection, long objectID);

	long ID();
	Arts::ModuleDesc parent();
	std::string name();
	Arts::PortType type();
	bool isConnected();
	bool hasValue();
	void hasValue(bool newValue);
	std::vector<Arts::PortDesc> * connections();
	float floatValue();
	void floatValue(float newValue);
	std::string stringValue();
	void stringValue(const std::string& newValue);
	Arts::Any value();
	void value(const Arts::Any& newValue);
	long internalOldID();
	void constructor(Arts::ModuleDesc parent, const std::string& name, const Arts::PortType& type);
	bool connectTo(Arts::PortDesc port);
	void disconnectFrom(Arts::PortDesc port);
	void disconnectAll();
	std::vector<std::string> * saveToList();
	void loadFromList(const std::vector<std::string>& list);
	void internalConnectInput(Arts::PortDesc port);
	void internalReConnect(const std::vector<Arts::PortDesc>& allports);
};

class PortDesc_skel : virtual public PortDesc_base, virtual public Arts::Object_skel {
protected:
	// emitters for change notifications
	inline void ID_changed(long newValue) {
		_emit_changed("ID_changed",newValue);
	}
	inline void name_changed(const std::string& newValue) {
		_emit_changed("name_changed",newValue);
	}
	inline void isConnected_changed(bool newValue) {
		_emit_changed("isConnected_changed",newValue);
	}
	inline void hasValue_changed(bool newValue) {
		_emit_changed("hasValue_changed",newValue);
	}
	inline void floatValue_changed(float newValue) {
		_emit_changed("floatValue_changed",newValue);
	}
	inline void stringValue_changed(const std::string& newValue) {
		_emit_changed("stringValue_changed",newValue);
	}
	inline void internalOldID_changed(long newValue) {
		_emit_changed("internalOldID_changed",newValue);
	}

public:
	PortDesc_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class PortDesc : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	PortDesc_base *_cache;
	inline PortDesc_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(PortDesc_base *)_pool->base->_cast(PortDesc_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline PortDesc(PortDesc_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef PortDesc_base _base_class;

	inline PortDesc() : Arts::Object(_Creator), _cache(0) {}
	inline PortDesc(const Arts::SubClass& s) :
		Arts::Object(PortDesc_base::_create(s.string())), _cache(0) {}
	inline PortDesc(const Arts::Reference &r) :
		Arts::Object(r.isString()?(PortDesc_base::_fromString(r.string())):(PortDesc_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline PortDesc(const Arts::DynamicCast& c) : Arts::Object(PortDesc_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline PortDesc(const PortDesc& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline PortDesc(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static PortDesc null() {return PortDesc((PortDesc_base*)0);}
	inline static PortDesc _from_base(PortDesc_base* b) {return PortDesc(b);}
	inline PortDesc& operator=(const PortDesc& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline PortDesc_base* _base() {return _cache?_cache:_method_call();}

	inline long ID();
	inline Arts::ModuleDesc parent();
	inline std::string name();
	inline Arts::PortType type();
	inline bool isConnected();
	inline bool hasValue();
	inline void hasValue(bool _newValue);
	inline std::vector<Arts::PortDesc> * connections();
	inline float floatValue();
	inline void floatValue(float _newValue);
	inline std::string stringValue();
	inline void stringValue(const std::string& _newValue);
	inline Arts::Any value();
	inline void value(const Arts::Any& _newValue);
	inline long internalOldID();
	inline PortDesc(Arts::ModuleDesc parent, const std::string& name, const Arts::PortType& type);
	inline bool connectTo(Arts::PortDesc port);
	inline void disconnectFrom(Arts::PortDesc port);
	inline void disconnectAll();
	inline std::vector<std::string> * saveToList();
	inline void loadFromList(const std::vector<std::string>& list);
	inline void internalConnectInput(Arts::PortDesc port);
	inline void internalReConnect(const std::vector<Arts::PortDesc>& allports);
};

class ModuleDesc_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static ModuleDesc_base *_create(const std::string& subClass = "Arts::ModuleDesc");
	static ModuleDesc_base *_fromString(const std::string& objectref);
	static ModuleDesc_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static ModuleDesc_base *_fromDynamicCast(const Arts::Object& object);
	inline ModuleDesc_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long ID() = 0;
	virtual Arts::StructureDesc parent() = 0;
	virtual std::string name() = 0;
	virtual std::vector<Arts::PortDesc> * ports() = 0;
	virtual long x() = 0;
	virtual long y() = 0;
	virtual long width() = 0;
	virtual long height() = 0;
	virtual bool isInterface() = 0;
	virtual bool isStructure() = 0;
	virtual void constructor(Arts::StructureDesc parent, const Arts::ModuleInfo& info) = 0;
	virtual bool moveTo(long x, long y) = 0;
	virtual Arts::PortDesc findPort(const std::string& name) = 0;
	virtual std::vector<std::string> * saveToList() = 0;
	virtual void loadFromList(const std::vector<std::string>& list) = 0;
};

class ModuleDesc_stub : virtual public ModuleDesc_base, virtual public Arts::Object_stub {
protected:
	ModuleDesc_stub();

public:
	ModuleDesc_stub(Arts::Connection *connection, long objectID);

	long ID();
	Arts::StructureDesc parent();
	std::string name();
	std::vector<Arts::PortDesc> * ports();
	long x();
	long y();
	long width();
	long height();
	bool isInterface();
	bool isStructure();
	void constructor(Arts::StructureDesc parent, const Arts::ModuleInfo& info);
	bool moveTo(long x, long y);
	Arts::PortDesc findPort(const std::string& name);
	std::vector<std::string> * saveToList();
	void loadFromList(const std::vector<std::string>& list);
};

class ModuleDesc_skel : virtual public ModuleDesc_base, virtual public Arts::Object_skel {
protected:
	// emitters for change notifications
	inline void ID_changed(long newValue) {
		_emit_changed("ID_changed",newValue);
	}
	inline void name_changed(const std::string& newValue) {
		_emit_changed("name_changed",newValue);
	}
	inline void x_changed(long newValue) {
		_emit_changed("x_changed",newValue);
	}
	inline void y_changed(long newValue) {
		_emit_changed("y_changed",newValue);
	}
	inline void width_changed(long newValue) {
		_emit_changed("width_changed",newValue);
	}
	inline void height_changed(long newValue) {
		_emit_changed("height_changed",newValue);
	}
	inline void isInterface_changed(bool newValue) {
		_emit_changed("isInterface_changed",newValue);
	}
	inline void isStructure_changed(bool newValue) {
		_emit_changed("isStructure_changed",newValue);
	}

public:
	ModuleDesc_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ModuleDesc : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	ModuleDesc_base *_cache;
	inline ModuleDesc_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(ModuleDesc_base *)_pool->base->_cast(ModuleDesc_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline ModuleDesc(ModuleDesc_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef ModuleDesc_base _base_class;

	inline ModuleDesc() : Arts::Object(_Creator), _cache(0) {}
	inline ModuleDesc(const Arts::SubClass& s) :
		Arts::Object(ModuleDesc_base::_create(s.string())), _cache(0) {}
	inline ModuleDesc(const Arts::Reference &r) :
		Arts::Object(r.isString()?(ModuleDesc_base::_fromString(r.string())):(ModuleDesc_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline ModuleDesc(const Arts::DynamicCast& c) : Arts::Object(ModuleDesc_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline ModuleDesc(const ModuleDesc& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline ModuleDesc(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static ModuleDesc null() {return ModuleDesc((ModuleDesc_base*)0);}
	inline static ModuleDesc _from_base(ModuleDesc_base* b) {return ModuleDesc(b);}
	inline ModuleDesc& operator=(const ModuleDesc& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline ModuleDesc_base* _base() {return _cache?_cache:_method_call();}

	inline long ID();
	inline Arts::StructureDesc parent();
	inline std::string name();
	inline std::vector<Arts::PortDesc> * ports();
	inline long x();
	inline long y();
	inline long width();
	inline long height();
	inline bool isInterface();
	inline bool isStructure();
	inline ModuleDesc(Arts::StructureDesc parent, const Arts::ModuleInfo& info);
	inline bool moveTo(long x, long y);
	inline Arts::PortDesc findPort(const std::string& name);
	inline std::vector<std::string> * saveToList();
	inline void loadFromList(const std::vector<std::string>& list);
};

class StructureDesc_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static StructureDesc_base *_create(const std::string& subClass = "Arts::StructureDesc");
	static StructureDesc_base *_fromString(const std::string& objectref);
	static StructureDesc_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static StructureDesc_base *_fromDynamicCast(const Arts::Object& object);
	inline StructureDesc_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual bool valid() = 0;
	virtual std::string name() = 0;
	virtual void name(const std::string& newValue) = 0;
	virtual std::vector<Arts::ModuleDesc> * modules() = 0;
	virtual std::vector<Arts::StructurePortDesc> * ports() = 0;
	virtual std::vector<std::string> * inheritedInterfaces() = 0;
	virtual Arts::ModuleInfo externalInterface() = 0;
	virtual long obtainID() = 0;
	virtual std::vector<std::string> * saveToList() = 0;
	virtual void loadFromList(const std::vector<std::string>& list) = 0;
	virtual void clear() = 0;
	virtual Arts::ModuleDesc createModuleDesc(const Arts::ModuleInfo& info) = 0;
	virtual void freeModuleDesc(Arts::ModuleDesc moduledesc) = 0;
	virtual Arts::StructurePortDesc createStructurePortDesc(const Arts::PortType& type, const std::string& name) = 0;
	virtual void freeStructurePortDesc(Arts::StructurePortDesc portdesc) = 0;
	virtual void moveStructurePortDesc(Arts::StructurePortDesc portdesc, long newposition) = 0;
	virtual void addInheritedInterface(const std::string& iface) = 0;
	virtual void removeInheritedInterface(const std::string& iface) = 0;
};

class StructureDesc_stub : virtual public StructureDesc_base, virtual public Arts::Object_stub {
protected:
	StructureDesc_stub();

public:
	StructureDesc_stub(Arts::Connection *connection, long objectID);

	bool valid();
	std::string name();
	void name(const std::string& newValue);
	std::vector<Arts::ModuleDesc> * modules();
	std::vector<Arts::StructurePortDesc> * ports();
	std::vector<std::string> * inheritedInterfaces();
	Arts::ModuleInfo externalInterface();
	long obtainID();
	std::vector<std::string> * saveToList();
	void loadFromList(const std::vector<std::string>& list);
	void clear();
	Arts::ModuleDesc createModuleDesc(const Arts::ModuleInfo& info);
	void freeModuleDesc(Arts::ModuleDesc moduledesc);
	Arts::StructurePortDesc createStructurePortDesc(const Arts::PortType& type, const std::string& name);
	void freeStructurePortDesc(Arts::StructurePortDesc portdesc);
	void moveStructurePortDesc(Arts::StructurePortDesc portdesc, long newposition);
	void addInheritedInterface(const std::string& iface);
	void removeInheritedInterface(const std::string& iface);
};

class StructureDesc_skel : virtual public StructureDesc_base, virtual public Arts::Object_skel {
protected:
	// emitters for change notifications
	inline void valid_changed(bool newValue) {
		_emit_changed("valid_changed",newValue);
	}
	inline void name_changed(const std::string& newValue) {
		_emit_changed("name_changed",newValue);
	}
	inline void inheritedInterfaces_changed(const std::vector<std::string>& newValue) {
		_emit_changed("inheritedInterfaces_changed",newValue);
	}

public:
	StructureDesc_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class StructureDesc : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	StructureDesc_base *_cache;
	inline StructureDesc_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(StructureDesc_base *)_pool->base->_cast(StructureDesc_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline StructureDesc(StructureDesc_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef StructureDesc_base _base_class;

	inline StructureDesc() : Arts::Object(_Creator), _cache(0) {}
	inline StructureDesc(const Arts::SubClass& s) :
		Arts::Object(StructureDesc_base::_create(s.string())), _cache(0) {}
	inline StructureDesc(const Arts::Reference &r) :
		Arts::Object(r.isString()?(StructureDesc_base::_fromString(r.string())):(StructureDesc_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline StructureDesc(const Arts::DynamicCast& c) : Arts::Object(StructureDesc_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline StructureDesc(const StructureDesc& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline StructureDesc(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static StructureDesc null() {return StructureDesc((StructureDesc_base*)0);}
	inline static StructureDesc _from_base(StructureDesc_base* b) {return StructureDesc(b);}
	inline StructureDesc& operator=(const StructureDesc& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline StructureDesc_base* _base() {return _cache?_cache:_method_call();}

	inline bool valid();
	inline std::string name();
	inline void name(const std::string& _newValue);
	inline std::vector<Arts::ModuleDesc> * modules();
	inline std::vector<Arts::StructurePortDesc> * ports();
	inline std::vector<std::string> * inheritedInterfaces();
	inline Arts::ModuleInfo externalInterface();
	inline long obtainID();
	inline std::vector<std::string> * saveToList();
	inline void loadFromList(const std::vector<std::string>& list);
	inline void clear();
	inline Arts::ModuleDesc createModuleDesc(const Arts::ModuleInfo& info);
	inline void freeModuleDesc(Arts::ModuleDesc moduledesc);
	inline Arts::StructurePortDesc createStructurePortDesc(const Arts::PortType& type, const std::string& name);
	inline void freeStructurePortDesc(Arts::StructurePortDesc portdesc);
	inline void moveStructurePortDesc(Arts::StructurePortDesc portdesc, long newposition);
	inline void addInheritedInterface(const std::string& iface);
	inline void removeInheritedInterface(const std::string& iface);
};

class StructurePortDesc_base : virtual public Arts::PortDesc_base {
public:
	static unsigned long _IID; // interface ID

	static StructurePortDesc_base *_create(const std::string& subClass = "Arts::StructurePortDesc");
	static StructurePortDesc_base *_fromString(const std::string& objectref);
	static StructurePortDesc_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static StructurePortDesc_base *_fromDynamicCast(const Arts::Object& object);
	inline StructurePortDesc_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long x() = 0;
	virtual long y() = 0;
	virtual long position() = 0;
	virtual Arts::StructureDesc parentStructure() = 0;
	virtual std::string inheritedInterface() = 0;
	virtual void inheritedInterface(const std::string& newValue) = 0;
	virtual void constructor(Arts::StructureDesc parent, const std::string& name, const Arts::PortType& type) = 0;
	virtual bool moveTo(long x, long y) = 0;
	virtual void lowerPosition() = 0;
	virtual void raisePosition() = 0;
	virtual void rename(const std::string& newname) = 0;
	virtual void internalSetPosition(long position) = 0;
};

class StructurePortDesc_stub : virtual public StructurePortDesc_base, virtual public Arts::PortDesc_stub {
protected:
	StructurePortDesc_stub();

public:
	StructurePortDesc_stub(Arts::Connection *connection, long objectID);

	long x();
	long y();
	long position();
	Arts::StructureDesc parentStructure();
	std::string inheritedInterface();
	void inheritedInterface(const std::string& newValue);
	void constructor(Arts::StructureDesc parent, const std::string& name, const Arts::PortType& type);
	bool moveTo(long x, long y);
	void lowerPosition();
	void raisePosition();
	void rename(const std::string& newname);
	void internalSetPosition(long position);
};

class StructurePortDesc_skel : virtual public StructurePortDesc_base, virtual public Arts::PortDesc_skel {
protected:
	// emitters for change notifications
	inline void x_changed(long newValue) {
		_emit_changed("x_changed",newValue);
	}
	inline void y_changed(long newValue) {
		_emit_changed("y_changed",newValue);
	}
	inline void position_changed(long newValue) {
		_emit_changed("position_changed",newValue);
	}
	inline void inheritedInterface_changed(const std::string& newValue) {
		_emit_changed("inheritedInterface_changed",newValue);
	}

public:
	StructurePortDesc_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class StructurePortDesc : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	StructurePortDesc_base *_cache;
	inline StructurePortDesc_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(StructurePortDesc_base *)_pool->base->_cast(StructurePortDesc_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline StructurePortDesc(StructurePortDesc_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef StructurePortDesc_base _base_class;

	inline StructurePortDesc() : Arts::Object(_Creator), _cache(0) {}
	inline StructurePortDesc(const Arts::SubClass& s) :
		Arts::Object(StructurePortDesc_base::_create(s.string())), _cache(0) {}
	inline StructurePortDesc(const Arts::Reference &r) :
		Arts::Object(r.isString()?(StructurePortDesc_base::_fromString(r.string())):(StructurePortDesc_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline StructurePortDesc(const Arts::DynamicCast& c) : Arts::Object(StructurePortDesc_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline StructurePortDesc(const StructurePortDesc& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline StructurePortDesc(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static StructurePortDesc null() {return StructurePortDesc((StructurePortDesc_base*)0);}
	inline static StructurePortDesc _from_base(StructurePortDesc_base* b) {return StructurePortDesc(b);}
	inline StructurePortDesc& operator=(const StructurePortDesc& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::PortDesc() const { return Arts::PortDesc(*_pool); }
	inline StructurePortDesc_base* _base() {return _cache?_cache:_method_call();}

	inline long ID();
	inline Arts::ModuleDesc parent();
	inline std::string name();
	inline Arts::PortType type();
	inline bool isConnected();
	inline bool hasValue();
	inline void hasValue(bool _newValue);
	inline std::vector<Arts::PortDesc> * connections();
	inline float floatValue();
	inline void floatValue(float _newValue);
	inline std::string stringValue();
	inline void stringValue(const std::string& _newValue);
	inline Arts::Any value();
	inline void value(const Arts::Any& _newValue);
	inline long internalOldID();
	inline StructurePortDesc(Arts::ModuleDesc parent, const std::string& name, const Arts::PortType& type);
	inline bool connectTo(Arts::PortDesc port);
	inline void disconnectFrom(Arts::PortDesc port);
	inline void disconnectAll();
	inline std::vector<std::string> * saveToList();
	inline void loadFromList(const std::vector<std::string>& list);
	inline void internalConnectInput(Arts::PortDesc port);
	inline void internalReConnect(const std::vector<Arts::PortDesc>& allports);
	inline long x();
	inline long y();
	inline long position();
	inline Arts::StructureDesc parentStructure();
	inline std::string inheritedInterface();
	inline void inheritedInterface(const std::string& _newValue);
	inline StructurePortDesc(Arts::StructureDesc parent, const std::string& name, const Arts::PortType& type);
	inline bool moveTo(long x, long y);
	inline void lowerPosition();
	inline void raisePosition();
	inline void rename(const std::string& newname);
	inline void internalSetPosition(long position);
};

class ObjectFactory_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static ObjectFactory_base *_create(const std::string& subClass = "Arts::ObjectFactory");
	static ObjectFactory_base *_fromString(const std::string& objectref);
	static ObjectFactory_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static ObjectFactory_base *_fromDynamicCast(const Arts::Object& object);
	inline ObjectFactory_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::Object createObject(const std::string& name) = 0;
};

class ObjectFactory_stub : virtual public ObjectFactory_base, virtual public Arts::Object_stub {
protected:
	ObjectFactory_stub();

public:
	ObjectFactory_stub(Arts::Connection *connection, long objectID);

	Arts::Object createObject(const std::string& name);
};

class ObjectFactory_skel : virtual public ObjectFactory_base, virtual public Arts::Object_skel {
public:
	ObjectFactory_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ObjectFactory : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	ObjectFactory_base *_cache;
	inline ObjectFactory_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(ObjectFactory_base *)_pool->base->_cast(ObjectFactory_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline ObjectFactory(ObjectFactory_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef ObjectFactory_base _base_class;

	inline ObjectFactory() : Arts::Object(_Creator), _cache(0) {}
	inline ObjectFactory(const Arts::SubClass& s) :
		Arts::Object(ObjectFactory_base::_create(s.string())), _cache(0) {}
	inline ObjectFactory(const Arts::Reference &r) :
		Arts::Object(r.isString()?(ObjectFactory_base::_fromString(r.string())):(ObjectFactory_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline ObjectFactory(const Arts::DynamicCast& c) : Arts::Object(ObjectFactory_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline ObjectFactory(const ObjectFactory& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline ObjectFactory(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static ObjectFactory null() {return ObjectFactory((ObjectFactory_base*)0);}
	inline static ObjectFactory _from_base(ObjectFactory_base* b) {return ObjectFactory(b);}
	inline ObjectFactory& operator=(const ObjectFactory& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline ObjectFactory_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::Object createObject(const std::string& name);
};

class LocalFactory_base : virtual public Arts::ObjectFactory_base {
public:
	static unsigned long _IID; // interface ID

	static LocalFactory_base *_create(const std::string& subClass = "Arts::LocalFactory");
	static LocalFactory_base *_fromString(const std::string& objectref);
	static LocalFactory_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static LocalFactory_base *_fromDynamicCast(const Arts::Object& object);
	inline LocalFactory_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class LocalFactory_stub : virtual public LocalFactory_base, virtual public Arts::ObjectFactory_stub {
protected:
	LocalFactory_stub();

public:
	LocalFactory_stub(Arts::Connection *connection, long objectID);

};

class LocalFactory_skel : virtual public LocalFactory_base, virtual public Arts::ObjectFactory_skel {
public:
	LocalFactory_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class LocalFactory : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	LocalFactory_base *_cache;
	inline LocalFactory_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(LocalFactory_base *)_pool->base->_cast(LocalFactory_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline LocalFactory(LocalFactory_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef LocalFactory_base _base_class;

	inline LocalFactory() : Arts::Object(_Creator), _cache(0) {}
	inline LocalFactory(const Arts::SubClass& s) :
		Arts::Object(LocalFactory_base::_create(s.string())), _cache(0) {}
	inline LocalFactory(const Arts::Reference &r) :
		Arts::Object(r.isString()?(LocalFactory_base::_fromString(r.string())):(LocalFactory_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline LocalFactory(const Arts::DynamicCast& c) : Arts::Object(LocalFactory_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline LocalFactory(const LocalFactory& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline LocalFactory(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static LocalFactory null() {return LocalFactory((LocalFactory_base*)0);}
	inline static LocalFactory _from_base(LocalFactory_base* b) {return LocalFactory(b);}
	inline LocalFactory& operator=(const LocalFactory& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::ObjectFactory() const { return Arts::ObjectFactory(*_pool); }
	inline LocalFactory_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::Object createObject(const std::string& name);
};

class StructureBuilder_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static StructureBuilder_base *_create(const std::string& subClass = "Arts::StructureBuilder");
	static StructureBuilder_base *_fromString(const std::string& objectref);
	static StructureBuilder_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static StructureBuilder_base *_fromDynamicCast(const Arts::Object& object);
	inline StructureBuilder_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual void addFactory(Arts::ObjectFactory factory) = 0;
	virtual Arts::Object createObject(Arts::StructureDesc structure) = 0;
	virtual Arts::ModuleDef createTypeInfo(Arts::StructureDesc structure) = 0;
};

class StructureBuilder_stub : virtual public StructureBuilder_base, virtual public Arts::Object_stub {
protected:
	StructureBuilder_stub();

public:
	StructureBuilder_stub(Arts::Connection *connection, long objectID);

	void addFactory(Arts::ObjectFactory factory);
	Arts::Object createObject(Arts::StructureDesc structure);
	Arts::ModuleDef createTypeInfo(Arts::StructureDesc structure);
};

class StructureBuilder_skel : virtual public StructureBuilder_base, virtual public Arts::Object_skel {
public:
	StructureBuilder_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class StructureBuilder : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	StructureBuilder_base *_cache;
	inline StructureBuilder_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(StructureBuilder_base *)_pool->base->_cast(StructureBuilder_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline StructureBuilder(StructureBuilder_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef StructureBuilder_base _base_class;

	inline StructureBuilder() : Arts::Object(_Creator), _cache(0) {}
	inline StructureBuilder(const Arts::SubClass& s) :
		Arts::Object(StructureBuilder_base::_create(s.string())), _cache(0) {}
	inline StructureBuilder(const Arts::Reference &r) :
		Arts::Object(r.isString()?(StructureBuilder_base::_fromString(r.string())):(StructureBuilder_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline StructureBuilder(const Arts::DynamicCast& c) : Arts::Object(StructureBuilder_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline StructureBuilder(const StructureBuilder& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline StructureBuilder(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static StructureBuilder null() {return StructureBuilder((StructureBuilder_base*)0);}
	inline static StructureBuilder _from_base(StructureBuilder_base* b) {return StructureBuilder(b);}
	inline StructureBuilder& operator=(const StructureBuilder& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline StructureBuilder_base* _base() {return _cache?_cache:_method_call();}

	inline void addFactory(Arts::ObjectFactory factory);
	inline Arts::Object createObject(Arts::StructureDesc structure);
	inline Arts::ModuleDef createTypeInfo(Arts::StructureDesc structure);
};

class ArtsBuilderLoader_base : virtual public Arts::Loader_base {
public:
	static unsigned long _IID; // interface ID

	static ArtsBuilderLoader_base *_create(const std::string& subClass = "Arts::ArtsBuilderLoader");
	static ArtsBuilderLoader_base *_fromString(const std::string& objectref);
	static ArtsBuilderLoader_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static ArtsBuilderLoader_base *_fromDynamicCast(const Arts::Object& object);
	inline ArtsBuilderLoader_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class ArtsBuilderLoader_stub : virtual public ArtsBuilderLoader_base, virtual public Arts::Loader_stub {
protected:
	ArtsBuilderLoader_stub();

public:
	ArtsBuilderLoader_stub(Arts::Connection *connection, long objectID);

};

class ArtsBuilderLoader_skel : virtual public ArtsBuilderLoader_base, virtual public Arts::Loader_skel {
public:
	ArtsBuilderLoader_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ArtsBuilderLoader : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	ArtsBuilderLoader_base *_cache;
	inline ArtsBuilderLoader_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(ArtsBuilderLoader_base *)_pool->base->_cast(ArtsBuilderLoader_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline ArtsBuilderLoader(ArtsBuilderLoader_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef ArtsBuilderLoader_base _base_class;

	inline ArtsBuilderLoader() : Arts::Object(_Creator), _cache(0) {}
	inline ArtsBuilderLoader(const Arts::SubClass& s) :
		Arts::Object(ArtsBuilderLoader_base::_create(s.string())), _cache(0) {}
	inline ArtsBuilderLoader(const Arts::Reference &r) :
		Arts::Object(r.isString()?(ArtsBuilderLoader_base::_fromString(r.string())):(ArtsBuilderLoader_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline ArtsBuilderLoader(const Arts::DynamicCast& c) : Arts::Object(ArtsBuilderLoader_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline ArtsBuilderLoader(const ArtsBuilderLoader& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline ArtsBuilderLoader(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static ArtsBuilderLoader null() {return ArtsBuilderLoader((ArtsBuilderLoader_base*)0);}
	inline static ArtsBuilderLoader _from_base(ArtsBuilderLoader_base* b) {return ArtsBuilderLoader(b);}
	inline ArtsBuilderLoader& operator=(const ArtsBuilderLoader& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Loader() const { return Arts::Loader(*_pool); }
	inline ArtsBuilderLoader_base* _base() {return _cache?_cache:_method_call();}

	inline std::string dataVersion();
	inline std::vector<Arts::TraderEntry> * traderEntries();
	inline std::vector<Arts::ModuleDef> * modules();
	inline Arts::Object loadObject(Arts::TraderOffer offer);
};

class Structure_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Structure_base *_create(const std::string& subClass = "Arts::Structure");
	static Structure_base *_fromString(const std::string& objectref);
	static Structure_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Structure_base *_fromDynamicCast(const Arts::Object& object);
	inline Structure_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual void run() = 0;
	virtual void halt() = 0;
};

class Structure_stub : virtual public Structure_base, virtual public Arts::SynthModule_stub {
protected:
	Structure_stub();

public:
	Structure_stub(Arts::Connection *connection, long objectID);

	void run();
	void halt();
};

class Structure_skel : virtual public Structure_base, virtual public Arts::SynthModule_skel {
public:
	Structure_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class Structure : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Structure_base *_cache;
	inline Structure_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Structure_base *)_pool->base->_cast(Structure_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Structure(Structure_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Structure_base _base_class;

	inline Structure() : Arts::Object(_Creator), _cache(0) {}
	inline Structure(const Arts::SubClass& s) :
		Arts::Object(Structure_base::_create(s.string())), _cache(0) {}
	inline Structure(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Structure_base::_fromString(r.string())):(Structure_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Structure(const Arts::DynamicCast& c) : Arts::Object(Structure_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Structure(const Structure& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Structure(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Structure null() {return Structure((Structure_base*)0);}
	inline static Structure _from_base(Structure_base* b) {return Structure(b);}
	inline Structure& operator=(const Structure& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Structure_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline void run();
	inline void halt();
};

}
// Forward wrapper calls to _base classes:

inline long Arts::PortDesc::ID()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->ID():static_cast<Arts::PortDesc_base*>(_method_call())->ID();
}

inline Arts::ModuleDesc Arts::PortDesc::parent()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->parent():static_cast<Arts::PortDesc_base*>(_method_call())->parent();
}

inline std::string Arts::PortDesc::name()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->name():static_cast<Arts::PortDesc_base*>(_method_call())->name();
}

inline Arts::PortType Arts::PortDesc::type()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->type():static_cast<Arts::PortDesc_base*>(_method_call())->type();
}

inline bool Arts::PortDesc::isConnected()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->isConnected():static_cast<Arts::PortDesc_base*>(_method_call())->isConnected();
}

inline bool Arts::PortDesc::hasValue()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->hasValue():static_cast<Arts::PortDesc_base*>(_method_call())->hasValue();
}

inline void Arts::PortDesc::hasValue(bool _newValue)
{
	 _cache?static_cast<Arts::PortDesc_base*>(_cache)->hasValue(_newValue):static_cast<Arts::PortDesc_base*>(_method_call())->hasValue(_newValue);
}

inline std::vector<Arts::PortDesc> * Arts::PortDesc::connections()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->connections():static_cast<Arts::PortDesc_base*>(_method_call())->connections();
}

inline float Arts::PortDesc::floatValue()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->floatValue():static_cast<Arts::PortDesc_base*>(_method_call())->floatValue();
}

inline void Arts::PortDesc::floatValue(float _newValue)
{
	 _cache?static_cast<Arts::PortDesc_base*>(_cache)->floatValue(_newValue):static_cast<Arts::PortDesc_base*>(_method_call())->floatValue(_newValue);
}

inline std::string Arts::PortDesc::stringValue()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->stringValue():static_cast<Arts::PortDesc_base*>(_method_call())->stringValue();
}

inline void Arts::PortDesc::stringValue(const std::string& _newValue)
{
	 _cache?static_cast<Arts::PortDesc_base*>(_cache)->stringValue(_newValue):static_cast<Arts::PortDesc_base*>(_method_call())->stringValue(_newValue);
}

inline Arts::Any Arts::PortDesc::value()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->value():static_cast<Arts::PortDesc_base*>(_method_call())->value();
}

inline void Arts::PortDesc::value(const Arts::Any& _newValue)
{
	 _cache?static_cast<Arts::PortDesc_base*>(_cache)->value(_newValue):static_cast<Arts::PortDesc_base*>(_method_call())->value(_newValue);
}

inline long Arts::PortDesc::internalOldID()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->internalOldID():static_cast<Arts::PortDesc_base*>(_method_call())->internalOldID();
}

inline Arts::PortDesc::PortDesc(Arts::ModuleDesc parent, const std::string& name, const Arts::PortType& type)
		: Arts::Object(PortDesc_base::_create())
{
	static_cast<Arts::PortDesc_base*>(_method_call())->constructor(parent, name, type);
}

inline bool Arts::PortDesc::connectTo(Arts::PortDesc port)
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->connectTo(port):static_cast<Arts::PortDesc_base*>(_method_call())->connectTo(port);
}

inline void Arts::PortDesc::disconnectFrom(Arts::PortDesc port)
{
	 _cache?static_cast<Arts::PortDesc_base*>(_cache)->disconnectFrom(port):static_cast<Arts::PortDesc_base*>(_method_call())->disconnectFrom(port);
}

inline void Arts::PortDesc::disconnectAll()
{
	 _cache?static_cast<Arts::PortDesc_base*>(_cache)->disconnectAll():static_cast<Arts::PortDesc_base*>(_method_call())->disconnectAll();
}

inline std::vector<std::string> * Arts::PortDesc::saveToList()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->saveToList():static_cast<Arts::PortDesc_base*>(_method_call())->saveToList();
}

inline void Arts::PortDesc::loadFromList(const std::vector<std::string>& list)
{
	 _cache?static_cast<Arts::PortDesc_base*>(_cache)->loadFromList(list):static_cast<Arts::PortDesc_base*>(_method_call())->loadFromList(list);
}

inline void Arts::PortDesc::internalConnectInput(Arts::PortDesc port)
{
	 _cache?static_cast<Arts::PortDesc_base*>(_cache)->internalConnectInput(port):static_cast<Arts::PortDesc_base*>(_method_call())->internalConnectInput(port);
}

inline void Arts::PortDesc::internalReConnect(const std::vector<Arts::PortDesc>& allports)
{
	 _cache?static_cast<Arts::PortDesc_base*>(_cache)->internalReConnect(allports):static_cast<Arts::PortDesc_base*>(_method_call())->internalReConnect(allports);
}

inline long Arts::ModuleDesc::ID()
{
	return _cache?static_cast<Arts::ModuleDesc_base*>(_cache)->ID():static_cast<Arts::ModuleDesc_base*>(_method_call())->ID();
}

inline Arts::StructureDesc Arts::ModuleDesc::parent()
{
	return _cache?static_cast<Arts::ModuleDesc_base*>(_cache)->parent():static_cast<Arts::ModuleDesc_base*>(_method_call())->parent();
}

inline std::string Arts::ModuleDesc::name()
{
	return _cache?static_cast<Arts::ModuleDesc_base*>(_cache)->name():static_cast<Arts::ModuleDesc_base*>(_method_call())->name();
}

inline std::vector<Arts::PortDesc> * Arts::ModuleDesc::ports()
{
	return _cache?static_cast<Arts::ModuleDesc_base*>(_cache)->ports():static_cast<Arts::ModuleDesc_base*>(_method_call())->ports();
}

inline long Arts::ModuleDesc::x()
{
	return _cache?static_cast<Arts::ModuleDesc_base*>(_cache)->x():static_cast<Arts::ModuleDesc_base*>(_method_call())->x();
}

inline long Arts::ModuleDesc::y()
{
	return _cache?static_cast<Arts::ModuleDesc_base*>(_cache)->y():static_cast<Arts::ModuleDesc_base*>(_method_call())->y();
}

inline long Arts::ModuleDesc::width()
{
	return _cache?static_cast<Arts::ModuleDesc_base*>(_cache)->width():static_cast<Arts::ModuleDesc_base*>(_method_call())->width();
}

inline long Arts::ModuleDesc::height()
{
	return _cache?static_cast<Arts::ModuleDesc_base*>(_cache)->height():static_cast<Arts::ModuleDesc_base*>(_method_call())->height();
}

inline bool Arts::ModuleDesc::isInterface()
{
	return _cache?static_cast<Arts::ModuleDesc_base*>(_cache)->isInterface():static_cast<Arts::ModuleDesc_base*>(_method_call())->isInterface();
}

inline bool Arts::ModuleDesc::isStructure()
{
	return _cache?static_cast<Arts::ModuleDesc_base*>(_cache)->isStructure():static_cast<Arts::ModuleDesc_base*>(_method_call())->isStructure();
}

inline Arts::ModuleDesc::ModuleDesc(Arts::StructureDesc parent, const Arts::ModuleInfo& info)
		: Arts::Object(ModuleDesc_base::_create())
{
	static_cast<Arts::ModuleDesc_base*>(_method_call())->constructor(parent, info);
}

inline bool Arts::ModuleDesc::moveTo(long x, long y)
{
	return _cache?static_cast<Arts::ModuleDesc_base*>(_cache)->moveTo(x, y):static_cast<Arts::ModuleDesc_base*>(_method_call())->moveTo(x, y);
}

inline Arts::PortDesc Arts::ModuleDesc::findPort(const std::string& name)
{
	return _cache?static_cast<Arts::ModuleDesc_base*>(_cache)->findPort(name):static_cast<Arts::ModuleDesc_base*>(_method_call())->findPort(name);
}

inline std::vector<std::string> * Arts::ModuleDesc::saveToList()
{
	return _cache?static_cast<Arts::ModuleDesc_base*>(_cache)->saveToList():static_cast<Arts::ModuleDesc_base*>(_method_call())->saveToList();
}

inline void Arts::ModuleDesc::loadFromList(const std::vector<std::string>& list)
{
	 _cache?static_cast<Arts::ModuleDesc_base*>(_cache)->loadFromList(list):static_cast<Arts::ModuleDesc_base*>(_method_call())->loadFromList(list);
}

inline bool Arts::StructureDesc::valid()
{
	return _cache?static_cast<Arts::StructureDesc_base*>(_cache)->valid():static_cast<Arts::StructureDesc_base*>(_method_call())->valid();
}

inline std::string Arts::StructureDesc::name()
{
	return _cache?static_cast<Arts::StructureDesc_base*>(_cache)->name():static_cast<Arts::StructureDesc_base*>(_method_call())->name();
}

inline void Arts::StructureDesc::name(const std::string& _newValue)
{
	 _cache?static_cast<Arts::StructureDesc_base*>(_cache)->name(_newValue):static_cast<Arts::StructureDesc_base*>(_method_call())->name(_newValue);
}

inline std::vector<Arts::ModuleDesc> * Arts::StructureDesc::modules()
{
	return _cache?static_cast<Arts::StructureDesc_base*>(_cache)->modules():static_cast<Arts::StructureDesc_base*>(_method_call())->modules();
}

inline std::vector<Arts::StructurePortDesc> * Arts::StructureDesc::ports()
{
	return _cache?static_cast<Arts::StructureDesc_base*>(_cache)->ports():static_cast<Arts::StructureDesc_base*>(_method_call())->ports();
}

inline std::vector<std::string> * Arts::StructureDesc::inheritedInterfaces()
{
	return _cache?static_cast<Arts::StructureDesc_base*>(_cache)->inheritedInterfaces():static_cast<Arts::StructureDesc_base*>(_method_call())->inheritedInterfaces();
}

inline Arts::ModuleInfo Arts::StructureDesc::externalInterface()
{
	return _cache?static_cast<Arts::StructureDesc_base*>(_cache)->externalInterface():static_cast<Arts::StructureDesc_base*>(_method_call())->externalInterface();
}

inline long Arts::StructureDesc::obtainID()
{
	return _cache?static_cast<Arts::StructureDesc_base*>(_cache)->obtainID():static_cast<Arts::StructureDesc_base*>(_method_call())->obtainID();
}

inline std::vector<std::string> * Arts::StructureDesc::saveToList()
{
	return _cache?static_cast<Arts::StructureDesc_base*>(_cache)->saveToList():static_cast<Arts::StructureDesc_base*>(_method_call())->saveToList();
}

inline void Arts::StructureDesc::loadFromList(const std::vector<std::string>& list)
{
	 _cache?static_cast<Arts::StructureDesc_base*>(_cache)->loadFromList(list):static_cast<Arts::StructureDesc_base*>(_method_call())->loadFromList(list);
}

inline void Arts::StructureDesc::clear()
{
	 _cache?static_cast<Arts::StructureDesc_base*>(_cache)->clear():static_cast<Arts::StructureDesc_base*>(_method_call())->clear();
}

inline Arts::ModuleDesc Arts::StructureDesc::createModuleDesc(const Arts::ModuleInfo& info)
{
	return _cache?static_cast<Arts::StructureDesc_base*>(_cache)->createModuleDesc(info):static_cast<Arts::StructureDesc_base*>(_method_call())->createModuleDesc(info);
}

inline void Arts::StructureDesc::freeModuleDesc(Arts::ModuleDesc moduledesc)
{
	 _cache?static_cast<Arts::StructureDesc_base*>(_cache)->freeModuleDesc(moduledesc):static_cast<Arts::StructureDesc_base*>(_method_call())->freeModuleDesc(moduledesc);
}

inline Arts::StructurePortDesc Arts::StructureDesc::createStructurePortDesc(const Arts::PortType& type, const std::string& name)
{
	return _cache?static_cast<Arts::StructureDesc_base*>(_cache)->createStructurePortDesc(type, name):static_cast<Arts::StructureDesc_base*>(_method_call())->createStructurePortDesc(type, name);
}

inline void Arts::StructureDesc::freeStructurePortDesc(Arts::StructurePortDesc portdesc)
{
	 _cache?static_cast<Arts::StructureDesc_base*>(_cache)->freeStructurePortDesc(portdesc):static_cast<Arts::StructureDesc_base*>(_method_call())->freeStructurePortDesc(portdesc);
}

inline void Arts::StructureDesc::moveStructurePortDesc(Arts::StructurePortDesc portdesc, long newposition)
{
	 _cache?static_cast<Arts::StructureDesc_base*>(_cache)->moveStructurePortDesc(portdesc, newposition):static_cast<Arts::StructureDesc_base*>(_method_call())->moveStructurePortDesc(portdesc, newposition);
}

inline void Arts::StructureDesc::addInheritedInterface(const std::string& iface)
{
	 _cache?static_cast<Arts::StructureDesc_base*>(_cache)->addInheritedInterface(iface):static_cast<Arts::StructureDesc_base*>(_method_call())->addInheritedInterface(iface);
}

inline void Arts::StructureDesc::removeInheritedInterface(const std::string& iface)
{
	 _cache?static_cast<Arts::StructureDesc_base*>(_cache)->removeInheritedInterface(iface):static_cast<Arts::StructureDesc_base*>(_method_call())->removeInheritedInterface(iface);
}

inline long Arts::StructurePortDesc::ID()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->ID():static_cast<Arts::PortDesc_base*>(_method_call())->ID();
}

inline Arts::ModuleDesc Arts::StructurePortDesc::parent()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->parent():static_cast<Arts::PortDesc_base*>(_method_call())->parent();
}

inline std::string Arts::StructurePortDesc::name()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->name():static_cast<Arts::PortDesc_base*>(_method_call())->name();
}

inline Arts::PortType Arts::StructurePortDesc::type()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->type():static_cast<Arts::PortDesc_base*>(_method_call())->type();
}

inline bool Arts::StructurePortDesc::isConnected()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->isConnected():static_cast<Arts::PortDesc_base*>(_method_call())->isConnected();
}

inline bool Arts::StructurePortDesc::hasValue()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->hasValue():static_cast<Arts::PortDesc_base*>(_method_call())->hasValue();
}

inline void Arts::StructurePortDesc::hasValue(bool _newValue)
{
	 _cache?static_cast<Arts::PortDesc_base*>(_cache)->hasValue(_newValue):static_cast<Arts::PortDesc_base*>(_method_call())->hasValue(_newValue);
}

inline std::vector<Arts::PortDesc> * Arts::StructurePortDesc::connections()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->connections():static_cast<Arts::PortDesc_base*>(_method_call())->connections();
}

inline float Arts::StructurePortDesc::floatValue()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->floatValue():static_cast<Arts::PortDesc_base*>(_method_call())->floatValue();
}

inline void Arts::StructurePortDesc::floatValue(float _newValue)
{
	 _cache?static_cast<Arts::PortDesc_base*>(_cache)->floatValue(_newValue):static_cast<Arts::PortDesc_base*>(_method_call())->floatValue(_newValue);
}

inline std::string Arts::StructurePortDesc::stringValue()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->stringValue():static_cast<Arts::PortDesc_base*>(_method_call())->stringValue();
}

inline void Arts::StructurePortDesc::stringValue(const std::string& _newValue)
{
	 _cache?static_cast<Arts::PortDesc_base*>(_cache)->stringValue(_newValue):static_cast<Arts::PortDesc_base*>(_method_call())->stringValue(_newValue);
}

inline Arts::Any Arts::StructurePortDesc::value()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->value():static_cast<Arts::PortDesc_base*>(_method_call())->value();
}

inline void Arts::StructurePortDesc::value(const Arts::Any& _newValue)
{
	 _cache?static_cast<Arts::PortDesc_base*>(_cache)->value(_newValue):static_cast<Arts::PortDesc_base*>(_method_call())->value(_newValue);
}

inline long Arts::StructurePortDesc::internalOldID()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->internalOldID():static_cast<Arts::PortDesc_base*>(_method_call())->internalOldID();
}

inline Arts::StructurePortDesc::StructurePortDesc(Arts::ModuleDesc parent, const std::string& name, const Arts::PortType& type)
		: Arts::Object(StructurePortDesc_base::_create())
{
	static_cast<Arts::PortDesc_base*>(_method_call())->constructor(parent, name, type);
}

inline bool Arts::StructurePortDesc::connectTo(Arts::PortDesc port)
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->connectTo(port):static_cast<Arts::PortDesc_base*>(_method_call())->connectTo(port);
}

inline void Arts::StructurePortDesc::disconnectFrom(Arts::PortDesc port)
{
	 _cache?static_cast<Arts::PortDesc_base*>(_cache)->disconnectFrom(port):static_cast<Arts::PortDesc_base*>(_method_call())->disconnectFrom(port);
}

inline void Arts::StructurePortDesc::disconnectAll()
{
	 _cache?static_cast<Arts::PortDesc_base*>(_cache)->disconnectAll():static_cast<Arts::PortDesc_base*>(_method_call())->disconnectAll();
}

inline std::vector<std::string> * Arts::StructurePortDesc::saveToList()
{
	return _cache?static_cast<Arts::PortDesc_base*>(_cache)->saveToList():static_cast<Arts::PortDesc_base*>(_method_call())->saveToList();
}

inline void Arts::StructurePortDesc::loadFromList(const std::vector<std::string>& list)
{
	 _cache?static_cast<Arts::PortDesc_base*>(_cache)->loadFromList(list):static_cast<Arts::PortDesc_base*>(_method_call())->loadFromList(list);
}

inline void Arts::StructurePortDesc::internalConnectInput(Arts::PortDesc port)
{
	 _cache?static_cast<Arts::PortDesc_base*>(_cache)->internalConnectInput(port):static_cast<Arts::PortDesc_base*>(_method_call())->internalConnectInput(port);
}

inline void Arts::StructurePortDesc::internalReConnect(const std::vector<Arts::PortDesc>& allports)
{
	 _cache?static_cast<Arts::PortDesc_base*>(_cache)->internalReConnect(allports):static_cast<Arts::PortDesc_base*>(_method_call())->internalReConnect(allports);
}

inline long Arts::StructurePortDesc::x()
{
	return _cache?static_cast<Arts::StructurePortDesc_base*>(_cache)->x():static_cast<Arts::StructurePortDesc_base*>(_method_call())->x();
}

inline long Arts::StructurePortDesc::y()
{
	return _cache?static_cast<Arts::StructurePortDesc_base*>(_cache)->y():static_cast<Arts::StructurePortDesc_base*>(_method_call())->y();
}

inline long Arts::StructurePortDesc::position()
{
	return _cache?static_cast<Arts::StructurePortDesc_base*>(_cache)->position():static_cast<Arts::StructurePortDesc_base*>(_method_call())->position();
}

inline Arts::StructureDesc Arts::StructurePortDesc::parentStructure()
{
	return _cache?static_cast<Arts::StructurePortDesc_base*>(_cache)->parentStructure():static_cast<Arts::StructurePortDesc_base*>(_method_call())->parentStructure();
}

inline std::string Arts::StructurePortDesc::inheritedInterface()
{
	return _cache?static_cast<Arts::StructurePortDesc_base*>(_cache)->inheritedInterface():static_cast<Arts::StructurePortDesc_base*>(_method_call())->inheritedInterface();
}

inline void Arts::StructurePortDesc::inheritedInterface(const std::string& _newValue)
{
	 _cache?static_cast<Arts::StructurePortDesc_base*>(_cache)->inheritedInterface(_newValue):static_cast<Arts::StructurePortDesc_base*>(_method_call())->inheritedInterface(_newValue);
}

inline Arts::StructurePortDesc::StructurePortDesc(Arts::StructureDesc parent, const std::string& name, const Arts::PortType& type)
		: Arts::Object(StructurePortDesc_base::_create())
{
	static_cast<Arts::StructurePortDesc_base*>(_method_call())->constructor(parent, name, type);
}

inline bool Arts::StructurePortDesc::moveTo(long x, long y)
{
	return _cache?static_cast<Arts::StructurePortDesc_base*>(_cache)->moveTo(x, y):static_cast<Arts::StructurePortDesc_base*>(_method_call())->moveTo(x, y);
}

inline void Arts::StructurePortDesc::lowerPosition()
{
	 _cache?static_cast<Arts::StructurePortDesc_base*>(_cache)->lowerPosition():static_cast<Arts::StructurePortDesc_base*>(_method_call())->lowerPosition();
}

inline void Arts::StructurePortDesc::raisePosition()
{
	 _cache?static_cast<Arts::StructurePortDesc_base*>(_cache)->raisePosition():static_cast<Arts::StructurePortDesc_base*>(_method_call())->raisePosition();
}

inline void Arts::StructurePortDesc::rename(const std::string& newname)
{
	 _cache?static_cast<Arts::StructurePortDesc_base*>(_cache)->rename(newname):static_cast<Arts::StructurePortDesc_base*>(_method_call())->rename(newname);
}

inline void Arts::StructurePortDesc::internalSetPosition(long position)
{
	 _cache?static_cast<Arts::StructurePortDesc_base*>(_cache)->internalSetPosition(position):static_cast<Arts::StructurePortDesc_base*>(_method_call())->internalSetPosition(position);
}

inline Arts::Object Arts::ObjectFactory::createObject(const std::string& name)
{
	return _cache?static_cast<Arts::ObjectFactory_base*>(_cache)->createObject(name):static_cast<Arts::ObjectFactory_base*>(_method_call())->createObject(name);
}

inline Arts::Object Arts::LocalFactory::createObject(const std::string& name)
{
	return _cache?static_cast<Arts::ObjectFactory_base*>(_cache)->createObject(name):static_cast<Arts::ObjectFactory_base*>(_method_call())->createObject(name);
}

inline void Arts::StructureBuilder::addFactory(Arts::ObjectFactory factory)
{
	 _cache?static_cast<Arts::StructureBuilder_base*>(_cache)->addFactory(factory):static_cast<Arts::StructureBuilder_base*>(_method_call())->addFactory(factory);
}

inline Arts::Object Arts::StructureBuilder::createObject(Arts::StructureDesc structure)
{
	return _cache?static_cast<Arts::StructureBuilder_base*>(_cache)->createObject(structure):static_cast<Arts::StructureBuilder_base*>(_method_call())->createObject(structure);
}

inline Arts::ModuleDef Arts::StructureBuilder::createTypeInfo(Arts::StructureDesc structure)
{
	return _cache?static_cast<Arts::StructureBuilder_base*>(_cache)->createTypeInfo(structure):static_cast<Arts::StructureBuilder_base*>(_method_call())->createTypeInfo(structure);
}

inline std::string Arts::ArtsBuilderLoader::dataVersion()
{
	return _cache?static_cast<Arts::Loader_base*>(_cache)->dataVersion():static_cast<Arts::Loader_base*>(_method_call())->dataVersion();
}

inline std::vector<Arts::TraderEntry> * Arts::ArtsBuilderLoader::traderEntries()
{
	return _cache?static_cast<Arts::Loader_base*>(_cache)->traderEntries():static_cast<Arts::Loader_base*>(_method_call())->traderEntries();
}

inline std::vector<Arts::ModuleDef> * Arts::ArtsBuilderLoader::modules()
{
	return _cache?static_cast<Arts::Loader_base*>(_cache)->modules():static_cast<Arts::Loader_base*>(_method_call())->modules();
}

inline Arts::Object Arts::ArtsBuilderLoader::loadObject(Arts::TraderOffer offer)
{
	return _cache?static_cast<Arts::Loader_base*>(_cache)->loadObject(offer):static_cast<Arts::Loader_base*>(_method_call())->loadObject(offer);
}

inline Arts::AutoSuspendState Arts::Structure::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Structure::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Structure::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Structure::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Structure::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Structure::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline void Arts::Structure::run()
{
	 _cache?static_cast<Arts::Structure_base*>(_cache)->run():static_cast<Arts::Structure_base*>(_method_call())->run();
}

inline void Arts::Structure::halt()
{
	 _cache?static_cast<Arts::Structure_base*>(_cache)->halt():static_cast<Arts::Structure_base*>(_method_call())->halt();
}

#endif /* ARTSBUILDER_H */
