#
#  fmt_rtf.pl
#
#  $Id: fmt_rtf.pl,v 1.3 1997/09/11 22:27:32 cg Exp $
#
#  RTF-specific driver stuff
#
#   Copyright 1996, Cees de Groot
#
package SGMLTools::fmt_rtf;
use strict;

use SGMLTools::Vars;

use File::Copy;

my $rtf = {};
$rtf->{NAME} = "rtf";
$rtf->{HELP} = "";
$rtf->{OPTIONS} = [
   { option => "twosplit", type => "f", short => "2" }
];
$rtf->{twosplit}  = 0;

$Formats{$rtf->{NAME}} = $rtf;

#
#  RTF does not treat newline as whitespace, so we need to
#  turn "\n" into " \n". Without the extra space, two words
#  separated only by a newline will get jammed together in
#  the RTF output.
#
$rtf->{preASP} = sub
{
  my ($infile, $outfile) = @_;

  while (<$infile>)
    {
      s/([^\\])\\n/$1 \\n/g;
      print $outfile $_;
    }
};

#
#  Take the sgmlsasp output, and make something
#  useful from it.
#
$rtf->{postASP} = sub
{
  my $infile = shift;

  #
  #  Set various stuff as a result of option processing.
  #
  my $split = "-2" if $rtf->{twosplit};

  my $pipe = new FileHandle 
    "|$main::BinDir/rtf2rtf $split \"$global->{filename}\" >\"$global->{filename}.rtf\"";
  copy ($infile, $pipe);
  $pipe->close;

  return 0;
};

1;
