Summary: A DSSSL implementation.
Name: openjade
Version: 1.3
Release: 17
Prereq: sgml-common >= 0.5
Source: http://download.sourceforge.net/openjade/openjade-%{version}.tar.gz
Patch0: openjade-1.3-decl.patch
Patch1: openjade-1.3-strdup.patch
# compiler bug. remove later.
Patch2: openjade-foo.patch
Patch3: openjade-1.3-size_t.patch
Patch4: openjade-1.3-31525.patch
Patch5: openjade-1.3-lt.patch
Patch6: http://indev.insu.com/openjade/openjade-1.3.patch
Patch7: openjade-1.3-ligature.patch
Copyright: Copyright 1997 James Clark
Group: Applications/Text
BuildRoot: /var/tmp/%{name}-%{version}-%{release}-root
Prefix: /usr
Obsoletes: jade
Provides: jade

%description
OpenJade is an implementation of the ISO/IEC 10179:1996 standard DSSSL
(Document Style Semantics and Specification Language).  OpenJade is
based on James Clark's Jade implementation of DSSSL. OpenJade is a
commmand line application and a set of components.  The DSSSL engine
inputs an SGML or XML document and can output a variety of formats:
XML, RTF, TeX, MIF (FrameMaker), SGML or XML.


%prep
%setup -q
%patch0 -p1 -b .decl
%patch1 -p1 -b .strdup
%patch2 -p1 -b .foo
%ifarch s390 s390x
%patch3 -p1 -b .size_t
%endif
%patch4 -p1 -b .31525
%patch5 -p1 -b .lt
%patch6 -p1
%patch7 -p1 -b .ligature

%build

cp config/configure.in .
%ifarch alpha
export CXXFLAGS="-O0"
%endif
%configure --prefix=%{prefix} --enable-static \
 --enable-default-catalog=/etc/sgml/catalog \
 --enable-default-search-path=/usr/share/sgml \
 --datadir=/usr/share/sgml/%{name}-%{version}
NRPROC=`egrep -c "^cpu[0-9]+" /proc/stat || :`
[ "$NRPROC" = "0" ] && NRPROC=1
make -j$NRPROC

%install
# NOTE: in installing I am also copying a bunch of .h files into
# $(prefix)/include/sp/{generic,include,lib}.  This is so that the
# library API can be used.  It's an ugly kludge, and the best way
# would be for James Clark to tell us what the appropriate list of
# files to be included is.

rm -rf $RPM_BUILD_ROOT

mkdir -p $RPM_BUILD_ROOT
mkdir -p \
 $RPM_BUILD_ROOT/%{prefix}/{lib,bin,doc,share/sgml/openjade-1.3,include/sp/{generic,include,lib}}

%makeinstall datadir=$RPM_BUILD_ROOT/%{prefix}/share/sgml/openjade-1.3

# oMy, othis ois osilly.
ln -s openjade $RPM_BUILD_ROOT/%{prefix}/bin/jade
for file in nsgmls sgmlnorm spam spent sx ; do
   ln -s o$file $RPM_BUILD_ROOT/%{prefix}/bin/$file
done

mv $RPM_BUILD_ROOT/%{prefix}/bin/sx $RPM_BUILD_ROOT/%{prefix}/bin/sgml2xml
install generic/*.h $RPM_BUILD_ROOT/%{prefix}/include/sp/generic/
install include/*.h $RPM_BUILD_ROOT/%{prefix}/include/sp/include/
install lib/*.h $RPM_BUILD_ROOT/%{prefix}/include/sp/lib/
# install jade/jade $RPM_BUILD_ROOT/%{prefix}/bin/jade 
cp dsssl/catalog $RPM_BUILD_ROOT/%{prefix}/share/sgml/%{name}-%{version}/
cp dsssl/dsssl.dtd dsssl/style-sheet.dtd dsssl/fot.dtd \
  $RPM_BUILD_ROOT/%{prefix}/share/sgml/%{name}-%{version}

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig
 
%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
%doc doc/ jadedoc/ dsssl/ pubtext/ unicode/ README COPYING VERSION
%{prefix}/bin/*
%{prefix}/lib/*
%{prefix}/share/sgml
%{prefix}/include/*

%changelog
* Fri Jun 15 2001 Tim Waugh <twaugh@redhat.com> 1.3-17
- Apply patch from CVS to break up unintentional ligatures (bugs #11497,
  #11779)

* Mon Jun  4 2001 Tim Waugh <twaugh@redhat.com> 1.3-16
- Apply the iNdev openjade-1.3.patch patch.

* Tue May 29 2001 Tim Waugh <twaugh@redhat.com> 1.3-15
- ldconfig (bug #32824).
- Fix up some libtool problems.

* Fri Apr 27 2001 Bill Nottingham <notting@redhat.com> 1.3-14
- rebuild for C++ exception handling on ia64
- build with optimization on ia64

* Tue Mar 13 2001 Tim Waugh <twaugh@redhat.com>
- Avoid creating bogus TeX output for section headings containing
  special characters (#bug 31525).

* Mon Jan 22 2001 Florian La Roche <Florian.LaRoche@redhat.de>
- Apply original autoconf patch to s390 s390x only. This patch can
  be deleted once s390* uses a current compiler.

* Thu Jan 19 2001 Tim Waugh <twaugh@redhat.com>
- Don't conflict with stylesheets; require sgml-common >= 0.5 instead.
- Revert autoconf change, as it's still broken.

* Wed Jan 17 2001 Florian La Roche <Florian.LaRoche@redhat.de>
- fix this autoconf macro to work on all archs :-)

* Wed Jan 17 2001 Florian La Roche <Florian.LaRoche@redhat.de>
- apply patch from Fritz Elfert <felfert@to.com>
	- removed explicit stripping
	- Added autoconf macro for correctly recognizing if size_t
	  is unsigned int

* Tue Jan 16 2001 Tim Waugh <twaugh@redhat.com>
- Default catalog file is /etc/sgml/catalog.

* Mon Jan 08 2001 Tim Waugh <twaugh@redhat.com>
- Conflict with stylesheets (new-trials location changes).
- /usr/lib/sgml -> /usr/share/sgml/%%{name}-%%{version}.
- Remove %%post and %%postun.

* Wed Oct 18 2000 Matt Wilson <msw@redhat.com>
- rebuilt against g++-2.96-60, fixes jade on alpha

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Tue Jul  4 2000 Jakub Jelinek <jakub@redhat.com>
- Rebuild with new C++

* Wed May 31 2000 Matt Wilson <msw@redhat.com>
- fix several C++ build problems (declarations)
- build against new libstdc++

* Wed May 17 2000 Matt Wilson <msw@redhat.com>
- build with -O0 on alpha
- fix -j testing

* Thu May  5 2000 Bill Nottingham <notting@redhat.com>
- openjade is maintained, and actually builds. Let's try that.

* Thu Mar  9 2000 Bill Nottingham <notting@redhat.com>
- this package is way too huge. strip *everything*

* Mon Feb 21 2000 Matt Wilson <msw@redhat.com>
- build with CXXFLAGS="-O2 -ggdb" to work around segfault on alpha

* Thu Feb  3 2000 Bill Nottingham <notting@redhat.com>
- strip binaries

* Wed Jan  5 2000 Bill Nottingham <notting@redhat.com>
- sanitize spec file some

* Tue Aug 17 1999 Tim Powers <timp@redhat.com>
- fixed conflict problem with sgml-tools

* Sat Jul 17 1999 Tim Powers <timp@redhat.com>
- changed buildroot path to /var/tmp
- rebuilt for 6.1

* Fri Apr 23 1999 Michael K. Johnson <johnsonm@redhat.com>
- quiet scripts

* Thu Apr 23 1999 Owen Taylor <otaylor@redhat.com>
- Made requires for sgml-common into prereq
