/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.math.BigInteger;

public final class BigInt {
    private byte[] places;
    private static final String digits = "0123456789abcdef";

    public BigInt(byte[] byArray) {
        this.places = (byte[])byArray.clone();
    }

    public BigInt(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if ((byArray[0] & 0x80) != 0) {
            throw new IllegalArgumentException("negative BigInteger");
        }
        if (byArray[0] != 0) {
            this.places = byArray;
        } else {
            this.places = new byte[byArray.length - 1];
            int n2 = 1;
            while (n2 < byArray.length) {
                this.places[n2 - 1] = byArray[n2];
                ++n2;
            }
        }
    }

    public BigInt(int n2) {
        if (n2 < 256) {
            this.places = new byte[1];
            this.places[0] = (byte)n2;
        } else if (n2 < 65536) {
            this.places = new byte[2];
            this.places[0] = (byte)(n2 >> 8);
            this.places[1] = (byte)n2;
        } else if (n2 < 0x1000000) {
            this.places = new byte[3];
            this.places[0] = (byte)(n2 >> 16);
            this.places[1] = (byte)(n2 >> 8);
            this.places[2] = (byte)n2;
        } else {
            this.places = new byte[4];
            this.places[0] = (byte)(n2 >> 24);
            this.places[1] = (byte)(n2 >> 16);
            this.places[2] = (byte)(n2 >> 8);
            this.places[3] = (byte)n2;
        }
    }

    public int toInt() {
        if (this.places.length > 4) {
            throw new NumberFormatException("BigInt.toLong, too big");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.places.length) {
            n2 = (n2 << 8) + (this.places[n3] & 0xFF);
            ++n3;
        }
        return n2;
    }

    public String toString() {
        return this.hexify();
    }

    public BigInteger toBigInteger() {
        return new BigInteger(1, this.places);
    }

    public byte[] toByteArray() {
        return (byte[])this.places.clone();
    }

    private String hexify() {
        if (this.places.length == 0) {
            return "  0  ";
        }
        StringBuffer stringBuffer = new StringBuffer(this.places.length * 2);
        stringBuffer.append("    ");
        int n2 = 0;
        while (n2 < this.places.length) {
            stringBuffer.append(digits.charAt(this.places[n2] >> 4 & 0xF));
            stringBuffer.append(digits.charAt(this.places[n2] & 0xF));
            if ((n2 + 1) % 32 == 0) {
                if (n2 + 1 != this.places.length) {
                    stringBuffer.append("\n    ");
                }
            } else if ((n2 + 1) % 4 == 0) {
                stringBuffer.append(' ');
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof BigInt) {
            return this.equals((BigInt)object);
        }
        return false;
    }

    public boolean equals(BigInt bigInt) {
        if (this == bigInt) {
            return true;
        }
        byte[] byArray = bigInt.toByteArray();
        if (this.places.length != byArray.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.places.length) {
            if (this.places[n2] != byArray[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        return this.hexify().hashCode();
    }
}

