/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import sun.awt.font.StandardGlyphVector;

public final class AdvanceCache {
    private Font font;
    private FontRenderContext frc;
    private LineMetrics lineMetrics;
    private float[] latinAdvances;
    private float[] kanaAdvances;
    private float cjkAdvance;
    private float cjkFullAdvance;
    private float cjkHalfAdvance;
    private float[] latin1GlyphInfo;
    private float[] kanaGlyphInfo;
    private static final char KANA_MIN = '\u3040';
    private static final char KANA_LIM = '\u3100';
    private static final char CJK_SAMPLE = '\u4e9e';
    private static final char CJK_MIN = '\u3200';
    private static final char CJK_LIM = '\u9fb0';
    private static final char CJKFULL_SAMPLE = '\uff01';
    private static final char CJKFULL1_MIN = '\uff00';
    private static final char CJKFULL1_LIM = '\uff5f';
    private static final char CJKFULL2_MIN = '\uffe0';
    private static final char CJKFULL2_LIM = '\uffe7';
    private static final char CJKHALF_SAMPLE = '\uff61';
    private static final char CJKHALF_MIN = '\uff61';
    private static final char CJKHALF_LIM = '\uff9e';
    private static final char KSYL_SAMPLE = '\uac00';
    private static final char KSYL_MIN = '\uac00';
    private static final char KSYL_MAX = '\ud7a0';
    private static final int CACHE_SIZE = 30;
    private static SoftReference[] cache = new SoftReference[30];
    private static int cacheNum;
    private static boolean enabled;
    private static String latin1;
    private static String kana;
    static int statCount;
    static int statTest;
    static int statMiss;
    static int statFlush;
    static int statFlushDelta;
    static int statLastFlushCount;

    private boolean equals(Font font, FontRenderContext fontRenderContext) {
        return this.font.equals(font) && this.frc.equals(fontRenderContext);
    }

    public static boolean supportsText(char[] cArray, int n2, int n3) {
        if (!enabled) {
            return false;
        }
        int n4 = n2;
        while (n4 < n3) {
            char c2 = cArray[n4];
            if (!(c2 < '\u0100' || c2 >= '\u3040' && c2 < '\u3100' || c2 >= '\u3200' && c2 < '\u9fb0' || c2 >= '\uff61' && c2 < '\uff9e' || c2 >= '\uff00' && c2 < '\uff5f' || c2 >= '\uffe0' && c2 < '\uffe7')) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static boolean supportsText(char[] cArray) {
        return AdvanceCache.supportsText(cArray, 0, cArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static AdvanceCache get(Font var0, FontRenderContext var1_1) {
        if (!AdvanceCache.enabled) {
            return null;
        }
        var2_2 = AdvanceCache.cache;
        synchronized (AdvanceCache.cache) {
            block10: {
                ++AdvanceCache.statCount;
                var3_3 = 0;
                while (var3_3 < AdvanceCache.cacheNum) {
                    var4_4 /* !! */  = (SoftReference[])AdvanceCache.cache[var3_3].get();
                    if (var4_4 /* !! */  == null) {
                        ++AdvanceCache.statFlush;
                        AdvanceCache.statFlushDelta = AdvanceCache.statCount - AdvanceCache.statLastFlushCount;
                        AdvanceCache.statLastFlushCount = AdvanceCache.statCount;
                        AdvanceCache.cache = new SoftReference[30];
                        AdvanceCache.cacheNum = 0;
                        break;
                    }
                    ++AdvanceCache.statTest;
                    if (super.equals(var0, var1_1)) {
                        if (var3_3 > 0) {
                            var5_5 = AdvanceCache.cache[var3_3];
                            while (var3_3 > 0) {
                                AdvanceCache.cache[var3_3--] = AdvanceCache.cache[var3_3];
                            }
                            AdvanceCache.cache[0] = var5_5;
                        }
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return var4_4 /* !! */ ;
                    }
                    ++var3_3;
                }
                ++AdvanceCache.statMiss;
                if (var3_3 != AdvanceCache.cache.length) ** GOTO lbl36
                var4_4 /* !! */  = new SoftReference[AdvanceCache.cache.length + 30];
                System.arraycopy(AdvanceCache.cache, 0, var4_4 /* !! */ , 1, AdvanceCache.cache.length);
                AdvanceCache.cache = var4_4 /* !! */ ;
                break block10;
lbl-1000:
                // 1 sources

                {
                    AdvanceCache.cache[var3_3 + 1] = AdvanceCache.cache[var3_3];
lbl36:
                    // 2 sources

                    ** while (--var3_3 >= 0)
                }
            }
            var4_4 /* !! */  = new AdvanceCache(var0, var1_1);
            AdvanceCache.cache[0] = new SoftReference(var4_4 /* !! */ );
            ++AdvanceCache.cacheNum;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return var4_4 /* !! */ ;
        }
    }

    private void initLatinAdvances() {
        StandardGlyphVector standardGlyphVector = new StandardGlyphVector(this.font, latin1, this.frc);
        this.latin1GlyphInfo = standardGlyphVector.getGlyphInfo();
        this.latinAdvances = new float[256];
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.latinAdvances.length) {
            this.latinAdvances[n2] = this.latin1GlyphInfo[n3 + 2];
            int n4 = n3 + 4;
            this.latin1GlyphInfo[n4] = this.latin1GlyphInfo[n4] - this.latin1GlyphInfo[n3];
            int n5 = n3 + 6;
            this.latin1GlyphInfo[n5] = this.latin1GlyphInfo[n5] + this.latin1GlyphInfo[n3 + 4];
            int n6 = n3 + 7;
            this.latin1GlyphInfo[n6] = this.latin1GlyphInfo[n6] + this.latin1GlyphInfo[n3 + 5];
            ++n2;
            n3 += 8;
        }
    }

    private void initKanaAdvances() {
        StandardGlyphVector standardGlyphVector = new StandardGlyphVector(this.font, kana, this.frc);
        this.kanaGlyphInfo = standardGlyphVector.getGlyphInfo();
        this.kanaAdvances = new float[kana.length()];
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.kanaAdvances.length) {
            this.kanaAdvances[n2] = this.kanaGlyphInfo[n3 + 2];
            int n4 = n3 + 4;
            this.kanaGlyphInfo[n4] = this.kanaGlyphInfo[n4] - this.kanaGlyphInfo[n3];
            int n5 = n3 + 6;
            this.kanaGlyphInfo[n5] = this.kanaGlyphInfo[n5] + this.kanaGlyphInfo[n3 + 4];
            int n6 = n3 + 7;
            this.kanaGlyphInfo[n6] = this.kanaGlyphInfo[n6] + this.kanaGlyphInfo[n3 + 5];
            ++n2;
            n3 += 8;
        }
        int n7 = 192;
        this.cjkAdvance = this.kanaAdvances[n7];
        this.cjkFullAdvance = this.kanaAdvances[n7 + 1];
        this.cjkHalfAdvance = this.kanaAdvances[n7 + 2];
    }

    private AdvanceCache(Font font, FontRenderContext fontRenderContext) {
        this.font = font;
        this.frc = fontRenderContext;
        this.initLatinAdvances();
        this.initKanaAdvances();
        this.lineMetrics = font.getLineMetrics(latin1, fontRenderContext);
    }

    public LineMetrics getLineMetrics() {
        return this.lineMetrics;
    }

    public float getAdvance(char c2) {
        if (c2 < '\u0100') {
            return this.latinAdvances[c2];
        }
        if (c2 >= '\u3040' && c2 < '\u3100') {
            return this.kanaAdvances[c2 - 12352];
        }
        if (c2 >= '\u3200' && c2 < '\u9fb0') {
            return this.cjkAdvance;
        }
        if (c2 >= '\uff61' && c2 < '\uff9e') {
            return this.cjkHalfAdvance;
        }
        if (c2 >= '\uff00' && c2 < '\uff5f') {
            return this.cjkFullAdvance;
        }
        if (c2 >= '\uffe0' && c2 < '\uffe7') {
            return this.cjkFullAdvance;
        }
        throw new IndexOutOfBoundsException("no advance for char " + Integer.toHexString(c2));
    }

    public float getAdvance(String string) {
        return this.getAdvance(string.toCharArray());
    }

    public float getAdvance(char[] cArray) {
        return this.getAdvance(cArray, 0, cArray.length);
    }

    public float getAdvance(char[] cArray, int n2, int n3) {
        float f2 = 0.0f;
        int n4 = n2;
        while (n4 < n3) {
            char c2 = cArray[n4];
            if (c2 < '\u0100') {
                f2 += this.latinAdvances[c2];
            } else if (c2 >= '\u3040' && c2 < '\u3100') {
                f2 += this.kanaAdvances[c2 - 12352];
            } else if (c2 >= '\u3200' && c2 < '\u9fb0') {
                f2 += this.cjkAdvance;
            } else if (c2 >= '\uff61' && c2 < '\uff9e') {
                f2 += this.cjkHalfAdvance;
            } else if (c2 >= '\uff00' && c2 < '\uff5f') {
                f2 += this.cjkFullAdvance;
            } else if (c2 >= '\uffe0' && c2 < '\uffe7') {
                f2 += this.cjkFullAdvance;
            } else {
                throw new IndexOutOfBoundsException("no advance for char " + Integer.toHexString(c2));
            }
            ++n4;
        }
        return f2;
    }

    public Rectangle2D getLogicalBounds(String string) {
        return this.getLogicalBounds(string.toCharArray());
    }

    public Rectangle2D getLogicalBounds(char[] cArray) {
        return this.getLogicalBounds(cArray, 0, cArray.length);
    }

    public Rectangle2D getLogicalBounds(char[] cArray, int n2, int n3) {
        float f2 = this.getAdvance(cArray, n2, n3);
        return new Rectangle2D.Float(0.0f, -this.lineMetrics.getAscent(), f2, this.lineMetrics.getHeight());
    }

    public Rectangle2D getVisualBounds(String string) {
        return this.getVisualBounds(string.toCharArray());
    }

    public Rectangle2D getVisualBounds(char[] cArray) {
        return this.getVisualBounds(cArray, 0, cArray.length);
    }

    public Rectangle2D getVisualBounds(char[] cArray, int n2, int n3) {
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MAX_VALUE;
        float f4 = Float.MIN_VALUE;
        float f5 = Float.MIN_VALUE;
        float f6 = 0.0f;
        float[] fArray = null;
        int n4 = 0;
        int n5 = n2;
        while (n5 < n3) {
            int n6 = cArray[n5];
            if (n6 < 256) {
                n4 = n6;
                fArray = this.latin1GlyphInfo;
            } else if (n6 >= 12352 && n6 < 12544) {
                n4 = n6 - 12352;
                fArray = this.kanaGlyphInfo;
            } else if (n6 >= 12800 && n6 < 40880) {
                n4 = 192;
                fArray = this.kanaGlyphInfo;
            } else if (n6 >= 65377 && n6 < 65438) {
                n4 = 193;
                fArray = this.kanaGlyphInfo;
            } else if (n6 >= 65280 && n6 < 65375) {
                n4 = 194;
                fArray = this.kanaGlyphInfo;
            } else if (n6 >= 65504 && n6 < 65511) {
                n4 = 194;
                fArray = this.kanaGlyphInfo;
            } else {
                throw new IndexOutOfBoundsException("no advance for char " + Integer.toHexString(n6));
            }
            float f7 = f6 + fArray[(n4 *= 8) + 4];
            float f8 = fArray[n4 + 5];
            float f9 = f6 + fArray[n4 + 6];
            float f10 = fArray[n4 + 7];
            if (f9 > f7 && f10 > f8) {
                if (f7 < f2) {
                    f2 = f7;
                }
                if (f8 < f3) {
                    f3 = f8;
                }
                if (f9 > f4) {
                    f4 = f9;
                }
                if (f10 > f5) {
                    f5 = f10;
                }
            }
            f6 += fArray[n4 + 2];
            ++n5;
        }
        return new Rectangle2D.Float(f2, f3, f4 - f2, f5 - f3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStats(int[] nArray) {
        SoftReference[] softReferenceArray = cache;
        synchronized (cache) {
            nArray[0] = statCount;
            nArray[1] = statTest;
            nArray[2] = statMiss;
            nArray[3] = statFlush;
            nArray[4] = statFlushDelta;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static {
        enabled = true;
        char[] cArray = new char[256];
        int n2 = 0;
        while (n2 < cArray.length) {
            cArray[n2] = (char)n2;
            ++n2;
        }
        latin1 = new String(cArray);
        int n3 = 192;
        cArray = new char[n3 + 3];
        int n4 = 0;
        while (n4 < n3) {
            cArray[n4] = (char)(12352 + n4);
            ++n4;
        }
        cArray[n3] = 20126;
        cArray[n3 + 1] = 65281;
        cArray[n3 + 2] = 65377;
        kana = new String(cArray);
        try {
            String string = System.getProperty("sun.awt.font.advancecache");
            if (string != null && string.equals("off")) {
                enabled = false;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        statCount = 0;
        statTest = 0;
        statMiss = 0;
        statFlush = 0;
        statFlushDelta = 0;
        statLastFlushCount = 0;
    }
}

