/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.dnd;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.util.Map;
import sun.awt.SunToolkit;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.dnd.SunDropTargetContextPeer;

public abstract class SunDragSourceContextPeer
implements DragSourceContextPeer {
    private DragGestureEvent trigger;
    private Component component;
    private Cursor cursor;
    private long nativeCtxt;
    private DragSourceContext dragSourceContext;
    private int sourceActions;
    private static boolean dragDropInProgress = false;
    static final int DISPATCH_ENTER = 1;
    static final int DISPATCH_MOTION = 2;
    static final int DISPATCH_CHANGED = 3;
    static final int DISPATCH_EXIT = 4;
    static final int DISPATCH_FINISH = 5;
    static final int DISPATCH_MOUSE_MOVED = 6;
    static /* synthetic */ Class class$sun$awt$dnd$SunDragSourceContextPeer;

    public SunDragSourceContextPeer(DragGestureEvent dragGestureEvent) {
        this.trigger = dragGestureEvent;
        this.component = this.trigger != null ? this.trigger.getComponent() : null;
    }

    public void startDrag(DragSourceContext dragSourceContext, Cursor cursor, Image image, Point point) throws InvalidDnDOperationException {
        if (this.getTrigger().getTriggerEvent() == null) {
            throw new InvalidDnDOperationException("DragGestureEvent has a null trigger");
        }
        this.dragSourceContext = dragSourceContext;
        this.cursor = cursor;
        this.sourceActions = this.getDragSourceContext().getSourceActions();
        Transferable transferable = this.getDragSourceContext().getTransferable();
        Map map = DataTransferer.getInstance().getFormatsForTransferable(transferable, DataTransferer.adaptFlavorMap(this.getTrigger().getDragSource().getFlavorMap()));
        DataTransferer.getInstance();
        long[] lArray = DataTransferer.keysToLongArray(map);
        this.startDrag(transferable, lArray, map);
    }

    protected abstract void startDrag(Transferable var1, long[] var2, Map var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursor(Cursor cursor) throws InvalidDnDOperationException {
        SunDragSourceContextPeer sunDragSourceContextPeer = this;
        synchronized (sunDragSourceContextPeer) {
            if (this.cursor == null || !this.cursor.equals(cursor)) {
                this.cursor = cursor;
                if (this.getNativeContext() != 0L) {
                    this.setNativeCursor(this.getNativeContext(), cursor, cursor != null ? cursor.getType() : 0);
                }
            }
        }
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    private native void setNativeCursor(long var1, Cursor var3, int var4);

    protected synchronized void setTrigger(DragGestureEvent dragGestureEvent) {
        this.trigger = dragGestureEvent;
        this.component = this.trigger != null ? this.trigger.getComponent() : null;
    }

    protected DragGestureEvent getTrigger() {
        return this.trigger;
    }

    protected Component getComponent() {
        return this.component;
    }

    protected synchronized void setNativeContext(long l2) {
        this.nativeCtxt = l2;
    }

    protected synchronized long getNativeContext() {
        return this.nativeCtxt;
    }

    protected DragSourceContext getDragSourceContext() {
        return this.dragSourceContext;
    }

    public void transferablesFlavorsChanged() {
    }

    private void dragEnter(int n2, int n3, int n4, int n5) {
        int n6 = SunDragSourceContextPeer.convertModifiersToDropAction(n3, this.sourceActions);
        DragSourceDragEvent dragSourceDragEvent = new DragSourceDragEvent(this.getDragSourceContext(), n6, n2 & this.sourceActions, n3, n4, n5);
        EventDispatcher eventDispatcher = new EventDispatcher(1, dragSourceDragEvent);
        SunToolkit.executeOnEventHandlerThread(this.getComponent(), eventDispatcher);
    }

    private void dragMotion(int n2, int n3, int n4, int n5) {
        int n6 = SunDragSourceContextPeer.convertModifiersToDropAction(n3, this.sourceActions);
        DragSourceDragEvent dragSourceDragEvent = new DragSourceDragEvent(this.getDragSourceContext(), n6, n2 & this.sourceActions, n3, n4, n5);
        EventDispatcher eventDispatcher = new EventDispatcher(2, dragSourceDragEvent);
        SunToolkit.executeOnEventHandlerThread(this.getComponent(), eventDispatcher);
    }

    private void operationChanged(int n2, int n3, int n4, int n5) {
        int n6 = SunDragSourceContextPeer.convertModifiersToDropAction(n3, this.sourceActions);
        DragSourceDragEvent dragSourceDragEvent = new DragSourceDragEvent(this.getDragSourceContext(), n6, n2 & this.sourceActions, n3, n4, n5);
        EventDispatcher eventDispatcher = new EventDispatcher(3, dragSourceDragEvent);
        SunToolkit.executeOnEventHandlerThread(this.getComponent(), eventDispatcher);
    }

    private void dragExit(int n2, int n3) {
        DragSourceEvent dragSourceEvent = new DragSourceEvent(this.getDragSourceContext(), n2, n3);
        EventDispatcher eventDispatcher = new EventDispatcher(4, dragSourceEvent);
        SunToolkit.executeOnEventHandlerThread(this.getComponent(), eventDispatcher);
    }

    private void dragMouseMoved(int n2, int n3, int n4, int n5) {
        int n6 = SunDragSourceContextPeer.convertModifiersToDropAction(n3, this.sourceActions);
        DragSourceDragEvent dragSourceDragEvent = new DragSourceDragEvent(this.getDragSourceContext(), n6, n2 & this.sourceActions, n3, n4, n5);
        EventDispatcher eventDispatcher = new EventDispatcher(6, dragSourceDragEvent);
        SunToolkit.executeOnEventHandlerThread(this.getComponent(), eventDispatcher);
    }

    private void dragDropFinished(boolean bl2, int n2, int n3, int n4) {
        DragSourceDropEvent dragSourceDropEvent = new DragSourceDropEvent(this.getDragSourceContext(), n2 & this.sourceActions, bl2, n3, n4);
        EventDispatcher eventDispatcher = new EventDispatcher(5, dragSourceDropEvent);
        SunToolkit.executeOnEventHandlerThread(this.getComponent(), eventDispatcher);
        this.setNativeContext(0L);
    }

    protected abstract boolean needsBogusExitBeforeDrop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDragDropInProgress(boolean bl2) throws InvalidDnDOperationException {
        if (dragDropInProgress == bl2) {
            throw new InvalidDnDOperationException(SunDragSourceContextPeer.getExceptionMessage(bl2));
        }
        Class clazz = class$sun$awt$dnd$SunDragSourceContextPeer == null ? (class$sun$awt$dnd$SunDragSourceContextPeer = SunDragSourceContextPeer.class$("sun.awt.dnd.SunDragSourceContextPeer")) : class$sun$awt$dnd$SunDragSourceContextPeer;
        synchronized (clazz) {
            if (dragDropInProgress == bl2) {
                throw new InvalidDnDOperationException(SunDragSourceContextPeer.getExceptionMessage(bl2));
            }
            dragDropInProgress = bl2;
        }
    }

    public static void checkDragDropInProgress() throws InvalidDnDOperationException {
        if (dragDropInProgress) {
            throw new InvalidDnDOperationException(SunDragSourceContextPeer.getExceptionMessage(true));
        }
    }

    private static String getExceptionMessage(boolean bl2) {
        return bl2 ? "Drag and drop in progress" : "No drag in progress";
    }

    public static int convertModifiersToDropAction(int n2, int n3) {
        int n4 = 0;
        switch (n2 & 0xC0) {
            case 192: {
                n4 = 0x40000000;
                break;
            }
            case 128: {
                n4 = 1;
                break;
            }
            case 64: {
                n4 = 2;
                break;
            }
            default: {
                if ((n3 & 2) != 0) {
                    n4 = 2;
                    break;
                }
                if ((n3 & 1) != 0) {
                    n4 = 1;
                    break;
                }
                if ((n3 & 0x40000000) == 0) break;
                n4 = 0x40000000;
            }
        }
        return n4 & n3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class EventDispatcher
    implements Runnable {
        private final int dispatchType;
        private final DragSourceEvent event;

        EventDispatcher(int n2, DragSourceEvent dragSourceEvent) {
            switch (n2) {
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    if (dragSourceEvent instanceof DragSourceDragEvent) break;
                    throw new IllegalArgumentException("Event: " + dragSourceEvent);
                }
                case 4: {
                    break;
                }
                case 5: {
                    if (dragSourceEvent instanceof DragSourceDropEvent) break;
                    throw new IllegalArgumentException("Event: " + dragSourceEvent);
                }
                default: {
                    throw new IllegalArgumentException("Dispatch type: " + n2);
                }
            }
            this.dispatchType = n2;
            this.event = dragSourceEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DragSourceContext dragSourceContext = SunDragSourceContextPeer.this.getDragSourceContext();
            switch (this.dispatchType) {
                case 1: {
                    dragSourceContext.dragEnter((DragSourceDragEvent)this.event);
                    break;
                }
                case 2: {
                    dragSourceContext.dragOver((DragSourceDragEvent)this.event);
                    break;
                }
                case 3: {
                    dragSourceContext.dropActionChanged((DragSourceDragEvent)this.event);
                    break;
                }
                case 4: {
                    dragSourceContext.dragExit(this.event);
                    break;
                }
                case 6: {
                    dragSourceContext.dragMouseMoved((DragSourceDragEvent)this.event);
                    break;
                }
                case 5: {
                    try {
                        if (SunDragSourceContextPeer.this.needsBogusExitBeforeDrop()) {
                            dragSourceContext.dragExit(this.event);
                        }
                        dragSourceContext.dragDropEnd((DragSourceDropEvent)this.event);
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        SunDragSourceContextPeer.setDragDropInProgress(false);
                        SunDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(null);
                        throw throwable;
                    }
                    SunDragSourceContextPeer.setDragDropInProgress(false);
                    SunDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(null);
                    break;
                }
                default: {
                    throw new IllegalStateException("Dispatch type: " + this.dispatchType);
                }
            }
        }
    }
}

