/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.XMLString;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class Expression
implements Serializable {
    protected SourceLocator m_slocator;

    public boolean canTraverseOutsideSubtree() {
        return false;
    }

    public void setSourceLocator(SourceLocator sourceLocator) {
        this.m_slocator = sourceLocator;
    }

    public XObject execute(XPathContext xPathContext, int n2) throws TransformerException {
        return this.execute(xPathContext);
    }

    public XObject execute(XPathContext xPathContext, int n2, DTM dTM, int n3) throws TransformerException {
        return this.execute(xPathContext);
    }

    public abstract XObject execute(XPathContext var1) throws TransformerException;

    public double num(XPathContext xPathContext) throws TransformerException {
        return this.execute(xPathContext).num();
    }

    public boolean bool(XPathContext xPathContext) throws TransformerException {
        return this.execute(xPathContext).bool();
    }

    public XMLString xstr(XPathContext xPathContext) throws TransformerException {
        return this.execute(xPathContext).xstr();
    }

    public boolean isNodesetExpr() {
        return false;
    }

    public int asNode(XPathContext xPathContext) throws TransformerException {
        return this.execute(xPathContext).iter().nextNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DTMIterator asIterator(XPathContext xPathContext, int n2) throws TransformerException {
        try {
            xPathContext.pushCurrentNodeAndExpression(n2, n2);
            DTMIterator dTMIterator = this.execute(xPathContext).iter();
            Object var5_4 = null;
            xPathContext.popCurrentNodeAndExpression();
            return dTMIterator;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            xPathContext.popCurrentNodeAndExpression();
            throw throwable;
        }
    }

    public void executeCharsToContentHandler(XPathContext xPathContext, ContentHandler contentHandler) throws TransformerException, SAXException {
        XObject xObject = this.execute(xPathContext);
        xObject.dispatchCharactersEvents(contentHandler);
    }

    public boolean isStableNumber() {
        return false;
    }

    public abstract void fixupVariables(Vector var1, int var2);

    public void warn(XPathContext xPathContext, int n2, Object[] objectArray) throws TransformerException {
        String string = XSLMessages.createXPATHWarning(n2, objectArray);
        if (null != xPathContext) {
            ErrorListener errorListener = xPathContext.getErrorListener();
            errorListener.warning(new TransformerException(string, xPathContext.getSAXLocator()));
        }
    }

    public void assertion(boolean bl2, String string) throws TransformerException {
        if (!bl2) {
            String string2 = XSLMessages.createXPATHMessage(30, new Object[]{string});
            throw new RuntimeException(string2);
        }
    }

    public void error(XPathContext xPathContext, int n2, Object[] objectArray) throws TransformerException {
        String string = XSLMessages.createXPATHMessage(n2, objectArray);
        if (null != xPathContext) {
            ErrorListener errorListener = xPathContext.getErrorListener();
            TransformerException transformerException = new TransformerException(string, this.m_slocator);
            errorListener.fatalError(transformerException);
        }
    }
}

