/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ListUI;
import javax.swing.text.Position;

public class JList
extends JComponent
implements Scrollable,
Accessible {
    private static final String uiClassID = "ListUI";
    public static final int VERTICAL = 0;
    public static final int VERTICAL_WRAP = 1;
    public static final int HORIZONTAL_WRAP = 2;
    private int fixedCellWidth = -1;
    private int fixedCellHeight = -1;
    private int horizontalScrollIncrement = -1;
    private Object prototypeCellValue;
    private int visibleRowCount = 8;
    private Color selectionForeground;
    private Color selectionBackground;
    private boolean dragEnabled;
    private ListSelectionModel selectionModel;
    private ListModel dataModel;
    private ListCellRenderer cellRenderer;
    private ListSelectionListener selectionListener;
    private int layoutOrientation;
    static /* synthetic */ Class class$javax$swing$event$ListSelectionListener;

    public JList(ListModel listModel) {
        if (listModel == null) {
            throw new IllegalArgumentException("dataModel must be non null");
        }
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.layoutOrientation = 0;
        this.dataModel = listModel;
        this.selectionModel = this.createSelectionModel();
        this.setAutoscrolls(true);
        this.setOpaque(true);
        this.updateUI();
    }

    public JList(final Object[] objectArray) {
        this(new AbstractListModel(){

            public int getSize() {
                return objectArray.length;
            }

            public Object getElementAt(int n2) {
                return objectArray[n2];
            }
        });
    }

    public JList(final Vector vector) {
        this(new AbstractListModel(){

            public int getSize() {
                return vector.size();
            }

            public Object getElementAt(int n2) {
                return vector.elementAt(n2);
            }
        });
    }

    public JList() {
        this(new AbstractListModel(){

            public int getSize() {
                return 0;
            }

            public Object getElementAt(int n2) {
                return "No Data Model";
            }
        });
    }

    public ListUI getUI() {
        return (ListUI)this.ui;
    }

    public void setUI(ListUI listUI) {
        super.setUI(listUI);
    }

    public void updateUI() {
        this.setUI((ListUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    private void updateFixedCellSize() {
        ListCellRenderer listCellRenderer = this.getCellRenderer();
        Object object = this.getPrototypeCellValue();
        if (listCellRenderer != null && object != null) {
            Component component = listCellRenderer.getListCellRendererComponent(this, object, 0, false, false);
            Font font = component.getFont();
            component.setFont(this.getFont());
            Dimension dimension = component.getPreferredSize();
            this.fixedCellWidth = dimension.width;
            this.fixedCellHeight = dimension.height;
            component.setFont(font);
        }
    }

    public Object getPrototypeCellValue() {
        return this.prototypeCellValue;
    }

    public void setPrototypeCellValue(Object object) {
        Object object2 = this.prototypeCellValue;
        this.prototypeCellValue = object;
        if (object != null && !object.equals(object2)) {
            this.updateFixedCellSize();
        }
        this.firePropertyChange("prototypeCellValue", object2, object);
    }

    public int getFixedCellWidth() {
        return this.fixedCellWidth;
    }

    public void setFixedCellWidth(int n2) {
        int n3 = this.fixedCellWidth;
        this.fixedCellWidth = n2;
        this.firePropertyChange("fixedCellWidth", n3, this.fixedCellWidth);
    }

    public int getFixedCellHeight() {
        return this.fixedCellHeight;
    }

    public void setFixedCellHeight(int n2) {
        int n3 = this.fixedCellHeight;
        this.fixedCellHeight = n2;
        this.firePropertyChange("fixedCellHeight", n3, this.fixedCellHeight);
    }

    public ListCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        ListCellRenderer listCellRenderer2 = this.cellRenderer;
        this.cellRenderer = listCellRenderer;
        if (listCellRenderer != null && !listCellRenderer.equals(listCellRenderer2)) {
            this.updateFixedCellSize();
        }
        this.firePropertyChange("cellRenderer", listCellRenderer2, listCellRenderer);
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionForeground(Color color) {
        Color color2 = this.selectionForeground;
        this.selectionForeground = color;
        this.firePropertyChange("selectionForeground", color2, color);
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public void setSelectionBackground(Color color) {
        Color color2 = this.selectionBackground;
        this.selectionBackground = color;
        this.firePropertyChange("selectionBackground", color2, color);
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public void setVisibleRowCount(int n2) {
        int n3 = this.visibleRowCount;
        this.visibleRowCount = Math.max(0, n2);
        this.firePropertyChange("visibleRowCount", n3, n2);
    }

    public int getLayoutOrientation() {
        return this.layoutOrientation;
    }

    public void setLayoutOrientation(int n2) {
        int n3 = this.layoutOrientation;
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                this.layoutOrientation = n2;
                this.firePropertyChange("layoutOrientation", n3, n2);
                break;
            }
            default: {
                throw new IllegalArgumentException("layoutOrientation must be one of: VERTICAL, HORIZONTAL_WRAP or VERTICAL_WRAP");
            }
        }
    }

    public int getFirstVisibleIndex() {
        Rectangle rectangle;
        Rectangle rectangle2 = this.getVisibleRect();
        int n2 = this.getComponentOrientation().isLeftToRight() ? this.locationToIndex(rectangle2.getLocation()) : this.locationToIndex(new Point(rectangle2.x + rectangle2.width - 1, rectangle2.y));
        if (n2 != -1 && (rectangle = this.getCellBounds(n2, n2)) != null) {
            SwingUtilities.computeIntersection(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle);
            if (rectangle.width == 0 || rectangle.height == 0) {
                n2 = -1;
            }
        }
        return n2;
    }

    public int getLastVisibleIndex() {
        Rectangle rectangle;
        boolean bl2 = this.getComponentOrientation().isLeftToRight();
        Rectangle rectangle2 = this.getVisibleRect();
        Point point = bl2 ? new Point(rectangle2.x + rectangle2.width - 1, rectangle2.y + rectangle2.height - 1) : new Point(rectangle2.x, rectangle2.y + rectangle2.height - 1);
        int n2 = this.locationToIndex(point);
        if (n2 != -1 && (rectangle = this.getCellBounds(n2, n2)) != null) {
            SwingUtilities.computeIntersection(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle);
            if (rectangle.width == 0 || rectangle.height == 0) {
                int n3;
                Point point2 = new Point(rectangle2.x, point.y);
                int n4 = -1;
                int n5 = n2;
                n2 = -1;
                do {
                    n3 = n4;
                    n4 = this.locationToIndex(point2);
                    if (n4 == -1) continue;
                    rectangle = this.getCellBounds(n4, n4);
                    if (n4 != n5 && rectangle != null && rectangle.contains(point2)) {
                        n2 = n4;
                        point2.x = rectangle.x + rectangle.width + 1;
                        if (point2.x < point.x) continue;
                        n3 = n4;
                        continue;
                    }
                    n3 = n4;
                } while (n4 != -1 && n3 != n4);
            }
        }
        return n2;
    }

    public void ensureIndexIsVisible(int n2) {
        Rectangle rectangle = this.getCellBounds(n2, n2);
        if (rectangle != null) {
            this.scrollRectToVisible(rectangle);
        }
    }

    public void setDragEnabled(boolean bl2) {
        if (bl2 && GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.dragEnabled = bl2;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public int getNextMatch(String string, int n2, Position.Bias bias) {
        ListModel listModel = this.getModel();
        int n3 = listModel.getSize();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0 || n2 >= n3) {
            throw new IllegalArgumentException();
        }
        string = string.toUpperCase();
        int n4 = bias == Position.Bias.Forward ? 1 : -1;
        int n5 = n2;
        do {
            String string2;
            Object object;
            if ((object = listModel.getElementAt(n5)) == null) continue;
            if (object instanceof String) {
                string2 = ((String)object).toUpperCase();
            } else {
                string2 = object.toString();
                if (string2 != null) {
                    string2 = string2.toUpperCase();
                }
            }
            if (string2 == null || !string2.startsWith(string)) continue;
            return n5;
        } while ((n5 = (n5 + n4 + n3) % n3) != n2);
        return -1;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            Rectangle rectangle;
            Point point = mouseEvent.getPoint();
            int n2 = this.locationToIndex(point);
            ListCellRenderer listCellRenderer = this.getCellRenderer();
            if (n2 != -1 && listCellRenderer != null && (rectangle = this.getCellBounds(n2, n2)) != null && rectangle.contains(point.x, point.y)) {
                ListSelectionModel listSelectionModel = this.getSelectionModel();
                Component component = listCellRenderer.getListCellRendererComponent(this, this.getModel().getElementAt(n2), n2, listSelectionModel.isSelectedIndex(n2), this.hasFocus() && listSelectionModel.getLeadSelectionIndex() == n2);
                if (component instanceof JComponent) {
                    point.translate(-rectangle.x, -rectangle.y);
                    MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    String string = ((JComponent)component).getToolTipText(mouseEvent2);
                    if (string != null) {
                        return string;
                    }
                }
            }
        }
        return super.getToolTipText();
    }

    public int locationToIndex(Point point) {
        ListUI listUI = this.getUI();
        return listUI != null ? listUI.locationToIndex(this, point) : -1;
    }

    public Point indexToLocation(int n2) {
        ListUI listUI = this.getUI();
        return listUI != null ? listUI.indexToLocation(this, n2) : null;
    }

    public Rectangle getCellBounds(int n2, int n3) {
        ListUI listUI = this.getUI();
        return listUI != null ? listUI.getCellBounds(this, n2, n3) : null;
    }

    public ListModel getModel() {
        return this.dataModel;
    }

    public void setModel(ListModel listModel) {
        if (listModel == null) {
            throw new IllegalArgumentException("model must be non null");
        }
        ListModel listModel2 = this.dataModel;
        this.dataModel = listModel;
        this.firePropertyChange("model", listModel2, this.dataModel);
        this.clearSelection();
    }

    public void setListData(final Object[] objectArray) {
        this.setModel(new AbstractListModel(){

            public int getSize() {
                return objectArray.length;
            }

            public Object getElementAt(int n2) {
                return objectArray[n2];
            }
        });
    }

    public void setListData(final Vector vector) {
        this.setModel(new AbstractListModel(){

            public int getSize() {
                return vector.size();
            }

            public Object getElementAt(int n2) {
                return vector.elementAt(n2);
            }
        });
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    protected void fireSelectionValueChanged(int n2, int n3, boolean bl2) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListSelectionEvent listSelectionEvent = null;
        int n4 = objectArray.length - 2;
        while (n4 >= 0) {
            if (objectArray[n4] == (class$javax$swing$event$ListSelectionListener == null ? JList.class$("javax.swing.event.ListSelectionListener") : class$javax$swing$event$ListSelectionListener)) {
                if (listSelectionEvent == null) {
                    listSelectionEvent = new ListSelectionEvent(this, n2, n3, bl2);
                }
                ((ListSelectionListener)objectArray[n4 + 1]).valueChanged(listSelectionEvent);
            }
            n4 -= 2;
        }
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        if (this.selectionListener == null) {
            this.selectionListener = new ListSelectionHandler();
            this.getSelectionModel().addListSelectionListener(this.selectionListener);
        }
        this.listenerList.add(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = JList.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener, listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.remove(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = JList.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener, listSelectionListener);
    }

    public ListSelectionListener[] getListSelectionListeners() {
        return (ListSelectionListener[])this.listenerList.getListeners(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = JList.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener);
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new IllegalArgumentException("selectionModel must be non null");
        }
        if (this.selectionListener != null) {
            this.selectionModel.removeListSelectionListener(this.selectionListener);
            listSelectionModel.addListSelectionListener(this.selectionListener);
        }
        ListSelectionModel listSelectionModel2 = this.selectionModel;
        this.selectionModel = listSelectionModel;
        this.firePropertyChange("selectionModel", listSelectionModel2, listSelectionModel);
    }

    public void setSelectionMode(int n2) {
        this.getSelectionModel().setSelectionMode(n2);
    }

    public int getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    public int getAnchorSelectionIndex() {
        return this.getSelectionModel().getAnchorSelectionIndex();
    }

    public int getLeadSelectionIndex() {
        return this.getSelectionModel().getLeadSelectionIndex();
    }

    public int getMinSelectionIndex() {
        return this.getSelectionModel().getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.getSelectionModel().getMaxSelectionIndex();
    }

    public boolean isSelectedIndex(int n2) {
        return this.getSelectionModel().isSelectedIndex(n2);
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    public void setSelectionInterval(int n2, int n3) {
        this.getSelectionModel().setSelectionInterval(n2, n3);
    }

    public void addSelectionInterval(int n2, int n3) {
        this.getSelectionModel().addSelectionInterval(n2, n3);
    }

    public void removeSelectionInterval(int n2, int n3) {
        this.getSelectionModel().removeSelectionInterval(n2, n3);
    }

    public void setValueIsAdjusting(boolean bl2) {
        this.getSelectionModel().setValueIsAdjusting(bl2);
    }

    public boolean getValueIsAdjusting() {
        return this.getSelectionModel().getValueIsAdjusting();
    }

    public int[] getSelectedIndices() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        int n2 = listSelectionModel.getMinSelectionIndex();
        int n3 = listSelectionModel.getMaxSelectionIndex();
        if (n2 < 0 || n3 < 0) {
            return new int[0];
        }
        int[] nArray = new int[1 + (n3 - n2)];
        int n4 = 0;
        int n5 = n2;
        while (n5 <= n3) {
            if (listSelectionModel.isSelectedIndex(n5)) {
                nArray[n4++] = n5;
            }
            ++n5;
        }
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, 0, nArray2, 0, n4);
        return nArray2;
    }

    public void setSelectedIndex(int n2) {
        this.getSelectionModel().setSelectionInterval(n2, n2);
    }

    public void setSelectedIndices(int[] nArray) {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.clearSelection();
        int n2 = 0;
        while (n2 < nArray.length) {
            listSelectionModel.addSelectionInterval(nArray[n2], nArray[n2]);
            ++n2;
        }
    }

    public Object[] getSelectedValues() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        ListModel listModel = this.getModel();
        int n2 = listSelectionModel.getMinSelectionIndex();
        int n3 = listSelectionModel.getMaxSelectionIndex();
        if (n2 < 0 || n3 < 0) {
            return new Object[0];
        }
        Object[] objectArray = new Object[1 + (n3 - n2)];
        int n4 = 0;
        int n5 = n2;
        while (n5 <= n3) {
            if (listSelectionModel.isSelectedIndex(n5)) {
                objectArray[n4++] = listModel.getElementAt(n5);
            }
            ++n5;
        }
        Object[] objectArray2 = new Object[n4];
        System.arraycopy(objectArray, 0, objectArray2, 0, n4);
        return objectArray2;
    }

    public int getSelectedIndex() {
        return this.getMinSelectionIndex();
    }

    public Object getSelectedValue() {
        int n2 = this.getMinSelectionIndex();
        return n2 == -1 ? null : this.getModel().getElementAt(n2);
    }

    public void setSelectedValue(Object object, boolean bl2) {
        if (object == null) {
            this.setSelectedIndex(-1);
        } else if (!object.equals(this.getSelectedValue())) {
            ListModel listModel = this.getModel();
            int n2 = 0;
            int n3 = listModel.getSize();
            while (n2 < n3) {
                if (object.equals(listModel.getElementAt(n2))) {
                    this.setSelectedIndex(n2);
                    if (bl2) {
                        this.ensureIndexIsVisible(n2);
                    }
                    this.repaint();
                    return;
                }
                ++n2;
            }
            this.setSelectedIndex(-1);
        }
        this.repaint();
    }

    private void checkScrollableParameters(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException("visibleRect must be non-null");
        }
        switch (n2) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
            }
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        if (this.getLayoutOrientation() != 0) {
            return this.getPreferredSize();
        }
        Insets insets = this.getInsets();
        int n2 = insets.left + insets.right;
        int n3 = insets.top + insets.bottom;
        int n4 = this.getVisibleRowCount();
        int n5 = this.getFixedCellWidth();
        int n6 = this.getFixedCellHeight();
        if (n5 > 0 && n6 > 0) {
            int n7 = n5 + n2;
            int n8 = n4 * n6 + n3;
            return new Dimension(n7, n8);
        }
        if (this.getModel().getSize() > 0) {
            int n9 = this.getPreferredSize().width;
            Rectangle rectangle = this.getCellBounds(0, 0);
            int n10 = rectangle != null ? n4 * rectangle.height + n3 : 1;
            return new Dimension(n9, n10);
        }
        n5 = n5 > 0 ? n5 : 256;
        n6 = n6 > 0 ? n6 : 16;
        return new Dimension(n5, n6 * n4);
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n2, int n3) {
        this.checkScrollableParameters(rectangle, n2);
        if (n2 == 0) {
            Font font = this.getFont();
            return font != null ? font.getSize() : 1;
        }
        int n4 = this.getFirstVisibleIndex();
        if (n4 == -1) {
            return 0;
        }
        if (n3 > 0) {
            Rectangle rectangle2 = this.getCellBounds(n4, n4);
            return rectangle2 == null ? 0 : rectangle2.height - (rectangle.y - rectangle2.y);
        }
        Rectangle rectangle3 = this.getCellBounds(n4, n4);
        if (rectangle3.y == rectangle.y && n4 == 0) {
            return 0;
        }
        if (rectangle3.y == rectangle.y) {
            Rectangle rectangle4 = this.getCellBounds(n4 - 1, n4 - 1);
            if (rectangle4.x != rectangle3.x) {
                return 0;
            }
            return rectangle4 == null ? 0 : rectangle4.height;
        }
        return rectangle.y - rectangle3.y;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n2, int n3) {
        int n4;
        this.checkScrollableParameters(rectangle, n2);
        if (n2 == 1) {
            int n5 = rectangle.height;
            if (n3 > 0) {
                Rectangle rectangle2;
                int n6 = this.locationToIndex(new Point(rectangle.x, rectangle.y + rectangle.height - 1));
                if (n6 != -1 && (rectangle2 = this.getCellBounds(n6, n6)) != null && (n5 = rectangle2.y - rectangle.y) == 0 && n6 < this.getModel().getSize() - 1) {
                    n5 = rectangle2.height;
                }
            } else {
                int n7 = this.locationToIndex(new Point(rectangle.x, rectangle.y - rectangle.height));
                int n8 = this.getFirstVisibleIndex();
                if (n7 != -1) {
                    if (n8 == -1) {
                        n8 = this.locationToIndex(rectangle.getLocation());
                    }
                    Rectangle rectangle3 = this.getCellBounds(n7, n7);
                    Rectangle rectangle4 = this.getCellBounds(n8, n8);
                    if (rectangle3 != null && rectangle4 != null) {
                        while (rectangle3.y + rectangle.height < rectangle4.y + rectangle4.height && rectangle3.y < rectangle4.y) {
                            rectangle3 = this.getCellBounds(++n7, n7);
                        }
                        n5 = rectangle.y - rectangle3.y;
                        if (n5 <= 0 && rectangle3.y > 0 && (rectangle3 = this.getCellBounds(--n7, n7)) != null) {
                            n5 = rectangle.y - rectangle3.y;
                        }
                    }
                }
            }
            return n5;
        }
        if (n2 == 0 && this.getLayoutOrientation() != 0 && (n4 = this.getFirstVisibleIndex()) != -1) {
            Rectangle rectangle5 = this.getCellBounds(n4, n4);
            if (rectangle != null && rectangle5 != null) {
                if (rectangle5.x != rectangle.x) {
                    if (n3 < 0) {
                        return Math.abs(rectangle5.x - rectangle.x);
                    }
                    return rectangle5.width + rectangle5.x - rectangle.x;
                }
                return rectangle5.width;
            }
        }
        return rectangle.width;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getLayoutOrientation() == 2 && this.getVisibleRowCount() <= 0) {
            return true;
        }
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getLayoutOrientation() == 1 && this.getVisibleRowCount() <= 0) {
            return true;
        }
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    protected String paramString() {
        String string = this.selectionForeground != null ? this.selectionForeground.toString() : "";
        String string2 = this.selectionBackground != null ? this.selectionBackground.toString() : "";
        return super.paramString() + ",fixedCellHeight=" + this.fixedCellHeight + ",fixedCellWidth=" + this.fixedCellWidth + ",horizontalScrollIncrement=" + this.horizontalScrollIncrement + ",selectionBackground=" + string2 + ",selectionForeground=" + string + ",visibleRowCount=" + this.visibleRowCount + ",layoutOrientation=" + this.layoutOrientation;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJList();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleJList
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    PropertyChangeListener,
    ListSelectionListener,
    ListDataListener {
        int leadSelectionIndex;

        public AccessibleJList() {
            JList.this.addPropertyChangeListener(this);
            JList.this.getSelectionModel().addListSelectionListener(this);
            JList.this.getModel().addListDataListener(this);
            this.leadSelectionIndex = JList.this.getLeadSelectionIndex();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (string.compareTo("model") == 0) {
                if (object != null && object instanceof ListModel) {
                    ((ListModel)object).removeListDataListener(this);
                }
                if (object2 != null && object2 instanceof ListModel) {
                    ((ListModel)object2).addListDataListener(this);
                }
            } else if (string.compareTo("selectionModel") == 0) {
                if (object != null && object instanceof ListSelectionModel) {
                    ((ListSelectionModel)object).removeListSelectionListener(this);
                }
                if (object2 != null && object2 instanceof ListSelectionModel) {
                    ((ListSelectionModel)object2).addListSelectionListener(this);
                }
                this.firePropertyChange("AccessibleSelection", false, true);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Object object;
            Object object2;
            int n2 = this.leadSelectionIndex;
            this.leadSelectionIndex = JList.this.getLeadSelectionIndex();
            if (n2 != this.leadSelectionIndex) {
                object2 = n2 >= 0 ? this.getAccessibleChild(n2) : null;
                object = this.leadSelectionIndex >= 0 ? this.getAccessibleChild(this.leadSelectionIndex) : null;
                this.firePropertyChange("AccessibleActiveDescendant", object2, object);
            }
            this.firePropertyChange("AccessibleVisibleData", false, true);
            this.firePropertyChange("AccessibleSelection", false, true);
            object2 = this.getAccessibleStateSet();
            object = JList.this.getSelectionModel();
            if (object.getSelectionMode() != 0) {
                if (!((AccessibleStateSet)object2).contains(AccessibleState.MULTISELECTABLE)) {
                    ((AccessibleStateSet)object2).add(AccessibleState.MULTISELECTABLE);
                    this.firePropertyChange("AccessibleState", null, AccessibleState.MULTISELECTABLE);
                }
            } else if (((AccessibleStateSet)object2).contains(AccessibleState.MULTISELECTABLE)) {
                ((AccessibleStateSet)object2).remove(AccessibleState.MULTISELECTABLE);
                this.firePropertyChange("AccessibleState", AccessibleState.MULTISELECTABLE, null);
            }
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.firePropertyChange("AccessibleVisibleData", false, true);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.firePropertyChange("AccessibleVisibleData", false, true);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.firePropertyChange("AccessibleVisibleData", false, true);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JList.this.selectionModel.getSelectionMode() != 0) {
                accessibleStateSet.add(AccessibleState.MULTISELECTABLE);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        public Accessible getAccessibleAt(Point point) {
            int n2 = JList.this.locationToIndex(point);
            if (n2 >= 0) {
                return new AccessibleJListChild(JList.this, n2);
            }
            return null;
        }

        public int getAccessibleChildrenCount() {
            return JList.this.getModel().getSize();
        }

        public Accessible getAccessibleChild(int n2) {
            if (n2 >= JList.this.getModel().getSize()) {
                return null;
            }
            return new AccessibleJListChild(JList.this, n2);
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleSelectionCount() {
            return JList.this.getSelectedIndices().length;
        }

        public Accessible getAccessibleSelection(int n2) {
            int n3 = this.getAccessibleSelectionCount();
            if (n2 < 0 || n2 >= n3) {
                return null;
            }
            return this.getAccessibleChild(JList.this.getSelectedIndices()[n2]);
        }

        public boolean isAccessibleChildSelected(int n2) {
            return JList.this.isSelectedIndex(n2);
        }

        public void addAccessibleSelection(int n2) {
            JList.this.addSelectionInterval(n2, n2);
        }

        public void removeAccessibleSelection(int n2) {
            JList.this.removeSelectionInterval(n2, n2);
        }

        public void clearAccessibleSelection() {
            JList.this.clearSelection();
        }

        public void selectAllAccessibleSelection() {
            JList.this.addSelectionInterval(0, this.getAccessibleChildrenCount() - 1);
        }

        protected class AccessibleJListChild
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private JList parent = null;
            private int indexInParent;
            private Component component = null;
            private AccessibleContext accessibleContext = null;
            private ListModel listModel;
            private ListCellRenderer cellRenderer = null;

            public AccessibleJListChild(JList jList, int n2) {
                this.parent = jList;
                this.setAccessibleParent(jList);
                this.indexInParent = n2;
                if (jList != null) {
                    this.listModel = jList.getModel();
                    this.cellRenderer = jList.getCellRenderer();
                }
            }

            private Component getCurrentComponent() {
                return this.getComponentAtIndex(this.indexInParent);
            }

            private AccessibleContext getCurrentAccessibleContext() {
                Component component = this.getComponentAtIndex(this.indexInParent);
                if (component instanceof Accessible) {
                    return ((Accessible)((Object)component)).getAccessibleContext();
                }
                return null;
            }

            private Component getComponentAtIndex(int n2) {
                if (n2 < 0 || n2 >= this.listModel.getSize()) {
                    return null;
                }
                if (this.parent != null && this.listModel != null && this.cellRenderer != null) {
                    Object object = this.listModel.getElementAt(n2);
                    boolean bl2 = this.parent.isSelectedIndex(n2);
                    boolean bl3 = this.parent.isFocusOwner() && n2 == this.parent.getLeadSelectionIndex();
                    return this.cellRenderer.getListCellRendererComponent(this.parent, object, n2, bl2, bl3);
                }
                return null;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public String getAccessibleName() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleName();
                }
                return null;
            }

            public void setAccessibleName(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                }
            }

            public String getAccessibleDescription() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleDescription();
                }
                return null;
            }

            public void setAccessibleDescription(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(string);
                }
            }

            public AccessibleRole getAccessibleRole() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleRole();
                }
                return null;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                AccessibleStateSet accessibleStateSet = accessibleContext != null ? accessibleContext.getAccessibleStateSet() : new AccessibleStateSet();
                accessibleStateSet = accessibleContext.getAccessibleStateSet();
                accessibleStateSet.add(AccessibleState.SELECTABLE);
                if (this.parent.isFocusOwner() && this.indexInParent == this.parent.getLeadSelectionIndex()) {
                    accessibleStateSet.add(AccessibleState.ACTIVE);
                }
                if (this.parent.isSelectedIndex(this.indexInParent)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                }
                if (this.isShowing()) {
                    accessibleStateSet.add(AccessibleState.SHOWING);
                } else if (accessibleStateSet.contains(AccessibleState.SHOWING)) {
                    accessibleStateSet.remove(AccessibleState.SHOWING);
                }
                if (this.isVisible()) {
                    accessibleStateSet.add(AccessibleState.VISIBLE);
                } else if (accessibleStateSet.contains(AccessibleState.VISIBLE)) {
                    accessibleStateSet.remove(AccessibleState.VISIBLE);
                }
                accessibleStateSet.add(AccessibleState.TRANSIENT);
                return accessibleStateSet;
            }

            public int getAccessibleIndexInParent() {
                return this.indexInParent;
            }

            public int getAccessibleChildrenCount() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleChildrenCount();
                }
                return 0;
            }

            public Accessible getAccessibleChild(int n2) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    Accessible accessible = accessibleContext.getAccessibleChild(n2);
                    accessibleContext.setAccessibleParent(this);
                    return accessible;
                }
                return null;
            }

            public Locale getLocale() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getLocale();
                }
                return null;
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.addPropertyChangeListener(propertyChangeListener);
                }
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.removePropertyChangeListener(propertyChangeListener);
                }
            }

            public AccessibleAction getAccessibleAction() {
                return this.getCurrentAccessibleContext().getAccessibleAction();
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public AccessibleSelection getAccessibleSelection() {
                return this.getCurrentAccessibleContext().getAccessibleSelection();
            }

            public AccessibleText getAccessibleText() {
                return this.getCurrentAccessibleContext().getAccessibleText();
            }

            public AccessibleValue getAccessibleValue() {
                return this.getCurrentAccessibleContext().getAccessibleValue();
            }

            public Color getBackground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getBackground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getBackground();
                }
                return null;
            }

            public void setBackground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBackground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBackground(color);
                    }
                }
            }

            public Color getForeground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getForeground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getForeground();
                }
                return null;
            }

            public void setForeground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setForeground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setForeground(color);
                    }
                }
            }

            public Cursor getCursor() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getCursor();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getCursor();
                }
                Accessible accessible = this.getAccessibleParent();
                if (accessible instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessible)).getCursor();
                }
                return null;
            }

            public void setCursor(Cursor cursor) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setCursor(cursor);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setCursor(cursor);
                    }
                }
            }

            public Font getFont() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFont();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFont();
                }
                return null;
            }

            public void setFont(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setFont(font);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setFont(font);
                    }
                }
            }

            public FontMetrics getFontMetrics(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFontMetrics(font);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFontMetrics(font);
                }
                return null;
            }

            public boolean isEnabled() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isEnabled();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isEnabled();
                }
                return false;
            }

            public void setEnabled(boolean bl2) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setEnabled(bl2);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setEnabled(bl2);
                    }
                }
            }

            public boolean isVisible() {
                int n2 = this.parent.getFirstVisibleIndex();
                int n3 = this.parent.getLastVisibleIndex();
                if (n3 == -1) {
                    n3 = this.parent.getModel().getSize() - 1;
                }
                return this.indexInParent >= n2 && this.indexInParent <= n3;
            }

            public void setVisible(boolean bl2) {
            }

            public boolean isShowing() {
                return this.parent.isShowing() && this.isVisible();
            }

            public boolean contains(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                    return rectangle.contains(point);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.contains(point);
                }
                return this.getBounds().contains(point);
            }

            public Point getLocationOnScreen() {
                if (this.parent != null) {
                    Point point = this.parent.getLocationOnScreen();
                    Point point2 = this.parent.indexToLocation(this.indexInParent);
                    if (point2 != null) {
                        point2.translate(point.x, point.y);
                        return point2;
                    }
                    return null;
                }
                return null;
            }

            public Point getLocation() {
                if (this.parent != null) {
                    return this.parent.indexToLocation(this.indexInParent);
                }
                return null;
            }

            public void setLocation(Point point) {
                if (this.parent != null && this.parent.contains(point)) {
                    JList.this.ensureIndexIsVisible(this.indexInParent);
                }
            }

            public Rectangle getBounds() {
                if (this.parent != null) {
                    return this.parent.getCellBounds(this.indexInParent, this.indexInParent);
                }
                return null;
            }

            public void setBounds(Rectangle rectangle) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBounds(rectangle);
                }
            }

            public Dimension getSize() {
                Rectangle rectangle = this.getBounds();
                if (rectangle != null) {
                    return rectangle.getSize();
                }
                return null;
            }

            public void setSize(Dimension dimension) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setSize(dimension);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setSize(dimension);
                    }
                }
            }

            public Accessible getAccessibleAt(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getAccessibleAt(point);
                }
                return null;
            }

            public boolean isFocusTraversable() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isFocusTraversable();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isFocusTraversable();
                }
                return false;
            }

            public void requestFocus() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).requestFocus();
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.requestFocus();
                    }
                }
            }

            public void addFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).addFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.addFocusListener(focusListener);
                    }
                }
            }

            public void removeFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).removeFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.removeFocusListener(focusListener);
                    }
                }
            }
        }
    }

    private class ListSelectionHandler
    implements ListSelectionListener,
    Serializable {
        private ListSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList.this.fireSelectionValueChanged(listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex(), listSelectionEvent.getValueIsAdjusting());
        }
    }
}

