/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.imageio.IIOImage;
import javax.imageio.ImageReader;
import javax.imageio.ImageTranscoder;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.event.IIOWriteProgressListener;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;

public abstract class ImageWriter
implements ImageTranscoder {
    protected ImageWriterSpi originatingProvider = null;
    protected Object output = null;
    protected Locale[] availableLocales = null;
    protected Locale locale = null;
    protected List warningListeners = null;
    protected List warningLocales = null;
    protected List progressListeners = null;
    private boolean abortFlag = false;

    protected ImageWriter(ImageWriterSpi imageWriterSpi) {
        this.originatingProvider = imageWriterSpi;
    }

    public ImageWriterSpi getOriginatingProvider() {
        return this.originatingProvider;
    }

    public void setOutput(Object object) {
        ImageWriterSpi imageWriterSpi;
        if (object != null && (imageWriterSpi = this.getOriginatingProvider()) != null) {
            Class[] classArray = imageWriterSpi.getOutputTypes();
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < classArray.length) {
                if (classArray[n2].isInstance(object)) {
                    bl2 = true;
                    break;
                }
                ++n2;
            }
            if (!bl2) {
                throw new IllegalArgumentException("Illegal output type!");
            }
        }
        this.output = object;
    }

    public Object getOutput() {
        return this.output;
    }

    public Locale[] getAvailableLocales() {
        return this.availableLocales == null ? null : (Locale[])this.availableLocales.clone();
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            Locale[] localeArray = this.getAvailableLocales();
            boolean bl2 = false;
            if (localeArray != null) {
                int n2 = 0;
                while (n2 < localeArray.length) {
                    if (locale.equals(localeArray[n2])) {
                        bl2 = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!bl2) {
                throw new IllegalArgumentException("Invalid locale!");
            }
        }
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new ImageWriteParam(this.getLocale());
    }

    public abstract IIOMetadata getDefaultStreamMetadata(ImageWriteParam var1);

    public abstract IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier var1, ImageWriteParam var2);

    public abstract IIOMetadata convertStreamMetadata(IIOMetadata var1, ImageWriteParam var2);

    public abstract IIOMetadata convertImageMetadata(IIOMetadata var1, ImageTypeSpecifier var2, ImageWriteParam var3);

    public int getNumThumbnailsSupported(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, IIOMetadata iIOMetadata, IIOMetadata iIOMetadata2) {
        return 0;
    }

    public Dimension[] getPreferredThumbnailSizes(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, IIOMetadata iIOMetadata, IIOMetadata iIOMetadata2) {
        return null;
    }

    public boolean canWriteRasters() {
        return false;
    }

    public abstract void write(IIOMetadata var1, IIOImage var2, ImageWriteParam var3) throws IOException;

    public void write(IIOImage iIOImage) throws IOException {
        this.write(null, iIOImage, null);
    }

    public void write(RenderedImage renderedImage) throws IOException {
        this.write(null, new IIOImage(renderedImage, null, null), null);
    }

    private void unsupported() {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        throw new UnsupportedOperationException("Unsupported write variant!");
    }

    public boolean canWriteSequence() {
        return false;
    }

    public void prepareWriteSequence(IIOMetadata iIOMetadata) throws IOException {
        this.unsupported();
    }

    public void writeToSequence(IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.unsupported();
    }

    public void endWriteSequence() throws IOException {
        this.unsupported();
    }

    public boolean canReplaceStreamMetadata() throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        return false;
    }

    public void replaceStreamMetadata(IIOMetadata iIOMetadata) throws IOException {
        this.unsupported();
    }

    public boolean canReplaceImageMetadata(int n2) throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        return false;
    }

    public void replaceImageMetadata(int n2, IIOMetadata iIOMetadata) throws IOException {
        this.unsupported();
    }

    public boolean canInsertImage(int n2) throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        return false;
    }

    public void writeInsert(int n2, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.unsupported();
    }

    public boolean canRemoveImage(int n2) throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        return false;
    }

    public void removeImage(int n2) throws IOException {
        this.unsupported();
    }

    public boolean canWriteEmpty() throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        return false;
    }

    public void prepareWriteEmpty(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, int n2, int n3, IIOMetadata iIOMetadata2, List list, ImageWriteParam imageWriteParam) throws IOException {
        this.unsupported();
    }

    public void endWriteEmpty() throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        throw new IllegalStateException("No call to prepareWriteEmpty!");
    }

    public boolean canInsertEmpty(int n2) throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        return false;
    }

    public void prepareInsertEmpty(int n2, ImageTypeSpecifier imageTypeSpecifier, int n3, int n4, IIOMetadata iIOMetadata, List list, ImageWriteParam imageWriteParam) throws IOException {
        this.unsupported();
    }

    public void endInsertEmpty() throws IOException {
        this.unsupported();
    }

    public boolean canReplacePixels(int n2) throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        return false;
    }

    public void prepareReplacePixels(int n2, Rectangle rectangle) throws IOException {
        this.unsupported();
    }

    public void replacePixels(RenderedImage renderedImage, ImageWriteParam imageWriteParam) throws IOException {
        this.unsupported();
    }

    public void replacePixels(Raster raster, ImageWriteParam imageWriteParam) throws IOException {
        this.unsupported();
    }

    public void endReplacePixels() throws IOException {
        this.unsupported();
    }

    public synchronized void abort() {
        this.abortFlag = true;
    }

    protected synchronized boolean abortRequested() {
        return this.abortFlag;
    }

    protected synchronized void clearAbortRequest() {
        this.abortFlag = false;
    }

    public void addIIOWriteWarningListener(IIOWriteWarningListener iIOWriteWarningListener) {
        if (iIOWriteWarningListener == null) {
            return;
        }
        this.warningListeners = ImageReader.addToList(this.warningListeners, iIOWriteWarningListener);
        this.warningLocales = ImageReader.addToList(this.warningLocales, this.getLocale());
    }

    public void removeIIOWriteWarningListener(IIOWriteWarningListener iIOWriteWarningListener) {
        if (iIOWriteWarningListener == null || this.warningListeners == null) {
            return;
        }
        int n2 = this.warningListeners.indexOf(iIOWriteWarningListener);
        if (n2 != -1) {
            this.warningListeners.remove(n2);
            this.warningLocales.remove(n2);
            if (this.warningListeners.size() == 0) {
                this.warningLocales = null;
                this.warningListeners = null;
            }
        }
    }

    public void removeAllIIOWriteWarningListeners() {
        this.warningListeners = null;
        this.warningLocales = null;
    }

    public void addIIOWriteProgressListener(IIOWriteProgressListener iIOWriteProgressListener) {
        if (iIOWriteProgressListener == null) {
            return;
        }
        this.progressListeners = ImageReader.addToList(this.progressListeners, iIOWriteProgressListener);
    }

    public void removeIIOWriteProgressListener(IIOWriteProgressListener iIOWriteProgressListener) {
        if (iIOWriteProgressListener == null || this.progressListeners == null) {
            return;
        }
        this.progressListeners = ImageReader.removeFromList(this.progressListeners, iIOWriteProgressListener);
    }

    public void removeAllIIOWriteProgressListeners() {
        this.progressListeners = null;
    }

    protected void processImageStarted(int n2) {
        if (this.progressListeners == null) {
            return;
        }
        int n3 = this.progressListeners.size();
        int n4 = 0;
        while (n4 < n3) {
            IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)this.progressListeners.get(n4);
            iIOWriteProgressListener.imageStarted(this, n2);
            ++n4;
        }
    }

    protected void processImageProgress(float f2) {
        if (this.progressListeners == null) {
            return;
        }
        int n2 = this.progressListeners.size();
        int n3 = 0;
        while (n3 < n2) {
            IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)this.progressListeners.get(n3);
            iIOWriteProgressListener.imageProgress(this, f2);
            ++n3;
        }
    }

    protected void processImageComplete() {
        if (this.progressListeners == null) {
            return;
        }
        int n2 = this.progressListeners.size();
        int n3 = 0;
        while (n3 < n2) {
            IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)this.progressListeners.get(n3);
            iIOWriteProgressListener.imageComplete(this);
            ++n3;
        }
    }

    protected void processThumbnailStarted(int n2, int n3) {
        if (this.progressListeners == null) {
            return;
        }
        int n4 = this.progressListeners.size();
        int n5 = 0;
        while (n5 < n4) {
            IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)this.progressListeners.get(n5);
            iIOWriteProgressListener.thumbnailStarted(this, n2, n3);
            ++n5;
        }
    }

    protected void processThumbnailProgress(float f2) {
        if (this.progressListeners == null) {
            return;
        }
        int n2 = this.progressListeners.size();
        int n3 = 0;
        while (n3 < n2) {
            IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)this.progressListeners.get(n3);
            iIOWriteProgressListener.thumbnailProgress(this, f2);
            ++n3;
        }
    }

    protected void processThumbnailComplete() {
        if (this.progressListeners == null) {
            return;
        }
        int n2 = this.progressListeners.size();
        int n3 = 0;
        while (n3 < n2) {
            IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)this.progressListeners.get(n3);
            iIOWriteProgressListener.thumbnailComplete(this);
            ++n3;
        }
    }

    protected void processWriteAborted() {
        if (this.progressListeners == null) {
            return;
        }
        int n2 = this.progressListeners.size();
        int n3 = 0;
        while (n3 < n2) {
            IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)this.progressListeners.get(n3);
            iIOWriteProgressListener.writeAborted(this);
            ++n3;
        }
    }

    protected void processWarningOccurred(int n2, String string) {
        if (this.warningListeners == null) {
            return;
        }
        int n3 = this.warningListeners.size();
        int n4 = 0;
        while (n4 < n3) {
            IIOWriteWarningListener iIOWriteWarningListener = (IIOWriteWarningListener)this.warningListeners.get(n4);
            iIOWriteWarningListener.warningOccurred(this, n2, string);
            ++n4;
        }
    }

    protected void processWarningOccurred(int n2, String string, String string2) {
        if (this.warningListeners == null) {
            return;
        }
        int n3 = this.warningListeners.size();
        int n4 = 0;
        while (n4 < n3) {
            IIOWriteWarningListener iIOWriteWarningListener = (IIOWriteWarningListener)this.warningListeners.get(n4);
            Locale locale = (Locale)this.warningLocales.get(n4);
            ResourceBundle resourceBundle = locale == null ? ResourceBundle.getBundle(string) : ResourceBundle.getBundle(string, locale);
            String string3 = resourceBundle.getString(string2);
            iIOWriteWarningListener.warningOccurred(this, n2, string3);
            ++n4;
        }
    }

    public void reset() {
        this.setOutput(null);
        this.setLocale(null);
        this.removeAllIIOWriteWarningListeners();
        this.removeAllIIOWriteProgressListeners();
        this.clearAbortRequest();
    }

    public void dispose() {
    }
}

