/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ReadOnlyBufferException;

class StringCharBuffer
extends CharBuffer {
    CharSequence str;

    StringCharBuffer(CharSequence charSequence, int n2, int n3) {
        super(-1, n2, n3, charSequence.length());
        int n4 = charSequence.length();
        if (n2 < 0 || n2 > n4 || n3 < n2 || n3 > n4) {
            throw new IndexOutOfBoundsException();
        }
        this.str = charSequence;
    }

    public CharBuffer slice() {
        return new StringCharBuffer(this.str, this.position(), this.limit());
    }

    private StringCharBuffer(CharSequence charSequence, int n2, int n3, int n4, int n5) {
        super(n2, n3, n4, n5);
        this.str = charSequence;
    }

    public CharBuffer duplicate() {
        return new StringCharBuffer(this.str, this.markValue(), this.position(), this.limit(), this.capacity());
    }

    public CharBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    public final char get() {
        return this.str.charAt(this.nextGetIndex());
    }

    public final char get(int n2) {
        return this.str.charAt(this.checkIndex(n2));
    }

    public final CharBuffer put(char c2) {
        throw new ReadOnlyBufferException();
    }

    public final CharBuffer put(int n2, char c2) {
        throw new ReadOnlyBufferException();
    }

    public final CharBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    public final boolean isReadOnly() {
        return true;
    }

    final String toString(int n2, int n3) {
        return this.str.toString().substring(n2, n3);
    }

    public final CharSequence subSequence(int n2, int n3) {
        try {
            int n4 = this.position();
            return new StringCharBuffer(this.str, n4 + this.checkIndex(n2, n4), n4 + this.checkIndex(n3, n4));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public boolean isDirect() {
        return false;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

