/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.Serializable;
import java.net.SocketPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Vector;

final class SocketPermissionCollection
extends PermissionCollection
implements Serializable {
    private Vector permissions = new Vector();

    public void add(Permission permission) {
        if (!(permission instanceof SocketPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        this.permissions.add(0, permission);
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof SocketPermission)) {
            return false;
        }
        SocketPermission socketPermission = (SocketPermission)permission;
        int n2 = socketPermission.getMask();
        int n3 = 0;
        int n4 = n2;
        Enumeration enumeration = this.permissions.elements();
        while (enumeration.hasMoreElements()) {
            SocketPermission socketPermission2 = (SocketPermission)enumeration.nextElement();
            if ((n4 & socketPermission2.getMask()) == 0 || !socketPermission2.impliesIgnoreMask(socketPermission)) continue;
            if (((n3 |= socketPermission2.getMask()) & n2) == n2) {
                return true;
            }
            n4 = n2 ^ n3;
        }
        return false;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

