/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Bits;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import sun.misc.SoftCache;
import sun.misc.Unsafe;
import sun.reflect.ReflectionFactory;

public class ObjectStreamClass
implements Serializable {
    public static final ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    private static final long serialVersionUID = -6120832682080437368L;
    private static final ObjectStreamField[] serialPersistentFields = NO_FIELDS;
    private static final ReflectionFactory reflFactory = (ReflectionFactory)AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());
    private static final SoftCache localDescs = new SoftCache(10);
    private static final SoftCache reflectors = new SoftCache(10);
    private Class cl;
    private String name;
    private volatile Long suid;
    private boolean isProxy;
    private boolean serializable;
    private boolean externalizable;
    private boolean hasWriteObjectData;
    private boolean hasBlockExternalData = true;
    private ClassNotFoundException resolveEx;
    private InvalidClassException deserializeEx;
    private InvalidClassException defaultSerializeEx;
    private ObjectStreamField[] fields;
    private int primDataSize;
    private int numObjFields;
    private FieldReflector fieldRefl;
    private volatile ClassDataSlot[] dataLayout;
    private Constructor cons;
    private Method writeObjectMethod;
    private Method readObjectMethod;
    private Method readObjectNoDataMethod;
    private Method writeReplaceMethod;
    private Method readResolveMethod;
    private ObjectStreamClass localDesc;
    private ObjectStreamClass superDesc;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$Externalizable;
    static /* synthetic */ Class class$java$io$ObjectOutputStream;
    static /* synthetic */ Class class$java$io$ObjectInputStream;
    static /* synthetic */ Class class$java$lang$Object;

    private static native void initNative();

    public static ObjectStreamClass lookup(Class clazz) {
        return ObjectStreamClass.lookup(clazz, false);
    }

    public String getName() {
        return this.name;
    }

    public long getSerialVersionUID() {
        if (this.suid == null) {
            this.suid = (Long)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Long(ObjectStreamClass.computeDefaultSUID(ObjectStreamClass.this.cl));
                }
            });
        }
        return this.suid;
    }

    public Class forClass() {
        return this.cl;
    }

    public ObjectStreamField[] getFields() {
        return this.getFields(true);
    }

    public ObjectStreamField getField(String string) {
        return this.getField(string, null);
    }

    public String toString() {
        return this.name + ": static final long serialVersionUID = " + this.getSerialVersionUID() + "L;";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ObjectStreamClass lookup(Class clazz, boolean bl2) {
        Object object;
        if (!bl2 && !(class$java$io$Serializable == null ? (class$java$io$Serializable = ObjectStreamClass.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz)) {
            return null;
        }
        EntryFuture entryFuture = null;
        SoftCache softCache = localDescs;
        synchronized (softCache) {
            object = localDescs.get(clazz);
            if (object == null) {
                entryFuture = new EntryFuture();
                localDescs.put(clazz, entryFuture);
            }
        }
        if (object instanceof ObjectStreamClass) {
            return (ObjectStreamClass)object;
        }
        if (object instanceof EntryFuture) {
            object = ((EntryFuture)object).get();
        } else if (object == null) {
            try {
                object = new ObjectStreamClass(clazz);
            }
            catch (Throwable throwable) {
                object = throwable;
            }
            entryFuture.set(object);
            SoftCache softCache2 = localDescs;
            synchronized (softCache2) {
                localDescs.put(clazz, object);
            }
        }
        if (object instanceof ObjectStreamClass) {
            return (ObjectStreamClass)object;
        }
        if (object instanceof RuntimeException) {
            throw (RuntimeException)object;
        }
        if (object instanceof Error) {
            throw (Error)object;
        }
        throw new InternalError("unexpected entry: " + object);
    }

    private ObjectStreamClass(final Class clazz) {
        this.cl = clazz;
        this.name = clazz.getName();
        this.isProxy = Proxy.isProxyClass(clazz);
        this.serializable = (class$java$io$Serializable == null ? (class$java$io$Serializable = ObjectStreamClass.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz);
        this.externalizable = (class$java$io$Externalizable == null ? (class$java$io$Externalizable = ObjectStreamClass.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(clazz);
        Class clazz2 = clazz.getSuperclass();
        this.superDesc = clazz2 != null ? ObjectStreamClass.lookup(clazz2, false) : null;
        this.localDesc = this;
        if (this.serializable) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ObjectStreamClass.this.suid = ObjectStreamClass.getDeclaredSUID(clazz);
                    ObjectStreamClass.access$502(ObjectStreamClass.this, ObjectStreamClass.getSerialFields(clazz));
                    try {
                        ObjectStreamClass.this.computeFieldOffsets();
                    }
                    catch (InvalidClassException invalidClassException) {
                        throw new InternalError();
                    }
                    if (ObjectStreamClass.this.externalizable) {
                        ObjectStreamClass.this.cons = ObjectStreamClass.getExternalizableConstructor(clazz);
                    } else {
                        ObjectStreamClass.this.cons = ObjectStreamClass.getSerializableConstructor(clazz);
                        ObjectStreamClass.this.writeObjectMethod = ObjectStreamClass.getPrivateMethod(clazz, "writeObject", new Class[]{class$java$io$ObjectOutputStream == null ? (class$java$io$ObjectOutputStream = ObjectStreamClass.class$("java.io.ObjectOutputStream")) : class$java$io$ObjectOutputStream}, Void.TYPE);
                        ObjectStreamClass.this.readObjectMethod = ObjectStreamClass.getPrivateMethod(clazz, "readObject", new Class[]{class$java$io$ObjectInputStream == null ? (class$java$io$ObjectInputStream = ObjectStreamClass.class$("java.io.ObjectInputStream")) : class$java$io$ObjectInputStream}, Void.TYPE);
                        ObjectStreamClass.this.readObjectNoDataMethod = ObjectStreamClass.getPrivateMethod(clazz, "readObjectNoData", new Class[0], Void.TYPE);
                        ObjectStreamClass.this.hasWriteObjectData = ObjectStreamClass.this.writeObjectMethod != null;
                    }
                    ObjectStreamClass.this.writeReplaceMethod = ObjectStreamClass.getInheritableMethod(clazz, "writeReplace", new Class[]{}, class$java$lang$Object == null ? (class$java$lang$Object = ObjectStreamClass.class$("java.lang.Object")) : class$java$lang$Object);
                    ObjectStreamClass.this.readResolveMethod = ObjectStreamClass.getInheritableMethod(clazz, "readResolve", new Class[]{}, class$java$lang$Object == null ? (class$java$lang$Object = ObjectStreamClass.class$("java.lang.Object")) : class$java$lang$Object);
                    return null;
                }
            });
        } else {
            this.suid = new Long(0L);
            this.fields = NO_FIELDS;
        }
        try {
            this.fieldRefl = ObjectStreamClass.getReflector(this.fields, this);
        }
        catch (InvalidClassException invalidClassException) {
            throw new InternalError();
        }
        if (this.cons == null) {
            this.deserializeEx = new InvalidClassException(this.name, "no valid constructor");
        }
        int n2 = 0;
        while (n2 < this.fields.length) {
            if (this.fields[n2].getField() == null) {
                this.defaultSerializeEx = new InvalidClassException(this.name, "unmatched serializable field(s) declared");
            }
            ++n2;
        }
    }

    ObjectStreamClass() {
    }

    void initProxy(Class clazz, ClassNotFoundException classNotFoundException, ObjectStreamClass objectStreamClass) throws InvalidClassException {
        this.cl = clazz;
        this.resolveEx = classNotFoundException;
        this.superDesc = objectStreamClass;
        this.isProxy = true;
        this.serializable = true;
        this.suid = new Long(0L);
        this.fields = NO_FIELDS;
        if (clazz != null) {
            this.localDesc = ObjectStreamClass.lookup(clazz, true);
            if (!this.localDesc.isProxy) {
                throw new InvalidClassException("cannot bind proxy descriptor to a non-proxy class");
            }
            this.name = this.localDesc.name;
            this.externalizable = this.localDesc.externalizable;
            this.cons = this.localDesc.cons;
            this.writeReplaceMethod = this.localDesc.writeReplaceMethod;
            this.readResolveMethod = this.localDesc.readResolveMethod;
            this.deserializeEx = this.localDesc.deserializeEx;
        }
        this.fieldRefl = ObjectStreamClass.getReflector(this.fields, this.localDesc);
    }

    void initNonProxy(ObjectStreamClass objectStreamClass, Class clazz, ClassNotFoundException classNotFoundException, ObjectStreamClass objectStreamClass2) throws InvalidClassException {
        this.cl = clazz;
        this.resolveEx = classNotFoundException;
        this.superDesc = objectStreamClass2;
        this.name = objectStreamClass.name;
        this.suid = new Long(objectStreamClass.getSerialVersionUID());
        this.isProxy = false;
        this.serializable = objectStreamClass.serializable;
        this.externalizable = objectStreamClass.externalizable;
        this.hasBlockExternalData = objectStreamClass.hasBlockExternalData;
        this.hasWriteObjectData = objectStreamClass.hasWriteObjectData;
        this.fields = objectStreamClass.fields;
        this.primDataSize = objectStreamClass.primDataSize;
        this.numObjFields = objectStreamClass.numObjFields;
        if (clazz != null) {
            this.localDesc = ObjectStreamClass.lookup(clazz, true);
            if (this.localDesc.isProxy) {
                throw new InvalidClassException("cannot bind non-proxy descriptor to a proxy class");
            }
            if (this.serializable == this.localDesc.serializable && !clazz.isArray() && this.suid.longValue() != this.localDesc.getSerialVersionUID()) {
                throw new InvalidClassException(this.localDesc.name, "local class incompatible: stream classdesc serialVersionUID = " + this.suid + ", local class serialVersionUID = " + this.localDesc.getSerialVersionUID());
            }
            if (!ObjectStreamClass.classNamesEqual(this.name, this.localDesc.name)) {
                throw new InvalidClassException(this.localDesc.name, "local class name incompatible with stream class name \"" + this.name + "\"");
            }
            if (this.serializable == this.localDesc.serializable && this.externalizable != this.localDesc.externalizable) {
                throw new InvalidClassException(this.localDesc.name, "Serializable incompatible with Externalizable");
            }
            if (this.serializable != this.localDesc.serializable || this.externalizable != this.localDesc.externalizable || !this.serializable && !this.externalizable) {
                this.deserializeEx = new InvalidClassException(this.localDesc.name, "class invalid for deserialization");
            }
            this.cons = this.localDesc.cons;
            this.writeObjectMethod = this.localDesc.writeObjectMethod;
            this.readObjectMethod = this.localDesc.readObjectMethod;
            this.readObjectNoDataMethod = this.localDesc.readObjectNoDataMethod;
            this.writeReplaceMethod = this.localDesc.writeReplaceMethod;
            this.readResolveMethod = this.localDesc.readResolveMethod;
            if (this.deserializeEx == null) {
                this.deserializeEx = this.localDesc.deserializeEx;
            }
        }
        this.fieldRefl = ObjectStreamClass.getReflector(this.fields, this.localDesc);
        this.fields = this.fieldRefl.getFields();
    }

    void readNonProxy(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl2;
        this.name = objectInputStream.readUTF();
        this.suid = new Long(objectInputStream.readLong());
        this.isProxy = false;
        byte by = objectInputStream.readByte();
        this.hasWriteObjectData = (by & 1) != 0;
        this.hasBlockExternalData = (by & 8) != 0;
        this.externalizable = (by & 4) != 0;
        boolean bl3 = bl2 = (by & 2) != 0;
        if (this.externalizable && bl2) {
            throw new InvalidClassException(this.name, "serializable and externalizable flags conflict");
        }
        this.serializable = this.externalizable || bl2;
        int n2 = objectInputStream.readShort();
        this.fields = n2 > 0 ? new ObjectStreamField[n2] : NO_FIELDS;
        int n3 = 0;
        while (n3 < n2) {
            char c2 = (char)objectInputStream.readByte();
            String string = objectInputStream.readUTF();
            String string2 = c2 == 'L' || c2 == '[' ? objectInputStream.readTypeString() : new String(new char[]{c2});
            try {
                this.fields[n3] = new ObjectStreamField(string, string2, false);
            }
            catch (RuntimeException runtimeException) {
                throw (IOException)new InvalidClassException(this.name, "invalid descriptor for field " + string).initCause(runtimeException);
            }
            ++n3;
        }
        this.computeFieldOffsets();
    }

    void writeNonProxy(ObjectOutputStream objectOutputStream) throws IOException {
        int n2;
        objectOutputStream.writeUTF(this.name);
        objectOutputStream.writeLong(this.getSerialVersionUID());
        int n3 = 0;
        if (this.externalizable) {
            n3 = (byte)(n3 | 4);
            n2 = objectOutputStream.getProtocolVersion();
            if (n2 != 1) {
                n3 = (byte)(n3 | 8);
            }
        } else if (this.serializable) {
            n3 = (byte)(n3 | 2);
        }
        if (this.hasWriteObjectData) {
            n3 = (byte)(n3 | 1);
        }
        objectOutputStream.writeByte(n3);
        objectOutputStream.writeShort(this.fields.length);
        n2 = 0;
        while (n2 < this.fields.length) {
            ObjectStreamField objectStreamField = this.fields[n2];
            objectOutputStream.writeByte(objectStreamField.getTypeCode());
            objectOutputStream.writeUTF(objectStreamField.getName());
            if (!objectStreamField.isPrimitive()) {
                objectOutputStream.writeTypeString(objectStreamField.getTypeString());
            }
            ++n2;
        }
    }

    ClassNotFoundException getResolveException() {
        return this.resolveEx;
    }

    void checkDeserialize() throws InvalidClassException {
        if (this.deserializeEx != null) {
            throw this.deserializeEx;
        }
    }

    void checkDefaultSerialize() throws InvalidClassException {
        if (this.defaultSerializeEx != null) {
            throw this.defaultSerializeEx;
        }
    }

    ObjectStreamClass getSuperDesc() {
        return this.superDesc;
    }

    ObjectStreamClass getLocalDesc() {
        return this.localDesc;
    }

    ObjectStreamField[] getFields(boolean bl2) {
        return bl2 ? (ObjectStreamField[])this.fields.clone() : this.fields;
    }

    ObjectStreamField getField(String string, Class clazz) {
        int n2 = 0;
        while (n2 < this.fields.length) {
            ObjectStreamField objectStreamField = this.fields[n2];
            if (objectStreamField.getName().equals(string)) {
                if (clazz == null || clazz == (class$java$lang$Object == null ? ObjectStreamClass.class$("java.lang.Object") : class$java$lang$Object) && !objectStreamField.isPrimitive()) {
                    return objectStreamField;
                }
                Class clazz2 = objectStreamField.getType();
                if (clazz2 != null && clazz.isAssignableFrom(clazz2)) {
                    return objectStreamField;
                }
            }
            ++n2;
        }
        return null;
    }

    boolean isProxy() {
        return this.isProxy;
    }

    boolean isExternalizable() {
        return this.externalizable;
    }

    boolean isSerializable() {
        return this.serializable;
    }

    boolean hasBlockExternalData() {
        return this.hasBlockExternalData;
    }

    boolean hasWriteObjectData() {
        return this.hasWriteObjectData;
    }

    boolean isInstantiable() {
        return this.cons != null;
    }

    boolean hasWriteObjectMethod() {
        return this.writeObjectMethod != null;
    }

    boolean hasReadObjectMethod() {
        return this.readObjectMethod != null;
    }

    boolean hasReadObjectNoDataMethod() {
        return this.readObjectNoDataMethod != null;
    }

    boolean hasWriteReplaceMethod() {
        return this.writeReplaceMethod != null;
    }

    boolean hasReadResolveMethod() {
        return this.readResolveMethod != null;
    }

    Object newInstance() throws InstantiationException, InvocationTargetException, UnsupportedOperationException {
        if (this.cons != null) {
            try {
                return this.cons.newInstance(new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError();
            }
        }
        throw new UnsupportedOperationException();
    }

    void invokeWriteObject(Object object, ObjectOutputStream objectOutputStream) throws IOException, UnsupportedOperationException {
        if (this.writeObjectMethod != null) {
            try {
                this.writeObjectMethod.invoke(object, new Object[]{objectOutputStream});
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                ObjectStreamClass.throwMiscException(throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError();
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    void invokeReadObject(Object object, ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, UnsupportedOperationException {
        if (this.readObjectMethod != null) {
            try {
                this.readObjectMethod.invoke(object, new Object[]{objectInputStream});
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)throwable;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                ObjectStreamClass.throwMiscException(throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError();
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    void invokeReadObjectNoData(Object object) throws IOException, UnsupportedOperationException {
        if (this.readObjectNoDataMethod != null) {
            try {
                this.readObjectNoDataMethod.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ObjectStreamException) {
                    throw (ObjectStreamException)throwable;
                }
                ObjectStreamClass.throwMiscException(throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError();
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    Object invokeWriteReplace(Object object) throws IOException, UnsupportedOperationException {
        if (this.writeReplaceMethod != null) {
            try {
                return this.writeReplaceMethod.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ObjectStreamException) {
                    throw (ObjectStreamException)throwable;
                }
                ObjectStreamClass.throwMiscException(throwable);
                throw new InternalError();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError();
            }
        }
        throw new UnsupportedOperationException();
    }

    Object invokeReadResolve(Object object) throws IOException, UnsupportedOperationException {
        if (this.readResolveMethod != null) {
            try {
                return this.readResolveMethod.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ObjectStreamException) {
                    throw (ObjectStreamException)throwable;
                }
                ObjectStreamClass.throwMiscException(throwable);
                throw new InternalError();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError();
            }
        }
        throw new UnsupportedOperationException();
    }

    ClassDataSlot[] getClassDataLayout() throws InvalidClassException {
        if (this.dataLayout == null) {
            this.dataLayout = this.getClassDataLayout0();
        }
        return this.dataLayout;
    }

    private ClassDataSlot[] getClassDataLayout0() throws InvalidClassException {
        Object object;
        ArrayList arrayList = new ArrayList();
        Class clazz = this.cl;
        Class clazz2 = this.cl;
        while (clazz2 != null && (class$java$io$Serializable == null ? ObjectStreamClass.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(clazz2)) {
            clazz2 = clazz2.getSuperclass();
        }
        ObjectStreamClass objectStreamClass = this;
        while (objectStreamClass != null) {
            object = objectStreamClass.cl != null ? objectStreamClass.cl.getName() : objectStreamClass.name;
            Class clazz3 = null;
            Class clazz4 = clazz;
            while (clazz4 != clazz2) {
                if (((String)object).equals(clazz4.getName())) {
                    clazz3 = clazz4;
                    break;
                }
                clazz4 = clazz4.getSuperclass();
            }
            if (clazz3 != null) {
                Class clazz5 = clazz;
                while (clazz5 != clazz3) {
                    arrayList.add(new ClassDataSlot(ObjectStreamClass.lookup(clazz5, true), false));
                    clazz5 = clazz5.getSuperclass();
                }
                clazz = clazz3.getSuperclass();
            }
            arrayList.add(new ClassDataSlot(objectStreamClass.getVariantFor(clazz3), true));
            objectStreamClass = objectStreamClass.superDesc;
        }
        object = clazz;
        while (object != clazz2) {
            arrayList.add(new ClassDataSlot(ObjectStreamClass.lookup((Class)object, true), false));
            object = ((Class)object).getSuperclass();
        }
        Collections.reverse(arrayList);
        return (ClassDataSlot[])arrayList.toArray(new ClassDataSlot[arrayList.size()]);
    }

    int getPrimDataSize() {
        return this.primDataSize;
    }

    int getNumObjFields() {
        return this.numObjFields;
    }

    void getPrimFieldValues(Object object, byte[] byArray) {
        this.fieldRefl.getPrimFieldValues(object, byArray);
    }

    void setPrimFieldValues(Object object, byte[] byArray) {
        this.fieldRefl.setPrimFieldValues(object, byArray);
    }

    void getObjFieldValues(Object object, Object[] objectArray) {
        this.fieldRefl.getObjFieldValues(object, objectArray);
    }

    void setObjFieldValues(Object object, Object[] objectArray) {
        this.fieldRefl.setObjFieldValues(object, objectArray);
    }

    private void computeFieldOffsets() throws InvalidClassException {
        this.primDataSize = 0;
        this.numObjFields = 0;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.fields.length) {
            ObjectStreamField objectStreamField = this.fields[n3];
            switch (objectStreamField.getTypeCode()) {
                case 'B': 
                case 'Z': {
                    objectStreamField.setOffset(this.primDataSize++);
                    break;
                }
                case 'C': 
                case 'S': {
                    objectStreamField.setOffset(this.primDataSize);
                    this.primDataSize += 2;
                    break;
                }
                case 'F': 
                case 'I': {
                    objectStreamField.setOffset(this.primDataSize);
                    this.primDataSize += 4;
                    break;
                }
                case 'D': 
                case 'J': {
                    objectStreamField.setOffset(this.primDataSize);
                    this.primDataSize += 8;
                    break;
                }
                case 'L': 
                case '[': {
                    objectStreamField.setOffset(this.numObjFields++);
                    if (n2 != -1) break;
                    n2 = n3;
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
            ++n3;
        }
        if (n2 != -1 && n2 + this.numObjFields != this.fields.length) {
            throw new InvalidClassException(this.name, "illegal field order");
        }
    }

    private ObjectStreamClass getVariantFor(Class clazz) throws InvalidClassException {
        if (this.cl == clazz) {
            return this;
        }
        ObjectStreamClass objectStreamClass = new ObjectStreamClass();
        if (this.isProxy) {
            objectStreamClass.initProxy(clazz, null, this.superDesc);
        } else {
            objectStreamClass.initNonProxy(this, clazz, null, this.superDesc);
        }
        return objectStreamClass;
    }

    private static Constructor getExternalizableConstructor(Class clazz) {
        try {
            Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (constructor.getModifiers() & 1) != 0 ? constructor : null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Constructor getSerializableConstructor(Class clazz) {
        Class clazz2 = clazz;
        while ((class$java$io$Serializable == null ? ObjectStreamClass.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(clazz2)) {
            if ((clazz2 = clazz2.getSuperclass()) != null) continue;
            return null;
        }
        try {
            Constructor constructor = clazz2.getDeclaredConstructor(new Class[0]);
            int n2 = constructor.getModifiers();
            if ((n2 & 2) != 0 || (n2 & 5) == 0 && !ObjectStreamClass.packageEquals(clazz, clazz2)) {
                return null;
            }
            constructor = reflFactory.newConstructorForSerialization(clazz, constructor);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Method getInheritableMethod(Class clazz, String string, Class[] classArray, Class clazz2) {
        Method method = null;
        Class clazz3 = clazz;
        while (clazz3 != null) {
            try {
                method = clazz3.getDeclaredMethod(string, classArray);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz3 = clazz3.getSuperclass();
            }
        }
        if (method == null || method.getReturnType() != clazz2) {
            return null;
        }
        method.setAccessible(true);
        int n2 = method.getModifiers();
        if ((n2 & 0x408) != 0) {
            return null;
        }
        if ((n2 & 5) != 0) {
            return method;
        }
        if ((n2 & 2) != 0) {
            return clazz == clazz3 ? method : null;
        }
        return ObjectStreamClass.packageEquals(clazz, clazz3) ? method : null;
    }

    private static Method getPrivateMethod(Class clazz, String string, Class[] classArray, Class clazz2) {
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            method.setAccessible(true);
            int n2 = method.getModifiers();
            return method.getReturnType() == clazz2 && (n2 & 8) == 0 && (n2 & 2) != 0 ? method : null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static boolean packageEquals(Class clazz, Class clazz2) {
        Package package_;
        Package package_2 = clazz.getPackage();
        return package_2 == (package_ = clazz2.getPackage()) || package_2 != null && package_2.equals(package_);
    }

    private static boolean classNamesEqual(String string, String string2) {
        string = string.substring(string.lastIndexOf(46) + 1);
        string2 = string2.substring(string2.lastIndexOf(46) + 1);
        return string.equals(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getClassSignature(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        while (clazz.isArray()) {
            stringBuffer.append('[');
            clazz = clazz.getComponentType();
        }
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                stringBuffer.append('I');
                return stringBuffer.toString();
            } else if (clazz == Byte.TYPE) {
                stringBuffer.append('B');
                return stringBuffer.toString();
            } else if (clazz == Long.TYPE) {
                stringBuffer.append('J');
                return stringBuffer.toString();
            } else if (clazz == Float.TYPE) {
                stringBuffer.append('F');
                return stringBuffer.toString();
            } else if (clazz == Double.TYPE) {
                stringBuffer.append('D');
                return stringBuffer.toString();
            } else if (clazz == Short.TYPE) {
                stringBuffer.append('S');
                return stringBuffer.toString();
            } else if (clazz == Character.TYPE) {
                stringBuffer.append('C');
                return stringBuffer.toString();
            } else if (clazz == Boolean.TYPE) {
                stringBuffer.append('Z');
                return stringBuffer.toString();
            } else {
                if (clazz != Void.TYPE) throw new InternalError();
                stringBuffer.append('V');
            }
            return stringBuffer.toString();
        } else {
            stringBuffer.append('L' + clazz.getName().replace('.', '/') + ';');
        }
        return stringBuffer.toString();
    }

    private static String getMethodSignature(Class[] classArray, Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        int n2 = 0;
        while (n2 < classArray.length) {
            stringBuffer.append(ObjectStreamClass.getClassSignature(classArray[n2]));
            ++n2;
        }
        stringBuffer.append(')');
        stringBuffer.append(ObjectStreamClass.getClassSignature(clazz));
        return stringBuffer.toString();
    }

    private static void throwMiscException(Throwable throwable) throws IOException {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        IOException iOException = new IOException("unexpected exception type");
        iOException.initCause(throwable);
        throw iOException;
    }

    private static ObjectStreamField[] getSerialFields(Class clazz) {
        Object[] objectArray;
        if ((class$java$io$Serializable == null ? (class$java$io$Serializable = ObjectStreamClass.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz) && !(class$java$io$Externalizable == null ? (class$java$io$Externalizable = ObjectStreamClass.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(clazz) && !Proxy.isProxyClass(clazz) && !clazz.isInterface()) {
            objectArray = ObjectStreamClass.getDeclaredSerialFields(clazz);
            if (objectArray == null) {
                objectArray = ObjectStreamClass.getDefaultSerialFields(clazz);
            }
            Arrays.sort(objectArray);
        } else {
            objectArray = NO_FIELDS;
        }
        return objectArray;
    }

    private static ObjectStreamField[] getDeclaredSerialFields(Class clazz) {
        int n2;
        ObjectStreamField[] objectStreamFieldArray;
        ObjectStreamField[] objectStreamFieldArray2 = null;
        try {
            objectStreamFieldArray = clazz.getDeclaredField("serialPersistentFields");
            n2 = 26;
            if ((objectStreamFieldArray.getModifiers() & n2) == n2) {
                objectStreamFieldArray.setAccessible(true);
                objectStreamFieldArray2 = (ObjectStreamField[])objectStreamFieldArray.get(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (objectStreamFieldArray2 == null) {
            return null;
        }
        if (objectStreamFieldArray2.length == 0) {
            return NO_FIELDS;
        }
        objectStreamFieldArray = new ObjectStreamField[objectStreamFieldArray2.length];
        n2 = 0;
        while (n2 < objectStreamFieldArray2.length) {
            ObjectStreamField objectStreamField = objectStreamFieldArray2[n2];
            try {
                Field field = clazz.getDeclaredField(objectStreamField.getName());
                if (field.getType() == objectStreamField.getType() && (field.getModifiers() & 8) == 0) {
                    objectStreamFieldArray[n2] = new ObjectStreamField(field, objectStreamField.isUnshared(), true);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (objectStreamFieldArray[n2] == null) {
                objectStreamFieldArray[n2] = new ObjectStreamField(objectStreamField.getName(), objectStreamField.getType(), objectStreamField.isUnshared());
            }
            ++n2;
        }
        return objectStreamFieldArray;
    }

    private static ObjectStreamField[] getDefaultSerialFields(Class clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        ArrayList arrayList = new ArrayList();
        int n2 = 136;
        int n3 = 0;
        while (n3 < fieldArray.length) {
            if ((fieldArray[n3].getModifiers() & n2) == 0) {
                arrayList.add(new ObjectStreamField(fieldArray[n3], false, true));
            }
            ++n3;
        }
        int n4 = arrayList.size();
        return n4 == 0 ? NO_FIELDS : (ObjectStreamField[])arrayList.toArray(new ObjectStreamField[n4]);
    }

    private static Long getDeclaredSUID(Class clazz) {
        try {
            Field field = clazz.getDeclaredField("serialVersionUID");
            int n2 = 24;
            if ((field.getModifiers() & n2) == n2) {
                field.setAccessible(true);
                return new Long(field.getLong(null));
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private static long computeDefaultSUID(Class clazz) {
        if (!(class$java$io$Serializable == null ? (class$java$io$Serializable = ObjectStreamClass.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz) || Proxy.isProxyClass(clazz)) {
            return 0L;
        }
        try {
            Object object;
            int n2;
            Object[] objectArray;
            Constructor[] constructorArray;
            int n3;
            int n4;
            Object[] objectArray2;
            Object[] objectArray3;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(clazz.getName());
            int n5 = clazz.getModifiers() & 0x611;
            Method[] methodArray = clazz.getDeclaredMethods();
            if ((n5 & 0x200) != 0) {
                n5 = methodArray.length > 0 ? n5 | 0x400 : n5 & 0xFFFFFBFF;
            }
            dataOutputStream.writeInt(n5);
            if (!clazz.isArray()) {
                objectArray3 = clazz.getInterfaces();
                objectArray2 = new String[objectArray3.length];
                n4 = 0;
                while (n4 < objectArray3.length) {
                    objectArray2[n4] = ((Class)objectArray3[n4]).getName();
                    ++n4;
                }
                Arrays.sort(objectArray2);
                n3 = 0;
                while (n3 < objectArray2.length) {
                    dataOutputStream.writeUTF((String)objectArray2[n3]);
                    ++n3;
                }
            }
            objectArray3 = clazz.getDeclaredFields();
            objectArray2 = new MemberSignature[objectArray3.length];
            n4 = 0;
            while (n4 < objectArray3.length) {
                objectArray2[n4] = new MemberSignature((Field)objectArray3[n4]);
                ++n4;
            }
            Arrays.sort(objectArray2, new Comparator(){

                public int compare(Object object, Object object2) {
                    String string = ((MemberSignature)object).name;
                    String string2 = ((MemberSignature)object2).name;
                    return string.compareTo(string2);
                }
            });
            n3 = 0;
            while (n3 < objectArray2.length) {
                constructorArray = objectArray2[n3];
                int n6 = constructorArray.member.getModifiers();
                if ((n6 & 2) == 0 || (n6 & 0x88) == 0) {
                    dataOutputStream.writeUTF(constructorArray.name);
                    dataOutputStream.writeInt(n6);
                    dataOutputStream.writeUTF(constructorArray.signature);
                }
                ++n3;
            }
            if (ObjectStreamClass.hasStaticInitializer(clazz)) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            constructorArray = clazz.getDeclaredConstructors();
            Object[] objectArray4 = new MemberSignature[constructorArray.length];
            int n7 = 0;
            while (n7 < constructorArray.length) {
                objectArray4[n7] = new MemberSignature(constructorArray[n7]);
                ++n7;
            }
            Arrays.sort(objectArray4, new Comparator(){

                public int compare(Object object, Object object2) {
                    String string = ((MemberSignature)object).signature;
                    String string2 = ((MemberSignature)object2).signature;
                    return string.compareTo(string2);
                }
            });
            int n8 = 0;
            while (n8 < objectArray4.length) {
                objectArray = objectArray4[n8];
                n2 = objectArray.member.getModifiers();
                if ((n2 & 2) == 0) {
                    dataOutputStream.writeUTF("<init>");
                    dataOutputStream.writeInt(n2);
                    dataOutputStream.writeUTF(objectArray.signature.replace('/', '.'));
                }
                ++n8;
            }
            objectArray = new MemberSignature[methodArray.length];
            n2 = 0;
            while (n2 < methodArray.length) {
                objectArray[n2] = new MemberSignature(methodArray[n2]);
                ++n2;
            }
            Arrays.sort(objectArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    MemberSignature memberSignature = (MemberSignature)object;
                    MemberSignature memberSignature2 = (MemberSignature)object2;
                    int n2 = memberSignature.name.compareTo(memberSignature2.name);
                    if (n2 == 0) {
                        n2 = memberSignature.signature.compareTo(memberSignature2.signature);
                    }
                    return n2;
                }
            });
            int n9 = 0;
            while (n9 < objectArray.length) {
                object = objectArray[n9];
                int n10 = ((MemberSignature)object).member.getModifiers();
                if ((n10 & 2) == 0) {
                    dataOutputStream.writeUTF(((MemberSignature)object).name);
                    dataOutputStream.writeInt(n10);
                    dataOutputStream.writeUTF(((MemberSignature)object).signature.replace('/', '.'));
                }
                ++n9;
            }
            dataOutputStream.flush();
            object = MessageDigest.getInstance("SHA");
            byte[] byArray = ((MessageDigest)object).digest(byteArrayOutputStream.toByteArray());
            long l2 = 0L;
            int n11 = Math.min(byArray.length, 8) - 1;
            while (n11 >= 0) {
                l2 = l2 << 8 | (long)(byArray[n11] & 0xFF);
                --n11;
            }
            return l2;
        }
        catch (IOException iOException) {
            throw new InternalError();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
    }

    private static native boolean hasStaticInitializer(Class var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FieldReflector getReflector(ObjectStreamField[] objectStreamFieldArray, ObjectStreamClass objectStreamClass) throws InvalidClassException {
        Object object;
        Class clazz = objectStreamClass != null && objectStreamFieldArray.length > 0 ? objectStreamClass.cl : null;
        FieldReflectorKey fieldReflectorKey = new FieldReflectorKey(clazz, objectStreamFieldArray);
        EntryFuture entryFuture = null;
        SoftCache softCache = reflectors;
        synchronized (softCache) {
            object = reflectors.get(fieldReflectorKey);
            if (object == null) {
                entryFuture = new EntryFuture();
                reflectors.put(fieldReflectorKey, entryFuture);
            }
        }
        if (object instanceof FieldReflector) {
            return (FieldReflector)object;
        }
        if (object instanceof EntryFuture) {
            object = ((EntryFuture)object).get();
        } else if (object == null) {
            try {
                object = new FieldReflector(ObjectStreamClass.matchFields(objectStreamFieldArray, objectStreamClass));
            }
            catch (Throwable throwable) {
                object = throwable;
            }
            entryFuture.set(object);
            SoftCache softCache2 = reflectors;
            synchronized (softCache2) {
                reflectors.put(fieldReflectorKey, object);
            }
        }
        if (object instanceof FieldReflector) {
            return (FieldReflector)object;
        }
        if (object instanceof InvalidClassException) {
            throw (InvalidClassException)object;
        }
        if (object instanceof RuntimeException) {
            throw (RuntimeException)object;
        }
        if (object instanceof Error) {
            throw (Error)object;
        }
        throw new InternalError("unexpected entry: " + object);
    }

    private static ObjectStreamField[] matchFields(ObjectStreamField[] objectStreamFieldArray, ObjectStreamClass objectStreamClass) throws InvalidClassException {
        ObjectStreamField[] objectStreamFieldArray2 = objectStreamClass != null ? objectStreamClass.fields : NO_FIELDS;
        ObjectStreamField[] objectStreamFieldArray3 = new ObjectStreamField[objectStreamFieldArray.length];
        int n2 = 0;
        while (n2 < objectStreamFieldArray.length) {
            ObjectStreamField objectStreamField = objectStreamFieldArray[n2];
            ObjectStreamField objectStreamField2 = null;
            int n3 = 0;
            while (n3 < objectStreamFieldArray2.length) {
                ObjectStreamField objectStreamField3 = objectStreamFieldArray2[n3];
                if (objectStreamField.getName().equals(objectStreamField3.getName())) {
                    if ((objectStreamField.isPrimitive() || objectStreamField3.isPrimitive()) && objectStreamField.getTypeCode() != objectStreamField3.getTypeCode()) {
                        throw new InvalidClassException(objectStreamClass.name, "incompatible types for field " + objectStreamField.getName());
                    }
                    objectStreamField2 = objectStreamField3.getField() != null ? new ObjectStreamField(objectStreamField3.getField(), objectStreamField3.isUnshared(), false) : new ObjectStreamField(objectStreamField3.getName(), objectStreamField3.getSignature(), objectStreamField3.isUnshared());
                }
                ++n3;
            }
            if (objectStreamField2 == null) {
                objectStreamField2 = new ObjectStreamField(objectStreamField.getName(), objectStreamField.getSignature(), false);
            }
            objectStreamField2.setOffset(objectStreamField.getOffset());
            objectStreamFieldArray3[n2] = objectStreamField2;
            ++n2;
        }
        return objectStreamFieldArray3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ ObjectStreamField[] access$502(ObjectStreamClass objectStreamClass, ObjectStreamField[] objectStreamFieldArray) {
        objectStreamClass.fields = objectStreamFieldArray;
        return objectStreamFieldArray;
    }

    static {
        ObjectStreamClass.initNative();
    }

    private static class FieldReflectorKey {
        private final Class cl;
        private final String sigs;
        private final int hash;

        FieldReflectorKey(Class clazz, ObjectStreamField[] objectStreamFieldArray) {
            this.cl = clazz;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < objectStreamFieldArray.length) {
                ObjectStreamField objectStreamField = objectStreamFieldArray[n2];
                stringBuffer.append(objectStreamField.getName()).append(objectStreamField.getSignature());
                ++n2;
            }
            this.sigs = stringBuffer.toString();
            this.hash = System.identityHashCode(clazz) + this.sigs.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (!(object instanceof FieldReflectorKey)) {
                return false;
            }
            FieldReflectorKey fieldReflectorKey = (FieldReflectorKey)object;
            return this.cl == fieldReflectorKey.cl && this.sigs.equals(fieldReflectorKey.sigs);
        }
    }

    private static class FieldReflector {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        private final ObjectStreamField[] fields;
        private final int numPrimFields;
        private final int[] keys;
        private final int[] offsets;
        private final char[] typeCodes;
        private final Class[] types;

        FieldReflector(ObjectStreamField[] objectStreamFieldArray) {
            this.fields = objectStreamFieldArray;
            int n2 = objectStreamFieldArray.length;
            this.keys = new int[n2];
            this.offsets = new int[n2];
            this.typeCodes = new char[n2];
            ArrayList arrayList = new ArrayList();
            int n3 = 0;
            while (n3 < n2) {
                ObjectStreamField objectStreamField = objectStreamFieldArray[n3];
                Field field = objectStreamField.getField();
                this.keys[n3] = field != null ? unsafe.fieldOffset(field) : -1;
                this.offsets[n3] = objectStreamField.getOffset();
                this.typeCodes[n3] = objectStreamField.getTypeCode();
                if (!objectStreamField.isPrimitive()) {
                    arrayList.add(field != null ? field.getType() : null);
                }
                ++n3;
            }
            this.types = (Class[])arrayList.toArray(new Class[arrayList.size()]);
            this.numPrimFields = n2 - this.types.length;
        }

        ObjectStreamField[] getFields() {
            return this.fields;
        }

        void getPrimFieldValues(Object object, byte[] byArray) {
            if (object == null) {
                throw new NullPointerException();
            }
            int n2 = 0;
            while (n2 < this.numPrimFields) {
                int n3 = this.keys[n2];
                int n4 = this.offsets[n2];
                switch (this.typeCodes[n2]) {
                    case 'Z': {
                        Bits.putBoolean(byArray, n4, unsafe.getBoolean(object, n3));
                        break;
                    }
                    case 'B': {
                        byArray[n4] = unsafe.getByte(object, n3);
                        break;
                    }
                    case 'C': {
                        Bits.putChar(byArray, n4, unsafe.getChar(object, n3));
                        break;
                    }
                    case 'S': {
                        Bits.putShort(byArray, n4, unsafe.getShort(object, n3));
                        break;
                    }
                    case 'I': {
                        Bits.putInt(byArray, n4, unsafe.getInt(object, n3));
                        break;
                    }
                    case 'F': {
                        Bits.putFloat(byArray, n4, unsafe.getFloat(object, n3));
                        break;
                    }
                    case 'J': {
                        Bits.putLong(byArray, n4, unsafe.getLong(object, n3));
                        break;
                    }
                    case 'D': {
                        Bits.putDouble(byArray, n4, unsafe.getDouble(object, n3));
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                ++n2;
            }
        }

        void setPrimFieldValues(Object object, byte[] byArray) {
            if (object == null) {
                throw new NullPointerException();
            }
            int n2 = 0;
            while (n2 < this.numPrimFields) {
                int n3 = this.keys[n2];
                if (n3 != -1) {
                    int n4 = this.offsets[n2];
                    switch (this.typeCodes[n2]) {
                        case 'Z': {
                            unsafe.putBoolean(object, n3, Bits.getBoolean(byArray, n4));
                            break;
                        }
                        case 'B': {
                            unsafe.putByte(object, n3, byArray[n4]);
                            break;
                        }
                        case 'C': {
                            unsafe.putChar(object, n3, Bits.getChar(byArray, n4));
                            break;
                        }
                        case 'S': {
                            unsafe.putShort(object, n3, Bits.getShort(byArray, n4));
                            break;
                        }
                        case 'I': {
                            unsafe.putInt(object, n3, Bits.getInt(byArray, n4));
                            break;
                        }
                        case 'F': {
                            unsafe.putFloat(object, n3, Bits.getFloat(byArray, n4));
                            break;
                        }
                        case 'J': {
                            unsafe.putLong(object, n3, Bits.getLong(byArray, n4));
                            break;
                        }
                        case 'D': {
                            unsafe.putDouble(object, n3, Bits.getDouble(byArray, n4));
                            break;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                }
                ++n2;
            }
        }

        void getObjFieldValues(Object object, Object[] objectArray) {
            if (object == null) {
                throw new NullPointerException();
            }
            int n2 = this.numPrimFields;
            while (n2 < this.fields.length) {
                switch (this.typeCodes[n2]) {
                    case 'L': 
                    case '[': {
                        objectArray[this.offsets[n2]] = unsafe.getObject(object, this.keys[n2]);
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                ++n2;
            }
        }

        void setObjFieldValues(Object object, Object[] objectArray) {
            if (object == null) {
                throw new NullPointerException();
            }
            int n2 = this.numPrimFields;
            while (n2 < this.fields.length) {
                int n3 = this.keys[n2];
                if (n3 != -1) {
                    switch (this.typeCodes[n2]) {
                        case 'L': 
                        case '[': {
                            Object object2 = objectArray[this.offsets[n2]];
                            if (object2 != null && !this.types[n2 - this.numPrimFields].isInstance(object2)) {
                                Field field = this.fields[n2].getField();
                                throw new ClassCastException("cannot assign instance of " + object2.getClass().getName() + " to field " + field.getDeclaringClass().getName() + "." + field.getName() + " of type " + field.getType().getName() + " in instance of " + object.getClass().getName());
                            }
                            unsafe.putObject(object, n3, object2);
                            break;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private static class MemberSignature {
        public final Member member;
        public final String name;
        public final String signature;

        public MemberSignature(Field field) {
            this.member = field;
            this.name = field.getName();
            this.signature = ObjectStreamClass.getClassSignature(field.getType());
        }

        public MemberSignature(Constructor constructor) {
            this.member = constructor;
            this.name = constructor.getName();
            this.signature = ObjectStreamClass.getMethodSignature(constructor.getParameterTypes(), Void.TYPE);
        }

        public MemberSignature(Method method) {
            this.member = method;
            this.name = method.getName();
            this.signature = ObjectStreamClass.getMethodSignature(method.getParameterTypes(), method.getReturnType());
        }
    }

    static class ClassDataSlot {
        final ObjectStreamClass desc;
        final boolean hasData;

        ClassDataSlot(ObjectStreamClass objectStreamClass, boolean bl2) {
            this.desc = objectStreamClass;
            this.hasData = bl2;
        }
    }

    private static class EntryFuture {
        private static final Object unset = new Object();
        private Object entry = unset;

        private EntryFuture() {
        }

        synchronized void set(Object object) {
            if (this.entry != unset) {
                throw new IllegalStateException();
            }
            this.entry = object;
            this.notifyAll();
        }

        synchronized Object get() {
            boolean bl2 = false;
            while (this.entry == unset) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                }
            }
            if (bl2) {
                AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ EntryFuture this$0;
                    {
                        this.this$0 = entryFuture;
                    }

                    public Object run() {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                });
            }
            return this.entry;
        }
    }
}

