/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.util.Arrays;

public class SinglePixelPackedSampleModel
extends SampleModel {
    private int[] bitMasks;
    private int[] bitOffsets;
    private int[] bitSizes;
    private int maxBitSize;
    private int scanlineStride;

    private static native void initIDs();

    public SinglePixelPackedSampleModel(int n2, int n3, int n4, int[] nArray) {
        this(n2, n3, n4, n3, nArray);
        if (n2 != 0 && n2 != 1 && n2 != 3) {
            throw new IllegalArgumentException("Unsupported data type " + n2);
        }
    }

    public SinglePixelPackedSampleModel(int n2, int n3, int n4, int n5, int[] nArray) {
        super(n2, n3, n4, nArray.length);
        if (n2 != 0 && n2 != 1 && n2 != 3) {
            throw new IllegalArgumentException("Unsupported data type " + n2);
        }
        this.dataType = n2;
        this.bitMasks = (int[])nArray.clone();
        this.scanlineStride = n5;
        this.bitOffsets = new int[this.numBands];
        this.bitSizes = new int[this.numBands];
        this.maxBitSize = 0;
        int n6 = 0;
        while (n6 < this.numBands) {
            int n7 = 0;
            int n8 = 0;
            int n9 = nArray[n6];
            if (n9 != 0) {
                while ((n9 & 1) == 0) {
                    n9 >>>= 1;
                    ++n7;
                }
                while ((n9 & 1) == 1) {
                    n9 >>>= 1;
                    ++n8;
                }
                if (n9 != 0) {
                    throw new IllegalArgumentException("Mask " + nArray[n6] + " must be contiguous");
                }
            }
            this.bitOffsets[n6] = n7;
            this.bitSizes[n6] = n8;
            if (n8 > this.maxBitSize) {
                this.maxBitSize = n8;
            }
            ++n6;
        }
    }

    public int getNumDataElements() {
        return 1;
    }

    private long getBufferSize() {
        long l2 = this.scanlineStride * (this.height - 1) + this.width;
        return l2;
    }

    public SampleModel createCompatibleSampleModel(int n2, int n3) {
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(this.dataType, n2, n3, this.bitMasks);
        return singlePixelPackedSampleModel;
    }

    public DataBuffer createDataBuffer() {
        DataBuffer dataBuffer = null;
        int n2 = (int)this.getBufferSize();
        switch (this.dataType) {
            case 0: {
                dataBuffer = new DataBufferByte(n2);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n2);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n2);
            }
        }
        return dataBuffer;
    }

    public int[] getSampleSize() {
        int[] nArray = new int[this.numBands];
        int n2 = 0;
        while (n2 < this.numBands) {
            nArray[n2] = 0;
            int n3 = this.bitMasks[n2] >>> this.bitOffsets[n2];
            while ((n3 & 1) != 0) {
                int n4 = n2;
                nArray[n4] = nArray[n4] + 1;
                n3 >>>= 1;
            }
            ++n2;
        }
        return nArray;
    }

    public int getSampleSize(int n2) {
        int n3 = 0;
        int n4 = this.bitMasks[n2] >>> this.bitOffsets[n2];
        while ((n4 & 1) != 0) {
            ++n3;
            n4 >>>= 1;
        }
        return n3;
    }

    public int getOffset(int n2, int n3) {
        int n4 = n3 * this.scanlineStride + n2;
        return n4;
    }

    public int[] getBitOffsets() {
        return (int[])this.bitOffsets.clone();
    }

    public int[] getBitMasks() {
        return (int[])this.bitMasks.clone();
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        if (nArray.length > this.numBands) {
            throw new RasterFormatException("There are only " + this.numBands + " bands");
        }
        int[] nArray2 = new int[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray2[n2] = this.bitMasks[nArray[n2]];
            ++n2;
        }
        return new SinglePixelPackedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, nArray2);
    }

    public Object getDataElements(int n2, int n3, Object object, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = this.getTransferType();
        switch (n4) {
            case 0: {
                byte[] byArray = object == null ? new byte[1] : (byte[])object;
                byArray[0] = (byte)dataBuffer.getElem(n3 * this.scanlineStride + n2);
                object = byArray;
                break;
            }
            case 1: {
                short[] sArray = object == null ? new short[1] : (short[])object;
                sArray[0] = (short)dataBuffer.getElem(n3 * this.scanlineStride + n2);
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[1] : (int[])object;
                nArray[0] = dataBuffer.getElem(n3 * this.scanlineStride + n2);
                object = nArray;
            }
        }
        return object;
    }

    public int[] getPixel(int n2, int n3, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray == null ? new int[this.numBands] : nArray;
        int n4 = dataBuffer.getElem(n3 * this.scanlineStride + n2);
        int n5 = 0;
        while (n5 < this.numBands) {
            nArray2[n5] = (n4 & this.bitMasks[n5]) >>> this.bitOffsets[n5];
            ++n5;
        }
        return nArray2;
    }

    public int[] getPixels(int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n4 * n5 * this.numBands];
        int n6 = n3 * this.scanlineStride + n2;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            int n9 = 0;
            while (n9 < n4) {
                int n10 = dataBuffer.getElem(n6 + n9);
                int n11 = 0;
                while (n11 < this.numBands) {
                    nArray2[n7++] = (n10 & this.bitMasks[n11]) >>> this.bitOffsets[n11];
                    ++n11;
                }
                ++n9;
            }
            n6 += this.scanlineStride;
            ++n8;
        }
        return nArray2;
    }

    public int getSample(int n2, int n3, int n4, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n5 = dataBuffer.getElem(n3 * this.scanlineStride + n2);
        return (n5 & this.bitMasks[n4]) >>> this.bitOffsets[n4];
    }

    public int[] getSamples(int n2, int n3, int n4, int n5, int n6, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n4 * n5];
        int n7 = n3 * this.scanlineStride + n2;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n5) {
            int n10 = 0;
            while (n10 < n4) {
                int n11 = dataBuffer.getElem(n7 + n10);
                nArray2[n8++] = (n11 & this.bitMasks[n6]) >>> this.bitOffsets[n6];
                ++n10;
            }
            n7 += this.scanlineStride;
            ++n9;
        }
        return nArray2;
    }

    public void setDataElements(int n2, int n3, Object object, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = this.getTransferType();
        switch (n4) {
            case 0: {
                byte[] byArray = (byte[])object;
                dataBuffer.setElem(n3 * this.scanlineStride + n2, byArray[0] & 0xFF);
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                dataBuffer.setElem(n3 * this.scanlineStride + n2, sArray[0] & 0xFFFF);
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                dataBuffer.setElem(n3 * this.scanlineStride + n2, nArray[0]);
            }
        }
    }

    public void setPixel(int n2, int n3, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = n3 * this.scanlineStride + n2;
        int n5 = dataBuffer.getElem(n4);
        int n6 = 0;
        while (n6 < this.numBands) {
            n5 &= ~this.bitMasks[n6];
            n5 |= nArray[n6] << this.bitOffsets[n6] & this.bitMasks[n6];
            ++n6;
        }
        dataBuffer.setElem(n4, n5);
    }

    public void setPixels(int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = n3 * this.scanlineStride + n2;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            int n9 = 0;
            while (n9 < n4) {
                int n10 = dataBuffer.getElem(n6 + n9);
                int n11 = 0;
                while (n11 < this.numBands) {
                    n10 &= ~this.bitMasks[n11];
                    int n12 = nArray[n7++];
                    n10 |= n12 << this.bitOffsets[n11] & this.bitMasks[n11];
                    ++n11;
                }
                dataBuffer.setElem(n6 + n9, n10);
                ++n9;
            }
            n6 += this.scanlineStride;
            ++n8;
        }
    }

    public void setSample(int n2, int n3, int n4, int n5, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = dataBuffer.getElem(n3 * this.scanlineStride + n2);
        n6 &= ~this.bitMasks[n4];
        dataBuffer.setElem(n3 * this.scanlineStride + n2, n6 |= n5 << this.bitOffsets[n4] & this.bitMasks[n4]);
    }

    public void setSamples(int n2, int n3, int n4, int n5, int n6, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n7 = n3 * this.scanlineStride + n2;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n5) {
            int n10 = 0;
            while (n10 < n4) {
                int n11 = dataBuffer.getElem(n7 + n10);
                n11 &= ~this.bitMasks[n6];
                int n12 = nArray[n8++];
                dataBuffer.setElem(n7 + n10, n11 |= n12 << this.bitOffsets[n6] & this.bitMasks[n6]);
                ++n10;
            }
            n7 += this.scanlineStride;
            ++n9;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)object;
        return this.width == singlePixelPackedSampleModel.width && this.height == singlePixelPackedSampleModel.height && this.numBands == singlePixelPackedSampleModel.numBands && this.dataType == singlePixelPackedSampleModel.dataType && Arrays.equals(this.bitMasks, singlePixelPackedSampleModel.bitMasks) && Arrays.equals(this.bitOffsets, singlePixelPackedSampleModel.bitOffsets) && Arrays.equals(this.bitSizes, singlePixelPackedSampleModel.bitSizes) && this.maxBitSize == singlePixelPackedSampleModel.maxBitSize && this.scanlineStride == singlePixelPackedSampleModel.scanlineStride;
    }

    public int hashCode() {
        int n2 = 0;
        n2 = this.width;
        n2 <<= 8;
        n2 ^= this.height;
        n2 <<= 8;
        n2 ^= this.numBands;
        n2 <<= 8;
        n2 ^= this.dataType;
        n2 <<= 8;
        int n3 = 0;
        while (n3 < this.bitMasks.length) {
            n2 ^= this.bitMasks[n3];
            n2 <<= 8;
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.bitOffsets.length) {
            n2 ^= this.bitOffsets[n4];
            n2 <<= 8;
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.bitSizes.length) {
            n2 ^= this.bitSizes[n5];
            n2 <<= 8;
            ++n5;
        }
        n2 ^= this.maxBitSize;
        n2 <<= 8;
        return n2 ^= this.scanlineStride;
    }

    static {
        ColorModel.loadLibraries();
        SinglePixelPackedSampleModel.initIDs();
    }
}

