/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth.module;

import com.sun.security.auth.UnixNumericGroupPrincipal;
import com.sun.security.auth.UnixNumericUserPrincipal;
import com.sun.security.auth.UnixPrincipal;
import com.sun.security.auth.module.UnixSystem;
import java.util.LinkedList;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class UnixLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean debug = true;
    private UnixSystem ss;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private UnixPrincipal userPrincipal;
    private UnixNumericUserPrincipal UIDPrincipal;
    private UnixNumericGroupPrincipal GIDPrincipal;
    private LinkedList supplementaryGroups = new LinkedList();

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.debug = "true".equalsIgnoreCase((String)map2.get("debug"));
    }

    public boolean login() throws LoginException {
        long[] lArray = null;
        this.ss = new UnixSystem();
        if (this.ss == null) {
            this.succeeded = false;
            throw new FailedLoginException("Failed in attempt to import the underlying system identity information");
        }
        this.userPrincipal = new UnixPrincipal(this.ss.getUsername());
        this.UIDPrincipal = new UnixNumericUserPrincipal(this.ss.getUid());
        this.GIDPrincipal = new UnixNumericGroupPrincipal(this.ss.getGid(), true);
        if (this.ss.getGroups() != null && this.ss.getGroups().length > 0) {
            lArray = this.ss.getGroups();
        }
        int n2 = 0;
        while (n2 < lArray.length) {
            UnixNumericGroupPrincipal unixNumericGroupPrincipal = new UnixNumericGroupPrincipal(lArray[n2], false);
            if (!unixNumericGroupPrincipal.getName().equals(this.GIDPrincipal.getName())) {
                this.supplementaryGroups.add(unixNumericGroupPrincipal);
            }
            ++n2;
        }
        if (this.debug) {
            System.out.println("\t\t[UnixLoginModule]: succeeded importing info: ");
            System.out.println("\t\t\tuid = " + this.ss.getUid());
            System.out.println("\t\t\tgid = " + this.ss.getGid());
            lArray = this.ss.getGroups();
            int n3 = 0;
            while (n3 < lArray.length) {
                System.out.println("\t\t\tsupp gid = " + lArray[n3]);
                ++n3;
            }
        }
        this.succeeded = true;
        return true;
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            if (this.debug) {
                System.out.println("\t\t[UnixLoginModule]: did not add any Principals to Subject because own authentication failed.");
            }
            return false;
        }
        if (this.subject.isReadOnly()) {
            throw new LoginException("commit Failed: Subject is Readonly");
        }
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add(this.userPrincipal);
        }
        if (!this.subject.getPrincipals().contains(this.UIDPrincipal)) {
            this.subject.getPrincipals().add(this.UIDPrincipal);
        }
        if (!this.subject.getPrincipals().contains(this.GIDPrincipal)) {
            this.subject.getPrincipals().add(this.GIDPrincipal);
        }
        int n2 = 0;
        while (n2 < this.supplementaryGroups.size()) {
            if (!this.subject.getPrincipals().contains((UnixNumericGroupPrincipal)this.supplementaryGroups.get(n2))) {
                this.subject.getPrincipals().add((UnixNumericGroupPrincipal)this.supplementaryGroups.get(n2));
            }
            ++n2;
        }
        if (this.debug) {
            System.out.println("\t\t[UnixLoginModule]: added UnixPrincipal,");
            System.out.println("\t\t\t\tUnixNumericUserPrincipal,");
            System.out.println("\t\t\t\tUnixNumericGroupPrincipal(s),");
            System.out.println("\t\t\t to Subject");
        }
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.debug) {
            System.out.println("\t\t[UnixLoginModule]: aborted authentication attempt");
        }
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.ss = null;
            this.userPrincipal = null;
            this.UIDPrincipal = null;
            this.GIDPrincipal = null;
            this.supplementaryGroups = new LinkedList();
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.subject.isReadOnly()) {
            throw new LoginException("logout Failed: Subject is Readonly");
        }
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.subject.getPrincipals().remove(this.UIDPrincipal);
        this.subject.getPrincipals().remove(this.GIDPrincipal);
        int n2 = 0;
        while (n2 < this.supplementaryGroups.size()) {
            this.subject.getPrincipals().remove((UnixNumericGroupPrincipal)this.supplementaryGroups.get(n2));
            ++n2;
        }
        this.ss = null;
        this.succeeded = false;
        this.commitSucceeded = false;
        this.userPrincipal = null;
        this.UIDPrincipal = null;
        this.GIDPrincipal = null;
        this.supplementaryGroups = new LinkedList();
        if (this.debug) {
            System.out.println("\t\t[UnixLoginModule]: logged out Subject");
        }
        return true;
    }
}

