/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;

class WaveFileFormat
extends AudioFileFormat {
    private int waveType;
    private static final int STANDARD_HEADER_SIZE = 28;
    private static final int STANDARD_FMT_CHUNK_SIZE = 16;
    static final int RIFF_MAGIC = 1380533830;
    static final int WAVE_MAGIC = 1463899717;
    static final int FMT_MAGIC = 1718449184;
    static final int DATA_MAGIC = 1684108385;
    static final int WAVE_FORMAT_UNKNOWN = 0;
    static final int WAVE_FORMAT_PCM = 1;
    static final int WAVE_FORMAT_ADPCM = 2;
    static final int WAVE_FORMAT_ALAW = 6;
    static final int WAVE_FORMAT_MULAW = 7;
    static final int WAVE_FORMAT_OKI_ADPCM = 16;
    static final int WAVE_FORMAT_DIGISTD = 21;
    static final int WAVE_FORMAT_DIGIFIX = 22;
    static final int WAVE_IBM_FORMAT_MULAW = 257;
    static final int WAVE_IBM_FORMAT_ALAW = 258;
    static final int WAVE_IBM_FORMAT_ADPCM = 259;
    static final int WAVE_FORMAT_DVI_ADPCM = 17;
    static final int WAVE_FORMAT_SX7383 = 7175;

    WaveFileFormat(AudioFileFormat audioFileFormat) {
        this(audioFileFormat.getType(), audioFileFormat.getByteLength(), audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }

    WaveFileFormat(AudioFileFormat.Type type, int n2, AudioFormat audioFormat, int n3) {
        super(type, n2, audioFormat, n3);
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        this.waveType = encoding == AudioFormat.Encoding.ALAW ? 6 : (encoding == AudioFormat.Encoding.ULAW ? 7 : (encoding == AudioFormat.Encoding.PCM_SIGNED || encoding == AudioFormat.Encoding.PCM_UNSIGNED ? 1 : 0));
    }

    int getWaveType() {
        return this.waveType;
    }

    int getHeaderSize() {
        return WaveFileFormat.getHeaderSize(this.getWaveType());
    }

    static int getHeaderSize(int n2) {
        return 28 + WaveFileFormat.getFmtChunkSize(n2);
    }

    static int getFmtChunkSize(int n2) {
        int n3 = 16;
        if (n2 != 1) {
            n3 += 2;
        }
        return n3;
    }
}

